
!!!      InterBase 6  FireBird 
   3      
   .      
,     backup  .

CONNECT "MYSERVER:C:/MYDIR/TEST.GDB" USER "SYSDBA" PASSWORD "masterkey"; 


/*
 * Auto grant internal objects
 * Copyright (c) 2000 SoftLab, Andre N Belokon
 * http://softlab.od.ua
 *
 * comments by KDV, http://ib.demo.ru
 */

SET TERM ^ ;

/*     .
         ,
   ,    ,
         ()
.    GRANT */

CREATE PROCEDURE SYS$UPDATE_OBJECT_GRANTS (OBJ_TYPE SMALLINT,
OBJ_NAME CHAR(31) CHARACTER SET ASCII)
AS 
declare variable DEP_NAME CHAR(31);
declare variable DEP_TYPE SMALLINT;
begin
    DELETE FROM rdb$user_privileges
      WHERE RDB$USER = :OBJ_NAME;
    FOR SELECT
      DISTINCT rdb$depended_on_name, rdb$depended_on_type
      FROM rdb$dependencies
      WHERE rdb$dependent_name = :OBJ_NAME
        AND rdb$dependent_type = :OBJ_TYPE
      INTO :DEP_NAME, :DEP_TYPE
      DO BEGIN
        if (DEP_TYPE = 0) THEN BEGIN
          INSERT INTO rdb$user_privileges
            (RDB$USER, RDB$GRANTOR, RDB$PRIVILEGE, RDB$GRANT_OPTION,
             RDB$RELATION_NAME, RDB$USER_TYPE, RDB$OBJECT_TYPE)
            VALUES
            (:OBJ_NAME,'SYSDBA','S',0,:DEP_NAME,:OBJ_TYPE,:DEP_TYPE);
          INSERT INTO rdb$user_privileges
            (RDB$USER, RDB$GRANTOR, RDB$PRIVILEGE, RDB$GRANT_OPTION,
             RDB$RELATION_NAME, RDB$USER_TYPE, RDB$OBJECT_TYPE)
            VALUES
            (:OBJ_NAME,'SYSDBA','I',0,:DEP_NAME,:OBJ_TYPE,:DEP_TYPE);
          INSERT INTO rdb$user_privileges
            (RDB$USER, RDB$GRANTOR, RDB$PRIVILEGE, RDB$GRANT_OPTION,
             RDB$RELATION_NAME, RDB$USER_TYPE, RDB$OBJECT_TYPE)
            VALUES
            (:OBJ_NAME,'SYSDBA','U',0,:DEP_NAME,:OBJ_TYPE,:DEP_TYPE);
          INSERT INTO rdb$user_privileges
            (RDB$USER, RDB$GRANTOR, RDB$PRIVILEGE, RDB$GRANT_OPTION,
             RDB$RELATION_NAME, RDB$USER_TYPE, RDB$OBJECT_TYPE)
            VALUES
            (:OBJ_NAME,'SYSDBA','D',0,:DEP_NAME,:OBJ_TYPE,:DEP_TYPE);
          INSERT INTO rdb$user_privileges
            (RDB$USER, RDB$GRANTOR, RDB$PRIVILEGE, RDB$GRANT_OPTION,
             RDB$RELATION_NAME, RDB$USER_TYPE, RDB$OBJECT_TYPE)
            VALUES
            (:OBJ_NAME,'SYSDBA','R',0,:DEP_NAME,:OBJ_TYPE,:DEP_TYPE);
        END ELSE if (DEP_TYPE = 1) THEN BEGIN
          INSERT INTO rdb$user_privileges
            (RDB$USER, RDB$GRANTOR, RDB$PRIVILEGE, RDB$GRANT_OPTION,
             RDB$RELATION_NAME, RDB$USER_TYPE, RDB$OBJECT_TYPE)
            VALUES
            (:OBJ_NAME,'SYSDBA','S',0,:DEP_NAME,:OBJ_TYPE,:DEP_TYPE);
        END ELSE if (DEP_TYPE = 5) THEN BEGIN
          INSERT INTO rdb$user_privileges
            (RDB$USER, RDB$GRANTOR, RDB$PRIVILEGE, RDB$GRANT_OPTION,
             RDB$RELATION_NAME, RDB$USER_TYPE, RDB$OBJECT_TYPE)
            VALUES
            (:OBJ_NAME,'SYSDBA','X',0,:DEP_NAME,:OBJ_TYPE,:DEP_TYPE);
        END
      END
end
 ^

/*        ,
  view*/

CREATE PROCEDURE SYS$UPDATE_GRANTS
AS
declare variable OBJ_NAME CHAR(31);
begin
  for select rdb$procedure_name
    from RDB$PROCEDURES
    where rdb$system_flag <> 1
       or rdb$system_flag is null
    into :OBJ_NAME
    do begin
      execute procedure SYS$UPDATE_OBJECT_GRANTS(5,:OBJ_NAME);
    end
  for select rdb$trigger_name
    from RDB$TRIGGERS
    where rdb$system_flag <> 1
       or rdb$system_flag is null
    into :OBJ_NAME
    do begin
      execute procedure SYS$UPDATE_OBJECT_GRANTS(2,:OBJ_NAME);
    end
  for select rdb$view_name
    from RDB$VIEW_RELATIONS
    into :OBJ_NAME
    do begin
      execute procedure SYS$UPDATE_OBJECT_GRANTS(1,:OBJ_NAME);
    end
  suspend;
end
 ^

/*      (ALTER)  */

CREATE TRIGGER T_AU_RDB$PROCEDURES FOR RDB$PROCEDURES                  
ACTIVE AFTER UPDATE POSITION 0 
as
begin
  execute procedure sys$update_object_grants(5,new.rdb$procedure_name);
end
 ^

/*      (ALTER)  */

CREATE TRIGGER T_AU_RDB$TRIGGERS FOR RDB$TRIGGERS                    
ACTIVE AFTER UPDATE POSITION 0 
as
begin
  execute procedure sys$update_object_grants(2,new.rdb$trigger_name);
end
 ^

/*      (ALTER)  */

CREATE TRIGGER T_AU_RDB$VIEW_RELATIONS FOR RDB$VIEW_RELATIONS              
ACTIVE AFTER UPDATE POSITION 0 
as
begin
  execute procedure sys$update_object_grants(1,new.rdb$view_name);
end
 ^

/*      (CREATE) view
   (..  View  alter) */

CREATE TRIGGER T_AI_RDB$VIEW_RELATIONS FOR RDB$VIEW_RELATIONS              
ACTIVE AFTER INSERT POSITION 0 
as
begin
  execute procedure sys$update_object_grants(1,new.rdb$view_name);
end
 ^

/*      (CREATE)  */

CREATE TRIGGER T_AI_RDB$TRIGGERS FOR RDB$TRIGGERS                    
ACTIVE AFTER INSERT POSITION 0 
as
begin
  execute procedure sys$update_object_grants(2,new.rdb$trigger_name);
end
 ^

/*      (CREATE)  */

CREATE TRIGGER T_AI_RDB$PROCEDURES FOR RDB$PROCEDURES                  
ACTIVE AFTER INSERT POSITION 0 
as
begin
  execute procedure sys$update_object_grants(5,new.rdb$procedure_name);
end
 ^

/*       */

CREATE TRIGGER T_AD_RDB$PROCEDURES FOR RDB$PROCEDURES
ACTIVE AFTER DELETE POSITION 0
as
begin
    DELETE FROM rdb$user_privileges
      WHERE RDB$USER = old.rdb$procedure_name;
end
 ^

/*       */

CREATE TRIGGER T_AD_RDB$TRIGGERS FOR RDB$TRIGGERS
ACTIVE AFTER DELETE POSITION 0
as
begin
    DELETE FROM rdb$user_privileges
      WHERE RDB$USER = old.rdb$trigger_name;
end
 ^

/*      view */

CREATE TRIGGER T_AD_RDB$VIEW_RELATIONS FOR RDB$VIEW_RELATIONS
ACTIVE AFTER DELETE POSITION 0
as
begin
    DELETE FROM rdb$user_privileges
      WHERE RDB$USER = old.rdb$view_name;
end
 ^

SET TERM ; ^

COMMIT WORK;

execute procedure SYS$UPDATE_GRANTS;

COMMIT WORK;
