unit Customers;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Param, FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf,
  FireDAC.DApt.Intf, FireDAC.Stan.Async, FireDAC.DApt, Data.DB,
  FireDAC.Comp.DataSet, FireDAC.Comp.Client, Vcl.Grids, Vcl.DBGrids,
  Vcl.ToolWin, Vcl.ComCtrls, Vcl.ImgList, System.Actions, Vcl.ActnList;

type
  TCustomerForm = class(TForm)
    DBGrid: TDBGrid;
    ToolBar1: TToolBar;
    ActionList: TActionList;
    actAddRecord: TAction;
    actEditRecord: TAction;
    actDeleteRecord: TAction;
    btnAddRecord: TToolButton;
    btnEditRecord: TToolButton;
    btnDeleteRecord: TToolButton;
    ToolButton1: TToolButton;
    actExit: TAction;
    ToolButton2: TToolButton;
    actRefresh: TAction;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    qryCustomer: TFDQuery;
    qryCustomerCUSTOMER_ID: TIntegerField;
    qryCustomerNAME: TWideStringField;
    qryCustomerADDRESS: TWideStringField;
    qryCustomerZIPCODE: TWideStringField;
    qryCustomerPHONE: TWideStringField;
    FDUpdateCustomer: TFDUpdateSQL;
    trWrite: TFDTransaction;
    DataSource: TDataSource;
    procedure FormActivate(Sender: TObject);
    procedure actAddRecordExecute(Sender: TObject);
    procedure actEditRecordExecute(Sender: TObject);
    procedure actDeleteRecordExecute(Sender: TObject);
    procedure actExitExecute(Sender: TObject);
    procedure actRefreshExecute(Sender: TObject);
    procedure DBGridDblClick(Sender: TObject);
    procedure DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    procedure CustomerEditorClose(Sender: TObject; var Action: TCloseAction);
  public

  end;

var
  CustomerForm: TCustomerForm;

implementation

{$R *.dfm}

uses CustomerEditor;

{ TCustomerForm }

procedure TCustomerForm.actAddRecordExecute(Sender: TObject);
var
  xEditorForm: TEditCustomerForm;
begin
  xEditorForm := TEditCustomerForm.Create(Self);
  try
    xEditorForm.OnClose := CustomerEditorClose;
    xEditorForm.DataSource := DataSource;
    xEditorForm.Caption := 'Add customer';
    qryCustomer.CachedUpdates := True;
    qryCustomer.Insert;
    xEditorForm.ShowModal;
  finally
    xEditorForm.Free;
  end;
end;

procedure TCustomerForm.actDeleteRecordExecute(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to delete the customer?', mtConfirmation,
    [mbYes, mbNo], 0) = mrYes then
  begin
    trWrite.StartTransaction;
    try
      qryCustomer.Delete;
      trWrite.Commit;
    except
      on E: Exception do
      begin
        trWrite.Rollback;
        Application.ShowException(E);
      end;
    end;
  end;
end;

procedure TCustomerForm.actEditRecordExecute(Sender: TObject);
var
  xEditorForm: TEditCustomerForm;
begin
  xEditorForm := TEditCustomerForm.Create(Self);
  try
    xEditorForm.OnClose := CustomerEditorClose;
    xEditorForm.DataSource := DataSource;
    xEditorForm.Caption := 'Edit customer';
    qryCustomer.CachedUpdates := True;
    qryCustomer.Edit;
    xEditorForm.ShowModal;
  finally
    xEditorForm.Free;
  end;
end;

procedure TCustomerForm.actExitExecute(Sender: TObject);
begin
  qryCustomer.Close;
  Close;
end;

procedure TCustomerForm.actRefreshExecute(Sender: TObject);
begin
  qryCustomer.Refresh;
end;

procedure TCustomerForm.CustomerEditorClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if TEditCustomerForm(Sender).ModalResult <> mrOK then
  begin
    qryCustomer.Cancel;
    qryCustomer.CancelUpdates;
    qryCustomer.CachedUpdates := False;
    Action := caFree;
    Exit;
  end;

  try
    qryCustomer.Post;

    // We do everything in a short transaction
    // In CachedUpdates mode error does not stop running.
    // ApplyUpdates method returns the number of errors.
    // The error can be obtained from the property RowError
    trWrite.StartTransaction;
    if (qryCustomer.ApplyUpdates = 0) then
    begin
      qryCustomer.CommitUpdates;
      trWrite.Commit;
    end
    else
    begin
      raise Exception.Create(qryCustomer.RowError.Message);
    end;
    qryCustomer.CachedUpdates := False;
    Action := caFree;
  except
    on E: Exception do
    begin
      if trWrite.Active then
        trWrite.Rollback;
      Application.ShowException(E);
      // It does not close the window give the user correct the error
      Action := caNone;
    end;
  end;

end;

procedure TCustomerForm.DBGridDblClick(Sender: TObject);
begin
  if fsModal in FormState then
  begin
    ModalResult := mrOK;
    CloseModal;
  end
  else
  begin
    actEditRecordExecute(Self);
  end;
end;

procedure TCustomerForm.DBGridKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_RETURN) and (Shift = []) then
  begin
    DBGridDblClick(Sender);
  end;
end;

procedure TCustomerForm.FormActivate(Sender: TObject);
begin
  qryCustomer.Open;
end;

end.
