unit Invoice;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, System.UITypes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.Grids, Vcl.DBGrids, Vcl.ToolWin,
  Vcl.ComCtrls, Vcl.ExtCtrls, Data.DB, System.Actions, Vcl.ActnList,
  Data.SqlTimSt,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  FireDAC.Stan.Async, FireDAC.DApt, FireDAC.Comp.DataSet, FireDAC.Comp.Client,
  Vcl.ImgList;

type
  TInvoiceForm = class(TForm)
    MasterPanel: TPanel;
    Splitter1: TSplitter;
    DetailPanel: TPanel;
    DetailToolBar: TToolBar;
    MasterToolBar: TToolBar;
    MasterGrid: TDBGrid;
    DetailGrid: TDBGrid;
    ActionList: TActionList;
    actAddInvoice: TAction;
    actEditInvoice: TAction;
    actDeleteInvoice: TAction;
    actAddInvoiceLine: TAction;
    actEditInvoiceLine: TAction;
    actDeleteInvoiceLine: TAction;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    actExit: TAction;
    actRefresh: TAction;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    qryInvoiceLine: TFDQuery;
    qryInvoiceLineINVOICE_LINE_ID: TIntegerField;
    qryInvoiceLinePRODUCT_ID: TIntegerField;
    qryInvoiceLineQUANTITY: TIntegerField;
    qryInvoiceLineSALE_PRICE: TFloatField;
    MasterSource: TDataSource;
    DetailSource: TDataSource;
    qryInvoiceLineINVOICE_ID: TIntegerField;
    qryInvoiceLinePRODUCTNAME: TWideStringField;
    qryInvoiceLineTOTAL: TFloatField;
    trWrite: TFDTransaction;
    ImageList1: TImageList;
    qryInvoice: TFDQuery;
    qryInvoiceINVOICE_ID: TIntegerField;
    qryInvoiceCUSTOMER_ID: TIntegerField;
    qryInvoiceCUSTOMER_NAME: TWideStringField;
    qryInvoiceINVOICE_DATE: TSQLTimeStampField;
    qryInvoiceTOTAL_SALE: TFloatField;
    qryInvoicePAYED: TWideStringField;
    qryAddInvoice: TFDCommand;
    qryEditInvoice: TFDCommand;
    qryDeleteInvoice: TFDCommand;
    qryAddInvoiceLine: TFDCommand;
    qryEditInvoiceLine: TFDCommand;
    qryDeleteInvoiceLine: TFDCommand;
    qryPayForInvoice: TFDCommand;
    actInvoicePay: TAction;
    ToolButton11: TToolButton;
    procedure FormActivate(Sender: TObject);
    procedure actAddInvoiceExecute(Sender: TObject);
    procedure actEditInvoiceExecute(Sender: TObject);
    procedure actDeleteInvoiceExecute(Sender: TObject);
    procedure actAddInvoiceLineExecute(Sender: TObject);
    procedure actEditInvoiceLineExecute(Sender: TObject);
    procedure actDeleteInvoiceLineExecute(Sender: TObject);
    procedure actExitExecute(Sender: TObject);
    procedure actRefreshExecute(Sender: TObject);
    procedure actInvoicePayExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    procedure AddInvoiceEditorClose(Sender: TObject; var Action: TCloseAction);
    procedure EditInvoiceEditorClose(Sender: TObject; var Action: TCloseAction);
    procedure AddInvoiceLineEditorClose(Sender: TObject;
      var Action: TCloseAction);
    procedure EditInvoiceLineEditorClose(Sender: TObject;
      var Action: TCloseAction);
  public
    procedure DateRangeChange(Sender: TObject);
  end;

var
  InvoiceForm: TInvoiceForm;

implementation

{$R *.dfm}

uses InvoiceEditor, dMain, InvoiceLineEditor;

procedure TInvoiceForm.actAddInvoiceExecute(Sender: TObject);
var
  xEditorForm: TEditInvoiceForm;
begin
  xEditorForm := TEditInvoiceForm.Create(Self);
  try
    xEditorForm.Caption := 'Add invoice';
    xEditorForm.OnClose := AddInvoiceEditorClose;

    xEditorForm.InvoiceDate := Now;

    xEditorForm.ShowModal;
  finally
    xEditorForm.Free;
  end;
end;

procedure TInvoiceForm.actAddInvoiceLineExecute(Sender: TObject);
var
  xEditorForm: TEditInvoiceLineForm;
begin
  xEditorForm := TEditInvoiceLineForm.Create(Self);
  try
    xEditorForm.EditMode := emInvoiceLineAdd;
    xEditorForm.OnClose := AddInvoiceLineEditorClose;
    xEditorForm.Caption := 'Add invoice line';

    xEditorForm.Quantity := 1;
    xEditorForm.InvoiceId := qryInvoice.FieldByName('INVOICE_ID').AsInteger;
    xEditorForm.ShowModal;
  finally
    xEditorForm.Free;
  end;
end;

procedure TInvoiceForm.actDeleteInvoiceExecute(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to delete an invoice?', mtConfirmation,
    [mbYes, mbNo], 0) = mrYes then
  begin
    // We do everything in a short transaction
    trWrite.StartTransaction;
    try
      qryDeleteInvoice.ParamByName('INVOICE_ID').AsInteger :=
        qryInvoice.FieldByName('INVOICE_ID').AsInteger;
      qryDeleteInvoice.Execute;
      trWrite.Commit;
      qryInvoice.Refresh;
    except
      on E: Exception do
      begin
        if trWrite.Active then
          trWrite.Rollback;
        Application.ShowException(E);
      end;
    end;
  end;
end;

procedure TInvoiceForm.actDeleteInvoiceLineExecute(Sender: TObject);
begin
  if MessageDlg('Are you sure you want to delete an invoice line?',
    mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    // We do everything in a short transaction
    trWrite.StartTransaction;
    try
      qryDeleteInvoiceLine.ParamByName('INVOICE_LINE_ID').AsInteger :=
        qryInvoiceLine.FieldByName('INVOICE_LINE_ID').AsInteger;
      qryDeleteInvoiceLine.Execute;
      trWrite.Commit;
      qryInvoice.Refresh;
      qryInvoiceLine.Refresh;
    except
      on E: Exception do
      begin
        if trWrite.Active then
          trWrite.Rollback;
        Application.ShowException(E);
      end;
    end;
  end;
end;

procedure TInvoiceForm.actEditInvoiceExecute(Sender: TObject);
var
  xEditorForm: TEditInvoiceForm;
begin
  xEditorForm := TEditInvoiceForm.Create(Self);
  try
    xEditorForm.OnClose := EditInvoiceEditorClose;
    xEditorForm.Caption := 'Edit invoice';

    xEditorForm.InvoiceId := qryInvoice.FieldByName('INVOICE_ID').AsInteger;
    xEditorForm.SetCustomer(
      qryInvoice.FieldByName('CUSTOMER_ID').AsInteger,
      qryInvoice.FieldByName('CUSTOMER_NAME').AsString);
    xEditorForm.InvoiceDate := qryInvoice.FieldByName('INVOICE_DATE').AsDateTime;

    xEditorForm.ShowModal;
  finally
    xEditorForm.Free;
  end;
end;

procedure TInvoiceForm.actEditInvoiceLineExecute(Sender: TObject);
var
  xEditorForm: TEditInvoiceLineForm;
begin
  xEditorForm := TEditInvoiceLineForm.Create(Self);
  try
    xEditorForm.EditMode := emInvoiceLineEdit;
    xEditorForm.OnClose := EditInvoiceLineEditorClose;
    xEditorForm.Caption := 'Edit invoice line';

    xEditorForm.InvoiceLineId := qryInvoiceLine.FieldByName('INVOICE_LINE_ID')
      .AsInteger;
    xEditorForm.SetProduct(
      qryInvoiceLine.FieldByName('PRODUCT_ID').AsInteger,
      qryInvoiceLine.FieldByName('PRODUCTNAME').AsString,
      qryInvoiceLine.FieldByName('SALE_PRICE').AsCurrency);
    xEditorForm.Quantity := qryInvoiceLine.FieldByName('QUANTITY').AsInteger;

    xEditorForm.ShowModal;
  finally
    xEditorForm.Free;
  end;
end;

procedure TInvoiceForm.actExitExecute(Sender: TObject);
begin
  qryInvoiceLine.Close;
  qryInvoice.Close;
  Close;
end;

procedure TInvoiceForm.actInvoicePayExecute(Sender: TObject);
begin
  if MessageDlg('Do you really want to pay by invoice?', mtConfirmation,
    [mbYes, mbNo], 0) = mrYes then
  begin
    // We do everything in a short transaction
    trWrite.StartTransaction;
    try
      qryPayForInvoice.ParamByName('INVOICE_ID').AsInteger :=
        qryInvoice.FieldByName('INVOICE_ID').AsInteger;
      qryPayForInvoice.Execute;
      trWrite.Commit;
      qryInvoice.Refresh;
    except
      on E: EFDDBEngineException do
      begin
        if trWrite.Active then
          trWrite.Rollback;
        Application.ShowException(E);
      end;
    end;
  end;
end;

procedure TInvoiceForm.actRefreshExecute(Sender: TObject);
begin
  qryInvoice.Refresh;
end;

procedure TInvoiceForm.DateRangeChange(Sender: TObject);
begin
  qryInvoiceLine.Close;
  qryInvoice.Close;
  qryInvoice.ParamByName('date_begin').AsSqlTimeStamp := dmMain.BeginDateSt;
  qryInvoice.ParamByName('date_end').AsSqlTimeStamp := dmMain.EndDateSt;
  qryInvoice.Open;
  qryInvoiceLine.Open;
end;

procedure TInvoiceForm.EditInvoiceEditorClose(Sender: TObject;
  var Action: TCloseAction);
var
  xEditorForm: TEditInvoiceForm;
begin
  xEditorForm := TEditInvoiceForm(Sender);

  if xEditorForm.ModalResult <> mrOK then
  begin
    Action := caFree;
    Exit;
  end;

  // We do everything in a short transaction
  trWrite.StartTransaction;
  try

    qryEditInvoice.ParamByName('INVOICE_ID').AsInteger := xEditorForm.InvoiceId;
    qryEditInvoice.ParamByName('CUSTOMER_ID').AsInteger :=
      xEditorForm.CustomerId;
    qryEditInvoice.ParamByName('INVOICE_DATE').AsSqlTimeStamp :=
      DateTimeToSQLTimeStamp(xEditorForm.InvoiceDate);

    qryEditInvoice.Execute();

    trWrite.Commit;
    qryInvoice.Refresh;

    Action := caFree;
  except
    on E: Exception do
    begin
      if trWrite.Active then
        trWrite.Rollback;
      Application.ShowException(E);
      // It does not close the window give the user correct the error
      Action := caNone;
    end;
  end;
end;

procedure TInvoiceForm.EditInvoiceLineEditorClose(Sender: TObject;
  var Action: TCloseAction);
var
  xCustomerId: Integer;
  xEditorForm: TEditInvoiceLineForm;
begin
  xEditorForm := TEditInvoiceLineForm(Sender);

  if xEditorForm.ModalResult <> mrOK then
  begin
    Action := caFree;
    Exit;
  end;

  // We do everything in a short transaction
  trWrite.StartTransaction;
  try
    qryEditInvoiceLine.ParamByName('INVOICE_LINE_ID').AsInteger :=
      xEditorForm.InvoiceLineId;
    qryEditInvoiceLine.ParamByName('QUANTITY').AsInteger :=
      xEditorForm.Quantity;

    qryEditInvoiceLine.Execute();

    trWrite.Commit;
    qryInvoice.Refresh;
    qryInvoiceLine.Refresh;

    Action := caFree;
  except
    on E: Exception do
    begin
      if trWrite.Active then
        trWrite.Rollback;
      Application.ShowException(E);
      // It does not close the window give the user correct the error
      Action := caNone;
    end;
  end;
end;

procedure TInvoiceForm.FormActivate(Sender: TObject);
begin
  qryInvoice.ParamByName('date_begin').AsSqlTimeStamp := dmMain.BeginDateSt;
  qryInvoice.ParamByName('date_end').AsSqlTimeStamp := dmMain.EndDateSt;
  qryInvoice.Open;
  qryInvoiceLine.Open;
end;

procedure TInvoiceForm.FormCreate(Sender: TObject);
begin
  dmMain.AddDateChangeHandler(DateRangeChange);
end;

procedure TInvoiceForm.FormDestroy(Sender: TObject);
begin
  dmMain.RemoveDateChangeHandler(DateRangeChange);
end;

procedure TInvoiceForm.AddInvoiceEditorClose(Sender: TObject;
  var Action: TCloseAction);
var
  xEditorForm: TEditInvoiceForm;
begin
  xEditorForm := TEditInvoiceForm(Sender);

  if xEditorForm.ModalResult <> mrOK then
  begin
    Action := caFree;
    Exit;
  end;

  // We do everything in a short transaction
  trWrite.StartTransaction;
  try
    qryAddInvoice.ParamByName('CUSTOMER_ID').AsInteger :=
      xEditorForm.CustomerId;
    qryAddInvoice.ParamByName('INVOICE_DATE').AsSqlTimeStamp :=
      DateTimeToSQLTimeStamp(xEditorForm.InvoiceDate);

    qryAddInvoice.Execute();

    trWrite.Commit;
    qryInvoice.Refresh;

    Action := caFree;
  except
    on E: Exception do
    begin
      if trWrite.Active then
        trWrite.Rollback;
      Application.ShowException(E);
      // It does not close the window give the user correct the error
      Action := caNone;
    end;
  end;
end;

procedure TInvoiceForm.AddInvoiceLineEditorClose(Sender: TObject;
  var Action: TCloseAction);
var
  xEditorForm: TEditInvoiceLineForm;
  xCustomerId: Integer;
begin
  xEditorForm := TEditInvoiceLineForm(Sender);

  if xEditorForm.ModalResult <> mrOK then
  begin
    Action := caFree;
    Exit;
  end;

  // We do everything in a short transaction
  trWrite.StartTransaction;
  try
    qryAddInvoiceLine.ParamByName('INVOICE_ID').AsInteger :=
      xEditorForm.InvoiceId;

    if xEditorForm.ProductId = 0 then
      raise Exception.Create('Not selected product');

    qryAddInvoiceLine.ParamByName('PRODUCT_ID').AsInteger :=
      xEditorForm.ProductId;
    qryAddInvoiceLine.ParamByName('QUANTITY').AsInteger := xEditorForm.Quantity;

    qryAddInvoiceLine.Execute();

    trWrite.Commit;
    qryInvoice.Refresh;
    qryInvoiceLine.Refresh;

    Action := caFree;
  except
    on E: Exception do
    begin
      if trWrite.Active then
        trWrite.Rollback;
      Application.ShowException(E);
      // It does not close the window give the user correct the error
      Action := caNone;
    end;
  end;
end;

end.
