unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FreeUDFLib, StdCtrls, ibase, ib_externals, StdFuncs, StdConsts;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    btnMulti: TButton;
    btnStop: TButton;
    Label1: TLabel;
    lbl0: TLabel;
    Label5: TLabel;
    lbl5: TLabel;
    Label3: TLabel;
    lbl1: TLabel;
    Label8: TLabel;
    lbl6: TLabel;
    Label2: TLabel;
    lbl2: TLabel;
    Label9: TLabel;
    lbl7: TLabel;
    Label4: TLabel;
    lbl3: TLabel;
    Label11: TLabel;
    lbl8: TLabel;
    Label6: TLabel;
    lbl4: TLabel;
    Label10: TLabel;
    lbl9: TLabel;
    GroupBox2: TGroupBox;
    btnTestAll: TButton;
    Label7: TLabel;
    Label12: TLabel;
    GroupBox3: TGroupBox;
    lstFuncTest: TListBox;
    lblDescribeTest: TLabel;
    btnIndividualTest: TButton;
    btnPlay: TButton;
    procedure btnMultiClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure btnTestAllClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnIndividualTestClick(Sender: TObject);
    procedure btnPlayClick(Sender: TObject);
    procedure lstFuncTestClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  NumFuncs = 67;
  FuncList: array[0..NumFuncs - 1] of String = (
                                                'AddMonth',
                                                'AddYear',
                                                'AgeInDays',
                                                'AgeInDaysThreshold',
                                                'AgeInMonths',
                                                'AgeInMonthsThreshold',
                                                'AgeInWeeks',
                                                'AgeInYearsThreshold',
                                                'CDOWLong',
                                                'CDOWShort',
                                                'CMonthLong',
                                                'CMonthShort',
                                                'DayOfMonth',
                                                'DayOfWeek',
                                                'DayOfYear',
                                                'MaxDate',
                                                'MinDate',
                                                'Month',
                                                'Quarter',
                                                'StripDate',
                                                'StripTime',
                                                'WeekOfYear',
                                                'WOY',
                                                'Year',
                                                'YearOfYear',
                                                'Character',
                                                'CRLF',
                                                'FindFirstWord',// go
                                                'FindNextWord', // go
                                                'FindNthWord',  // go
                                                'FindWord',
                                                'FindWordIndex',
                                                'Left',
                                                'lrTrim',
                                                'lTrim',
                                                'Mid',
                                                'PadLeft',
                                                'PadRight',
                                                'ProperCase',
                                                'QPushQueue',
                                                'Right',
                                                'rTrim',
                                                'StringLength',
                                                'Strip',        // go
                                                'StripString',
                                                'SubStr',
                                                'GenerateFormattedName',
                                                'ValidateNameFormat',
                                                'ValidateRegularExpression',
                                                'ValidateStringInRE',
                                                'Debug',
                                                'GetCurrentResultValue', // go
                                                'IBTempPath',
                                                'ValidateCycleExpression',
                                                'EvaluateCycleExpression',
                                                'EvaluateExpression',
                                                'DollarVal',
                                                'FixedPoint',
                                                'Modulo',
                                                'IsDivisibleBy',
                                                'RoundFloat',
                                                'Truncate',
                                                'IBPassword',
                                                'DoubleAbs',
                                                'IntegerAbs',
                                                'LineWrap',
                                                'GenerateSndxIndex'
                                               );

function DateToQuad(d: TDateTime): TISC_QUAD;
function StrToQuad(st: String): TISC_QUAD;
function QuadToDate(var ibd: TISC_QUAD): TDateTime;
function QuadToStr(var ibd: TISC_QUAD): String;
procedure TestWeekOfYear;

var
  Form1: TForm1;
  cs_quit, cs_form: TRTLCriticalSection;
  quit_threads: Boolean;
  ib_date1, ib_date2: TISC_QUAD;
  ctm: TCTimeStructure;

implementation

{$R *.DFM}

uses
  WeekOfYear, GenerateFormattedName;
  
function TestLibFunc(i: Integer): Boolean;
var
  ib_date3: TISC_QUAD;
  ctm1: TCTimeStructure;
  j, k, l, m: Integer;
  ib_double, ib_double1: Double;
  st: String;
begin
  case i of
    0: begin
      j := 1;
      ib_date3 := FreeUDFLib.AddMonth(@ib_date1, j)^;
      isc_decode_date(@ib_date3, @ctm1);
      result := (ctm1.tm_mon = 1) and
                (ctm1.tm_mday = 1) and
                (ctm1.tm_year = 98);
    end;
    1: begin
      j := 1;
      ib_date3 := FreeUDFLib.AddYear(@ib_date1, j)^;
      isc_decode_date(@ib_date3, @ctm1);
      result := (ctm1.tm_mon = 0) and
                (ctm1.tm_mday = 1) and
                (ctm1.tm_year = 99);
    end;
    2: result := FreeUDFLib.AgeInDays(@ib_date2, @ib_date1) = 365;
    3: begin
      j := 0; k := 0; l := 6; m := 1;
      result := FreeUDFLib.AgeInDaysThreshold(@ib_date2, @ib_date1, j, k, l, m) = 6;
    end;
    4: result := FreeUDFLib.AgeInMonths(@ib_date2, @ib_date1) = 12;
    5: begin
      j := 0; k := 0; l := 6; m := 1;
      result := FreeUDFLib.AgeInMonthsThreshold(@ib_date2, @ib_date1, j, k, l, m) = 6;
    end;
    6: result := FreeUDFLib.AgeInWeeks(@ib_date2, @ib_date1) = 52;
    7: begin
      j := 0; k := 0; l := 6; m := 1;
      result := FreeUDFLib.AgeInWeeksThreshold(@ib_date2, @ib_date1, j, k, l, m) = 6;
    end;
    8: result := FreeUDFLib.CDOWLong(@ib_date1) = 'Thursday';
    9: result := FreeUDFLib.CDOWShort(@ib_date1) = 'Thu';
    10: result := FreeUDFLib.CMonthLong(@ib_date1) = 'January';
    11: result := FreeUDFLib.CMonthShort(@ib_date1) = 'Jan';
    12: result := FreeUDFLib.DayOfMonth(@ib_date1) = 1;
    13: result := FreeUDFLib.DayOfWeek(@ib_date1) = 5;
    14: result := FreeUDFLib.DayOfYear(@ib_date1) = 1;
    15: begin
      ib_date3 := FreeUDFLib.MaxDate(@ib_date1, @ib_date2)^;
      result := (ib_date3.gds_quad_high = ib_date1.gds_quad_high) and
                (ib_date3.gds_quad_low = ib_date1.gds_quad_low);
    end;
    16: begin
      ib_date3 := FreeUDFLib.MinDate(@ib_date1, @ib_date2)^;
      result := (ib_date3.gds_quad_high = ib_date2.gds_quad_high) and
                (ib_date3.gds_quad_low = ib_date2.gds_quad_low);
    end;
    17: result := FreeUDFLib.Month(@ib_date1) = 1;
    18: result := FreeUDFLib.Quarter(@ib_date1) = 1;
    19: begin
      FreeUDFLib.StripDate(@ib_date1);
      result := True;
    end;
    20: begin
      ib_date3 := FreeUDFLib.StripTime(@ib_date1)^;
      result := (ib_date3.gds_quad_high = ib_date1.gds_quad_high) and
                (ib_date3.gds_quad_low = ib_date1.gds_quad_low);
    end;
    21: result := FreeUDFLib.WeekOfYear(@ib_date1) = 53;
    22: result := String(FreeUDFLib.WOY(@ib_date1)) = '199753';
    23: result := FreeUDFLib.Year(@ib_date1) = 1998;
    24: result := FreeUDFLib.YearOfYear(@ib_date1) = 1997;
    25: begin
      j := 13;
      result := FreeUDFLib.Character(j)^ = #13;
    end;
    26: result := String(FreeUDFLib.CRLF) = StdConsts.CRLF;
    27: result := True;
    28: result := True;
    29: result := True;
    30: begin
      j := 0;
      result := String(FreeUDFLib.FindWord('Hello world', j)) = 'Hello';
    end;
    31: begin
      j := 5;
      result := FreeUDFLib.FindWordIndex('Hello world', j) = 6;
    end;
    32: begin
      j := 3;
      result := String(FreeUDFLib.Left('Hello world', j)) = 'Hel';
    end;
    33: result := String(FreeUDFLib.lrTrim('   Hello world   ')) = 'Hello world';
    34: result := String(FreeUDFLib.lTrim('   Hello world   ')) = 'Hello world   ';
    35: begin
      j := 3; k := 4;
      result := String(FreeUDFLib.Mid('Hello world', j, k)) = 'lo w';
    end;
    36: begin
      j := 10;
      result := String(FreeUDFLib.PadLeft('Hello', ' ', j)) = '     Hello';
    end;
    37: begin
      j := 10;
      result := String(FreeUDFLib.PadRight('Hello', ' ', j)) = 'Hello     ';
    end;
    38: result := String(FreeUDFLib.ProperCase('hello world')) = 'Hello World';
    39: result := True;
    40: begin
      j := 5;
      result := String(FreeUDFLib.Right('Hello World', j)) = 'World';
    end;
    41: result := String(FreeUDFLib.rTrim('   Hello world   ')) = '   Hello world';
    42: result := FreeUDFLib.StringLength('Hello') = 5;
    43: result := True;
    44: result := String(FreeUDFLib.StripString('Hello 234 World', '34 ')) = 'Hello2World';
    45: result := FreeUDFLib.SubStr('World', 'hello World') = 6;
    46: result := String(FreeUDFLib.GenerateFormattedName(
                  '\\ \P\\ \F\\. \M\\\L\, \\S',
                  'Mr.', 'John', '', 'Smith', 'Esq.')) = 'Mr. John Smith, Esq.';
    47: result := ValidateNameFormat('\\ \P\\ \F\\. \M\\\L\, \\S') = 1;
    48: result := FreeUDFLib.ValidateRegularExpression('') = 1;
    49: result := FreeUDFLib.ValidateStringInRE('', '') = 1;
    50: result := FreeUDFLib.Debug('Hello world') = 0;
    51: result := True;
    52: result := String(FreeUDFLib.IBTempPath) = String(StdFuncs.TempPath);
    53: begin
      j := 0;
      result := FreeUDFLib.ValidateCycleExpression('and 3 or >=5 $2000', j) = 1;
    end;
    54: begin
      j := 0; ib_double := 20000;
      result := FreeUDFLib.EvaluateCycleExpression('and 12 $20000',
                  j, @ib_date2, @ib_date1, ib_double) = 1;
    end;
    55: begin
      result := String(FreeUDFLib.EvaluateExpression(
                  'd1 = {12/1/97} and s1 = "hello world" and n1 = 15',
                  'd1 {12/1/97} s1 ''hello world'' n1 15'))
                  = 'TRUE';
    end;
    56: begin
      ib_double := 35.689;
      result := String(FreeUDFLib.DollarVal(ib_double)) = '$35.69';
    end;
    57: begin
      ib_double := 35.689; j := 3;
      result := String(FreeUDFLib.FixedPoint(ib_double, j)) = '35.689';
    end;
    58: begin
      j := 3; k := 2;
      result := FreeUDFLib.Modulo(j, k) = 1;
    end;
    59: begin
      j := 4; k := 2;
      result := FreeUDFLib.IsDivisibleBy(j, k) = 1;
    end;
    60: begin
      ib_double := 45.689; ib_double1 := 1;
      result := FreeUDFLib.RoundFloat(ib_double, ib_double1) = 46;
    end;
    61: begin
      ib_double := 45.689;
      result := FreeUDFLib.Truncate(ib_double) = 45;
    end;
    62: result := String(FreeUDFLib.IBPassword('hello')) =
                  'buc8moUKUUc';
    63: begin
      ib_double := -31;
      result := FreeUDFLib.DoubleAbs(ib_double) = 31;
    end;
    64: begin
      i := -10; j := 10;
      result := (FreeUDFLib.IntegerAbs(i) = 10) and
                (FreeUDFLib.IntegerAbs(j) = 10);
    end;
    65: begin
      st := 'This is the way the world ends. This is the way the world ends. ' +
            'This is the way the world ends. Not with a bang but a whimper.';
      i := 0; j := 20;
      result := FreeUDFLib.LineWrap(PChar(st), i, j) =
                'This is the way the ';
    end;
    66: begin
      st := 'Smith';
      result := FreeUDFLib.GenerateSndxIndex(PChar(st)) = 'S5300';
      st := 'Bremner';
      result := result and (FreeUDFLib.GenerateSndxIndex(PChar(st)) = 'B6560');
    end;
    else
      result := False;
  end;
end;

procedure TestLibrary;
var
  i: Integer;
begin
  (* Testing date routines *)
  for i := 0 to NumFuncs - 1 do
    if not TestLibFunc(i) then
      raise Exception.Create('Error executing function #' +
                             IntToStr(i) + ', ' + FuncList[i]);
end;

function ThreadFunc(Parameter: Pointer): Integer;
var
  quit: Boolean;
begin
  result := 0;
  while True do begin
    EnterCriticalSection(cs_quit);
    try
      quit := quit_threads;
    finally
      LeaveCriticalSection(cs_quit);
    end;
    if quit then exit;
    TestLibrary;
    EnterCriticalSection(cs_form);
    try
      TLabel(Parameter).Caption := IntToStr(
                                     StrToInt(TLabel(Parameter).Caption) + 1);
    finally
      LeaveCriticalSection(cs_form);
    end;
  end;
end;

procedure TForm1.btnMultiClick(Sender: TObject);
var
  ThreadID: DWORD;
begin
  SetDebuggerOutput('STDOUT');
  quit_threads := False;
  btnStop.Enabled := True;
  lbl0.Caption := '0';
  lbl1.Caption := '0';
  lbl2.Caption := '0';
  lbl3.Caption := '0';
  lbl4.Caption := '0';
  lbl5.Caption := '0';
  lbl6.Caption := '0';
  lbl7.Caption := '0';
  lbl8.Caption := '0';
  lbl9.Caption := '0';
  BeginThread(nil, 0, ThreadFunc, Pointer(lbl0), 0, ThreadID);
  BeginThread(nil, 0, ThreadFunc, Pointer(lbl1), 0, ThreadID);
  BeginThread(nil, 0, ThreadFunc, Pointer(lbl2), 0, ThreadID);
  BeginThread(nil, 0, ThreadFunc, Pointer(lbl3), 0, ThreadID);
  BeginThread(nil, 0, ThreadFunc, Pointer(lbl4), 0, ThreadID);
  BeginThread(nil, 0, ThreadFunc, Pointer(lbl5), 0, ThreadID);
  BeginThread(nil, 0, ThreadFunc, Pointer(lbl6), 0, ThreadID);
  BeginThread(nil, 0, ThreadFunc, Pointer(lbl7), 0, ThreadID);
  BeginThread(nil, 0, ThreadFunc, Pointer(lbl8), 0, ThreadID);
  BeginThread(nil, 0, ThreadFunc, Pointer(lbl9), 0, ThreadID);
end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
  EnterCriticalSection(cs_quit);
  try
    quit_threads := True;
  finally
    LeaveCriticalSection(cs_quit);
    CloseDebuggerOutput;
  end;
  btnStop.Enabled := False;
end;

procedure TForm1.btnTestAllClick(Sender: TObject);
var
  st: String;
begin
  if SetDebuggerOutput('STDOUT') = 0 then begin
    try
      TestLibrary;
    finally
      if CloseDebuggerOutput = 1 then
        raise Exception.Create('CloseDebuggerOutput failed.')
    end;
  end else
    raise Exception.Create('SetDebuggerOutput("STDOUT") failed');
  // Now test debugging to a file.
  st := GetTempFile('ful');
  try
    if SetDebuggerOutput(PChar(st)) = 0 then begin
      try
        TestLibrary;
      finally
        if CloseDebuggerOutput = 1 then
          raise Exception.Create('CloseDebuggerOutput("<file>") failed.');
      end;
    end else
      raise Exception.Create('SetDebuggerOutput("<file>") failed.');
  finally
    DeleteFile(st);
  end;
  ShowMessage('All tests pass!');
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to NumFuncs - 1 do
    lstFuncTest.Items.Add(FuncList[i]);
  lstFuncTest.ItemIndex := 0;
end;

procedure TForm1.btnIndividualTestClick(Sender: TObject);
begin
  case lstFuncTest.ItemIndex of
    21, 23: TestWeekOfYear;
  else
    ShowMessage('No custom test for ' + FuncList[lstFuncTest.ItemIndex]);
  end;
  ShowMessage('Success!');
end;

procedure TForm1.btnPlayClick(Sender: TObject);
var
  f: TForm;
begin
  case lstFuncTest.ItemIndex of
    21, 23: begin
      f := TfWeekOfYear.Create(Application);
      try
        f.ShowModal;
      finally
        f.Free;
      end;
    end;
    46: begin
      f := TfGenerateFormattedName.Create(Application);
      try
        f.ShowModal;
      finally
        f.Free;
      end;
    end;
   { 66: begin
      f := TfGenerateSndxIndex.Create(Application);
      try
        f.ShowModal;
      finally
        f.Free;
      end;
    end; }
  else
    ShowMessage('Can''t play with ' + FuncList[lstFuncTest.ItemIndex]);
  end;
end;

procedure TForm1.lstFuncTestClick(Sender: TObject);
begin
  case lstFuncTest.ItemIndex of
    21, 23:
      lblDescribeTest.Caption := 'Run through 2000 years and test the ' +
                                 'WeekOfYear and YearOfYear function ' +
                                 'for each day in each year. This function ' +
                                 'takes about 30-120 seconds.';
    else
      lblDescribeTest.Caption := 'Perform a thorough check on the selected '
                               + 'function. Not all functions have individual '
                               + 'tests--only those that have "odd" extreme '
                               + 'conditions.';
  end;
end;

function DateToQuad(d: TDateTime): TISC_QUAD;
var
  day, m, y: Word;
  ctmd: TCTimeStructure;
begin
  DecodeDate(d, y, m, day);
  ctmd.tm_year := y - 1900;
  ctmd.tm_mon := m - 1;
  ctmd.tm_mday := day;
  isc_encode_date(@ctmd, @result);
end;

function StrToQuad(st: String): TISC_QUAD;
begin
  result := DateToQuad(StrToDate(st));
end;

function QuadToDate(var ibd: TISC_QUAD): TDateTime;
var
  d, m, y: Word;
  ctmd: TCTimeStructure;
begin
  isc_decode_date(@ibd, @ctmd);
  y := ctmd.tm_year + 1900;
  m := ctmd.tm_mon + 1;
  d := ctmd.tm_mday;
  result := EncodeDate(y, m, d);
end;

function QuadToStr(var ibd: TISC_QUAD): String;
begin
  result := DateToStr(QuadToDate(ibd));
end;

procedure TestWeekOfYear;
var
  ibd: TISC_QUAD;
  d, de: TDateTime;
  dow, cur_year, cur_week: Integer;
begin
  Screen.Cursor := crHourglass;
  try
    // Do a whole slew of tests of YearOfYear and WeekOfYear
    d := StrToDate('1/1/1000');
    de := StrToDate('1/1/3000');
    dow := dWed;
    cur_year := 1000;
    cur_week := 1;
    while d <= de do begin
      ibd := DateToQuad(d);
      if not ((FreeUDFLib.WeekOfYear(@ibd) = cur_week) and (YearOfYear(@ibd) = cur_year)) then
        raise Exception.Create('Bad WeekOfYear: ' + DateToStr(d));
      d := d + 1;
      dow := (dow mod 7) + 1;
      if dow = 1 then begin
        (*
         * If it's Sunday, then I have to check
         *   if Sun, Mon, Tue or Wed start the new year
         *     it's week 1 of next year.
         *   if
         *)
        if (StdFuncs.Year(d) = cur_year + 1) or
           (StdFuncs.Year(d + 1) = cur_year + 1) or
           (StdFuncs.Year(d + 2) = cur_year + 1) or
           (StdFuncs.Year(d + 3) = cur_year + 1) then begin
          cur_week := 1;
          Inc(cur_year);
        end else
          Inc(cur_week);
      end;
    end;
  finally
    Screen.Cursor := crDefault;
  end;
end;

initialization

  IsMultiThread := True;
  InitializeCriticalSection(cs_quit);
  InitializeCriticalSection(cs_form);
  (* Get prepared for date testing *)
  ctm.tm_mday := 1;
  ctm.tm_mon := 0;
  ctm.tm_year := 98;
  isc_encode_date(@ctm, @ib_date1);
  ctm.tm_mday := 1;
  ctm.tm_mon := 0;
  ctm.tm_year := 97;
  isc_encode_date(@ctm, @ib_date2);
  ShortDateFormat := 'm/d/yyyy';

finalization

  DeleteCriticalSection(cs_quit);
  DeleteCriticalSection(cs_form);

end.
