unit CommUnit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls,IniFiles, Menus,StdCtrls,DateUtil, DB, SHellApi,
  FileUtil,Windows, Registry;

type
  TProperty=class;

  TOwner=class
  protected
    FProperty:TList; { }
  public
    function Insert(AProperty:TProperty):Integer; {  }
    procedure Remove(AProperty:TProperty); { }
    function GetProperty(Index:Integer):TProperty;
    function GetPropertyCount:Integer;
    constructor Create;virtual;
    destructor Destroy;virtual;
    property AProperty[Index:Integer]:TProperty
             read GetProperty;
    property APropertyCount:Integer
             read GetPropertyCount;
  end;

  TProperty=class
  protected
    FIndex:Integer;
    FOwner:TOwner;
  public
    constructor Create(AOwner:TOwner);virtual;
    destructor Destroy;virtual;
  end;

  TContainer=class
  protected
    FIndex:Integer;
    FContainer:TContainer;
    FContainers:TList;
    function Insert(AContainer:TContainer):Integer;
    procedure Remove(AContainer:TContainer);
    function  GetContainersCount:Integer;
    function  GetContainer(Index:Integer):TContainer;
    procedure SetContainer(AContainer:TContainer);
  public
    constructor Create(AContainer:TContainer);virtual;
    destructor  Destroy;virtual;
    property  ContainersCount:Integer
              read GetContainersCount;
    property  Containers[Index:Integer]:TContainer
              read GetContainer;
    property  Container:TContainer
              read FContainer
              write SetContainer;
  end;

  TBooleanList=class
  protected
    List:TList;
    function GetBooleanValue(Index:Integer):Boolean;
    function GetCount:Integer;
    procedure SetBooleanValue(Index:Integer;Value:Boolean);
  public
    constructor Create;
    destructor Destroy;
    function Add(Value:Boolean):Integer;  //    
    procedure Remove(Index:Integer);  //   
    procedure Clear;                  //    
    property BooleanValues[Index:Integer]:Boolean
             read GetBooleanValue
             write SetBooleanValue;default;
    property Count:Integer
             read GetCount;
  end;

  TIntegerList=class
  protected
    List:TList;
    function GetIntegerValue(Index:Integer):Integer;
    function GetCount:Integer;
    procedure SetIntegerValue(Index:Integer;Value:Integer);
  public
    constructor Create;
    destructor Destroy;
    function Add(Value:Integer):Integer; //    
    function IndexOf(Value:Integer):Integer; //     
    procedure Remove(Index:Integer); //  
    procedure Clear;                 //  
    property IntegerValues[Index:Integer]:Integer
             read GetIntegerValue
             write SetIntegerValue;default;
    property Count:Integer
             read GetCount;
  end;

  TDoubleList=class
  protected
    List:TList;
    function GetDoubleValue(Index:Integer):Double;
    function GetCount:Integer;
    procedure SetDoubleValue(Index:Integer;Value:Double);
  public
    constructor Create;
    destructor Destroy;
    function Add(Value:Double):Integer;
    procedure Remove(Index:Integer);
    procedure Clear;
    property DoubleValues[Index:Integer]:Double
             read GetDoubleValue
             write SetDoubleValue;default;
    property Count:Integer
             read GetCount;
  end;

  TLineType=(ltTop,ltAverage,ltBottom);

  TCharSet=set of Char;

  PByte=^Byte;
  PBoolean=^Boolean;
  PInteger=^Integer;
  PDouble=^Double;
  PIntegerList=^TIntegerList;
  PDataSet=^TDataSet;
  PStrings=^TStrings;
  TPercent=0..100;
  TAngle=0..360;

procedure PlayInformationMessage;
procedure PlayExclamationMessage;
procedure PlayQuestionMessage;
procedure PlayErrorMessage;
procedure PlayDefaultMessage;
procedure PlayMessage(Number:Integer);
procedure NextDate(var Day,Month,Year:Integer);
procedure PrevDate(var Day,Month,Year:Integer);
function MakeFullName(Directory,Name:String):String;
function CompareMaskedValues(FirstValue,SecondValue:String):Boolean;
function StringInList(Value:String;StringList:TStrings):Boolean;
function IndexInList(Value:String;StringList:TStrings):Integer;
function IndexInNumList(Value:Integer;IntegerList:TIntegerList):Integer;
function DayFromDate(DateString:String):Integer;
function MounthFromDate(DateString:String):Integer;
function YearFromDate(DateString:String):Integer;
function HourFromTime(Value:TTime):String;
function MinuteFromTime(Value:TTime):String;
function CutString(Value:String;CutFrom,CutTo:Integer):String;
function StrInString(Value1,Value2:String):Boolean;
function TabbedString(Value:String;Len:Integer):String;
function WriteLineToFile(Filename:String;TextColumns:TStrings;Tabs:TIntegerList):Boolean;
function WriteGraphLineToFile(Filename:String;LineType:TLineType;Tabs:TIntegerList):Boolean;
function WriteStringToFile(Handler:Integer;const Value:String):Boolean;
function WriteNumToFile(Handler:Integer;const Value:Integer):Boolean;
function WriteByteToFile(Handler:Integer;const Value:Byte):Boolean;
function WriteStringsToFile(Handler:Integer; Strings:TStrings):Boolean;
function WriteIntegersToFile(Handler:Integer; Integers:TIntegerList):Boolean;
function WriteRealToFile(Handler:Integer;const Value:Real):Boolean;
function WriteDoubleToFile(Handler:Integer;const Value:Double):Boolean;
function ReadNumFromFile(Handler:Integer):Integer;
function ReadByteFromFile(Handler:Integer):Byte;
function ReadStringFromFile(Handler:Integer):String;
function ReadStringsFromFile(Handler:Integer;var Value:TStrings):Boolean;
function ReadIntegersFromFile(Handler:Integer;var Value:TIntegerList):Boolean;
function ReadDoubleFromFile(Handler:Integer):Double;
function ReadRealFromFile(Handler:Integer):Real;
function ValueIsNumber(Value:String):Boolean;
function ValueInRange(Value,Top,Bottom:Integer):Boolean;
function CommaToPoint(Value:String):String;
function VarToFloat(V:Variant):Double;
function Around(Value:Double;Length,Decimals:Integer):Double;
procedure IndexedTextOut(Canvas:TCanvas;X,Y:Integer;Text:String);
procedure Circle(Canvas:TCanvas;X,Y,D:Integer);
function MakeFillStr(Value:Char;Count:Integer):String;
function RemoveLastSpaces(Value:String):String;
function RealToText(Value:Real):String;
function GetHalf(Value:String;Count:Integer):String;
function FileCopy(SrcName,DstName:String):Boolean;
function RemoveBackSlash(Directory:String):String;
function GetMaxLengthInStrings(Strings:TStrings):Integer;
procedure RefreshDataSet(DataSet:TDataSet);
function GetValueFromKey(KeyName,KeyValue,ResultField:String;DataSet:TDataSet):String;
function MakeValidDate(Value:String):String;
function MakeValidTime(Value:String):String;
function ArraysIndentical(Arr1,Arr2:array of byte;Len:Integer):Boolean;
function ExecuteFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
function GetNameWOExt(Value:String):String;
procedure CreateEmptyFile(Filename:String);
function LastRecord(DataSet:TDataSet):Boolean;
procedure RefreshDataSetEx(DataSet:TDataSet;ForceOpen:Boolean);
function NumberValid(Value:String):Boolean;
function CutInitials(FullName:String):String;
function GetTempFileName:String;
procedure EnableGDS_DB;
function StrInStrings(Value:String;Strings:TStrings):Boolean;
function AxGetComputerName:String;
function StringsMatches(Value1,Value2:String):Boolean;
function GetWord(Value:String;WordNo:Integer;CharSet:TCharSet):String;
function GetWordsCount(Value:String;CharSet:TCharSet):Integer;
procedure FillStringsFromDataSet(Strings:TStrings;KeyField:String;DataSet:TDataSet);
function FilterString(Value:String;Filter:TCharSet):String;
function StringAsPChar(Value:String):PChar;
function GetNextWorkDay(Value:TDateTime):TDateTime;
function Abbreviate(Value:String;CharCount:Integer):String;
function GetFileDateTime(Filename:String):TDateTime;
function StringToUUE(Str:String):String;
function UUEToString(Value:String):String;

implementation

constructor TDoubleList.Create;
begin
  List:=TLIst.Create;
end;

destructor TDoubleList.Destroy;
var
  Instance:PDouble;
begin
  while (List.Count<>0) do
  begin
    Instance:=List.Last;
    List.Remove(Instance);
    Dispose(Instance);
  end;
  List.Free;
end;

function TDoubleList.GetDoubleValue(Index:Integer):Double;
begin
  Result:=PDouble(List[Index])^;
end;

function TDoubleList.GetCount:Integer;
begin
  Result:=List.Count;
end;

procedure TDoubleList.SetDoubleValue(Index:Integer;Value:Double);
var
  Instance:PDouble;
begin
  Instance:=List[Index];
  Instance^:=Value;
end;

function TDoubleList.Add(Value:Double):Integer;
var
  Instance:PDouble;
begin
  New(Instance);
  Instance^:=Value;
  List.Add(Instance);
  Result:=List.Count-1;
end;

procedure TDoubleList.Remove(Index:Integer);
var
  Instance:PDouble;
begin
  Instance:=List[Index];
  List.Remove(Instance);
  Dispose(Instance);
end;

procedure TDoubleList.Clear;
var
  Instance:PDouble;
begin
  while (List.Count<>0) do
  begin
    Instance:=List.Last;
    List.Remove(Instance);
    Dispose(Instance);
  end;
end;

constructor TIntegerList.Create;
begin
  List:=TList.Create;
end;

destructor TIntegerList.Destroy;
var
  Instance:PInteger;
begin
  while (List.Count<>0) do
  begin
    Instance:=List.Last;
    List.Remove(Instance);
    Dispose(Instance);
  end;
  List.Free;
end;

function TIntegerList.GetIntegerValue(Index:Integer):Integer;
begin
  Result:=PInteger(List[Index])^;
end;

function TIntegerList.GetCount:Integer;
begin
  Result:=List.Count;
end;

procedure TIntegerList.SetIntegerValue(Index:Integer;Value:Integer);
var
  Instance:PInteger;
begin
  Instance:=List[Index];
  Instance^:=Value;
end;

function TIntegerList.Add(Value:Integer):Integer;
var
  Instance:PInteger;
begin
  New(Instance);
  Instance^:=Value;
  List.Add(Instance);
  Result:=List.Count-1;
end;

procedure TIntegerList.Remove(Index:Integer);
var
  Instance:PInteger;
begin
  Instance:=List[Index];
  List.Remove(Instance);
  Dispose(Instance);
end;

procedure TIntegerList.Clear;
var
  Instance:PInteger;
begin
  while (List.Count<>0) do
  begin
    Instance:=List.Last;
    List.Remove(Instance);
    Dispose(Instance);
  end;
end;

constructor TBooleanList.Create;
begin
  List:=TList.Create;
end;

destructor TBooleanList.Destroy;
var
  Instance:PBoolean;
begin
  while (List.Count<>0) do
  begin
    Instance:=List.Last;
    List.Remove(Instance);
    Dispose(Instance);
  end;
  List.Free;
end;

function TBooleanList.GetBooleanValue(Index:Integer):Boolean;
begin
  Result:=PBoolean(List[Index])^;
end;

procedure TBooleanList.SetBooleanValue(Index:Integer;Value:Boolean);
var
  Instance:PBoolean;
begin
  Instance:=List[Index];
  Instance^:=Value;
end;

function TBooleanList.GetCount:Integer;
begin
  Result:=List.Count;
end;

function TBooleanList.Add(Value:Boolean):Integer;
var
  Instance:PBoolean;
begin
  New(Instance);
  Instance^:=Value;
  List.Add(Instance);
  Result:=List.Count-1;
end;

procedure TBooleanList.Remove(Index:Integer);
var
  Instance:PBoolean;
begin
  Instance:=List[Index];
  List.Remove(Instance);
  Dispose(Instance);
end;

procedure TBooleanList.Clear;
var
  Instance:PBoolean;
begin
  while (List.Count<>0) do
  begin
    Instance:=List.Last;
    List.Remove(Instance);
    Dispose(Instance);
  end;
end;

constructor TContainer.Create(AContainer:TContainer);
begin
  FContainers:=TList.Create;
  if AContainer<>nil then
     FIndex:=AContainer.Insert(Self);
  FContainer:=AContainer;
end;

destructor TContainer.Destroy;
var
  Instance:TContainer;
begin
  if FContainers<>nil then
     while FContainers.Count<>0 do   {  }
     begin
       Instance:=FContainers.Last;
       Instance.Destroy;
     end;
  if FContainer<>nil then
     FContainer.Remove(Self);        {   }
  FContainers.Free;
end;

function TContainer.Insert(AContainer:TContainer):Integer;
begin
  Result:=FContainers.Add(AContainer);
end;

procedure TContainer.Remove(AContainer:TContainer);
begin
  FContainers.Remove(AContainer);
end;

function TContainer.GetContainersCount:Integer;
begin
  Result:=FContainers.Count
end;

function TContainer.GetContainer(Index:Integer):TContainer;
begin
  Result:=FContainers.Items[Index]
end;

procedure TContainer.SetContainer(AContainer:TContainer);
begin
  if FContainer<>nil then
     FContainer.Remove(Self);
  if AContainer<>nil then
     FIndex:=AContainer.Insert(Self);
  FContainer:=AContainer;
end;

constructor TOwner.Create;
begin
  FProperty:=TList.Create;
end;

destructor TOwner.Destroy;
var
  Instance:TProperty;
begin
  while FProperty.Count<>0 do
  begin
    Instance:=FProperty.Last;
    Instance.Destroy;
  end;
  FProperty.Free;
end;

function TOwner.Insert(AProperty:TProperty):Integer;
begin
  Result:=FProperty.Add(AProperty);
end;

procedure TOwner.Remove(AProperty:TProperty);
begin
  FProperty.Remove(AProperty);
end;

function TOwner.GetProperty(Index:Integer):TProperty;
begin
  Result:=FProperty.Items[Index];
end;

function TOwner.GetPropertyCount:Integer;
begin
  Result:=FProperty.Count;
end;

constructor TProperty.Create(AOwner:TOwner);
begin
  FIndex:=AOwner.Insert(Self);
  FOwner:=AOwner;
end;

destructor TProperty.Destroy;
begin
  FOwner.Remove(Self);
end;


function CompareMaskedValues(FirstValue,SecondValue:String):Boolean;
var
  I:Integer;
begin
  if Length(FirstValue)<>Length(SecondValue) then
  begin
    Result:=False;
    Exit;
  end;
  for i:=1 to Length(FirstValue) do
  begin
    if (FirstValue[i]='#') or (SecondValue[i]='#') then
       Continue;
    if FirstValue[i]<>SecondValue[i] then
    begin
      Result:=False;
      Exit;
    end;
  end;
  Result:=True;
end;

procedure PlayInformationMessage;
begin
  PlayMessage(64);
end;

procedure PlayExclamationMessage;
begin
  PlayMessage(48);
end;

procedure PlayQuestionMessage;
begin
  PlayMessage(32);
end;

procedure PlayErrorMessage;
begin
  PlayMessage(16);
end;

procedure PlayDefaultMessage;
begin
  PlayMessage(0);
end;

procedure PlayMessage(Number:Integer);
begin
  with TIniFile.Create(ChangeFileExt(ExtractFilename(Application.ExeName),'.INI')) do
    try
      if ReadBool('Options','UseSound',True) then
         MessageBeep(Number);
    finally
      Free;
    end;
end;

function MakeFullName(Directory,Name:String):String;
begin
  if Directory[Length(Directory)]='\' then
     Result:=Directory
  else
     Result:=Directory+'\';
  Result:=Result+Name;
end;

//  -     
function  StringInList(Value:String;StringList:TStrings):Boolean;
var
  i:Integer;
begin
  Result:=False;  //  ,      
  for i:=0 to StringList.Count-1 do
  begin
    if StringList[i]=Value then
    //  -  
       Result:=True;
  end;
end;

//     
function  IndexInList(Value:String;StringList:TStrings):Integer;
var
  i:Integer;
begin
  Result:=0-1;
  for i:=0 to StringList.Count-1 do
      if StringList[i]=Value then
         if Result=0-1 then
            Result:=i
         else
            begin
              Result:=0-1;
              Exit;
            end;
end;

function FromPointToPoint(From:Integer;DateStr:String):String;
var
  i:Integer;
  j:Integer;
begin
  Result:='';
  i:=0;
  j:=1;
  //     
  while (i<From) do
  begin
    if DateStr[j]='.' then
       i:=i+1;
    j:=j+1;
  end;
  //     
  while ((DateStr[j]<>'.') and (j<=Length(DateStr))) do
  begin
    Result:=Result+DateStr[j];
    j:=j+1;
  end;
end;

function DayFromDate(DateString:String):Integer;
begin
  Result:=StrToInt(FromPointToPoint(0,DateString));
end;

function MounthFromDate(DateString:String):Integer;
begin
  Result:=StrToInt(FromPointToPoint(1,DateString));
end;

function YearFromDate(DateString:String):Integer;
begin
  Result:=StrToInt(FromPointToPoint(2,DateString));
end;

procedure NextDate(var Day,Month,Year:Integer);
begin
  Day:=Day+1;
  if Day>DaysPerMonth(Year,Month) then
  begin
    Day:=1;
    Month:=Month+1;
    if Month>12 then
       Year:=Year+1;
  end;
end;

procedure PrevDate(var Day,Month,Year:Integer);
begin
  Day:=Day-1;
  if Day=0 then
  begin
    Month:=Month-1;
    if Month=0 then
    begin
      Month:=12;
      Year:=Year-1;
    end;
    Day:=DaysPerMonth(Year,Month);
  end;
end;

function CutString(Value:String;CutFrom,CutTo:Integer):String;
var
  i:Integer;
begin
  Result:='';
  if Length(Value)>=CutTo then
     for i:=CutFrom to CutTo do
         Result:=Result+Value[i];
end;

function TabbedString(Value:String;Len:Integer):String;
var
  i:Integer;
begin
  Result:=Value;
  if Len>Length(Value) then
     for i:=1 to Len-Length(Value) do
         Result:=Result+' ';
end;

function  WriteLineToFile(Filename:String;TextColumns:TStrings;Tabs:TIntegerList):Boolean;
var
  i:Integer;
  F:TextFile;
  TextValue:String;
  TextValue2:String;
begin
{$I-}
  AssignFile(F,Filename);
  Append(F);
  try
    if TextColumns.Count<>Tabs.Count then
    begin //  -   -    ,   
      Result:=False;
      Exit;
    end;
    for i:=0 to TextColumns.Count-1 do
    begin //   
      Write(F,#179+#32); //  
      TextValue:=TabbedString(TextColumns[i],Tabs[i])+#0;
      TextValue2:=TextValue;
      CharToOEM(@TextValue[1],@TextValue2[1]);
      Write(F,TextValue2);
      Write(F,#32);      //   
    end; // for i:=0...
    WriteLn(F,#179);       //  
  finally
    CloseFile(F);
  end;
  {$I+}
end;

function  WriteGraphLineToFile(Filename:String;LineType:TLineType;Tabs:TIntegerList):Boolean;
var
  i,j:Integer;
  F:TextFile;
begin
  {$I-}
  AssignFile(F,Filename);
  Append(F);
  try
    { }
    if LineType=ltTop then
       Write(F,#218);
    if LineType=ltAverage then
       Write(F,#195);
    if LineType=ltBottom then
       Write(F,#192);
    for i:=0 to Tabs.Count-1 do //     
    begin
      for j:=0 to Tabs[i]+2 do
          Write(F,#196);
      if i<>Tabs.Count-1 then
      begin //     , ...
        if LineType=ltTop then
           Write(F,#194);
        if LineType=ltAverage then
           Write(F,#197);
        if LineType=ltBottom then
           Write(F,#193);
      end
      else
      begin //  , ...
        if LineType=ltTop then
           WriteLn(F,#191); //  ,  -
        if LineType=ltAverage then
           WriteLn(F,#180);
        if LineType=ltBottom then
           WriteLn(F,#217);
      end;
    end;
  finally
    CloseFile(F);
  end;
end;

function WriteNumToFile(Handler:Integer;const Value:Integer):Boolean;
begin
  if FileWrite(Handler,Value,SizeOf(Value))<>SizeOf(Value) then
     Result:=False
  else
     Result:=True;
end;

function WriteByteToFile(Handler:Integer;const Value:Byte):Boolean;
begin
  if FileWrite(Handler,Value,SizeOf(Value))<>SizeOf(Value) then
     Result:=False
  else
     Result:=True;
end;

function WriteStringToFile(Handler:Integer;const Value:String):Boolean;
begin
  if WriteNumToFile(Handler,Length(Value)) then
     if FileWrite(Handler,Pointer(Value)^,Length(Value))<>Length(Value) then
        Result:=False
     else
        Result:=True;
end;

function WriteStringsToFile(Handler:Integer; Strings:TStrings):Boolean;
var
  i:Integer;
begin
  Result:=True;
  WriteNumToFile(Handler,Strings.Count);  { - }
  for i:=0 to Strings.Count-1 do          {   }
      if not WriteStringToFile(Handler,Strings[i]) then
      begin
        Result:=False;
        Exit;
      end;
end;

function WriteIntegersToFile(Handler:Integer; Integers:TIntegerList):Boolean;
var
  i:Integer;
begin
  Result:=True;
  WriteNumToFile(Handler,Integers.Count);  { - }
  for i:=0 to Integers.Count-1 do          {   }
      if not WriteNumToFile(Handler,Integers.IntegerValues[i]) then
      begin
        Result:=False;
        Exit;
      end;
end;

function WriteRealToFile(Handler:Integer;const Value:Real):Boolean;
begin
  if FileWrite(Handler,Value,SizeOf(Value))<>SizeOf(Value) then
     Result:=False
  else
     Result:=True;
end;

function ReadRealFromFile(Handler:Integer):Real;
begin
  FileRead(Handler,Result,SizeOf(Result));
end;

function ReadNumFromFile(Handler:Integer):Integer;
begin
  FileRead(Handler,Result,SizeOf(Result));
end;

function ReadByteFromFile(Handler:Integer):Byte;
begin
  FileRead(Handler,Result,SizeOf(Result));
end;

function ReadStringFromFile(Handler:Integer):String;
var
  i:Integer;
  Buffer:Char;
begin
  Result:='';
  for i:=1 to ReadNumFromFile(Handler) do
  begin
    FileRead(Handler,Buffer,SizeOf(Buffer));
    Result:=Result+Buffer;
  end;
end;

function ReadStringsFromFile(Handler:Integer; var Value:TStrings):Boolean;
var
  i:Integer;
  Str:String;
begin
  for i:=0 to ReadNumFromFile(Handler)-1 do
  begin
    Str:=ReadStringFromFile(Handler);
    Value.Add(Str);
    Str:='';
  end;
end;

function ReadIntegersFromFile(Handler:Integer; var Value:TIntegerList):Boolean;
var
  i:Integer;
  Num:Integer;
begin
  for i:=0 to ReadNumFromFile(Handler)-1 do
  begin
    Num:=ReadNumFromFile(Handler);
    Value.Add(Num);
  end;
end;

function StrInString(Value1,Value2:String):Boolean;
var
  i,j:Integer;
  Founded:Boolean;
begin
  Founded:=False;
  i:=1;
  for j:=1 to Length(Value2) do
      if Value2[j]=Value1[i] then
      begin
        Result:=True;
        Founded:=True;
        i:=i+1;
        if i>Length(Value1) then
           Exit;
      end
      else
      if Founded then
      begin
        Result:=False;
        i:=1;
      end;
end;

function  IndexInNumList(Value:Integer;IntegerList:TIntegerList):Integer;
var
  i:Integer;
begin
  Result:=-1;
  for i:=0 to IntegerList.Count-1 do
      if IntegerList.IntegerValues[i]=Value then
      begin
        Result:=i;
        Break;
      end;
end;

function ValueIsNumber(Value:String):Boolean;
var
  i:Integer;
begin
  Result:=True;
  if Value='' then
     Result:=False;
  for i:=1 to Length(Value) do
      if (Value[i]<',') or (Value[i]>'9') then
      begin
        Result:=False;
        Break;
      end;
end;

function ValueInRange(Value,Top,Bottom:Integer):Boolean;
begin
  if (Value>Bottom) and (Value<Top) then
     Result:=True
  else
     Result:=False;
end;

function CommaToPoint(Value:String):String;
var
  i:Integer;
begin
  Result:='';
  for i:=1 to Length(Value) do
      if Value[i]=',' then
         Result:=Result+'.'
      else
         Result:=Result+Value[i];
end;

function VarToFloat(V:Variant):Double;
begin
  Result:=0;
  if VarType(V)<>varNull then
     Result:=V;
end;

function Around(Value:Double;Length,Decimals:Integer):Double;
var
  TempString:String;
  a:Integer;
begin
  Str(Value:Length:Decimals,TempString);
  Val(TempString, Result, a);
  if a<>0 then
  begin //    ,     
    MessageDlg('   "'+TempString[a]+'"', mtError,[mbOK],0);
    Result:=1.7 * Exp(308*ln(10));
  end;
end;

procedure IndexedTextOut(Canvas:TCanvas;X,Y:Integer;Text:String);
var
  i:Integer;
  DefaultFontSize:Integer;
  NextCharLeft:Integer;
  NextCharTop:Integer;
begin
  NextCharLeft:=X;
  NextCharTop:=Y;
  DefaultFontSize:=Canvas.Font.Size;
  for i:=1 to Length(Text) do
  begin //    ...
    if Text[i]='_' then
    begin //  
      Canvas.Font.Size:=Canvas.Font.Size-(DefaultFontSize div 2); //    
      NextCharTop:=NextCharTop+Canvas.TextHeight(Text[i-1]); //    
      Continue;
    end;
    if Text[i]='|' then
    begin //  
      Canvas.Font.Size:=Canvas.Font.Size-(DefaultFontSize div 2); //   
      NextCharTop:=NextCharTop-Canvas.TextHeight(Text[i-1]); //    
      Continue;
    end;
    if Text[i]='\' then
    begin //  
      Canvas.Font.Size:=DefaultFontSize;
      NextCharTop:=Y;
      Continue;
    end;
    Canvas.TextOut(NextCharLeft, NextCharTop, Text[i]);
    NextCharLeft:=NextCharLeft+Canvas.TextWidth(Text[i])+1;
  end;
  Canvas.Font.Size:=DefaultFontSize;
end;

procedure Circle(Canvas:TCanvas;X,Y,D:Integer);
var
  k:Integer;
begin
  k:=D div 2;
  with Canvas do
       Ellipse(X-k, Y-k, X+k, Y+k);
end;

function MakeFillStr(Value:Char;Count:Integer):String;
var
  i:Integer;
begin
  Result:='';
  for i:=1 to Count do
      Result:=Result+Value;
end;

function RemoveLastSpaces(Value:String):String;
var
  i:Integer;
begin
  Result:=Value;
  for i:=Length(Value) downto 1 do
      if Value[i]<>#32 then
         Break; // ,      
  SetLength(Result,i);
end;

function RealToText(Value:Real):String;
var
  TextPointer:PChar;
  i:Integer;
begin
  TextPointer:=@Value;
  Result:='';
  for i:=0 to 7 do
      Result:=Result+TextPointer[i];
end;

function GetHalf(Value:String;Count:Integer):String;
var
  i:Integer;
begin
  i:=1;
  while (Count<>0) do
  begin
    while (Value[i]<>',') and (i<=Length(Value)) do
          i:=i+1;
    Count:=Count-1;
    i:=i+1;
  end;
  Result:='';
  while (Value[i]<>',') and (i<=Length(Value)) do
  begin
    Result:=Result+Value[i];
    i:=i+1;
  end;
end;

function FileCopy(SrcName,DstName:String):Boolean;
var
  Src,Dst:PChar;
begin
  StrPCopy(Src,SrcName);
  StrPCopy(Dst,DstName);
  CopyFile(Src,Dst,False);
  Dispose(Src);
  Dispose(Dst);
end;

function RemoveBackSlash(Directory:String):String;
begin
  if Directory<>'' then
     if Directory[Length(Directory)]='\' then
        Directory:=CutString(Directory,1,Length(Directory)-1);
  Result:=Directory;
end;

function GetMaxLengthInStrings(Strings:TStrings):Integer;
var
  i:Integer;
begin
  Result:=0;
  for i:=0 to Strings.Count-1 do
      if Length(Strings[i])>Result then
         Result:=Length(Strings[i]);
end;

procedure RefreshDataSet(DataSet:TDataSet);
var
  LastKey:Integer;
  i:Integer;
  FieldName:String;
begin
  if not DataSet.Active then
     Exit
  else
  if DataSet.DataSource<>nil then
     if not DataSet.DataSource.DataSet.Active then
        Exit;
  for i:=0 to DataSet.FieldCount-1 do
      if (DataSet.Fields[i].DataType=ftInteger) then
      begin
        FieldName:=DataSet.Fields[i].FieldName;
        LastKey:=DataSet.Fields[i].AsInteger;
        DataSet.Close;
        DataSet.Open;
        DataSet.Locate(FieldName,LastKey,[]);
        Break;
      end;
end;

function GetValueFromKey(KeyName,KeyValue,ResultField:String;DataSet:TDataSet):String;
var
  LastPos:Integer;
begin
  LastPos:=DataSet.FieldByName(KeyName).AsInteger;
  if DataSet.Locate(KeyName,KeyValue,[]) then
     Result:=DataSet.FieldByName(ResultField).AsString
  else
     Result:='';
  DataSet.Locate(KeyName, LastPos,[]);
end;

function MakeValidDate(Value:String):String;
var
  i:Integer;
begin
  Result:='01.01.1999';
  i:=0;
  repeat
    i:=i+1;
    if (Value[i]<'0') or (Value[i]>'9') then
       Continue;
    Result[i]:=Value[i];
  until(i=10);
end;

function MakeValidTime(Value:String):String;
var
  i:Integer;
begin
  Result:='00:00';
  i:=0;
  repeat
    i:=i+1;
    if (Value[i]<'0') or (Value[i]>':') then
       Continue;
    Result[i]:=Value[i];
  until(i=5);
end;

function ArraysIndentical(Arr1,Arr2:array of byte;Len:Integer):Boolean;
var
  i:Integer;
begin
  Result:=False;
  if SizeOf(Arr1)=SizeOf(Arr2) then
  begin
    for i:=0 to Len do
        if Arr1[i]<>Arr2[i] then
           Exit;
  end;
  Result:=True;
end;

function ExecuteFile(const FileName, Params, DefaultDir: string;
  ShowCmd: Integer): THandle;
var
  zFileName, zParams, zDir: array[0..79] of Char;
begin
  Result := ShellExecute(Application.MainForm.Handle, 'open',
    StrPCopy(zFileName, FileName), StrPCopy(zParams, Params),
    StrPCopy(zDir, DefaultDir), ShowCmd);
end;

function GetNameWOExt(Value:String):String;
var
  i:Integer;
begin
 Result:='';
 Value:=ExtractFilename(Value);
 for i:=1 to Length(Value) do
     if Value[i]='.' then
        Break
     else
        Result:=Result+Value[i];
end;

procedure CreateEmptyFile(Filename:String);
var
  FH:Integer;
begin
  FH:=FileCreate(Filename);
  FileClose(FH);
end;

function LastRecord(DataSet:TDataSet):Boolean;
begin
  Result:=False;
  if DataSet.EOF then
     Result:=True
  else
  begin
    DataSet.Next;
    if DataSet.EOF then
       Result:=True
    else
       DataSet.Prior;
  end;
end;

procedure RefreshDataSetEx(DataSet:TDataSet;ForceOpen:Boolean);
begin
  if ForceOpen then
  begin //     DataSet,  
    if DataSet.Active then
       DataSet.Close;
    DataSet.Open;
  end
  else //    
    RefreshDataSet(DataSet);
end;

function ReadDoubleFromFile(Handler:Integer):Double;
begin
  FileRead(Handler,Result,SizeOf(Result));
end;

function WriteDoubleToFile(Handler:Integer;const Value:Double):Boolean;
begin
  if FileWrite(Handler,Value,SizeOf(Value))<>SizeOf(Value) then
     Result:=False
  else
     Result:=True;
end;

function NumberValid(Value:String):Boolean;
var
  i:Integer;
begin
  if Length(Value)>0 then
  begin
    Result:=True;
    for i:=1 to Length(Value) do
        if (Value[i]<#40) or (Value[i]>#57) then
        begin
          Result:=False;
          Break;
        end;
  end
  else
    Result:=False;
end;

function CutInitials(FullName:String):String;
var
  i:Integer;
  SpacesCount:Integer;
  InitialStored:Boolean;
  Initials:String;
begin
  Initials:='';
  SpacesCount:=0;
  for i:=1 to Length(FullName) do
  begin
    if FullName[i]=' ' then
    begin
      SpacesCount:=SpacesCount+1;
      InitialStored:=False;
      Continue;
    end;
    case SpacesCount of
         0: begin
              Initials:=Initials+FullName[i];
            end;
         1: begin
              if not InitialStored then
              begin
                Initials:=Initials+' '+FullName[i];
                InitialStored:=True;
              end;
            end;
         2: begin
              if not InitialStored then
              begin
                Initials:=Initials+'.'+FullName[i]+'.';
                Break;
              end;
            end;
    end;
  end;
  Result:=Initials;
end;

function GetTempFileName:String;
var
  Str:String;
  i:Integer;
begin
  Result:='';
  Str:=DateTimeToStr(Now);
  for i:=1 to Length(Str) do
      if (Str[i]>'0') and (Str[i]<'9') then
         Result:=Result+Str[i];
  Result:=Result+'.tmp';
end;

procedure EnableGDS_DB;
var
  ServPath:String;
  Services:TStrings;
begin
  ServPath:=GetWindowsDir;
  if not FileExists(ServPath+'\services') then //    Win98
  begin
    ServPath:=ServPath+'\system32\drivers\etc\services'; //   NT
    if not FileExists(ServPath) then
       Exit; //  ,  -   :-(
  end
  else
    ServPath:=ServPath+'\services'; // Win98
  Services:=TStringList.Create;
  try
    Services.LoadFromFile(ServPath);
    if not StrInStrings('gds_db',Services) then
    begin
      Services.SaveToFile(ChangeFileExt(ServPath,'.gds_db'));
      Services.Add('gds_db           3050/tcp                  # InterBase Server');
      Services.SaveToFile(ServPath);
    end;
  finally
    Services.Free;
  end;
end;

function StrInStrings(Value:String;Strings:TStrings):Boolean;
var
  i:Integer;
begin
  Result:=False;
  for i:=0 to Strings.Count-1 do
      if StrInString(Value,Strings[i]) then
      begin
        Result:=True;
        Break;
      end;
end;

function AxGetComputerName:String;
var
  Reg:TRegistry;
begin
  Reg:=TRegistry.Create;
  try
    Reg.RootKey:=HKEY_LOCAL_MACHINE;
    Reg.OpenKey('\System\CurrentControlSet\control\ComputerName\ComputerName',False);
    Result:=Reg.ReadString('ComputerName');
  finally
    Reg.Free;
  end;
end;

function StringsMatches(Value1,Value2:String):Boolean;
var
  i:Integer;
  MinCount:Integer;
begin
  if Length(Value1)>Length(Value2) then
     MinCount:=Length(Value2)
  else
     MinCount:=Length(Value1);
  Result:=True;
  for i:=1 to MinCount do
      if Value1[i]<>Value2[i] then
      begin
        Result:=False;
        Break;
      end;
end;

function GetWord(Value:String;WordNo:Integer;CharSet:TCharSet):String;
var
  i,j:Integer;
  Working:Boolean;
begin
  j:=0;
  Result:='';
  //      ,   
  if not (Value[1] in CharSet) then
     Working:=True
  else
     Working:=False;
  for i:=1 to Length(Value) do
  begin
    if Working then
    begin //  
      if (Value[i] in CharSet) then
      begin //    ,  , -   
        Inc(j);
        if j=WordNo then
           Break
        else
        begin
          Result:='';
          Working:=False;
        end;
      end
      else
        Result:=Result+Value[i];
    end
    else //     ,    
      if not (Value[i] in CharSet) then
      begin
        Result:=Result+Value[i];
        Working:=True;
      end;
  end;
end;

function GetWordsCount(Value:String;CharSet:TCharSet):Integer;
var
  SearchWord:Boolean;
  i:Integer;
begin
  SearchWord:=True;
  Result:=0;
  for i:=1 to Length(Value) do
  begin
    if SearchWord then
    begin //   ,     
      if not (Value[i] in CharSet) then
      begin
        Result:=Result+1;
        SearchWord:=False;
      end;
    end
    else
    begin
      if (Value[i] in CharSet) then
         SearchWord:=True; //   ,   
    end;
  end;
end;

procedure FillStringsFromDataSet(Strings:TStrings;KeyField:String;DataSet:TDataSet);
begin
  DataSet.First;
  while not DataSet.EOF do
  begin
    Strings.Add(DataSet.FieldByName(KeyField).AsString);
    DataSet.Next;
  end;
end;

function FilterString(Value:String;Filter:TCharSet):String;
var
  i:Integer;
begin
  Result:='';
  for i:=1 to Length(Value) do
      if not (Value[i] in Filter) then
         Result:=Result+Value[i];
end;

function HourFromTime(Value:TTime):String;
begin
  Result:=GetWord(TimeToStr(Value),1,[':']);
  if Length(Result)=1 then
     Result:='0'+Result;
end;

function MinuteFromTime(Value:TTime):String;
begin
  Result:=GetWord(TimeToStr(Value),2,[':']);
  if Length(Result)=1 then
     Result:='0'+Result;
end;

function StringAsPChar(Value:String):PChar;
var
  Value1:String;
begin
  Value1:=Value+#0;
  Result:=@Value1[1];
end;

function GetNextWorkDay(Value:TDateTime):TDateTime;
var
  TempDay:TDateTime;
begin
  TempDay:=Value;
  repeat
    TempDay:=IncDay(TempDay,1);
  until((DayOfWeek(TempDay)<>1) and (DayOfWeek(TempDay)<>7));
  Result:=TempDay;
end;

function Abbreviate(Value:String;CharCount:Integer):String;
var
  i:Integer;
  ChC:Integer;
  WordCount:Integer;
begin
  WordCount:=GetWordsCount(Value,[' ',',','.','-']);
  
  Result:='';
  if Length(Value)<CharCount then
     ChC:=Length(Value)-1
  else
     ChC:=CharCount;
  for i:=1 to ChC do
      Result:=Result+Value[i];
end;

function TIntegerList.IndexOf(Value: Integer): Integer;
var
  i:Integer;
begin
  Result:=-1;
  for i:=0 to Count-1 do
      if IntegerValues[i]=Value then
      begin
        Result:=i;
        Break;
      end;
end;

function GetFileDateTime(Filename:String):TDateTime;
var
  FileHandle:Integer;
begin
  FileHandle:=FileOpen(Filename, fmOpenRead);
  try
    Result:=FileDateToDateTime(FileGetDate(FileHandle));
  finally
    FileCLose(FileHandle);
  end;
end;

function StringToUUE(Str:String):String;
var
  i,j,k,l:Integer;
  Value:Dword;
  Str1:array of Char;
  c1:Char;
  c2:Char;
  Count:Byte;
begin
  Result:='';
  for i:=1 to (Length(Str) mod 3) do
      Str:=Str+' '; //  
  k:=1;
  for i:=1 to (Length(Str) div 3 ) do
  begin //      3 
    Value:=0;
    c2:=#0;
    Count:=2;
    for j:=k to k+2 do
    begin //   3 
      c1:=Str[k];
      asm
        pusha;
        mov cl,Count; //    
        xor al,al; //    
        mov ah,c1; //   
        shr ax,cl; //    
        mov bl,c2; //   
        shr bl,2; //  
        or  ah,bl; //   
        mov c1,ah;
        mov c2,al;
        popa;
      end;
      Result:=Result+Char(Byte(c1)+32);
      k:=k+1;
      Count:=Count+2;
    end;
    asm
      pusha;
      mov ah,c2;
      xor al,al;
      shr ax,2;
      mov c2,ah;
      popa;
    end;
    Result:=Result+Char(Byte(c2)+32);
  end;
end;

function UUEToString(Value:String):String;
var
  i,k:Integer;
  ShiftCount:Byte;
  c1:Char;
  c2:Char;
begin
  Result:='';
  for i:=1 to Length(Value) do
      Value[i]:=Char(Byte(Value[i])-32);
  i:=1;
  k:=1;
  ShiftCount:=2;
  while i<=Length(Value) do
  begin
    {    }
    c1:=Value[i];
    if ShiftCount<>2 then
       c2:=Value[k-1]
    else
       c2:=#0;
    asm
      pusha;
      mov cl,ShiftCount;
      mov al,c1;
      xor ah,ah;
      shl ax,cl;
      or ah,c2;
      mov c1,al;
      mov c2,ah;
      popa;
    end;
    Value[k]:=c1;
    if ShiftCount<>2 then
       Value[k-1]:=c2;
    i:=i+1;
    k:=k+1;
    ShiftCount:=ShiftCount+2;
    if ShiftCount>8 then
    begin
      ShiftCount:=2;
//      i:=i+1;
      k:=k-1;
    end;
  end;
  Result:=Value;
end;

end.

