unit StoredProcRec;

interface

uses
  SysUtils, Windows;

type
  TStoredProc=class
  private
    FSPID:Integer; //   
    FStartTime:TTimeStamp;
    FIntCounter:Integer;
    FPriority:Integer;
    function GetPriority:Integer;
    procedure SetPriority(Value:Integer);
  public
    SPname:String;
    Stopped:Boolean;
    constructor Create(spID, APriority:Integer);
    procedure CheckPriority;
    property ID:Integer
             read FSPID;
    property StartTime:TTimeStamp
             read FStartTime;
    property Priority:Integer
             read GetPriority
             write SetPriority;
  end;

  PStoredProc=^TStoredProc;

implementation

{ TStoredProcRecord }

procedure TStoredProc.CheckPriority;
var
  i:Integer;
begin
  if FPriority>0 then
  begin
    if FIntCounter<=0 then
    begin
      Sleep(1);
      FIntCounter:=FPriority;
    end
    else
      FIntCounter:=FIntCounter-1;
  end
  else
    Sleep(Abs(FPriority));
end;

constructor TStoredProc.Create(spID, APriority: Integer);
begin
  FSPID:=spID;
  Priority:=APriority;
  FStartTime:=DateTimeToTimeStamp(Now);
  FIntCounter:=APriority;
  Stopped:=False;
end;

function TStoredProc.GetPriority: Integer;
begin
  Result:=FPriority div 10;
end;

procedure TStoredProc.SetPriority(Value: Integer);
begin
  FPriority:=Value * 10;
end;

end.
