library SPC;

uses
  SysUtils,
  Classes,
  Windows,
  Dialogs,
  StoredProcRec in '..\Common\StoredProcRec.pas',
  CommUnit in '..\..\UNITS\CommUnit.pas';

var
  LastExitProc:Pointer;
  UniqueID:Integer;
  Logs:TList; //  
  LogsID:TIntegerList; //   
  LogsFiles:TStrings; //    
  ProceduresList:TList; //   

//     ProciD
function GetProcByID(ProcID:Integer):TStoredProc;
var
  Instance:PStoredProc;
  i:Integer;
begin
  Result:=nil;
  for i:=0 to ProceduresList.Count-1 do
  begin
    Instance:=ProceduresList[i];
    if Instance.ID=ProcID then
    begin
      Result:=Instance^;
      Break;
    end;
  end;
end;

//     ProciD
function GetPositionByID(ProcID:Integer):Integer;
var
  Instance:PStoredProc;
  i:Integer;
begin
  Result:=-1;
  for i:=0 to ProceduresList.Count-1 do
  begin
    Instance:=ProceduresList[i];
    if Instance.ID=ProcID then
    begin
      Result:=i;
      Break;
    end;
  end;
end;

//  ProcID   
function GetAPidByPosition(var Pos:Integer):Integer;cdecl;export;
var
  Instance:PStoredProc;
begin
  if (Pos>=0) and (Pos<ProceduresList.Count) then
  begin
    Instance:=ProceduresList[Pos];
    Result:=Instance.ID;
  end
  else
    Result:=-1;
end;

//  -  
function GetAPcount:Integer;cdecl;export;
var
  v:Integer;
begin
  v:=ProceduresList.Count;
  Result:=v;
end;

//   
function GetAPname(var ProcID:Integer):PChar;cdecl;export;
var
  Instance:TStoredProc;
  Str:String;
begin
  Instance:=GetProcByID(ProcID);
  if Instance<>nil then
  begin
    Str:=Instance.SPname+#0;
    Result:=@Str[1];
  end;
end;

//   
function GetAPpriority(var ProcID:Integer):Integer;cdecl;export;
var
  Instance:TStoredProc;
begin
  Instance:=GetProcByID(ProcID);
  if Instance<>nil then
     Result:=Instance.Priority
  else
     Result:=-1;
end;

//      
function GetAPagems(var ProcID:Integer):integer;cdecl;export;
var
  Instance:TStoredProc;
  NowTime:TTimeStamp;
begin
  Instance:=GetProcByID(ProcID);
  if Instance<>nil then
  begin
    NowTime:=DateTimeToTimeStamp(Now);
    Result:=NowTime.Time-Instance.StartTime.Time;
  end
  else
     Result:=-1;
end;

//    
function GetAPageDays(var ProcID:Integer):integer;cdecl;export;
var
  Instance:TStoredProc;
  NowTime:TTimeStamp;
begin
  Instance:=GetProcByID(ProcID);
  if Instance<>nil then
  begin
    NowTime:=DateTimeToTimeStamp(Now);
    Result:=NowTime.Date-Instance.StartTime.Date;
  end
  else
     Result:=-1;
end;


//    AdvancedProcedure
function RegisterAP(ProcName:PChar;var APriority:Integer):Integer;cdecl;export;
var
  Instance:PStoredProc;
begin
  UniqueID:=UNiqueID+1;
  Result:=UniqueID;
  New(Instance);
  Instance^:=TStoredProc.Create(Result,APriority);
  Instance.SPname:=String(ProcName);
  ProceduresList.Add(Instance);
end;

//    
function SetAPpriority(var ProcID:Integer; var APriority:Integer):Integer;cdecl;export;
var
  Proc:TStoredProc;
begin
  Proc:=GetProcByID(ProcID);
  if Proc<>nil then
  begin
    Proc.Priority:=APriority;
    Result:=0;
  end
  else
    Result:=-1;
end;

//   
function CheckAP(var ProcID:Integer):Integer;cdecl;export;
var
  Proc:TStoredProc;
begin
  Proc:=GetProcByID(ProcID);
  if Proc<>nil then
  begin
    if not Proc.Stopped then
    begin
      Result:=0;
      Proc.CheckPriority;
    end
    else
    begin
      Result:=1;
    end;
  end;
end;

function CheckAPstopped(var ProcID:Integer):Integer;cdecl;export;
var
  Proc:TStoredProc;
begin
  Proc:=GetProcByID(ProcID);
  if Proc<>nil then
  begin
    if Proc.Stopped then
    begin
      MessageDlg('Stopping', mtWarning, [mbOK], 0);
      Result:=1;
    end
    else
    begin
      Result:=0;
    end;
  end;
end;

//  
function StopAP(var ProcID:Integer):Integer;cdecl;export;
var
  Proc:TStoredProc;
begin
  Proc:=GetProcByID(ProcID);
  if Proc<>nil then
  begin
    Proc.Stopped:=True;
    Result:=0;
  end
  else
    Result:=-1;
end;

//   
function RegisterAPterminate(var ProcID:Integer):Integer;cdecl;export;
var
  Proc:TStoredProc;
  i:Integer;
begin
  i:=GetPositionByID(ProcID);
  if i<>-1 then
  begin
    Proc:=GetProcByID(ProcID);
    ProceduresList.Delete(i);
    Proc.Free;
  end;
end;

//     LogID
function GetLogByID(LogID:Integer):Integer;
var
  i:Integer;
begin
  Result:=-1;
  for i:=0 to LogsID.Count-1 do
      if LogsID[i]=LogID then
      begin
        Result:=i;
        Break;
      end;
end;

//   ,  
function OpenLog(FileName:PChar):Integer;cdecl;export;
var
  LogInstance:PStrings;
  Str:String;
begin
  Result:=UniqueID;
  UniqueID:=UniqueID+1;
  Str:=String(FileName);
  New(LogInstance);
  LogInstance^:=TStringList.Create;
  Logs.Add(LogInstance);
  LogsID.Add(Result);
  LogsFiles.Add(Str);
end;

//   
function SaveLog(var LogID:Integer):Integer;cdecl;export;
var
  Log:Integer;
  LogInstance:PStrings;
begin
  Log:=GetLogByID(LogID);
  if Log>=0 then
  begin
    LogInstance:=Logs[Log];
    LogInstance.SaveToFile(LogsFiles[Log]);
    Result:=0;
  end
  else
    Result:=-1;
end;

//   
function CloseLog(var LogID:Integer):Integer;cdecl;export;
var
  Log:Integer;
  LogInstance:PStrings;
begin
  Log:=GetLogByID(LogID);
  if Log>=0 then
  begin
    LogInstance:=Logs[Log];
    Logs.Remove(LogInstance);
    LogInstance.Free;
    LogsID.Remove(Log);
    LogsFiles.Delete(Log);
    Result:=0;
  end
  else
    Result:=-1;
end;

//   
function LogMessage(var LogID:Integer; Msg:PChar):Integer;cdecl;export;
var
  Log:Integer;
  Str:String;
  LogInstance:PStrings;
begin
  Log:=GetLogByID(LogID);
  Str:=DateTimeToStr(Now)+' '+String(Msg);
  LogInstance:=Logs[Log];
  LogInstance.Add(Str);
  Result:=0;
end;

//   
function CloseAllLogs(var Save:Integer):Integer;cdecl;export;
var
  i:Integer;
  LogID:Integer;
begin
  for i:=0 to LogsID.Count-1 do
  begin
    LogID:=LogsID[i];
    if Save=1 then
       SaveLog(LogID);
    CloseLog(LogID);
  end;
  Result:=0;
end;

procedure NewExitProc;
var
  a:Integer;
begin
  ExitProc:=LastExitProc;
  a:=0;
  CloseAllLogs(a);
  Logs.Free;
  LogsID.Free;
  LogsFiles.Free;
  ProceduresList.Free;
end;

{$R *.RES}

exports
  OpenLog,
  SaveLog,
  CloseLog,
  LogMessage,
  RegisterAp,
  CheckAP,
  SetAPpriority,
  RegisterAPterminate,
  GetAPname,
  GetAPpriority,
  GetAPagems,
  GetAPageDays,
  GetAPcount,
  GetAPidByPosition,
  StopAP,
  CheckAPstopped,
  CloseAllLogs;

begin
  LastExitProc:=ExitProc;
  ExitProc:=@NewExitProc;
  UniqueID:=0;
  Logs:=TList.Create;
  LogsID:=TIntegerList.Create;
  LogsFiles:=TStringList.Create;
  ProceduresList:=TList.Create;
end.
