connect "IB_SERVER:/PATH/DATABASE.GDB" user "sysdba" password "masterkey";

declare external function OPEN_LOG cstring(100)
returns integer by value
entry_point 'OpenLog'
module_name 'SPC.DLL';

declare external function SAVE_LOG integer
returns integer by value
entry_point 'SaveLog'
module_name 'SPC.DLL';

declare external function CLOSE_LOG integer
returns integer by value
entry_point 'CloseLog'
module_name 'SPC.DLL';

declare external function LOG_MESSAGE integer, cstring(100)
returns integer by value
entry_point 'LogMessage'
module_name 'SPC.DLL';
                       
declare external function CLOSE_ALL_LOGS integer
returns integer by value
entry_point 'CloseAllLogs'
module_name 'SPC.DLL';

declare external function REGISTER_AP cstring(100), integer
returns integer by value
entry_point 'RegisterAP'
module_name 'SPC.DLL';

declare external function REGISTER_AP_TERMINATE integer
returns integer by value
entry_point 'RegisterAPterminate'
module_name 'SPC.DLL';

declare external function CHECK_AP integer
returns integer by value
entry_point 'CheckAP'
module_name 'SPC.DLL';

declare external function SET_AP_PRIORITY integer, integer
returns integer by value 
entry_point 'SetAPpriority'
module_name 'SPC.DLL';

declare external function GET_AP_NAME integer
returns cstring(100)
entry_point 'GetAPname'
module_name 'SPC.DLL';

declare external function GET_AP_PRIORITY integer
returns integer by value 
entry_point 'GetAPpriority'
module_name 'SPC.DLL';

declare external function GET_AP_AGE_DAYS integer
returns Integer by value
entry_point "GetAPageDays"
module_name "SPC.DLL";

declare external function GET_AP_AGE_MS integer
returns Integer by value
entry_point "GetAPagems"
module_name "SPC.DLL";

declare external function GET_AP_COUNT
returns integer by value 
entry_point 'GetAPcount'
module_name 'SPC.DLL';

declare external function GET_APID_BY_POSITION integer
returns integer by value 
entry_point 'GetAPidByPosition'
module_name 'SPC.DLL';

declare external function STOP_AP integer
returns integer by value 
entry_point 'StopAP'
module_name 'SPC.DLL';

declare external function CHECK_AP_STOPPED integer
returns integer by value 
entry_point 'CheckAPstopped'
module_name 'SPC.DLL';

commit;

set term ^ ;

create procedure SL_PROC_STATE
returns (
  PROC_ID Integer,
  PROC_NAME Varchar(100),
  PROC_PRIORITY Integer,
  PROC_AGE_MS Integer,
  PROC_AGE_DAYS Integer
) as
DECLARE VARIABLE ProcCount INTEGER;
DECLARE VARIABLE ProcIndex INTEGER;
BEGIN
  ProcCount=GET_AP_COUNT();
  ProcIndex=0;
  WHILE (ProcCount<>0) DO
  BEGIN
    ProcCount=ProcCount-1;
    PROC_ID=GET_APID_BY_POSITION(ProcIndex);
    PROC_NAME=GET_AP_NAME(PROC_ID);
    PROC_PRIORITY=GET_AP_PRIORITY(PROC_ID);
    PROC_AGE_MS=GET_AP_AGE_MS(PROC_ID);
    PROC_AGE_DAYS=GET_AP_AGE_DAYS(PROC_ID);
    SUSPEND;
    ProcIndex=ProcIndex+1;
  END
END
^
commit^

create procedure STOP_PROC (
  PROC_ID Integer )
returns (
  RESULT Integer
) as
BEGIN
  RESULT=STOP_AP(PROC_ID);
  SUSPEND;
END
^
commit^

create procedure SET_PROC_PRIORITY (
  PROC_ID Integer,
  PRIORITY Integer )
returns (
  RESULT Integer
) as
BEGIN
  RESULT=SET_AP_PRIORITY(PROC_ID, PRIORITY);
END
^
commit^

create procedure SPC_TEST1 (
  PROC_NAME Varchar(100),
  PROC_PRIORITY Integer )
returns (
  R_ID Integer,
  R_VALUE Float
) as
DECLARE VARIABLE Counter INTEGER;
DECLARE VARIABLE ProcID INTEGER;
BEGIN
  ProcID=REGISTER_AP(PROC_NAME, PROC_PRIORITY);
  Counter=1000000;
  R_ID=0;
  R_VALUE=1;
  WHILE (Counter>0) DO
  BEGIN
    if (CHECK_AP(ProcID)=1) THEN
    BEGIN
      ProcID=REGISTER_AP_TERMINATE(ProcID);
      Exit;
    END
    select Count(*) FROM RDB$TRANSACTIONS
    INTO :R_VALUE;
    R_ID=R_ID+1;
    R_VALUE=R_VALUE+Counter/R_ID;
        Counter=Counter-1;
  END
  SUSPEND;
  ProcID=REGISTER_AP_TERMINATE(ProcID);
END
^
commit^