unit Event1;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, IBCtrls, DB, DBTables;

type
  TfrmEvents = class(TForm)
    GroupBox1: TGroupBox;
    btnOpenDatabase: TButton;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    btnGenerateEvent: TButton;
    Label1: TLabel;
    btnRegisterEvents: TButton;
    btnClearEvents: TButton;
    lbReceived: TListBox;
    ebEvent: TEdit;
    moRegister: TMemo;
    btnCloseDatabase: TButton;
    Database1: TDatabase;
    StoredProc1: TStoredProc;
    IBEventAlerter1: TIBEventAlerter;
    procedure btnClearEventsClick(Sender: TObject);
    procedure btnGenerateEventClick(Sender: TObject);
    procedure btnRegisterEventsClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnOpenDatabaseClick(Sender: TObject);
    procedure btnCloseDatabaseClick(Sender: TObject);
    procedure IBEventAlerter1EventAlert(Sender: TObject; EventName: String;
      EventCount: Longint; var CancelAlerts: Boolean);
  end;

var
  frmEvents: TfrmEvents;

implementation

uses DbiErrs, DbiTypes, DbiProcs;

{$R *.DFM}

function IsInterbaseAlias(const AliasName: string): Boolean;
var
  ConfigDesc: CFGDesc;
  Cursor: HDBICur;
  SPath: array[0..63] of Char;
begin
  Result := False;
  try
    Check(DbiOpenCfgInfoList(nil, dbiREADONLY, cfgPERSISTENT,
      StrLFmt(SPath, SizeOf(SPath) - 1, '\DATABASES\%s\DB INFO',
        [AliasName]), Cursor));
    try
      while DbiGetNextRecord(Cursor, dbiNOLOCK, @ConfigDesc, nil) = 0 do
        with ConfigDesc do
        begin
          if (StrIComp(szNodeName, 'TYPE') = 0) and
            (StrIComp(szValue, 'INTRBASE') = 0) then
          begin
            Result := True;
            Break;
          end;
        end;
    finally
      DbiCloseCursor(Cursor);
    end;
  except
  end;
end;


procedure TfrmEvents.btnClearEventsClick(Sender: TObject);
begin
  lbReceived.Clear;
end;

procedure TfrmEvents.btnGenerateEventClick(Sender: TObject);
begin
  Database1.StartTransaction;
  StoredProc1.Prepare;
  StoredProc1.Params[0].AsString := ebEvent.Text;
  StoredProc1.ExecProc;
  Database1.Commit;
end;

procedure TfrmEvents.btnRegisterEventsClick(Sender: TObject);
begin
  with IBEventAlerter1 do
  begin
    UnregisterEvents;
    Events.Assign(moRegister.Lines);
    RegisterEvents;
  end;
end;

procedure TfrmEvents.FormDestroy(Sender: TObject);
begin
  IBEventAlerter1.UnregisterEvents;
  Database1.Connected := False;

  GroupBox2.Enabled := False;
  GroupBox3.Enabled := False;
  GroupBox4.Enabled := False;
  Label1.Enabled := False;
  btnGenerateEvent.Enabled := False;
  btnRegisterEvents.Enabled := False;
  btnClearEvents.Enabled := False;
end;

procedure TfrmEvents.btnOpenDatabaseClick(Sender: TObject);
begin
  Database1.Connected := True;

  GroupBox2.Enabled := True;
  GroupBox3.Enabled := True;
  GroupBox4.Enabled := True;
  Label1.Enabled := True;
  btnGenerateEvent.Enabled := True;
  btnRegisterEvents.Enabled := True;
  btnClearEvents.Enabled := True;
  btnCloseDatabase.Enabled := True;
  btnOpenDatabase.Enabled:=False;
end;

procedure TfrmEvents.btnCloseDatabaseClick(Sender: TObject);
begin
  Database1.Connected := False;

  GroupBox2.Enabled := False;
  GroupBox3.Enabled := False;
  GroupBox4.Enabled := False;
  Label1.Enabled := False;
  btnGenerateEvent.Enabled := False;
  btnRegisterEvents.Enabled := False;
  btnClearEvents.Enabled := False;
  btnCloseDatabase.Enabled := False;
  btnOpenDatabase.Enabled := True;
end;

procedure TfrmEvents.IBEventAlerter1EventAlert(Sender: TObject;
  EventName: String; EventCount: Longint; var CancelAlerts: Boolean);
begin
  lbReceived.Items.Add(EventName);
end;

end.
