{********************************************************}
{                                                        }
{       InterBase EventAlerter components                }
{       Copyright (c) 1995 Borland International         }
{                                                        }
{       Written by:                                      }
{         James Thorpe                                   }
{         CSA Australasia                                }
{         Compuserve: 100035,2064                        }
{         Internet:   csa@csaa.com.au                    }
{                                                        }
{       Adapted for Delphi 1.02 by                       }
{         Oleg Kukarthev                                 }
{         E-mail:   dima@bor.compnet.ru                  }
{                                                        }
{********************************************************}

unit IBReg;

interface

procedure Register;

implementation

uses SysUtils, DsgnIntf, IBEvnts, IBCtrls, Classes, DB, LibConst;

{ EventAlerter Events property Editor }

type
  TIBEventListProperty = class(TClassProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

function TIBEventListProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paDialog] - [paSubProperties];
end;

procedure TIBEventListProperty.Edit;
var
  Events: TStrings;
begin
  Events := TStringList.Create;
  try
    Events.Assign( TStrings(GetOrdValue));
    if EditAlerterEvents( Events) then SetOrdValue( longint(Events));
  finally
    Events.Free;
  end;
end;

{ IBDatabase component editor }
procedure Register;
begin
  RegisterComponents(LoadStr(srSamples), [TIBEventAlerter]);
  RegisterPropertyEditor(TypeInfo(TStrings), TIBEventAlerter, 'Events', TIBEventListProperty);
end;

end.
