
{+--------------------------------------------------------------------------+
 | Component: TIBBase
 | Author: Robert J. Love
 | Company: Lovedata Software
 | Copyright 1996, all rights reserved.
 | Description: Interbase Database Component
 | Version: 0.5a
 | Modification History: NONE
 | Updates may be obtained at http://www.xmission.com/~uldata/ib
 |
 | This Code May not be modified and sold for Profit
 | Any Modification to this Code that is Redistributed must
 | include source code and must be freely available to the public and
 | must include the above Information
 +--------------------------------------------------------------------------+}
unit IBbase;
interface
uses
  SysUtils,Classes,IBProcs;

Type

  TIBErrorEvent = procedure(ErrorMessage, ErrorCodes : TStringList;Var RExcept : Boolean) of object;
  TIBBase = class(TComponent)
              Private
              Protected
                    FOnIBErrorEvent : TIBErrorEvent;
                    status: status_vector;
                    errcode: isc_status;
                    Procedure HandleIBErrors( status: pstatus_vector); Virtual;
                    Procedure TriggerIBErrorEvent(ErrorMessage, ErrorCodes : TStringList;Var RExcept : Boolean); virtual;
              Public
                    Property OnIBError : TIBErrorEvent read FOnIBErrorEvent write FonIBErrorEvent;
                    constructor Create(AOwner : TComponent); override;
                    Destructor Destroy; override;
             end;

implementation

Constructor TIBBase.Create(AOwner : TComponent);
begin
 inherited create(Aowner);
end;

Destructor TIBBase.Destroy;
begin
inherited destroy;
end;

Procedure TIBBase.TriggerIBErrorEvent (ErrorMessage, ErrorCodes : TStringList;Var RExcept : Boolean);
begin
  if (assigned(FOnIBErrorEvent)) then
    FOnIbErrorEvent(ErrorMessage,ErrorCodes,RExcept);
end;

procedure TIBBase.HandleIBErrors( status: pstatus_vector);
var
  buffer: array[0..255] of char;
  errMsg, lastMsg: string;
  errCode: isc_status;
  ErrorMessages,ErrorCodes : TStringList;
  RExcept: Boolean;
begin
 RExcept := True;
 ErrorMessages := TStringList.Create;
 ErrorCodes := TStringList.Create;
 repeat
  errCode := isc_interprete( @buffer, @status);
  if lastMsg <> strPas( Buffer) then
   begin
     lastMsg := strPas( buffer);
     ErrorMessages.Add(LastMsg);
     ErrorCodes.Add(IntToStr(errCode));
     if length( errMsg) <> 0 then errMsg := errMsg+#13#10;
     errMsg := errMsg+lastMsg;
   end;
 until errCode = 0;
 TriggerIBErrorEvent(ErrorMessages,ErrorCodes,RExcept);
 ErrorMessages.Free;
 ErrorCodes.Free;
 if RExcept then raise EIBError.Create( errMsg);
end;



end.
