{+--------------------------------------------------------------------------+
 | Component: TIBBASESQL
 | Author: Robert J. Love (rlove@pobox.com)
 | Company: Lovedata Software (801.776.5354)
 | Copyright 1996, all rights reserved.
 | Description: Interbase SQL Processor
 | Version: 0.5a
 | Modification History: NONE
 | Updates may be obtained at http://www.xmission.com/~uldata/ib
 |
 | This Code May not be modified and sold for Profit
 | Any Modification to this Code that is Redistributed must
 | include source code and must be freely available to the public and
 | must include the above Information
 +--------------------------------------------------------------------------+}
unit IBBASQL;  { TIBBASESQL component. }

interface
{Range Checking must be off for this component to work}
{$R-}
uses
  WinTypes,
  WinProcs,
  SysUtils,
  Messages,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  Menus,
  ibDb,
  IbProcs,
  IBBase;

type
  ESQLError = class(EIbError);
  TStatementType = (stUnknown,stSelect,stInsert,stUpdate,stDelete,stDDL,stGetSegment,stPutSegment,stExecProcedure,stStartTrans,stCommit,stRollback,stSelectForUpdate);
  TResultColumnEvent = procedure(ColNum  : Integer; var SQLVAR : XSQLVar) of object;
  TResultNewRowEvent = procedure(RowNumber : Integer) of object;
  TQueryEvent = procedure of object;
  TColumnHeader = procedure (ColNum : Integer;var SQLVAR : XSQLVAR) of object;
  TIBBASESQL = class(TIBBase)
  private
    { Private declarations }
    FDatabase : TIBdatabase;
    FStatement : TSTrings;
    FStatementType : TStatementType;
    FColumns : Integer;
    FOnResultColumn : TResultColumnEvent;
    FOnResultNewRow : TResultNewRowEvent;
    FOnStartQuery : TQueryEvent;
    FOnFinishedQuery : TQueryEvent;
    FonColumnHeader : TColumnHeader;
    procedure SetDatabase(newValue : TIBdatabase);
    procedure SetStatement(newValue : TSTrings);
    function GetColumns : Integer;
    function GetStatementType : TStatementType;
  protected
    { Protected declarations }
    { Event triggers: }
    Procedure TriggerStartQueryEvent;  virtual;
    procedure TriggerFinishedQueryEvent; virtual;
    procedure TriggerColumnHeaderEvent (ColNum : Integer;var SQLVAR : XSQLVAR); virtual;
    procedure TriggerResultColumnEvent(ColNum  : Integer;var SQLVAR : XSQLVAR); virtual;
    procedure TriggerResultNewRowEvent(RowNumber : Integer); virtual;
    procedure Notification(someComponent: TComponent; operation: TOperation); override;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure Execute;
    property Columns : Integer read GetColumns;  { Run-time access only }
    property StatementType : TStatementType read GetStatementType; { Run-time access only }
   published
    { Published properties and events }
    property Database : TIBdatabase read FDatabase write SetDatabase;
    property Statement : TStrings read FStatement write SetStatement;
    property OnResultColumn : TResultColumnEvent read FOnResultColumn write FOnResultColumn;
    property OnResultNewRow : TResultNewRowEvent read FOnResultNewRow write FOnResultNewRow;
    property OnQueryFinished : TQueryEvent read FOnFinishedQuery Write FOnFinishedQuery;
    Property OnColumnHeader : TColumnHeader read FOnColumnHeader write FOnColumnHeader;
    property OnQueryStart : TQueryEvent read FonStartQuery write fonStartQuery;
    Property OnIBError; //Published from Base Class
  end;  { TIBBASESQL }

procedure Register;

implementation
function PadCh(S : string; Ch : Char; Len : Integer) : string;
  var
    ResultStr : string;
    PassedStrLen : Integer;
  begin
    PassedStrLen := Length(S);
    if PassedStrLen >= Len then
      Result := S
    else begin
      setlength(ResultStr,Len);
      Move(S[1], ResultStr[1], PassedStrLen);
      FillChar(ResultStr[Succ(PassedStrLen)], Len - PassedStrLen, Ch);
      Result := ResultStr;
    end;
  end;

{ **************************************** }
{ **   Read and Write methods for Prop. ** }
{ **************************************** }
procedure TIBBASESQL.SetDatabase(newValue : TIBdatabase);
{ Sets data member FDatabase to newValue. }
begin
  if (FDatabase <> newValue) then
  begin
    FDatabase := newValue;
  end;  { if }
end;  { SetDatabase }

procedure TIBBASESQL.SetStatement(newValue : TSTrings);
{ Sets data member FStatement to newValue. }
begin
  FStatement.Assign(newValue);
end;  { SetStatement }

function TIBBASESQL.GetStatementType : TStatementType;
{ Returns the value of data member FQueryStyle. }
begin
  result := FStatementType;
end;  { GetQueryStyle }

function TIBBASESQL.GetColumns : Integer;
{ Returns the value of data member FColumns. }
begin
  result := FColumns;
end;  { GetColumns }

{ ******************************************************** }
{ **  The Heart of this Component (Execute)             ** }
{ ******************************************************** }
procedure TIBBASESQL.Execute;  { public }
var
 I,LP : integer;
 out_da : PXSQLDA;
 fetch_stat : Integer;
 StmtHandle : isc_stmt_handle;
 status: status_vector;
 errcode: isc_status;
 FdbHandle : isc_db_Handle;
 trans: isc_tr_handle;
 tmp : array[0..10] of Char;
 TypeBuffer : array[0..50] of Char;
 StmtType : Integer;
 RowNum : Integer;
begin
 FdbHandle := FDatabase.dbHandle;
 trans := FDatabase.trHandle;
 if FdbHandle = nil then raise ESQLError.Create('Database must be attached and open');
 if trans = nil then raise ESQLError.Create('Transaction must be started to process statement');
 TriggerStartQueryEvent;
 StmtHandle := nil;

 getmem(out_da,SQLDA_LENGTH(4));
 TRY     //Used for FINALLY to free in_daand out_da
 out_da^.version := SQLDA_VERSION1;
 out_da^.sqln := 4;   //Try for 4 Parameters by Default (need to make property later

 {Allocate Statement}
 errcode := isc_dsql_allocate_statement(@STATUS,@FDBHandle,@StmtHandle);
  if errcode <> 0 then HandleIBErrors( @status);
 {Prepare Statement}
 errcode := isc_dsql_prepare(@STATUS,@trans,@StmtHandle,0,pchar(FStatement.Text),1,out_da);
  if errcode <> 0 then HandleIBErrors( @status);

 fillChar(tmp,sizeof(tmp),#0);
 fillchar(TypeBuffer,SizeOf(TypeBuffer),#0);

 {Find out what the Statement Type is for this Statement}
 tmp[0] := char(isc_info_sql_stmt_type);
 errcode := isc_dsql_sql_info(@Status,@StmtHandle,SizeOf(tmp),
                              tmp,SizeOf(TypeBuffer),@TypeBuffer);
 if errcode <> 0 then HandleIBErrors( @Status);

 if (TypeBuffer[0] = char(isc_info_sql_stmt_type))
 then StmtType := Integer(TypeBuffer[3]) // Check to see if Length check is needed
 else raise EsqlError.Create('Invalid data returned from isc_dsql_sql_info');
 FStatementType := stUnknown;
 inc(FStatementType,StmtType);

{Execute Non-Select Statements}
 if (out_da^.sqld = 0) then
 begin
   errcode := isc_dsql_execute(@status,@trans,@stmtHandle,1,nil);
   if errcode <> 0 then HandleIBErrors ( @Status);

 end
 else
{Execute Query Statements}
  begin
    RowNum := 0;
    fColumns := out_da.sqld;
    {If there is not Enough Space Allocate More}
    if out_da^.sqld > out_da^.sqln then
     begin
      I := out_da^.sqld;
      freemem(out_da,SQLDA_LENGTH(4));
      getmem(out_da,SQLDA_LENGTH(I));
      out_da^.version := SQLDA_VERSION1;
      out_da^.sqln := I;
      errcode := isc_dsql_describe(@STATUS,@StmtHandle,1,out_da);
      if errcode <> 0 then HandleIBErrors( @status);

      fColumns := out_da.sqld;
     end;  {if  out_da^.sqld > out_da^.sqln }
     {Call ColumnHeader Event For UserDefined Manipulation}
     For LP := 0 to fcolumns -1 do
      begin
        TriggerColumnHeaderEvent(LP,out_da.sqlvar[lp]);
      end;
     {Allocate Memory for Each Field in the out_da structure}
      // +2 to handle VARCHAR
     for LP := 0 to out_da^.sqld -1 do
      begin
       if (out_da.sqlvar[lp].sqltype = SQL_VARYING) or (out_da.sqlvar[lp].sqltype = SQL_VARYING +1)
        then  getmem(out_da.sqlvar[lp].sqlData,out_da.sqlvar[lp].sqllen +2 )
        else getmem(out_da.sqlvar[lp].sqlData,out_da.sqlvar[lp].sqllen);
        getmem(out_da.sqlvar[lp].sqlind,sizeof(short));
      end; { for LP := 0 to out_da^.sqld }
     {Create the Cursor Name set it up to be the name of the component}
   errcode := isc_dsql_execute(@status,@trans,@stmtHandle,1,out_da);
   if errcode <> 0 then HandleIBErrors ( @Status);

   {Fetch Rows...}
      repeat
         fetch_stat := isc_dsql_fetch(@status,@stmtHandle,1,out_da);
         if fetch_stat = 100 then break;
         inc(RowNum);
         for i := 0 to fcolumns -1 do
           TriggerResultColumnEvent(I+1,out_da.sqlvar[i]);
         TriggerResultNewRowEvent(RowNum);
      until fetch_stat <> 0;
      if fetch_stat <> 100 then HandleIBErrors(@Status);
     {Free Memory for Each Field in the out_da structure}
     {Note because of the way this works I did not wrap in TRY|Finally For Now}
  for LP := 0 to out_da^.sqld -1 do
     begin
       // +2 to handle VARCHAR
       if (out_da.sqlvar[lp].sqltype = SQL_VARYING) or (out_da.sqlvar[lp].sqltype = SQL_VARYING +1)
        then  freemem(out_da.sqlvar[lp].sqlData,out_da.sqlvar[lp].sqllen +2 )
        else freemem(out_da.sqlvar[lp].sqlData,out_da.sqlvar[lp].sqllen);
       freemem(out_da.sqlvar[lp].sqlind,sizeof(short));
     end; { for LP := 0 to out_da^.sqld }
   end;
 FINALLY;
 freemem(out_da,SQLDA_LENGTH(fcolumns));
 END;
 TriggerFinishedQueryEvent;
end;  { Execute }

{ Event triggers: }
procedure TIBBASESQL.TriggerResultColumnEvent(ColNum  : Integer; var SQLVAr : XSQLVAR);
{ Triggers the OnResultColumn event. This is a virtual method (descendants of this component can override it). }
begin
  if (assigned(FOnResultColumn)) then
    FOnResultColumn(ColNum,SQLVAr);
end;  { TriggerResultColumnEvent }

Procedure TIBBASESQL.TriggerStartQueryEvent;
begin
  if (assigned(FOnStartQuery)) then
    FOnStartQuery;
end; {TriggerStartQueryEvent}

Procedure TIBBASESQL.TriggerFinishedQueryEvent;
begin
  if (assigned(FOnFinishedQuery)) then
    FOnFinishedQuery;
end; {TriggerFinishQueryEvent}

procedure TIBBASESQL.TriggerColumnHeaderEvent(ColNum : Integer;var SQLVAR : XSQLVAR);
begin
  if (assigned(FOnColumnHeader)) then
     FOnColumnHeader(Colnum,SQLVAR);
end;  {TriggerHeaderResultEvent}

procedure TIBBASESQL.TriggerResultNewRowEvent(RowNumber : Integer);
{ Triggers the OnResultNewRow event. This is a virtual method (descendants of this component can override it). }
begin
  if (assigned(FOnResultNewRow)) then
    FOnResultNewRow(RowNumber );
end;  { TriggerResultNewRowEvent }


procedure TIBBASESQL.Notification(someComponent: TComponent; operation: TOperation);
begin
  inherited Notification(someComponent, operation);
  if operation = opRemove then
  begin
    {CURRENTLY NOT USED}
  end;
end;		{ Notification }

destructor TIBBASESQL.Destroy;
begin
  { Free member variables: }
  FStatement.Free;
  inherited Destroy;
end;  { Destroy }

constructor TIBBASESQL.Create(AOwner : TComponent);
{ Creates an object of type TIBBASESQL, and initializes properties. }
begin
  inherited Create(AOwner);
  { Create property fields (that are objects): }
  FStatement := TSTringlist.Create;
end;  { Create }

procedure Register;
begin
  RegisterComponents('Interbase', [TIBBASESQL]);
end;  { Register }

end.

