{+--------------------------------------------------------------------------+
 | InterBase API Import Unit
 | The Following Code is Free to use.
 | This code is far from complete however there is no other publicly available
 | Import Unit for the InterBase API
 |
 | If you have suggestions for improvement, or function declarations to add
 | or anything else you might find useful for the Interbase API.  Please
 | send an E-mail to Robert J. Love (rlove@pobox.com)  So that the Import
 | Unit maybe modified for the benfit of everyone.
 |
 | Version : 1.0
 | Notes : Currently only works with Delphi 2.0
 | Modification History : NONE
 | Updates may be obtained at http://www.xmission.com/~uldata/ib
 +--------------------------------------------------------------------------+}
unit ibprocs;
Interface
uses Sysutils,Windows;

const                                                       
  isc_dpb_version1  = 1;
  isc_dpb_user_name = 28;
  isc_dpb_password  = 29;

  isc_tpb_concurrency = 2;
  isc_tpb_version3  = 3;
  isc_tpb_wait      = 6;
  isc_tpb_write     = 9;

type
  isc_db_handle = pointer;
  pisc_db_handle = ^isc_db_handle;
  isc_long = longint;
  pisc_long = ^isc_long;
  isc_status = longint;
  pisc_status = ^isc_status;
  isc_tr_handle = pointer;
  pisc_tr_handle = ^isc_tr_handle;

  status_vector = array[0..19] of isc_status;
  pstatus_vector = ^status_vector;
  ppstatus_vector = ^pstatus_vector;

  short = word;

  isc_teb = record
    db_ptr: pisc_db_handle;
    tpb_len: longint;
    tpb_ptr: pchar;
  end;
  pisc_teb = ^isc_teb;

{Interbase Data/Time Record}
  ISC_QUAD =  record
         isc_quad_high: Integer;  // Date
         isc_quad_low: Cardinal;  // Time
      end ;
  PISC_QUAD = ^ISC_Quad;
{C Date/Time Record}
tm = record
   tm_sec : integer;   // Seconds
   tm_min : integer;   // Minutes
   tm_hour : integer;  // Hour (0--23)
   tm_mday : integer;  // Day of month (1--31)
   tm_mon : integer;   // Month (0--11)
   tm_year : integer;  // Year (calendar year minus 1900)
   tm_wday : integer;  // Weekday (0--6) Sunday = 0)
   tm_yday : integer;  // Day of year (0--365)
   tm_isdst : integer; // 0 if daylight savings time is not in effect)
end;
ptm = ^tm;

  isc_callback = procedure( ptr: pointer; length: short; updated: pchar);

const
  SQLDA_VERSION1 = 1;
  SQL_TEXT =       452;
  SQL_VARYING =    448;
  SQL_SHORT =      500;
  SQL_LONG =       496;
  SQL_FLOAT =      482;
  SQL_DOUBLE =     480;
  SQL_D_FLOAT =    530;
  SQL_DATE =       510;
  SQL_BLOB =       520;
  SQL_ARRAY =      540;
  SQL_QUAD =       550;
  DSQL_close = 1;
  DSQL_drop  = 2;

{*********************************}
{* SQL information return values *}
{*********************************}

  isc_info_sql_stmt_select =          1;
  isc_info_sql_stmt_insert =          2;
  isc_info_sql_stmt_update =          3;
  isc_info_sql_stmt_delete =          4;
  isc_info_sql_stmt_ddl =             5;
  isc_info_sql_stmt_get_segment =     6;
  isc_info_sql_stmt_put_segment =     7;
  isc_info_sql_stmt_exec_procedure =  8;
  isc_info_sql_stmt_start_trans =     9;
  isc_info_sql_stmt_commit =         10;
  isc_info_sql_stmt_rollback =       11;
  isc_info_sql_stmt_select_for_upd = 12;
  isc_info_sql_stmt_set_generator =  13;
  

{*************************}
{* SQL information items *}
{*************************}

  isc_info_sql_select =         4;
  isc_info_sql_bind =           5;
  isc_info_sql_num_variables =  6;
  isc_info_sql_describe_vars =  7;
  isc_info_sql_describe_end =   8;
  isc_info_sql_sqlda_seq =      9;
  isc_info_sql_message_seq =   10;
  isc_info_sql_type =          11;
  isc_info_sql_sub_type =      12;
  isc_info_sql_scale =         13;
  isc_info_sql_length =        14;
  isc_info_sql_null_ind =      15;
  isc_info_sql_field =         16;
  isc_info_sql_relation =      17;
  isc_info_sql_owner =         18;
  isc_info_sql_alias =         19;
  isc_info_sql_sqlda_start =   20;
  isc_info_sql_stmt_type =     21;
  isc_info_sql_get_plan =      22;
  isc_info_sql_records =       23;
  isc_info_sql_batch_fetch =   24;


type
  XSQLVAR = record
    sqltype:          SmallInt;
    sqlscale:         SmallInt;
    sqlsubtype:       SmallInt;
    sqllen:           SmallInt;
    sqldata:          Pointer;
    sqlind:           ^SmallInt;
    sqlname_length:   SmallInt;
    sqlname:          array[0..31] of Char;
    relname_length:   SmallInt;
    relname:          array[0..31] of Char;
    ownname_length:   SmallInt;
    ownname:          array[0..31] of Char;
    aliasname_length: SmallInt;
    aliasname:        array[0..31] of Char;
  end;

  XSQLDA = record
    version: SmallInt;
    sqldaid: array[0..7] of Char;
    sqldabc: ISC_LONG;
    sqln: SmallInt;
    sqld: SmallInt;
    sqlvar: array[0..0] of XSQLVAR;
  end;
 PXSQLDA = ^XSQLDA;

  VARY = record
    vary_length: Smallint;
    vary_string: array[0..0] of Char;
  end;


 isc_stmt_handle = pointer;
 pisc_stmt_handle = ^isc_stmt_handle;

 TiscDsqlPrepare = function (status : PISC_STATUS;
                             trans_handle : pisc_tr_handle;
                             stmt_handle : pisc_stmt_handle;
                             len : smallint;
                             statement : pchar;
                             dialect : short;
                             Params : PXSQLDA
                             ) : ISC_STATUS; stdcall;

 TiscDsqlAllocateStatement = function (status : PISC_STATUS;
                                   db_handle : pisc_db_handle;
                                   stmt_handle : pisc_stmt_handle
                                   ) : ISC_STATUS; stdcall;

 TIscDsqlExecute = function (status : PISC_STATUS;
                             trans_handle: pisc_tr_handle;
                             stmt_handle : pisc_stmt_handle;
                             dialect : smallint;
                             Params : PXSQLDA
                             ): ISC_STATUS; stdcall;


Tiscdsqldescribe  = function (status_vector: PISC_STATUS;
                              stmt_handle:   pisc_stmt_handle;
                              dialect:       smallint;
                              xsqlda:        PXSQLDA) : ISC_STATUS; stdcall;


Tiscdsqlsetcursorname = function  (status_vector: PISC_STATUS;
                                   stmt_handle:   pisc_stmt_handle;
                                   cursor_name:   PChar;
                                   unusedType:         smallint) : ISC_STATUS; stdcall;

Tiscdsqlfetch = function (status_vector: PISC_STATUS;
                         stmt_handle:   Pisc_stmt_handle;
                         dialect:       smallint;
                         xsqlda:        PXSQLDA) : ISC_STATUS; stdcall;
Tiscdsqlfreestatement = function (status_vector: PISC_STATUS;
                                  stmt_handle:   pisc_stmt_handle;
                                  option:        smallint) : ISC_STATUS; stdcall;
//isc_attach_database
TIscAttachDatabase = function(
  status: pstatus_vector;
  db_name_length: short;
  db_name: pchar;
  db_handle: pisc_db_handle;
  parm_buffer_length: short;
  parm_buffer: pchar
  ): isc_status; stdcall;


// isc_cancel_events
TIscCancelEvents = function(
  status: pstatus_vector;
  db_handle: pisc_db_handle;
  event_id: pisc_long
  ): isc_status; stdcall;

// isc_commit_transaction
TIscCommitTransaction = function(
  status: pstatus_vector;
  trans_handle: pisc_tr_handle
  ): isc_status; stdcall;

// isc_detach_database
TIscDetachDatabase = function(
  status: pstatus_vector;
  db_handle: pisc_db_handle
  ): isc_status; stdcall;

// isc_drop_database
TIscDropDatabase = function(
  status: pstatus_vector;
  db_handle: pisc_db_handle
  ): isc_status; stdcall;

// isc_dsql_execute_immediate
TIscDsqlExecuteImmediate = function(
  status: pstatus_vector;
  db_handle: pisc_db_handle;
  trans_handle: pisc_tr_handle;
  length: short;
  statement: PChar;
  dialect: short;
  xslqda: PXSQLDA
  ): isc_status; stdcall;

// isc_event_block
TIscEventBlock = function(
  event_buf: pointer;
  result_buf: pointer;
  count: short;
  name1: pchar):  longint; cdecl;

// isc_event_counts
TIscEventCounts = procedure(
  status: pstatus_vector;
  buffer_length: short;
  event_buffer: pchar;
  result_buffer: pchar
  ); stdcall;

// isc_free
TIscFree = function(
  buffer: PChar
  ): isc_long; stdcall;

// isc_interprete
TIscInterprete = function(
  buffer: PChar;
  status: ppstatus_vector
  ): isc_status; stdcall;

// isc_que_events
TIscQueEvents = function(
  status: pstatus_vector;
  db_handle: pisc_db_handle;
  event_id: pisc_long;
  length: short;
  event_buffer: pchar;
  event_function: isc_callback;
  event_function_arg: pointer
  ): isc_status; stdcall;

// isc_rollback_transaction
TIscRollbackTransaction = function(
  status: pstatus_vector;
  trans_handle: pisc_tr_handle
  ): isc_status; stdcall;

// isc_start_multiple
TIscStartMultiple = function(
  status: pstatus_vector;
  trans_handle: pisc_tr_handle;
  db_handle_count: short;
  teb_vector_address: pisc_teb
  ): isc_status; stdcall;

// isc_dsql_sql_info
TIscDsqlSqlInfo = function(
  status: pstatus_vector;
  stmt_handle : pisc_stmt_handle;
  item_length : short;
  items : pchar;
  buffer_length : short;
  result_buffer : pchar
  ) : isc_status; stdcall;

TIscDecodeDate = procedure (ib_date: PISC_QUAD; tm_date: ptm); stdcall;
TiscEnCodeDate = procedure (tm_date: ptm; ib_date: PISC_QUAD); stdcall;


// Exception Classes
EIBError = class(Exception);
EIBDLLLoadError = class(EIBError);
var

  Isc_Free: TIscfree;
  Isc_Interprete: TIscInterprete;
  isc_start_multiple : TIscStartMultiple;
  isc_dsql_execute_immediate : TiscDsqlExecuteImmediate;
  isc_commit_transaction : TiscCommitTransaction;
  isc_rollback_transaction : TiscRollbackTransaction;
  isc_Attach_database : TIscAttachDatabase;
  isc_detach_database : TiscDetachdatabase;
  isc_dsql_execute : TiscDsqlExecute;
  isc_dsql_allocate_statement : Tiscdsqlallocatestatement;
  isc_dsql_prepare : TiscDsqlPrepare;
  isc_dsql_set_cursor_name : Tiscdsqlsetcursorname;
  isc_dsql_describe : Tiscdsqldescribe;
  isc_dsql_fetch : Tiscdsqlfetch;
  isc_dsql_free_statement : Tiscdsqlfreestatement;
  isc_dsql_sql_info : TIscDsqlSqlInfo;
  isc_decode_date : TiscDecodeDate;
  isc_encode_date : TiscEncodeDate;

  function SQLDA_LENGTH(n: SmallInt): Longint;
  procedure LoadAPI;
  procedure FreeAPi; 
var

 LibHandle : THandle;

implementation

function SQLDA_LENGTH(n: SmallInt): Longint;
begin
  SQLDA_LENGTH := (Sizeof(XSQLDA) + (n - 1) * Sizeof(XSQLVAR));
end;

procedure LoadAPI;
begin
  LibHandle := LoadLibrary('gds32.dll');
  if LibHandle < 32 then
    raise EIBDLLLoadError.Create('Unable to load gds32.dll');

  @Isc_Attach_Database := GetProcAddress(LibHandle, 'isc_attach_database');
  if @Isc_Attach_Database = nil then
    raise EIBDLLLoadError.Create('Failed to lookup isc_attach_database');

  @Isc_Interprete := GetProcAddress(LibHandle, 'isc_interprete');
  if @Isc_Interprete = nil then
    raise EIBDLLLoadError.Create('Failed to lookup isc_interprete');

  @Isc_Free := GetProcAddress(LibHandle, 'isc_free');
  if @Isc_Free = nil then
    raise EIBDLLLoadError.Create('Failed to lookup isc_free');

 @isc_start_multiple := GetProcAddress(LibHandle, 'isc_start_multiple');
 if @isc_start_multiple = nil then
   raise EIBDLLLoadError.Create('Failed to lookup isc_start_multiple');

 @isc_dsql_execute_immediate := GetProcAddress(LibHandle, 'isc_dsql_execute_immediate');
  if @isc_dsql_execute_immediate = nil then
   raise EIBDLLLoadError.Create('Failed to lookup isc_dsql_execute_immediate');

 @isc_commit_transaction := GetProcAddress(LibHandle, 'isc_commit_transaction');
  if @isc_commit_transaction = nil then
   raise EIBDLLLoadError.Create('Failed to lookup isc_commit_transaction');

 @isc_rollback_transaction := GetProcAddress(LibHandle, 'isc_rollback_transaction');
  if @isc_rollback_transaction = nil then
   raise EIBDLLLoadError.Create('Failed to lookup isc_rollback_transaction');

 @isc_detach_database := GetProcAddress(LibHandle, 'isc_detach_database');
  if @isc_detach_database = nil then
   raise EIBDLLLoadError.Create('Failed to lookup isc_detache_database');

 @isc_dsql_execute := GetProcAddress(LibHandle, 'isc_dsql_execute');
  if @isc_dsql_execute = nil then
   raise EIBDLLLoadError.Create('Failed to lookup isc_dsql_execute');

 @isc_dsql_allocate_statement := GetProcAddress(LibHandle, 'isc_dsql_allocate_statement');
  if @isc_dsql_allocate_statement = nil then
   raise EIBDLLLoadError.Create('Failed to lookup isc_dsql_allocate_statement');

 @isc_dsql_prepare := GetProcAddress(LibHandle, 'isc_dsql_prepare');
  if @isc_dsql_prepare = nil then
   raise EIBDLLLoadError.Create('Failed to lookup isc_dsql_prepare');

 @isc_dsql_set_cursor_name := GetProcAddress(LibHandle, 'isc_dsql_set_cursor_name');
  if @isc_dsql_set_cursor_name = nil then
   raise EIBDLLLoadError.Create('Failed to lookup isc_dsql_set_cursor_name');

 @isc_dsql_describe := GetProcAddress(LibHandle, 'isc_dsql_describe');
  if @isc_dsql_describe = nil then
   raise EIBDLLLoadError.Create('Failed to lookup isc_dsql_describe');

 @isc_dsql_fetch := GetProcAddress(LibHandle, 'isc_dsql_fetch');
  if @isc_dsql_fetch = nil then
    raise EIBDLLLoadError.Create('Failed to lookup isc_dsql_fetch');

 @isc_dsql_free_statement := GetProcAddress(LibHandle, 'isc_dsql_free_statement');
  if @isc_dsql_free_statement = nil then
     raise EIBDLLLoadError.Create('Failed to lookup isc_dsql_free_statement');
     
 @isc_dsql_sql_info := GetProcAddress(LibHandle,'isc_dsql_sql_info');
  if @isc_dsql_sql_info = nil then
    raise EIBDLLLoadError.Create('Failed to lookup isc_dsql_sql_info');

 @isc_decode_date := GetProcAddress(LibHandle,'isc_decode_date');
  if @isc_decode_date = nil then
    raise EIBdLLLoadError.Create('Failed to lookup isc_decode_date');

 @isc_encode_date := GetProcAddress(LibHandle,'isc_encode_date');
  if @isc_encode_date = nil then
    raise EIBdLLLoadError.Create('Failed to lookup isc_encode_date');

end;
Procedure FreeAPI;
begin
  FreeLibrary(LibHandle);
end;

end.
