library blobsaveload;

{ (c) KDV, www.ibase.ru }
{ Simple set of Load/Save blob functions for InterBase and Firebird }
{ based on LoadBlobFromFile from UDFDEMO with my corrections to
  GetSegment/PutSegment declarations

  Freeware }

uses
  SysUtils,
  Classes;

{$R *.res}

type

  PInteger  = ^integer;
  PInt      = ^integer;
  Short     = SmallInt;// 16 bit signed
  UShort    = Word;    // 16 bit unsigned
  Long      = LongInt; // 32 bit signed

  TISC_BlobGetSegment = function(BlobHandle: pointer;
                                 Buffer: PChar;
                                 BufferSize: ushort;
                                  var ResultLength: ushort): Short; cdecl;
  TISC_BlobPutSegment = procedure(BlobHandle: pointer;
                                  Buffer: PChar;
                                  BufferLength: Short); cdecl;
  TBlob = record
    GetSegment         : TISC_BlobGetSegment;
    Handle             : pointer;
    SegmentCount       : Long;
    MaxSegmentLength   : Long;
    TotalSize          : Long;
    PutSegment         : TISC_BlobPutSegment;
  end;

  PBlob = ^TBlob;

{
declare external function LoadBLOBFromFile
  cstring(256), blob
returns
  parameter 2
entry_point 'LoadBLOBFromFile'
module_name 'blobsaveload';
}

{
declare external function SaveBLOBToFile
  blob, cstring(256)
returns
  integer by value
entry_point 'SaveBLOBToFile'
module_name 'blobsaveload';
}

function SaveBLOBToFile(var BLOb: TBLOb; FileName: PChar): integer; cdecl; export;
var
  Stream: TFileStream;
  Buffer: PChar;
  EndOfBlob: short;
  MaxBufSize: ushort;
  GotLength: ushort;
begin
  Result:=0;
  try
    if (Assigned(Blob.Handle)) or (Blob.TotalSize > 0) then // don't do anything is blob = 0
      begin
        // add fmShare... option to fmCreate as needed
        Stream := TFileStream.Create(FileName, fmCreate);
        Stream.Seek(0, soFromBeginning);
        MaxBufSize:=Blob.MaxSegmentLength;
        GetMem(Buffer, MaxBufSize + 1);
        try
          repeat
            GotLength := 0; { !?! }

            with BLOb do
              EndOfBLOb := GetSegment(Handle, Buffer, MaxBufSize, GotLength);
            if (GotLength > 0) then {?}
              Stream.WriteBuffer(Buffer^, GotLength);
          until EndOfBLOb = 0;

        finally
          FreeMem(Buffer, MaxBufSize + 1);
          Result:=Stream.Size; // really result need to be int64. but 2 gb blob files is ok.
          Stream.Free;
        end;
      end;
  except
  end;
end;

procedure LoadBLOBFromFile(FileName: PChar; var BLOb: TBLOb); cdecl; export;
const
  MaxBufSize = 8192;
var
  BufSize, ReadLength, StreamSize: Integer;
  Buffer: PChar;
  Stream: TStream;
begin
  try
    Stream := TFileStream.Create(FileName, fmOpenRead or fmShareDenyNone);
    try
      StreamSize := Stream.Size;

      if StreamSize > MaxBufSize then
        BufSize := MaxBufSize
      else
        BufSize := StreamSize;
      GetMem(Buffer, BufSize);
      try
        while StreamSize <> 0 do
          begin
            if StreamSize > BufSize then
              ReadLength := BufSize
            else
              ReadLength := StreamSize;
            Stream.ReadBuffer(Buffer^, ReadLength);

            with BLOb do
              PutSegment(Handle, Buffer, ReadLength);

            Dec(StreamSize, ReadLength);
          end;
      finally
        FreeMem(Buffer, BufSize);
      end;
    finally
      Stream.Free;
    end;
  except
    // do nothing or write error info into initialized log
  end;
end;

// !!! function names in DECLARE EXTERNAL FUNCION ... ENTRY POINT
//     must be SaMe as name specified here
// !!! Function and fUNCTION are different names
exports
 LoadBLOBFromFile,
 SaveBLOBToFile;

begin
  isMultiThread:=True;
end.
