program
  DBF2ext;

{$APPTYPE CONSOLE}

uses
  mydbf,
  Classes,
  SysUtils;

function RightPadCh(S: string; Ch: Char; Len: Word): string;
var
  SLen: Word;
begin
  SLen := Length(S);
  if Length(S) >= Len then 
    Result := S
  else 
  begin
    SetLength(Result, Len);
    Move(S[1], Result[1], SLen);
    FillChar(Result[Succ(SLen)], Len - SLen, Ch);
  end;
end;

var
  FileSource, FileRecover: file;
  FileSql: TextFile;
  NumRead, NumWritten: integer;
  DBFHeader: TDBFHeader;
  DBFField: PDBFField;
  lpBuffer: PChar;
  RecordSize, BuferCount: integer;
  NextF, LenF, locatF, typeIndex, i, j, zi: integer;
  FieldList: TList;
  ChByte: byte;
  BlockSize: longint;
  bFullHeader: integer; // ᢮  "" 
  FullArea: integer;
  EndOfFile: boolean;
  s, s1: String;

  w: LongWord;
  w2: Word;

begin
  FieldList := TList.Create;
  try

    bFullHeader := 0;

    try
      AssignFile(FileSource, ParamStr(1));
      Reset(FileSource, 1);
    except
      on E:Exception do
      begin
        Writeln('? "', ParamStr(1), '" - ', E.Message);
        Halt(99);
      end;
    end;
    BlockRead(FileSource, DBFHeader, SizeOf(DBFHeader), NumRead);

    if DBFHeader.Signat = 4 then
    begin
      Writeln('?  dbf-ଠ  ন.');
      Halt(99);
    end;

    if DBFHeader.Signat <> 3 then
    begin
      Writeln('?   dbf-䠩y');
      Halt(99);
    end;

    repeat
      inc(bFullHeader, BlockHeaderSize);
      GetMem(DBFField, SizeOf(DBFField^));
      BlockRead(FileSource, DBFField^, SizeOf(DBFField^), NumRead);
      if DBFField^.FieldName[1] = #13 then break;
      FieldList.Add(DBFField);
    until false;

    BuferCount := 1000; // ⢮ ᥩ  ⠥ 

    RecordSize := DBFHeader.RecSize;

    BlockSize := RecordSize * BuferCount;

    bFullHeader := bFullHeader + 1;

    Reset(FileSource, 1);
    seek(FileSource, bFullHeader);

    FullArea := FileSize(FileSource) - bFullHeader;

    if BlockSize > FullArea then
      BlockSize := FullArea;

    GetMem(lpBuffer, BlockSize);

    try
      if Trim(ParamStr(2)) = '' then raise EInOutError.CreateFmt('饥  १饣 䠩.', []);
      AssignFile(FileRecover, ParamStr(2));
      Rewrite(FileRecover, 1);
    except
      on E:Exception do
      begin
        Writeln('? "', ParamStr(2), '" - ', E.Message);
        Halt(99);
      end;
    end;

    typeIndex := 2;

    repeat
      EndOfFile := FullArea <= BlockSize;
      BlockRead(FileSource, lpBuffer^, BlockSize, NumRead);
      if (NumRead = 0) 
        then Break;
      locatF := 1;
      if typeIndex <> 0 then
        for zi := 0 to DBFHeader.RecCount - 1 do
          for i := 0 to FieldList.Count - 1 do
          begin
            LenF := PDBFField(FieldList.Items[i]).FieldLen;
            if i = 0 then Inc(locatF);
            NextF := locatF;
            case PDBFField(FieldList.Items[i]).FieldType of 
              'C': begin
                repeat
                  for j := NextF to NextF + LenF - 1 do
                  begin
                    ChByte := Ch_conv[typeIndex, ord(lpBuffer[j])];
                    if ChByte <> 0 then lpBuffer[j] := chr(ChByte);
                  end;
                  NextF := NextF + RecordSize;
                until NumRead < NextF;
                BlockWrite(FileRecover, Word(LenF), SizeOf(Word));
                s := Copy(lpBuffer, locatF, LenF);
                BlockWrite(FileRecover, s[1], LenF);
//                Inc(LenF);
              end;
              'N': begin
                s := Copy(lpBuffer, locatF, LenF);
                if PDBFField(FieldList.Items[i]).FieldDec <> 0 
                  then Delete(s, Pos('.', s), 1);
                w := StrToIntDef(Trim(s), -1);
                if PDBFField(FieldList.Items[i]).FieldLen <= 4 then
                begin
                  w2 := Word(w);
                  BlockWrite(FileRecover, w2, SizeOf(w2));
                end
                else
                begin
                  BlockWrite(FileRecover, w, SizeOf(w));
                end;
  //              writeln(w);
                
              end;
            end;
            NumRead := LenF;
            locatF := locatF + LenF;
          end;

      FullArea := FullArea - NumRead;
      if EndOfFile 
        then NumRead := NumRead - 1;
//      BlockWrite(FileRecover, lpBuffer^, NumRead, NumWritten);

    until EndOfFile;

    FreeMem(lpBuffer);
    CloseFile(FileSource);
    CloseFile(FileRecover);

    try
      if Trim(ParamStr(3)) = '' then raise EInOutError.CreateFmt('饥  䠩 SQL-.', []);
      AssignFile(FileSql, ParamStr(3));
      Rewrite(FileSql);
    except
      on E:Exception do
      begin
        Writeln('? "', ParamStr(3), '" - ', E.Message);
        Halt(99);
      end;
    end;

    writeln(FileSql, 'Create table et'#13#10'External File ', '''', ParamStr(2), ''' (');
//    write(FileSql, '  "isDelete"     Char(1)');
    for i := 0 to FieldList.Count - 1 do
    begin
      if i <> 0 then writeln(FileSql, ',');
      s := PDBFField(FieldList.Items[i]).FieldName;
      if Pos(#00, s) <> 0 
        then s := Copy(s, 1, Pos(#00, s));
      s1 := PDBFField(FieldList.Items[i]).FieldType;
      case s1[1] of
        #78: write(FileSql, '  "', RightPadCh(Trim(s) + '"', ' ', 13), ' Numeric(', PDBFField(FieldList.Items[i]).FieldLen, ',', PDBFField(FieldList.Items[i]).FieldDec, ')');
        #76: begin end;
        else write(FileSql, '  "', RightPadCh(Trim(s) + '"', ' ', 13), ' VarChar(', PDBFField(FieldList.Items[i]).FieldLen, ')');
      end;
//      write(FileSql, '  "', RightPadCh(Trim(s) + '"', ' ', 13), ' Char(', PDBFField(FieldList.Items[i]).FieldLen, ')'); // '-- ', PDBFField(FieldList.Items[i]).FieldType, '(', PDBFField(FieldList.Items[i]).FieldLen, ',', PDBFField(FieldList.Items[i]).FieldDec, ')');
      FreeMem(FieldList.Items[i]);
    end;
    writeln(FileSql, #13#10');');

    CloseFile(FileSql);

    Writeln('!  襭.');
  finally
    FieldList.Free;
  end;
end.