unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, Spin, ComCtrls;

type
  TfrmMain = class(TForm)
    rdgDecode: TRadioGroup;
    OpenDlg: TOpenDialog;
    SaveDlg: TSaveDialog;
    bbDbfFile: TBitBtn;
    bbIbfile: TBitBtn;
    bbscrippt: TBitBtn;
    lbDbfFile: TLabel;
    lbIbfile: TLabel;
    lbsqlscript: TLabel;
    speKolRec: TSpinEdit;
    Label1: TLabel;
    myProgressBar: TProgressBar;
    btnExe: TBitBtn;
    procedure btnExeClick(Sender: TObject);
    procedure bbDbfFileClick(Sender: TObject);
    procedure bbIbfileClick(Sender: TObject);
    procedure bbscripptClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses mydbf;

{$R *.DFM}

procedure TfrmMain.btnExeClick(Sender: TObject);
var
 FileSourse, FileRecover : File;
 FileSql: TextFile;
 NumRead, NumWritten: integer;
 DBFHeader: TDBFHeader;
 DBFField: PDBFField;
 lpBuffer: PChar;
 RecordSize, BuferCount: integer;
 NextF, LenF, locatF, typeIndex, i, j : integer;
 FieldList: TList;
 ChByte: byte;
 BlockSize: longint;
 bFullHeader: integer;  //   "" 
 FullArea: integer;
 EndOfFile: boolean;
begin

FieldList:=TList.Create;
try

 bFullHeader:=0;

 AssignFile(FileSourse, lbDbfFile.Caption);
 Reset(FileSourse,1);
 BlockRead(FileSourse, DBFHeader, SizeOf(DBFHeader), NumRead);

if DBFHeader.Signat=4 then
 begin
  messagedlg(' dbf   ',mtError, [mbOk],0);
  exit;
 end;

 if DBFHeader.Signat<>3 then
 begin
  messagedlg('  dbf ',mtError, [mbOk],0);
  exit;
 end;


 repeat
  inc(bFullHeader,BlockHeaderSize);
  GetMem(DBFField,SizeOf(DBFField^));
  BlockRead(FileSourse, DBFField^, SizeOf(DBFField^), NumRead);
  if DBFField^.FieldName[1] = #13 then break;
  FieldList.Add(DBFField);
 until false;

 BuferCount := speKolRec.Value;  //     

 RecordSize:=DBFHeader.RecSize;

 BlockSize := RecordSize * BuferCount;

 bFullHeader:=bFullHeader+1;

 Reset(FileSourse,1);
 seek(FileSourse,bFullHeader);

 FullArea := FileSize(FileSourse)-bFullHeader;

 if frac(FullArea/BlockSize)>0 then
      myProgressBar.Max:=trunc(FullArea/BlockSize)+1
 else myProgressBar.Max:=trunc(FullArea/BlockSize);

 if BlockSize > FullArea then
    BlockSize := FullArea;



 GetMem(lpBuffer,BlockSize);

 AssignFile(FileRecover, lbIbfile.Caption);
 Rewrite(FileRecover,1);

 typeIndex:=rdgDecode.ItemIndex;

 repeat
  EndOfFile := FullArea <= BlockSize;
  BlockRead(FileSourse, lpBuffer^, BlockSize, NumRead);
  locatF := 1;
  if typeIndex<>0 then
   for i:=0 to FieldList.Count-1 do
   begin
    LenF := PDBFField(FieldList.Items[i]).FieldLen;
    NextF:= locatF;
    if PDBFField(FieldList.Items[i]).FieldType = 'C' then
      repeat
       for j:=NextF to NextF + LenF - 1 do
        begin
         ChByte:=Ch_conv[typeIndex, ord(lpBuffer[j])];
         if ChByte<>0 then lpBuffer[j]:=chr(ChByte);
        end;
        NextF := NextF + RecordSize;
      until NumRead<NextF;
      locatF := locatF + LenF;
    end;

   FullArea := FullArea - NumRead;
   if EndOfFile then NumRead := NumRead -1 ;

   BlockWrite(FileRecover, lpBuffer^, NumRead, NumWritten);

   myProgressBar.StepIt;
 until EndOfFile;

 FreeMem(lpBuffer);
 CloseFile(FileSourse);
 CloseFile(FileRecover);

 AssignFile(FileSql, lbsqlscript.Caption);
 Rewrite(FileSql);

 writeln(FileSql,'Create table et external file ','"',lbIbfile.Caption,'" (');
 write(FileSql,'       isDelete    char(1)');
 for i:=0 to FieldList.Count-1 do
 begin
  writeln(FileSql,',');
  write(FileSql,'       ',PDBFField(FieldList.Items[i]).FieldName , ' char(',PDBFField(FieldList.Items[i]).FieldLen,')');
  FreeMem(FieldList.Items[i]);
 end;
  writeln(FileSql,');');

  CloseFile(FileSql);

 messagedlg(' .',mtConfirmation,[mbOk],0);
finally
 FieldList.Free;
 myProgressBar.Position:=0;

end;

end;

procedure TfrmMain.bbDbfFileClick(Sender: TObject);
 var
  fullName, fName, pName: string;
begin
 if OpenDlg.Execute then
 begin
   btnExe.Enabled:=true;
   bbIbfile.Enabled:=true;
   bbscrippt.Enabled:=true;
   lbIbfile.Enabled:=true;
   lbsqlscript.Enabled:=true;


  fullName:=OpenDlg.FileName;
  lbDbfFile.Caption:=fullName;
  pName:=ExtractFilePath(fullName);

  fName:=ExtractFileName(fullName);
  fName:=copy(fName,0,pos('.',fName));
  lbIbfile.Caption:=pName+fName+'dat';
  lbsqlscript.Caption:=pName+fName+'sql';

 end;
end;

procedure TfrmMain.bbIbfileClick(Sender: TObject);
begin
 SaveDlg.Filter:='dat files|*.dat|all files (*.*)|*.*';
  SaveDlg.DefaultExt:='dat';
 if SaveDlg.Execute then
  lbIbfile.Caption:=SaveDlg.FileName;

end;

procedure TfrmMain.bbscripptClick(Sender: TObject);
begin
 SaveDlg.Filter:='sql files|*.sql|all files (*.*)|*.*';
 SaveDlg.DefaultExt:='sql';
 if SaveDlg.Execute then
  lbsqlscript.Caption:=SaveDlg.FileName;
end;

end.
