unit fEventer;

interface

uses
	IBase,
	SysUtils, WinTypes, WinProcs, Messages, Classes, Forms ;
const
	 WM_DbEvent = WM_USER + 175;
	 EventGroups = 2;
	 EventsPerGroup = 15;
type
	StatusArray = array[0..19] of Isc_Long;
	TEventGroup = (egFirst, egSecond);
	EventGroupRange = 0..Pred(EventGroups);
	EventsPerGroupRange = 0..Pred(EventsPerGroup);
	EventNamesArray = array [EventsPerGroupRange] of PChar;
	EventStatusArray = array[EventsPerGroupRange] of Isc_Long;
	EventRec = record
		EventBuf: PChar;
		EventID: LongInt;
		EventNames: EventNamesArray;
		EventsStatus: EventStatusArray;
		Length: Short;
		lpAstProc:  TFarProc;
		ResultBuf: PChar;
	end;
	EventRecArray = array [TEventGroup] of EventRec;

	PBufRec = ^TBufRec;
	TBufRec = Record
		Db: Isc_Db_Handle;
		EventCount: Short;
		EventGroups: EventRecArray;
		hWnd: THandle;
	end;

{---------------------------------------------------}
	TfrmEvtAlerter = class(TForm)
	public
		procedure WMDbEvent(var Msg: TMessage); message WM_DbEvent;
	end;

{---------------------------------------------------}

	EEvtAlerter = class (Exception);
{	public
		constructor Show(const Msg: String);
	end;}
{---------------------------------------------------}

	TEvtAlerter = class
	protected
		FConnected: Boolean;
		procedure InitEventNames;
		constructor Create;
	public

		destructor Destroy; override;
		procedure CheckError(msg: String);
		procedure ClearEventsStatus;
		procedure DisposeEventNames;
		procedure EventsCallBack(pBuf: PBufRec; anEventGroup: TEventGroup);
		function InitEventDatabase: Boolean;
		function InitEvents: Boolean;
		procedure NotifyEventsForGroup(anEventGroup: TEventGroup;
			anEventsStatus: EventStatusArray);
		property Connected: Boolean read FConnected;
	end;
{---------------------------------------------------}

	Procedure AstRoutineFirstGroup(pBuf: PBufRec; lLength: Short; Updated: PChar);
		cdecl; export;
	Procedure AstRoutineSecondGroup(pBuf: PBufRec; lLength: Short; Updated: PChar);
		cdecl; export;

var
	frmEvtAlerter: TfrmEvtAlerter;
	pBuf: PBufRec;
	SEvtAlerter: TEvtAlerter;
	Status: StatusArray;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}

implementation
{$R *.DFM}
uses
	Tester ;

{---------------------------------------------------------------------------}

{constructor EEvtAlerter.Show(const Msg: String);
begin
	inherited Create(Msg);
	FTitle := FTitle + ': EvtAlerter'#0;
	ShowMessage;
end;           }
{---------------------------------------------------------------------------}

procedure AstRoutineFirstGroup(pBuf: PBufRec; lLength: Short; Updated: PChar);
var
	pResult: PChar;
	I: Integer;
begin
	pResult := pBuf^.EventGroups[egFirst].ResultBuf;
	for I := 0 to lLength-1 do
		pResult[I]:= Updated[I];
	MessageBeep(0);
	PostMessage(pBuf^.hWnd, WM_DbEvent, Word(egFirst), LongInt(pBuf));
end;
{---------------------------------------------------}
procedure AstRoutineSecondGroup(pBuf: PBufRec; lLength: Short; Updated: PChar);
var
	pResult: PChar;
	I: Integer;
begin
	pResult := pBuf^.EventGroups[egSecond].ResultBuf;
	for I := 0 to lLength-1 do
		pResult[I]:= Updated[I];
	MessageBeep(0);
	PostMessage(pBuf^.hWnd, WM_DbEvent, Word(egSecond), LongInt(pBuf));
end;
{---------------------------------------------------}

constructor TEvtAlerter.Create;
begin
	inherited Create;
	FConnected := False;
end;
{---------------------------------------------------}

procedure TEvtAlerter.CheckError(msg: String);
begin
	if (Status[1] <> 0) then Raise EEvtAlerter.Create(msg);
end;
{---------------------------------------------------}

procedure TEvtAlerter.ClearEventsStatus;
var
	curGroup: TEventGroup;
	curEvent: Integer;
begin
	for curGroup := Low(TEventGroup) to High(TEventGroup) do
		for curEvent := Low(EventsPerGroupRange) to High(EventsPerGroupRange) do
			with pBuf^.EventGroups[curGroup] do
				EventsStatus[curEvent] := LongInt(0);
end;
{---------------------------------------------------}

destructor TEvtAlerter.Destroy;
var
	curGroup: TEventGroup;
begin
	if FConnected then begin
		DisposeEventNames;
		Isc_Detach_Database(@Status, @pBuf^.Db);

		for curGroup := Low(TEventGroup) to High(TEventGroup) do
			with pBuf^.EventGroups[curGroup] do begin
				FreeProcInstance(lpAstProc);
				isc_free(EventBuf);
				isc_free(ResultBuf);
			end;

		GlobalFreePtr(pBuf);
	end;
	inherited Destroy;
end;
{---------------------------------------------------}

procedure TEvtAlerter.DisposeEventNames;
var
	curGroup: TEventGroup;
	curEvent: Integer;
begin
	for curGroup := Low(TEventGroup) to High(TEventGroup) do
		for curEvent := Low(EventsPerGroupRange) to High(EventsPerGroupRange)	do
			with pBuf^.EventGroups[curGroup] do begin
				StrDispose(EventNames[curEvent]);
				EventNames[curEvent] := nil;
			end;
end;
{---------------------------------------------------}

procedure TEvtAlerter.EventsCallBack(pBuf: PBufRec; anEventGroup: TEventGroup);
begin
	ClearEventsStatus;
	with pBuf^.EventGroups[anEventGroup] do begin
		isc_event_counts(@EventsStatus, Length, EventBuf, ResultBuf);
		CheckError('EventsCallBack'#13 + 'Problems with isc_event_counts.');
		NotifyEventsForGroup(anEventGroup, EventsStatus);
		isc_que_events(@EventsStatus, @(pBuf^.Db), @EventId, Length,
			EventBuf, lpAstProc, pBuf);
		CheckError('EventsCallBack'#13 + 'Problems with isc_que_events.');
	end;
end;
{---------------------------------------------------}

function TEvtAlerter.InitEventDatabase: Boolean;
var
	Db: Isc_Db_Handle;
	dpb: array[0..255] of char;
	UserName: String;
	Password: String;
	Database: String;
	Count: Integer;
begin
	Database := 'GATE.STUBBS.COM:C:\EVENTS\TESTER.GDB'#0; {****override****}
	UserName := 'SYSDBA';
	Password:= 'masterkey';
	Db := nil;
	dpb[0] := Char(isc_dpb_Version1);
	dpb[1] := Char(isc_dpb_user_name);
	dpb[2] := Char(Length(UserName));
	StrPCopy(@dpb[3], UserName);
	Count := 3 + Length(UserName);
	dpb[Count] := Char(isc_dpb_password);
	Count := Count + 1;
	dpb[Count] := Char(Length(PassWord));
	Count := Count + 1;
	StrPCopy(@dpb[Count], Password);
	Count := Count + Length(Password);
	Isc_Attach_Database(@Status, 0, @Database[1], @Db, Count, @dpb);
	Result := LongBool(Db);
	if Result then begin
		pBuf := PBufRec(GlobalAllocPtr(GMEM_MOVEABLE or GMEM_ZEROINIT,
			sizeof(TBufRec)));
		pBuf^.Db := pLong(Db);
		FConnected := True
	end else
		raise Exception.Create('Could not initialize the event database.'#13 +
			'Check that you have overriden the database name');
end;
{---------------------------------------------------}

procedure TEvtAlerter.InitEventNames;
var
	curGroup: TEventGroup;
	curEvent,	lEventCount, EventIndex: Integer;
	Event_Names: TStrings;
begin
	Event_Names := frmTester.EventNames;
	try
		lEventCount := Event_Names.Count;

		for curGroup := Low(TEventGroup) to High(TEventGroup) do
			for curEvent := Low(EventsPerGroupRange) to High(EventsPerGroupRange) do
				with pBuf^.EventGroups[curGroup] do begin
					EventNames[curEvent] := StrAlloc(25);
					EventIndex := Ord(curGroup) * (EventsPerGroup) + curEvent;

					if (EventIndex < lEventCount) then
						StrPCopy(EventNames[curEvent], Event_Names[EventIndex])
					else
						StrPCopy(EventNames[curEvent], #0);

				end;
	finally
		Event_Names.Free;
	end;
end;
{---------------------------------------------------}

function TEvtAlerter.InitEvents: Boolean;
var
	curGroup: TEventGroup;
	curEvent: Integer;
begin
	try try
		pBuf^.EventCount := EventsPerGroup;
		InitEventNames;
		with pBuf^ do begin
			hWnd := frmEvtAlerter.Handle;
			EventGroups[egFirst].lpAstProc :=
				MakeProcInstance(@AstRoutineFirstGroup, HInstance);
			EventGroups[egSecond].lpAstProc :=
				MakeProcInstance(@AstRoutineSecondGroup, HInstance);
		end;

		for curGroup := Low(TEventGroup) to High(TEventGroup) do
			with pBuf^.EventGroups[curGroup] do begin
				Length := Short(Isc_Event_Block15(@(EventBuf), @(ResultBuf),
					pBuf^.EventCount,
					EventNames[0],   EventNames[1],	 EventNames[2],	 EventNames[3],
					EventNames[4],   EventNames[5],	 EventNames[6],	 EventNames[7],
					EventNames[8],   EventNames[9], EventNames[10],	EventNames[11],
					EventNames[12], EventNames[13], EventNames[14]));

				isc_que_events(@Status, @(pBuf^.Db), @(EventId), Length, EventBuf,
					lpAstProc,	pBuf);
				CheckError('InitEvents'#13 + 'Problems with isc_que_events.');
			end;

	except
		raise Exception.Create('Could not run  EvtAlerter.InitEvents');
		end;
	finally
	end;
end;
{---------------------------------------------------}

procedure TEvtAlerter.NotifyEventsForGroup(anEventGroup: TEventGroup;
	anEventsStatus: EventStatusArray);
var
	curEvent: Integer;
begin
	for curEvent := Low(EventsPerGroupRange) to High(EventsPerGroupRange) do
		if anEventsStatus[curEvent] > 0 then
			with pBuf^.EventGroups[anEventGroup] do
				frmTester.lbxEventsNotified.Items.Add(FormatDateTime('hh:nn:ss', Time)
					+ ' ' +	StrPas(EventNames[curEvent]));
end;
{-----------------------------------------------------------------------------}

procedure TfrmEvtAlerter.WMDbEvent(var Msg: TMessage);
var
	pBuf: PBufRec;
	EventGroup: TEventGroup;
begin
	EventGroup := TEventGroup(Msg.wParam);
	pBuf := PBufRec(Msg.lParam);
	SEvtAlerter.EventsCallBack(pBuf, EventGroup);
end;
{---------------------------------------------------------------------------}

procedure DoneEventer; far;
begin
	SEvtAlerter.Free;
	frmEvtAlerter.Close;
end;

initialization
	frmEvtAlerter := TfrmEvtAlerter.Create(Application);
	SEvtAlerter := TEvtAlerter.Create;
	AddExitProc(DoneEventer);
end.
