{ Wizard for TFIBDataSet 1.0 from 25 Feb 1999

  Freware with source.

  Copyright (c) 1998 Soft House Labs, Andre N Belokon
  Web     http://softlab.od.ua/
  Email   support@softlab.od.ua

  Disclaimer: THIS SOFTWARE AND THE ACCOMPANYING FILES ARE DISTRIBUTED
  "AS IS" AND WITHOUT WARRANTIES AS TO PERFORMANCE OF MERCHANTABILITY OR
  ANY OTHER WARRANTIES WHETHER EXPRESSED OR IMPLIED.
  NO WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE IS OFFERED.
  THE USER MUST ASSUME THE ENTIRE RISK OF USING THE ACCOMPANYING CODE.
}
unit FIBTblWiz;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FIB, FIBDatabase, FIBQuery, Db, FIBDataSet, Grids, DBGrids, StdCtrls,
  ExtCtrls, CheckLst, ComCtrls, DsgnIntf;

type
  TFIBTableWizardForm = class(TForm)
    TableList: TFIBDataSet;
    TableListRNAME: TFIBStringField;
    DataSource1: TDataSource;
    Notebook1: TNotebook;
    DBGrid1: TDBGrid;
    Label1: TLabel;
    PrevBtn: TButton;
    NextBtn: TButton;
    Button3: TButton;
    PKListBox: TListBox;
    Label2: TLabel;
    Label3: TLabel;
    FldListBox: TCheckListBox;
    PKQuery: TFIBQuery;
    FldQuery: TFIBQuery;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    MemoSelect: TMemo;
    MemoRefresh: TMemo;
    MemoUpdate: TMemo;
    MemoInsert: TMemo;
    MemoDelete: TMemo;
    procedure Button3Click(Sender: TObject);
    procedure Notebook1PageChanged(Sender: TObject);
    procedure PrevBtnClick(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure NextBtnClick(Sender: TObject);
  private
    TableName: string;
  end;

function ShowTableWizard(DataSet: TFIBDataSet): Boolean;
procedure Register;

implementation

{$R *.DFM}

function ShowTableWizard(DataSet: TFIBDataSet): Boolean;
begin
  Result:=False;
  if (DataSet <> nil) and (DataSet.Database <> nil) then
    with TFIBTableWizardForm.Create(Application) do try
      TableName:='';
      TableList.Database:=DataSet.Database;
      TableList.Transaction:=DataSet.Database.DefaultTransaction;
      PKQuery.Database:=DataSet.Database;
      PKQuery.Transaction:=DataSet.Database.DefaultTransaction;
      FldQuery.Database:=DataSet.Database;
      FldQuery.Transaction:=DataSet.Database.DefaultTransaction;
      PKQuery.Prepare;
      FldQuery.Prepare;
      TableList.Open;
      Notebook1.PageIndex:=0;
      if ShowModal = mrOK then begin
        DataSet.Active:=False;
        DataSet.SelectSQL:=MemoSelect.Lines;
        DataSet.RefreshSQL:=MemoRefresh.Lines;
        DataSet.UpdateSQL:=MemoUpdate.Lines;
        DataSet.InsertSQL:=MemoInsert.Lines;
        DataSet.DeleteSQL:=MemoDelete.Lines;
        Result:=True;
      end;
    finally
      Free;
    end;
end;

procedure TFIBTableWizardForm.Button3Click(Sender: TObject);
begin
  ModalResult:=mrCancel;
end;

procedure TFIBTableWizardForm.Notebook1PageChanged(Sender: TObject);
begin
  PrevBtn.Enabled:=Notebook1.PageIndex > 0;
  if Notebook1.PageIndex = Pred(Notebook1.Pages.Count) then
    NextBtn.Caption:='Finish'
  else
    NextBtn.Caption:='Next';
end;

procedure TFIBTableWizardForm.PrevBtnClick(Sender: TObject);
begin
  Notebook1.PageIndex:=Notebook1.PageIndex-1;
end;

procedure TFIBTableWizardForm.DataSource1DataChange(Sender: TObject;
  Field: TField);
var FName: string;
begin
  if Trim(TableListRNAME.value) <> TableName then begin
    TableName:=Trim(TableListRNAME.value);
    PKQuery.Params[0].AsString:=TableName;
    PKListBox.Items.Clear;
    PKQuery.ExecQuery;
    try
      while not PKQuery.Eof do begin
        PKListBox.Items.Add(Trim(PKQuery.Fields[0].AsString));
        PKQuery.Next;
      end;
    finally
      PKQuery.Close;
    end;
    FldQuery.Params[0].AsString:=TableName;
    FldListBox.Items.Clear;
    FldQuery.ExecQuery;
    try
      FldListBox.Items.BeginUpdate;
      while not FldQuery.Eof do begin
        FName:=Trim(FldQuery.Fields[0].AsString);
        if PKListBox.Items.IndexOf(FName) < 0 then begin
          FldListBox.Items.Add(FName);
          FldListBox.Checked[Pred(FldListBox.Items.Count)]:=True;
        end;
        FldQuery.Next;
      end;
    finally
      FldListBox.Items.EndUpdate;
      FldQuery.Close;
    end;
  end;
end;

procedure TFIBTableWizardForm.NextBtnClick(Sender: TObject);
var j: integer;
    s: string;
begin
  if Notebook1.PageIndex = Pred(Notebook1.Pages.Count) then
    ModalResult:=mrOK
  else begin
    case Notebook1.PageIndex of
      0: begin
        // select SQL
        with MemoSelect.Lines do begin
          Clear;
          Add('select');
          for j:=0 to Pred(PKListBox.Items.Count) do
            Add('  '+PKListBox.Items[j]+',');
          for j:=0 to Pred(FldListBox.Items.Count) do
            if FldListBox.Checked[j] then
              Add('  '+FldListBox.Items[j]+',');
          s:=MemoSelect.Lines[MemoSelect.Lines.Count-1];
          MemoSelect.Lines[MemoSelect.Lines.Count-1]:=Copy(s,1,Length(s)-1);
          Add('from '+TableName);
        end;
        // delete SQL
        with MemoDelete.Lines do begin
          Clear;
          Add('delete from '+TableName);
          Add('where');
          for j:=0 to Pred(PKListBox.Items.Count) do begin
            s:=PKListBox.Items[j];
            Add('  '+s+' = ?old_'+s+' and ');
          end;
          s:=MemoDelete.Lines[MemoDelete.Lines.Count-1];
          MemoDelete.Lines[MemoDelete.Lines.Count-1]:=Copy(s,1,Length(s)-4);
        end;
        // refresh SQL
        with MemoRefresh.Lines do begin
          Clear;
          Add('select');
          for j:=0 to Pred(PKListBox.Items.Count) do
            Add('  '+PKListBox.Items[j]+',');
          for j:=0 to Pred(FldListBox.Items.Count) do
            if FldListBox.Checked[j] then
              Add('  '+FldListBox.Items[j]+',');
          s:=MemoRefresh.Lines[MemoRefresh.Lines.Count-1];
          MemoRefresh.Lines[MemoRefresh.Lines.Count-1]:=Copy(s,1,Length(s)-1);
          Add('from '+TableName);
          Add('where');
          for j:=0 to Pred(PKListBox.Items.Count) do begin
            s:=PKListBox.Items[j];
            Add('  '+s+' = ?old_'+s+' and ');
          end;
          s:=MemoRefresh.Lines[MemoRefresh.Lines.Count-1];
          MemoRefresh.Lines[MemoRefresh.Lines.Count-1]:=Copy(s,1,Length(s)-4);
        end;
        // update SQL
        with MemoUpdate.Lines do begin
          Clear;
          Add('update '+TableName);
          Add('set');
          for j:=0 to Pred(FldListBox.Items.Count) do
            if FldListBox.Checked[j] then begin
              s:=FldListBox.Items[j];
              Add('  '+s+' = ?new_'+s+',');
            end;
          s:=MemoUpdate.Lines[MemoUpdate.Lines.Count-1];
          MemoUpdate.Lines[MemoUpdate.Lines.Count-1]:=Copy(s,1,Length(s)-1);
          Add('where');
          for j:=0 to Pred(PKListBox.Items.Count) do begin
            s:=PKListBox.Items[j];
            Add('  '+s+' = ?old_'+s+' and ');
          end;
          s:=MemoUpdate.Lines[MemoUpdate.Lines.Count-1];
          MemoUpdate.Lines[MemoUpdate.Lines.Count-1]:=Copy(s,1,Length(s)-4);
        end;
        // insert SQL
        with MemoInsert.Lines do begin
          Clear;
          Add('insert into '+TableName);
          Add('(');
          for j:=0 to Pred(PKListBox.Items.Count) do
            Add('  '+PKListBox.Items[j]+',');
          for j:=0 to Pred(FldListBox.Items.Count) do
            if FldListBox.Checked[j] then
              Add('  '+FldListBox.Items[j]+',');
          s:=MemoInsert.Lines[MemoInsert.Lines.Count-1];
          MemoInsert.Lines[MemoInsert.Lines.Count-1]:=Copy(s,1,Length(s)-1);
          Add(')');
          Add('values');
          Add('(');
          for j:=0 to Pred(PKListBox.Items.Count) do
            Add('  ?new_'+PKListBox.Items[j]+',');
          for j:=0 to Pred(FldListBox.Items.Count) do
            if FldListBox.Checked[j] then
              Add('  ?new_'+FldListBox.Items[j]+',');
          s:=MemoInsert.Lines[MemoInsert.Lines.Count-1];
          MemoInsert.Lines[MemoInsert.Lines.Count-1]:=Copy(s,1,Length(s)-1);
          Add(')');
        end;
      end
    end;
    Notebook1.PageIndex:=Notebook1.PageIndex+1;
  end;
end;

type
  TFIBDataSetEditor = class(TComponentEditor)
  private
    stdEditor: TComponentEditor;
  public
    constructor Create(AComponent: TComponent; ADesigner: IFormDesigner); override;
    destructor Destroy;  override;
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
    procedure DoEdit; 
  end;

type PClass = ^TClass;

constructor TFIBDataSetEditor.Create(AComponent: TComponent;
  ADesigner: IFormDesigner);
var saveClass: TClass;
begin
  inherited Create(AComponent,ADesigner);
  saveClass:=PClass(AComponent)^;
  try
    PClass(AComponent)^:=TDataSet;
    stdEditor:=GetComponentEditor(AComponent,ADesigner);
  finally
    PClass(AComponent)^:=saveClass;
  end;
end;

destructor TFIBDataSetEditor.Destroy;
begin
  stdEditor.Free;
  inherited Destroy;
end;

procedure TFIBDataSetEditor.ExecuteVerb(Index: Integer);
begin
  if Index < stdEditor.GetVerbCount then
    stdEditor.ExecuteVerb(Index)
  else
    DoEdit;
end;

function TFIBDataSetEditor.GetVerb(Index: Integer): String;
begin
  if Index < stdEditor.GetVerbCount then
    Result:=stdEditor.GetVerb(Index)
  else
    Result:='Table Wizard...';
end;

function TFIBDataSetEditor.GetVerbCount: Integer;
begin
  Result:=stdEditor.GetVerbCount+1;
end;

procedure TFIBDataSetEditor.DoEdit;
begin
  if ShowTableWizard(TFIBDataSet(Component)) then
    if Designer <> nil then Designer.Modified;
end;

procedure Register;
begin
  RegisterComponentEditor(TFIBDataSet,TFIBDataSetEditor);
end;

end.
