unit FIBProvider;

{ (c) "Mark Shapiro" <Mark.Shapiro@seguetech.com>

I decided to hack up a quick TFIBProvider class.  
This is functionally equivalent to TDataSetProvider, except that it
allows for the fetching and setting of parameters.

It's fairly simple, just add it to FIBComponents.dpk, compile, and use it in
place of TDataSetProvider components.

Enjoy, and feel free to make enhancements to this, just please make sure
they get back to Greg, and to myself.}

interface

uses Classes, Provider, FIB, FIBQuery, FIBDataSet, DBClient;

type
  TFIBProvider=class(TDataSetProvider)
  private
  protected
    function FetchParams: OleVariant; override;
    function GetDataSet: TFIBDataSet;
    procedure SetDataSet(ADataSet: TFIBDataSet);
    procedure SetParamByName(const ParamName: string; const Value: =
OleVariant); override;
    procedure SetParamByIndex(ParamIndex: Integer; const Value: =
OleVariant); override;
    function GetParamCount: Integer; override;
  public
    procedure SetParams(Values: OleVariant); override;
  published
    property DataSet: TFIBDataSet read GetDataSet write SetDataSet;
  end;

  procedure Register;

implementation

uses StdVcl, MidConst;

procedure Register;
begin
  RegisterComponents(FIBPalette, [TFIBProvider]);
end;

{ TProvider }

function TFIBProvider.GetDataSet: TFIBDataSet;
begin
  Result :=TFIBDataSet(inherited GetDataSet);
end;

procedure TFIBProvider.SetDataSet(ADataSet: TFIBDataSet);
begin
  inherited SetDataSet(ADataSet);
end;

function TFIBProvider.GetParamCount: Integer;
begin
  Result := 0;
  if not Assigned(DataSet) then Exit;
  Result:=TFIBDataSet(DataSet).Params.Count;
end;

procedure TFIBProvider.SetParamByName(const ParamName: string; const =
Value: OleVariant);
var
  Params: TFIBXSQLDA;
begin
  Params := TFIBDataSet(DataSet).Params;
  Params.ByName[ParamName].Value := Value;
end;

procedure TFIBProvider.SetParamByIndex(ParamIndex: Integer; const Value: =
OleVariant);
var
  Params: TFIBXSQLDA;
begin
  Params:=TFIBDataSet(DataSet).Params;
  Params[ParamIndex].Value := Value;
end;

function TFIBProvider.FetchParams: OleVariant;
var
  Params: TFIBXSQLDA;
  i: Integer;
begin
  Params:=TFIBDataSet(Dataset).Params;
  if (Params = nil) or (Params.Count = 0) then
    Result := NULL else
  begin
    Result := VarArrayCreate([0, Params.Count - 1], varVariant);
    for i := 0 to Params.Count - 1 do
      with Params[i] do
        Result[i] := VarArrayOf([Name, Ord(SQLType), 0, Value]);
  end;
end;

procedure TFIBProvider.SetParams(Values: OleVariant);
begin
  inherited SetParams(Values);
  DataSet.Close;
end;

end.

