unit Main;

interface

type
  PSmallInt = ^SmallInt;
  PInteger  = ^Integer;
  PFloat    = ^Single;
  PDouble   = ^Double;

function FormatFloat(var Value : Double; var K : Integer): PDouble; cdecl; export;

const K10 : array [0..10] of Double = (1,10,100,1000,10000,100000,
                                      1000000,10000000,100000000,
                                      1E9, 1E10);
implementation

uses Windows, SysUtils;

function FormatFloat(var Value : Double; var K : Integer): PDouble;
const
  EPS : Extended =1E-12;

  function MyABS(InValue: Extended): Extended;
  begin
      if InValue<-EPS then Result:=-InValue else Result:=InValue;
  end;

var
  X,Y : Extended;
  I   : Smallint;
begin
  if (K>=0) and (K<=10) then begin
    X:=Trunc(Value * K10[K]);
    Y:=Frac (Value * K10[K]);
    I:=0;
    if (Y<=-(EPS+0.5)) then I:=-1;
    if (Y>= (EPS+0.5)) then I:= 1;
    X:=X+I;

    if ( MyABS(MyABS(Y)-0.5)<EPS ) and ( MyABS(Frac(X/2))>Eps ) then begin
      if Y<-EPS then X:=X-1 else X:=X+1;
    end;

    Value := X/K10[K];
  end;
  Result:=@Value;
end;

initialization
  IsMultiThread:=True;   

end.

