{-------------------------------------------------------------------------------
          Savage Software Solutions FreeIB compliant DataSetPageProducer

              Copyright 1999 Savage Software All Rights Reserved.

                        http://www.SavageSoftware.com.au

 Author: Dominique Louis ( mailto:Dominique@SavageSoftware.com.au )

 Credits:
   Gregory H. Deatz : For putting together the FreeIB components.

 Description:
 ============
   An FIB compliant DatSetPageProducer, because TDataSetPageProducer was not
   compatible with FreeIB.

 Usage:
 ======
   If you install the FreeIBweb Pack this component should appear in your
   FreeIBComponents tab.  Otherwise you can just install this component on it's
   own into an existing package.
   Please Note : You must have the WebBroker components for this to work.
   If you have Delphi CS then you already have them otherwise you may have to
   purchase the WebBroker components from Borland.

 History:
 ========
   First Release.

 Licencing
 =========
 This is component is free, so do with it what you please but standard
 disclaimers apply.  If you happen to improve it please be sure to send me a
 copy of the inproved version so that I can include it in the next distribution
 for others to benefit from.

 ------------------------------------------------------------------------------}
unit FIBDataSetPageProducer;

interface

uses Classes, HTTPApp, DB, FIBDataSet, FIBQuery;

type
  TFIBDataSetPageProducer = class(TPageProducer)
  private
    FDataSet: TFIBDataSet;
  protected
    function GetDataSet: TFIBDataSet; virtual;
    procedure SetDataSet(ADataSet: TFIBDataSet); virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure DoTagEvent(Tag: TTag; const TagString: string; TagParams: TStrings;
      var ReplaceText: string); override;
  public
    function Content: string; override;
  published
    property DataSet: TFIBDataSet read GetDataSet write SetDataSet;
    property OnHTMLTag;
  end;

procedure Register;

implementation

uses
  WebConst, FIB;

function TFIBDataSetPageProducer.GetDataSet: TFIBDataSet;
begin
  Result := FDataSet;
end;

procedure TFIBDataSetPageProducer.SetDataSet(ADataSet: TFIBDataSet);
begin
  if FDataSet <> ADataSet then
  begin
    if ADataSet <> nil then ADataSet.FreeNotification(Self);
    FDataSet := ADataSet;
  end;
end;

procedure TFIBDataSetPageProducer.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = FDataSet) then
    FDataSet := nil;
end;

procedure TFIBDataSetPageProducer.DoTagEvent(Tag: TTag; const TagString: string;
  TagParams: TStrings; var ReplaceText: string);
var
  Field: TField;
begin
  if (TagParams.Count = 0) and Assigned(FDataSet) then
  begin
    Field := FDataSet.FindField(TagString);
    if Assigned(Field) then
        ReplaceText := Field.DisplayText;
  end;
  inherited DoTagEvent(Tag, TagString, TagParams, ReplaceText);
end;

function TFIBDataSetPageProducer.Content: string;
var
  Params: TStrings;
  I: Integer;
  Name: string;
begin
  if (FDataSet <> nil) and not FDataSet.Active then
    FDataSet.Open;
  if FDataSet <> nil then
  begin
    if FDataSet.Active then
      FDataSet.Active := False;
    FDataSet.QSelect.ParamCheck := True;
    try
      FDataSet.Prepare;
    except
      on E: EFIBInterBaseError do begin
        if EFIBInterBaseError(E).SQLCode = -104 then begin
          FDataSet.QSelect.ParamCheck := False;
          FDataSet.Prepare;
        end else
          raise;
      end;
    end;
    Params := nil;
    if Dispatcher <> nil then
      if Dispatcher.Request.MethodType = mtPost then
        Params := Dispatcher.Request.ContentFields
      else if Dispatcher.Request.MethodType = mtGet then
        Params := Dispatcher.Request.QueryFields;
    if Params <> nil then
      for I := 0 to Params.Count - 1 do
      begin
        Name := Params.Names[I];
        if FDataSet.Params.ByName[Name] <> nil then
          FDataSet.Params.ByName[Name].AsString := Params.Values[Name];
      end;
    FDataSet.Active := True;
  end;
  Result := inherited Content;
end;

procedure Register;
begin
  RegisterComponents('FreeIBComponents', [TFIBDataSetPageProducer]);
end;

end.
