{-------------------------------------------------------------------------------
          Savage Software Solutions FreeIB compliant QueryTableProducer

              Copyright 1999 Savage Software All Rights Reserved.

                        http://www.SavageSoftware.com.au

 Author: Dominique Louis ( mailto:Dominique@SavageSoftware.com.au )

 Credits:
   Gregory H. Deatz : For putting together the FreeIB components.

 Description:
 ============
   An FIB compliant QueryTableProducer, because TQueryTableProducer was not
   compatible with FreeIB.

 Usage:
 ======
   If you install the FreeIBweb Pack this component should appear in your
   FreeIBComponents tab.  Otherwise you can just install this component on it's
   own into an existing package.
   Please Note : You must have the WebBroker components for this to work.
   If you have Delphi CS then you already have them otherwise you may have to
   purchase the WebBroker components from Borland.

 History:
 ========
   First Release.

 Licencing
 =========
 This is component is free, so do with it what you please but standard
 disclaimers apply.  If you happen to improve it please be sure to send me a
 copy of the improved version so that I can include it in the next distribution
 for others to benefit from.
 
 ------------------------------------------------------------------------------}
unit FIBQueryTableProducer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  HTTPApp, DBWeb, DB, FIBDataSet, FIBQuery;

type
  TFIBQueryTableProducer = class(TDSTableProducer)
  private
    { Private declarations }
    FQuery: TFIBDataSet;
    procedure SetQuery(AQuery: TFIBDataSet);
  protected
    { Protected declarations }
    function GetDataSet: TDataSet; override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure SetDataSet(ADataSet: TDataSet); override;
  public
    { Public declarations }
    function Content: string; override;
  published
    { Published declarations }
    property Caption;
    property CaptionAlignment;
    property Columns;
    property Footer;
    property Header;
    property MaxRows;
    property Query: TFIBDataSet read FQuery write SetQuery;
    property RowAttributes;
    property TableAttributes;
    property OnCreateContent;
    property OnFormatCell;
    property OnGetTableCaption;
  end;

procedure Register;

implementation

uses
  WebConst, FIB;

{ TFIBQueryTableProducer }

function TFIBQueryTableProducer.Content: string;
var
  Params: TStrings;
  I: Integer;
  Name: string;
begin
  Result := '';
  if FQuery <> nil then
  begin
    if FQuery.Active then
      FQuery.Active := False;
    FQuery.QSelect.ParamCheck := True;
    try
      FQuery.Prepare;
    except
      on E: EFIBInterBaseError do begin
        if EFIBInterBaseError(E).SQLCode = -104 then begin
          FQuery.QSelect.ParamCheck := False;
          FQuery.Prepare;
        end else
          raise;
      end;
    end;
    Params := nil;
    if Dispatcher <> nil then
      if Dispatcher.Request.MethodType = mtPost then
        Params := Dispatcher.Request.ContentFields
      else if Dispatcher.Request.MethodType = mtGet then
        Params := Dispatcher.Request.QueryFields;
    if Params <> nil then
      for I := 0 to Params.Count - 1 do
      begin
        Name := Params.Names[I];
        if FQuery.Params.ByName[Name] <> nil then
          FQuery.Params.ByName[Name].AsString := Params.Values[Name];
      end;
    FQuery.Active := True;
    if DoCreateContent then
      Result := Header.Text + HTMLTable( FQuery, Self, MaxRows) + Footer.Text;
  end;
end;

function TFIBQueryTableProducer.GetDataSet: TDataSet;
begin
  Result := FQuery;
end;

procedure TFIBQueryTableProducer.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = FQuery) then
    FQuery := nil;
end;

procedure TFIBQueryTableProducer.SetDataSet(ADataSet: TDataSet);
begin
  SetQuery(ADataSet as TFIBDataSet);
end;

procedure TFIBQueryTableProducer.SetQuery(AQuery: TFIBDataSet);
begin
  if FQuery <> AQuery then
  begin
    if AQuery <> nil then AQuery.FreeNotification(Self);
    FQuery := AQuery;
    InternalDataSource.DataSet := FQuery;
  end;
end;

procedure Register;
begin
  RegisterComponents('FreeIBComponents', [TFIBQueryTableProducer]);
end;

end.
