{************************************************************************}
{                                                                        }
{   "gb_DataSets Components" - set of  additional components for IBX and }
{                             FIBPLUS libraries.                         }
{                                                                        }
{     These components are written to make possible a normal             }
{     navigation on potentially big tables or queries returning          }
{     a potentially high count of records                                }
{                                                                        }
{    ATTENTION: Don't forget about the rule of DOUBLE INDEXES for normal }
{               perfomance (see readme.txt for more information )!!!     }
{                                                                        }
{   Copyright (c) 2001, 2004 Spirin Sergey                               }
{                                                                        }
{   Company        : Paritet Soft LTD, Moscow                            }
{   Support e-mail : spirin@paritetsoft.ru                               }
{                                                                        }
{   Please see the file license.txt for full license information         }
{                                                                        }
{************************************************************************}

unit gb_DataReg;

{$I gb_DataInc.inc}

interface

uses
  Windows, Classes, SysUtils, DB, DBReg, gb_CustomDataSet, gb_Table, FldLinks,
  SQLEdit {$IFDEF D6} ,DesignEditors, DesignIntf, {$ELSE}, DsgnIntf, {$ENDIF}
{$IFDEF VER_IBX}
  {$IFNDEF BCB} IBUpdateSQLEditor, {$ENDIF} IBCustomDataSet, IBSQL;
{$ELSE}
  fibquery, fibdatabase, fibdataset, pFIBDataSet, FIBDataSQLEditor {fibsqled};
{$ENDIF}

type

  TgbSQLTranslator = class(TDataSetEditor)
  public
    IBDataset: {$IFDEF VER_IBX} TIBCustomDataset {$ELSE} TFIBCustomDataset {$ENDIF};
    FGetTableNamesProc: TGetTableNamesProc;
    FGetFieldnamesProc: TGetFieldNamesProc;
    procedure EditSQL;
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
    procedure GetTableNames(List: TStrings; SystemTables: Boolean);
    procedure GetFieldNames(const TableName: string; List: TStrings);
  end;

  TgbTableNameProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TgbFieldNameProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TgbGeneratorNameProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TgbIndexFieldNamesProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings);
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TgbTableFieldLinkProperty = class(TFieldLinkProperty)
  private
    FTable: TgbTable;
  protected
    function GetIndexFieldNames: string; override;
    function GetMasterFields: string; override;
    procedure SetIndexFieldNames(const Value: string); override;
    procedure SetMasterFields(const Value: string); override;
  public
    procedure Edit; override;
  end;


{$IFDEF VER_FIBPLUS}
procedure GetTablesNames(DataBase: TFIBDataBase; List: TStrings; SystemTables: Boolean);
procedure GetFieldsNames(DataSet: TgbCustomDataSet; DataBase: TFIBDataBase; const TableName: string; List: TStrings);
{$ENDIF}


procedure Register;

implementation

{$R gb_DataReg.res}

uses Forms;

procedure Register;
begin
  RegisterComponents('GB', [TgbDataSet, TgbTable]);
  RegisterComponentEditor(TgbDataSet, TgbSQLTranslator);
  RegisterPropertyEditor(TypeInfo(string), TgbTable, 'TableName', TgbTableNameProperty);
  RegisterPropertyEditor(TypeInfo(string), TgbTable, 'IndexFieldNames', TgbIndexFieldNamesProperty);
  RegisterPropertyEditor(TypeInfo(string), TgbTable, 'MasterFields', TgbTableFieldLinkProperty);
  RegisterPropertyEditor(TypeInfo(string), TGeneratorDef, 'FieldName', TgbFieldNameProperty);
  RegisterPropertyEditor(TypeInfo(string), TGeneratorDef, 'GeneratorName', TgbGeneratorNameProperty);
end;

{$IFDEF VER_FIBPLUS}

type
  THackDB = class(TFIBDataBase);

procedure GetTablesNames(DataBase: TFIBDataBase; List: TStrings; SystemTables: Boolean);
var
  Query : TFIBQuery;
  WasNotActive: Boolean;
begin
  if not DataBase.Connected then
    DataBase.Open;
  WasNotActive := True;
  if not THackDB(DataBase).vInternalTransaction.Active then
    THackDB(DataBase).vInternalTransaction.StartTransaction
  else
    WasNotActive := False;
  Query := TFIBQuery.Create(DataBase);
  try
    Query.GoToFirstRecordOnExecute := False;
    Query.Database := DataBase;
    Query.Transaction := THackDB(DataBase).vInternalTransaction;
    if SystemTables then
      Query.SQL.Text := 'Select RDB$RELATION_NAME from RDB$RELATIONS ' +
                        ' where RDB$VIEW_BLR is NULL ' +
                        'ORDER BY RDB$RELATION_NAME'
    else
      Query.SQL.Text := 'Select RDB$RELATION_NAME from RDB$RELATIONS ' +
                        ' where RDB$VIEW_BLR is NULL and RDB$SYSTEM_FLAG = 0 ' +
                        'ORDER BY RDB$RELATION_NAME';
    Query.Prepare;
    Query.ExecQuery;
    with List do
    begin
      BeginUpdate;
      try
        Clear;
        while (not Query.EOF) and (Query.Next <> nil) do
          List.Add(TrimRight(Query.Current[0].AsString));
      finally
        EndUpdate;
      end;
    end;
  finally
    Query.Free;
    if WasNotActive then
      THackDB(DataBase).vInternalTransaction.Commit;
  end;
end;

procedure GetFieldsNames(DataSet: TgbCustomDataSet; DataBase: TFIBDataBase; const TableName: string; List: TStrings);
var
  Query : TFIBQuery;
  WasNotActive: Boolean;
begin
  if TableName = '' then Exit;
  if not DataBase.Connected then
    DataBase.Open;
  WasNotActive := True;
  if not THackDB(DataBase).vInternalTransaction.Active then
    THackDB(DataBase).vInternalTransaction.StartTransaction
  else
    WasNotActive := False;
  Query := TFIBQuery.Create(DataBase);
  try
    Query.GoToFirstRecordOnExecute := False;
    Query.Database := DataBase;
    Query.Transaction := THackDB(DataBase).vInternalTransaction;
    Query.SQL.Text := 'Select R.RDB$FIELD_NAME ' +
      'from RDB$RELATION_FIELDS R, RDB$FIELDS F ' +
      'where R.RDB$RELATION_NAME = ' +
      '''' +
      ExtractIdent(DataSet, TableName) +
      ''' ' +
      'and R.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME ' +
      'ORDER BY R.RDB$FIELD_NAME';
    Query.Prepare;
    Query.ExecQuery;
    with List do
    begin
      BeginUpdate;
      try
        Clear;
        while (not Query.EOF) and (Query.Next <> nil) do
          List.Add(TrimRight(Query.Current.ByName['RDB$FIELD_NAME'].AsString)); {do not localize}
      finally
        EndUpdate;
      end;
    end;
  finally
    Query.free;
    if WasNotActive then
      THackDB(DataBase).vInternalTransaction.Commit;
  end;
end;
{$ENDIF}

{ TgbSQLTranslator }

procedure TgbSQLTranslator.EditSQL;
var
  SQLText: string;
  SQL: TStrings;
begin
  SQL := TStringList.Create;
  try
    SQL.Assign(TgbDataSet(Component).SelectSQL);
    SQLText := SQL.Text;
    if (SQLEdit.EditSQL(SQLText, FGetTableNamesProc, FGetFieldNamesProc)) and
      (SQL.Text <> SQLText) then
    begin
      SQL.Text := SQLText;
      if TgbDataSet(Component).Active then TgbDataSet(Component).Close;
      TgbDataSet(Component).SelectSQL.Assign(SQL);
      Designer.Modified;
    end;
  finally
    SQL.free;
  end;
end;

procedure TgbSQLTranslator.ExecuteVerb(Index: Integer);
var
  UpdSQL: {$IFDEF VER_IBX} TIBDataSet {$ELSE} TpFIBDataSet {$ENDIF};
begin
  if Index < inherited GetVerbCount then
    inherited ExecuteVerb(Index)
  else
  begin
    UpdSQL := {$IFDEF VER_IBX} TIBDataSet {$ELSE} TpFIBDataSet {$ENDIF}.Create(TgbDataSet(Component));
    UpdSQL.Database := TgbDataSet(Component).Database;
    UpdSQL.Transaction := TgbDataSet(Component).Transaction;
    UpdSQL.SelectSQL.Assign(TgbDataSet(Component).SelectSQL);
    UpdSQL.InsertSQL.Assign(TgbDataSet(Component).InsertSQL);
    UpdSQL.{$IFDEF VER_IBX} ModifySQL {$ELSE} UpdateSQL {$ENDIF}.Assign(TgbDataSet(Component).UpdateSQL);
    UpdSQL.DeleteSQL.Assign(TgbDataSet(Component).DeleteSQL);
    UpdSQL.RefreshSQL.Assign(TgbDataSet(Component).RefreshSQL);
    try
      if Index > 1 then
      begin
{$IFDEF VER_IBX}
  {$IFNDEF BCB}
        if EditIBDataSet(UpdSQL) then
   {$ELSE}
        Application.MessageBox('Sorry, IBX does not support interface for IBUpdateSQLEditor in C++Builder',
          'Not supported in C++Builder', MB_OK + MB_ICONSTOP);
        if False then
   {$ENDIF}
{$ELSE}
        if {ShowGenSQL} ShowDSSQLsEdit(UpdSQL) then
{$ENDIF}
        begin
          if TgbDataSet(Component).Active then TgbDataSet(Component).Close;
          TgbDataSet(Component).SelectSQL.Assign(UpdSQL.SelectSQL);
          TgbDataSet(Component).InsertSQL.Assign(UpdSQL.InsertSQL);
          TgbDataSet(Component).UpdateSQL.Assign(UpdSQL.{$IFDEF VER_IBX} ModifySQL {$ELSE} UpdateSQL {$ENDIF});
          TgbDataSet(Component).DeleteSQL.Assign(UpdSQL.DeleteSQL);
          TgbDataSet(Component).RefreshSQL.Assign(UpdSQL.RefreshSQL);
          Designer.Modified;
        end;
      end
      else
      begin
        IBDataset := UpdSQL;
        if Assigned(IBDataSet.Database) then
        begin
          FGetTableNamesProc := GetTableNames;
          FGetFieldNamesProc := GetFieldNames;
        end
        else
        begin
          FGetTableNamesProc := nil;
          FGetFieldNamesProc := nil;
        end;
       EditSQL;
      end;
    finally
      UpdSQL.Free;
    end;
  end;
end;

procedure TgbSQLTranslator.GetFieldNames(const TableName: string;
  List: TStrings);
var
  S : TStringList;
  i : Integer;
begin
  List.Clear;
  S := TStringList.Create;
  try
    S.Sorted := True;
{$IFDEF VER_IBX}
    IBDataset.Database.GetFieldNames(CheckQuotes(TgbDataSet(Component), TableName), S);
{$ELSE}
    GetFieldsNames(TgbDataSet(Component), IBDataset.Database, CheckQuotes(TgbDataSet(Component), TableName), S);
{$ENDIF}
    for i := 0 to S.Count - 1 do
      List.Add(S[i]);
  finally
    S.Free;
  end;
end;

procedure TgbSQLTranslator.GetTableNames(List: TStrings;
  SystemTables: Boolean);
begin
{$IFDEF VER_IBX}
  IBDataset.Database.GetTableNames(List, SystemTables);
{$ELSE}
  GetTablesNames(IBDataset.Database, List, SystemTables);
{$ENDIF}
  TStringList(List).Sorted := True;
end;

function TgbSQLTranslator.GetVerb(Index: Integer): string;
begin
  if Index < inherited GetVerbCount then
    Result := inherited GetVerb(Index)
  else
    if Index = 1 then
      Result := 'SQL Editor..'
    else
      Result := 'Update-SQL Editor...';
end;

function TgbSQLTranslator.GetVerbCount: Integer;
begin
  Result := inherited GetVerbCount + 2;
end;

{ TgbTableNameProperty }

function TgbTableNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList];
end;

procedure TgbTableNameProperty.GetValues(Proc: TGetStrProc);
var
  List: TStringList;
  Table: TgbTable;
  i: integer;
begin
  Table := GetComponent(0) as TgbTable;
  if Assigned(Table.Database) then
  begin
    List := TStringList.Create;
    try
{$IFDEF VER_IBX}
      Table.Database.GetTableNames(List, False);
{$ELSE}
      GetTablesNames(Table.DataBase, List, False);
{$ENDIF}
      for i := 0 to List.Count - 1 do
        Proc (List[i]);
    finally
      List.Free;
    end;
  end;
end;


{ TgbIndexFieldNamesProperty }

function TgbIndexFieldNamesProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TgbIndexFieldNamesProperty.GetValueList(List: TStrings);
var
  I: Integer;
  IndexDefs: TIndexDefs;
begin
  IndexDefs := (GetComponent(0) as TgbTable).IndexDefs;
  if Assigned((GetComponent(0) as TgbTable).Database) then IndexDefs.Update;
  for I := 0 to IndexDefs.Count - 1 do
    with IndexDefs[I] do
      if (Options * [ixExpression, ixDescending] = []) and (Fields <> '') then
        List.Add(Fields);
end;

procedure TgbIndexFieldNamesProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

{ TgbTableFieldLinkProperty }

procedure TgbTableFieldLinkProperty.Edit;
begin
  FTable := DataSet as TgbTable;
  inherited Edit;
end;

function TgbTableFieldLinkProperty.GetIndexFieldNames: string;
begin
  Result := FTable.IndexFieldNames;
end;

function TgbTableFieldLinkProperty.GetMasterFields: string;
begin
  Result := FTable.MasterFields;
end;

procedure TgbTableFieldLinkProperty.SetIndexFieldNames(
  const Value: string);
begin
  FTable.IndexFieldNames := Value;
end;

procedure TgbTableFieldLinkProperty.SetMasterFields(const Value: string);
begin
  FTable.MasterFields := Value;
end;

{ TgbFieldNameProperty }

function TgbFieldNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList];
end;

type
  gbHack = class(TgbCustomDataSet);
{$IFDEF D5}
  gbHack2 = class(TOwnedCollection);
{$ENDIF}

procedure TgbFieldNameProperty.GetValues(Proc: TGetStrProc);
var
  DataSet: TgbCustomDataSet;
  i: integer;
begin
{$IFDEF D6}
  DataSet := (TCollectionItem(GetComponent(0)).Collection).Owner as TgbCustomDataSet;
{$ELSE}
  DataSet := gbHack2(TCollectionItem(GetComponent(0)).Collection).GetOwner as TgbCustomDataSet;
{$ENDIF}
  if Assigned(DataSet.Database) and Assigned(DataSet.Transaction) then
  begin
    if gbHack(DataSet).SelectSQL.Text = '' then
    begin
      if (DataSet is TgbTable) and ((DataSet as TgbTable).TableName <> '') then
      begin
        DataSet.DisableControls;
        try
          DataSet.Open;
          DataSet.Close;
        finally
          DataSet.EnableControls;
        end;
      end;
    end;
    DataSet.FieldDefs.Update;
    for i := 0 to DataSet.FieldDefs.Count - 1 do
    begin
      if DataSet.FieldDefs.Items[i].DataType in [ftSmallInt, ftInteger, ftLargeint] then
        Proc(DataSet.FieldDefs.Items[i].Name);
    end;
  end;
end;

{ TgbGeneratorNameProperty }

function TgbGeneratorNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList];
end;

procedure TgbGeneratorNameProperty.GetValues(Proc: TGetStrProc);
const
  GENSQL =
    'SELECT RDB$GENERATOR_NAME FROM RDB$GENERATORS ' +
    'WHERE RDB$SYSTEM_FLAG = 0 OR RDB$SYSTEM_FLAG is NULL';
var
  DataSet: TgbCustomDataSet;
  sqlGen: {$IFDEF VER_IBX} TIBSQL {$ELSE} TFIBQuery {$ENDIF};
  DidActivate, DidConnect : Boolean;
begin
{$IFDEF D6}
  DataSet := (TCollectionItem(GetComponent(0)).Collection).Owner as TgbCustomDataSet;
{$ELSE}
  DataSet := gbHack2(TCollectionItem(GetComponent(0)).Collection).GetOwner as TgbCustomDataSet;
{$ENDIF}

  if Assigned(DataSet.Database) and Assigned(DataSet.Transaction) then
  begin
    DidActivate := false;
    DidConnect := false;
    sqlGen := {$IFDEF VER_IBX} TIBSQL {$ELSE} TFIBQuery {$ENDIF}.Create(DataSet.Database);
    sqlGen.Transaction := DataSet.Transaction;
    try
      sqlGen.SQL.Text := GENSQL;
      if not DataSet.Database.Connected then
      begin
        DataSet.Database.Connected := true;
        DidConnect := true;
      end;
      if not DataSet.Transaction.Active then
      begin
        DataSet.Transaction.Active := true;
        DidActivate := true;
      end;
      sqlGen.ExecQuery;
      while not sqlGen.Eof do
      begin
        Proc(Trim(sqlGen.Fields[0].AsString));
        sqlGen.Next;
      end;
    finally
      sqlGen.Free;
      if DidActivate then
        DataSet.Transaction.Active := false;
      if DidConnect then
        DataSet.Database.Connected := false;
    end;
  end;
end;

end.
