{************************************************************************}
{                                                                        }
{   "gb_DataSets Components" - set of  additional components for IBX and }
{                             FIBPLUS libraries.                         }
{                                                                        }
{     These components are written to make possible a normal             }
{     navigation on potentially big tables or queries returning          }
{     a potentially high count of records                                }
{                                                                        }
{    ATTENTION: Don't forget about the rule of DOUBLE INDEXES for normal }
{               perfomance (see readme.txt for more information )!!!     }
{                                                                        }
{   Copyright (c) 2001, 2004 Spirin Sergey                               }
{                                                                        }
{   Company        : Paritet Soft LTD, Moscow                            }
{   Support e-mail : spirin@paritetsoft.ru                               }
{                                                                        }
{   Please see the file license.txt for full license information         }
{                                                                        }
{************************************************************************}

unit gb_Table;

{$I gb_DataInc.inc}

interface

uses
  Windows, Messages, SysUtils, Classes, DB, gb_CustomDataSet,
  {$IFDEF VER_IBX} IBSQL; {$ELSE} fibquery; {$ENDIF}

type
  TgbTable = class(TgbCustomDataSet)
  private
    FTableName, FPrimaryIndexFields, FIndexFieldNames: string;
    FIndexDefs: TIndexDefs;
    FMasterLink: TMasterDataLink;
    FMasterWasDisabled: Boolean;
    function GetMasterFields: string;
    procedure MasterChanged(Sender: TObject);
    procedure MasterDisabled(Sender: TObject);
    procedure SetDataSource(Value: TDataSource);
    procedure SetMasterFields(const Value: string);
    procedure SetIndexDefs(Value: TIndexDefs);
    procedure SetTableName(Value: String);
    procedure SetIndexFieldNames(const Value: string);
    procedure GenerateSQL;
    procedure GenerateOtherSQLs;
    procedure TableReQuery;
  protected
    function GetDataSource: TDataSource; override;
    procedure UpdateIndexDefs; override;
    procedure InternalOpen; override;
    function GetMasterFieldValue(const ParName: string): Variant; override;
    procedure InternalInitFieldDefs; override;
    procedure SetFilterText(const Value: string); override;
    procedure SetFiltered(Value: Boolean); override;
  public
    property IndexDefs: TIndexDefs read FIndexDefs write SetIndexDefs;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property TableName: string read FTableName write SetTableName;
    property IndexFieldNames: string read FIndexFieldNames write SetIndexFieldNames;
    property Filter;
    property Filtered;
    property MasterFields: string read GetMasterFields write SetMasterFields;
    property MasterSource: TDataSource read GetDataSource write SetDataSource;
  end;


implementation


uses gb_DataConsts {$IFDEF VER_IBX}, IBHeader {$ELSE}, fibdatabase, ibase {$ENDIF};

{ TgbTable }

constructor TgbTable.Create(AOwner: TComponent);
begin
  inherited;
  FIndexDefs := TIndexDefs.Create(Self);
  FMasterLink := TMasterDataLink.Create(Self);
  FMasterLink.OnMasterChange := MasterChanged;
  FMasterLink.OnMasterDisable := MasterDisabled;
  FMasterWasDisabled := False;
end;

destructor TgbTable.Destroy;
begin
  FIndexDefs.Free;
  inherited;
end;

procedure TgbTable.GenerateOtherSQLs;
var
 P: integer;
 Str, StrWhere, TokenName, InsWhere, Temp: string;
 FieldInfo : PFieldInfo;

 procedure AddToken(S, Con: string; var Res :string);
 begin
   if Res = '' then
     Res := S
   else
     Res := Res + Con + S;
 end;

begin
  Str := '';
  StrWhere := '';
  P := 1;

  while P <= Length(FPrimaryIndexFields) do
  begin
    TokenName := ExtractFieldName(FPrimaryIndexFields, P);
    Temp := CheckQuotes(Self, TokenName);
    AddToken(Temp + '=:' + Temp, ' and ', Str);
    if StrWhere = '' then
      AddToken(Temp + '=:' + Temp, '', StrWhere);
  end;

  RefreshSQL.Assign(SelectSQL);
  RefreshSQL.Delete(RefreshSQL.Count - 1);
  InsertWhere(Str, RefreshSQL);

  FLockSQLText := 'update ' + CheckQuotes(Self, FTableName) + ' set ' +
                                                   StrWhere + ' where ' + Str;
  if opUseFirstStatement in Options then
  begin
    Str := RefreshSQL[0];
    System.Insert(' FIRST 1 ', Str, 7);
    RefreshSQL[0] := Str;
  end;

  SetRefreshSQL(RefreshSQL);
  if opCheckNullsInRefreshWhere in Options then
    Options := Options - [opCheckNullsInRefreshWhere];

  Str := '';
  StrWhere := '';
  TokenName := '';
  InsWhere := '';
  for P := 0 to GetMapCount -1 do
  begin
    FieldInfo := GetMap(P, False);
    if (FieldInfo^.FUnknownType) or (FieldInfo^.FNotUpdateble) then Continue;
    Temp := CheckQuotes(Self, FieldInfo^.FFieldName);
    AddToken(Temp + '=:' + Temp, ', ', Str);
    if FieldInfo^.FType <> SQL_BLOB then
      AddToken(Temp + '=:' + CheckQuotes(Self, 'OLD_' + FieldInfo^.FFieldName), ' and ', StrWhere);
    AddToken(Temp, ',', TokenName);
    AddToken(Temp, ',:', InsWhere);
  end;

  DeleteSQL.Clear;
  DeleteSQL.Add('delete from ' + CheckQuotes(Self, FTableName));
  DeleteSQL.Add('where ' + StrWhere);

  UpdateSQL.Clear;
  UpdateSQL.Add('update ' + CheckQuotes(Self, FTableName));
  UpdateSQL.Add('set ' + Str);
  UpdateSQL.Add('where ' + StrWhere);

  InsertSQL.Clear;
  InsertSQL.Add('insert into ' + CheckQuotes(Self, FTableName) + ' (' + TokenName + ')');
  InsertSQL.Add('values ' + '(:' + InsWhere + ')');
end;

procedure TgbTable.GenerateSQL;
var
  SQL: TStringList;
  P, x: integer;
  TokenName, TokenName2, WhereStr, CheckInd: string;
  WherePresent: Boolean;

  function GetQuotesNames(const S: string): string;
  var
    P: integer;
  begin
    P := 1;
    Result := '';
    while P <= Length(S) do
    begin
      if Result = '' then
        Result := CheckQuotes(Self, ExtractFieldName(S, P))
      else
        Result := Result + ',' + CheckQuotes(Self, ExtractFieldName(S, P));
    end;
  end;

  function GetCorrectOrder:string;
  var
    x: integer;
  begin
    Result := '';
    if (IndexFieldNames = '') or (IndexFieldNames = FPrimaryIndexFields) then
    begin
      Result := GetQuotesNames(FPrimaryIndexFields);
    end
    else
    begin
      for x := 0 to IndexDefs.Count -1 do
      begin
        if IndexFieldNames = IndexDefs.Items[x].Fields then
          if ixUnique in IndexDefs.Items[x].Options then
          begin
            Result := GetQuotesNames(IndexFieldNames);
            break;
          end;
      end;
      if Result = '' then
      begin
         P := 1;
         Result := GetQuotesNames(IndexFieldNames);
         while P <= Length(FPrimaryIndexFields) do
         begin
           TokenName := ExtractFieldName(FPrimaryIndexFields, P);
           if Pos(',' + TokenName + ',', ',' + Result + ',') = 0 then
              Result := Result + ',' + CheckQuotes(Self, TokenName);
         end;
      end;
    end;
  end;

begin
  IndexDefs.Update;

  FKeyFieldsForBookmark := FPrimaryIndexFields;

  SQL:= TStringList.Create;
  SQL.Clear;
  SQL.Add('select * from ' + CheckQuotes(Self, FTableName));
  SQL.Add('order by ' + GetCorrectOrder);

  WherePresent := False;
  if Filtered and (Filter <> '') then
  begin
    SQL.Insert(1, 'where ' + Filter);
    WherePresent := True;
  end;

  if (MasterSource <> nil) and (MasterSource.DataSet <> nil) and (MasterSource.DataSet.Active)
    and (MasterFields <> '') then
  begin
    WhereStr := '';
    P := 1;
    x:= 1;
    if IndexFieldNames <> '' then
      CheckInd := IndexFieldNames
    else
      CheckInd := FPrimaryIndexFields;
    while P <= Length(MasterFields) do
    begin
      TokenName := ExtractFieldName(MasterFields, P);
      if x <= Length(CheckInd) then
      begin
        TokenName2 := ExtractFieldName(CheckInd, x);
        if WhereStr = '' then
          WhereStr := CheckQuotes(Self, TokenName2) + '=:' +
            CheckQuotes(Self, 'M$S$T$_' + TokenName)
        else
          WhereStr := WhereStr + ' and ' + CheckQuotes(Self, TokenName2) +
            '=:' + CheckQuotes(Self, 'M$S$T$_' + TokenName);
      end
      else
        break;
    end;
  if WherePresent then
    SQL[1] := SQL[1] + ' and ' + WhereStr
  else
    SQL.Insert(1, 'where ' + WhereStr);
  end;
{$IFDEF VER_FIBPLUS}
  CloseSelectQuery;
{$ENDIF}
  SelectSQL.Assign(SQL);
  SQL.Free;
  RefreshSQL.Clear;
  UpdateSQL.Clear;
end;

function TgbTable.GetDataSource: TDataSource;
begin
  Result := FMasterLink.DataSource;
end;

function TgbTable.GetMasterFields: string;
begin
  Result := FMasterLink.FieldNames;
end;

function TgbTable.GetMasterFieldValue(const ParName: string): Variant;
begin
  if (MasterSource = nil) or (MasterSource.DataSet = nil) or
    (not MasterSource.DataSet.Active) then
    Result := VarNull
  else
    Result := MasterSource.DataSet.FieldByName(ParName).Value;
end;

procedure TgbTable.InternalInitFieldDefs;
begin
  if TableName = '' then
    raise Exception.Create(gb_SNoTableName);
  if SelectSQL.Text = '' then GenerateSQL;
  inherited;
end;

procedure TgbTable.InternalOpen;
begin
  if FTableName <> '' then
  begin
    GenerateSQL;
    inherited;
    GenerateOtherSQLs;
  end
  else
    raise Exception.Create(gb_SNoTableName);
end;

procedure TgbTable.MasterChanged(Sender: TObject);
begin
  if FMasterWasDisabled then
    FMasterWasDisabled := False;
  TableReQuery;
end;

procedure TgbTable.MasterDisabled(Sender: TObject);
begin
  TableReQuery;
  FMasterWasDisabled := True;
end;

procedure TgbTable.SetDataSource(Value: TDataSource);
begin
  if IsLinkedTo(Value) then raise Exception.Create(gb_SCircularDataLink);
  if FMasterLink.DataSource <> Value then
    DataEvent(dePropertyChange, 0);
  FMasterLink.DataSource := Value;
end;

procedure TgbTable.SetFiltered(Value: Boolean);
begin
  if Value <> Filtered then
  begin
    inherited;
    if Active then TableReQuery;
  end;
end;

procedure TgbTable.SetFilterText(const Value: string);
begin
  if Value <> Filter then
  begin
    inherited;
    if Active and Filtered then TableReQuery;
  end;
end;

procedure TgbTable.SetIndexDefs(Value: TIndexDefs);
begin
  IndexDefs.Assign(Value);
end;

procedure TgbTable.SetIndexFieldNames(const Value: string);
begin
  if FIndexFieldNames <> Value then
  begin
    FIndexFieldNames := Value;
    if Active then TableReQuery;
  end;
end;

procedure TgbTable.SetMasterFields(const Value: string);
begin
  if FMasterLink.FieldNames <> Value then
    DataEvent(dePropertyChange, 0);
  FMasterLink.FieldNames := Value;
end;

procedure TgbTable.SetTableName(Value: String);
begin
  if not (csReading in ComponentState) then
  begin
    if Value <> FTableName then
    begin
      if Active then Close;
      FTableName := Value;
      FIndexFieldNames := '';
      FPrimaryIndexFields := '';
      SelectSQL.Clear;
      IndexDefs.Updated := False;
      DataEvent(dePropertyChange, 0);
      GenerateSQL;
    end;
  end
  else
    if Value <> FTableName then
      FTableName := Value;
end;

procedure TgbTable.TableReQuery;
begin
  GenerateSQL;
  ConvertSQLs(True);
  GenerateOtherSQLs;
  ReQuery(True);
end;

{$IFDEF VER_FIBPLUS}
type
  THackDataBase = class(TFIBDataBase);
{$ENDIF}

procedure TgbTable.UpdateIndexDefs;
var
  Opts: TIndexOptions;
  Flds: string;
  Query, SubQuery: {$IFDEF VER_IBX} TIBSQL {$ELSE} TFIBQuery {$ENDIF};
begin
  if not (csReading in ComponentState) then
  begin
    IndexDefs.Clear;
    if not Assigned(Database) then
       raise Exception.Create(gb_SNoDatabase);
    {$IFDEF VER_IBX}
    Database.InternalTransaction.StartTransaction;
    {$ELSE}
    THackDataBase(DataBase).vInternalTransaction.StartTransaction;
    {$ENDIF}
    Query := {$IFDEF VER_IBX} TIBSQL {$ELSE} TFIBQuery {$ENDIF}.Create(self);
    try
      FPrimaryIndexFields := '';
      Query.GoToFirstRecordOnExecute := False;
      Query.Database := DataBase;
     {$IFDEF VER_IBX}
      Query.Transaction := Database.InternalTransaction;
     {$ELSE}
      Query.Transaction := THackDataBase(DataBase).vInternalTransaction;
     {$ENDIF}
      Query.SQL.Text :=
      'Select I.RDB$INDEX_NAME, I.RDB$UNIQUE_FLAG, I.RDB$INDEX_TYPE, ' + {do not localize}
      'I.RDB$SEGMENT_COUNT, S.RDB$FIELD_NAME from RDB$INDICES I, ' + {do not localize}
      'RDB$INDEX_SEGMENTS S where I.RDB$INDEX_NAME = S.RDB$INDEX_NAME '+ {do not localize}
      'and I.RDB$RELATION_NAME = ' + '''' + {do not localize}
      ExtractIdent(Self, CheckQuotes(Self, FTableName)) + '''';
      Query.Prepare;
      Query.ExecQuery;
      while (not Query.EOF) and (Query.Next <> nil) do
      begin
        with IndexDefs.AddIndexDef do
        begin
          Name := TrimRight(Query.Current.{$IFDEF VER_IBX}ByName('RDB$INDEX_NAME'){$ELSE}ByName['RDB$INDEX_NAME']{$ENDIF}.AsString); {do not localize}
          Opts := [];
          if Pos ('RDB$PRIMARY', Name) = 1 then Include(Opts, ixPrimary); {do not localize} {mbcs ok}
          if Query.Current.{$IFDEF VER_IBX}ByName('RDB$UNIQUE_FLAG'){$ELSE}ByName['RDB$UNIQUE_FLAG']{$ENDIF}.AsInteger = 1 then Include(Opts, ixUnique); {do not localize}
          if Query.Current.{$IFDEF VER_IBX}ByName('RDB$INDEX_TYPE'){$ELSE}ByName['RDB$INDEX_TYPE']{$ENDIF}.AsInteger = 1  then Include(Opts, ixDescending); {do not localize}
          Options := Opts;
          if (Query.Current.{$IFDEF VER_IBX}ByName('RDB$SEGMENT_COUNT'){$ELSE}ByName['RDB$SEGMENT_COUNT']{$ENDIF}.AsInteger = 1) then {do not localize}
            Fields := Trim(Query.Current.{$IFDEF VER_IBX}ByName('RDB$FIELD_NAME'){$ELSE}ByName['RDB$FIELD_NAME']{$ENDIF}.AsString) {do not localize}
          else
          begin
            SubQuery := {$IFDEF VER_IBX} TIBSQL {$ELSE} TFIBQuery {$ENDIF}.Create(self);
          try
            SubQuery.GoToFirstRecordOnExecute := False;
            SubQuery.Database := DataBase;
            {$IFDEF VER_IBX}
            SubQuery.Transaction := Database.InternalTransaction;
            {$ELSE}
            SubQuery.Transaction := THackDataBase(DataBase).vInternalTransaction;
            {$ENDIF}
            SubQuery.SQL.Text :=
            'Select RDB$FIELD_NAME from RDB$INDEX_SEGMENTS where RDB$INDEX_NAME = ' + {do not localize}
            '''' +  {do not localize}
            ExtractIdent(Self,
            CheckQuotes(Self, Name)) + '''' + 'ORDER BY RDB$FIELD_POSITION'; {do not localize}
            SubQuery.Prepare;
            SubQuery.ExecQuery;
            Flds := '';
            while (not SubQuery.EOF) and (SubQuery.Next <> nil) do
            begin
              if (Flds = '') then
                Flds := TrimRight(SubQuery.Current.{$IFDEF VER_IBX}ByName('RDB$FIELD_NAME'){$ELSE}ByName['RDB$FIELD_NAME']{$ENDIF}.AsString) {do not localize}
              else
              begin
                Query.Next;
                Flds := Flds + ';' + TrimRight(SubQuery.Current[0].AsString);
              end;
            end;
            Fields := Flds;
          finally
            SubQuery.Free;
          end;
          end;
          if (ixDescending in Opts) then
            DescFields := Fields;
          if ixPrimary in Opts then
            FPrimaryIndexFields := Fields;
        end;
      end;
      if FPrimaryIndexFields = '' then
        raise Exception.Create(gb_NotCorrectTableName);
    finally
      Query.Free;
      {$IFDEF VER_IBX}
      Database.InternalTransaction.Commit;
      {$ELSE}
      THackDataBase(DataBase).vInternalTransaction.Commit;
      {$ENDIF}
    end;
  end;
end;

end.
