{*******************************************************************}
{                                                                   }
{    Copyright () 1998-2000 RCAV rcav@peterlink.ru                 }
{                                                                   }
{    :   (LOA)  loa@mail.ru                          }
{                                                                   }
{*******************************************************************}

program gidx;
{$APPTYPE CONSOLE}
uses
  SysUtils, Classes, DB, IBDataBase, IBSQL;

type
  TUpdateIndicesFlag = (uifIncludeSystem, uifCommitAfterEachIndex, uifIncludeUnique);
  TUpdateIndicesFlags = set of TUpdateIndicesFlag;                           

var
  ADatabaseName, AUserName, APassword: string;
  SQL: TIBSQL;
  Indices: TStrings;
  I: Integer;
  Flags: TUpdateIndicesFlags;
begin
  if ParamCount = 0 then
  begin
    WriteLn('please retry, specifing an option');
    WriteLn('allowed options are:');
    WriteLn;
    WriteLn(' -user       default user name');
    WriteLn(' -password   default password');
    WriteLn(' -c          commit after each index');
    WriteLn(' -s          include system defined indices');
    WriteLn(' "database name"');
    Halt(1);
  end;

  try
    //   
    // default values
    AUserName := 'sysdba'; APassword := 'masterke'; Flags := [];

    I := 1;
    while I <= ParamCount do
    begin
      if AnsiCompareText(ParamStr(I), '-user') = 0 then
      begin
        Inc(I);
        if I <= ParamCount then AUserName := ParamStr(I);  
        Continue;
      end else
      if AnsiCompareText(ParamStr(I), '-password') = 0 then
      begin
        Inc(I);
        if I <= ParamCount then APassword := ParamStr(I);  
        Continue;
      end else
      if AnsiCompareText(ParamStr(I), '-s') = 0 then
      begin
        Inc(I);
        Include(Flags, uifIncludeSystem);  
        Continue;
      end else
      if AnsiCompareText(ParamStr(I), '-c') = 0 then
      begin
        Inc(I);
        Include(Flags, uifCommitAfterEachIndex);  
        Continue;
      end else
      if AnsiCompareText(ParamStr(I), '-u') = 0 then
      begin
        Inc(I);
        Include(Flags, uifIncludeUnique);  
        Continue;
      end else
      if AnsiCompareText(ParamStr(I)[1], '-') = 0 then
        raise Exception.Create('unknown option '+ParamStr(I))
      else
      begin
        ADatabaseName := ParamStr(I);
        Inc(I);
      end;
    end;

    SQL := nil; Indices := nil;
    try 
      SQL := TIBSQL.Create(nil);
      Indices := TStringList.Create;

      SQL.Database := TIBDatabase.Create(SQL);
      with SQL.Database do
      begin
        DatabaseName := ADatabaseName;
        LoginPrompt := False;
        Params.Values['user_name'] := AUserName;
        Params.Values['password'] := APassword;
      end;   
      SQL.Transaction := TIBTransaction.Create(SQL);
      SQL.Transaction.DefaultDatabase := SQL.Database;

      SQL.SQL.Add('select RDB$INDEX_NAME from RDB$INDICES');
      SQL.SQL.Add('where (RDB$INDEX_INACTIVE is null or RDB$INDEX_INACTIVE<>1)');

      if not (uifIncludeUnique in Flags) then
        SQL.SQL.Add('and (RDB$UNIQUE_FLAG is null or RDB$UNIQUE_FLAG<>1)');
      if not (uifIncludeSystem in Flags) then
        SQL.SQL.Add('and (RDB$SYSTEM_FLAG is null or RDB$SYSTEM_FLAG<>1)');

      WriteLn('gidx: connecting database ', SQL.DataBase.DatabaseName);    
      SQL.DataBase.Open;
      SQL.Transaction.StartTransaction;  

      WriteLn('gidx: fetch out index names');    
      //     
      // got index list to update
      SQL.ExecQuery;
      while not SQL.EOF do
      begin
        Indices.Add(SQL.Fields[0].AsString);
        SQL.Next;
      end;
      SQL.Close;

      WriteLn('gidx: updating indices');    
      //    
      // running set statistics for indices
      for I := 0 to Indices.Count-1 do
      begin
        WriteLn('gidx: updating index ', Indices[I]);    
        SQL.SQL.Text := Format('set statistics index %s', [Indices[I]]);
        SQL.ExecQuery;
        SQL.Close;
      
        if uifCommitAfterEachIndex in Flags then 
        begin
          WriteLn('gidx: commit retaining');    
          SQL.Transaction.CommitRetaining;
        end;
      end;    
		  
      WriteLn('gidx: commit');    
      SQL.Transaction.Commit;    
    finally
      FreeAndNil(Indices);
      FreeAndNil(SQL);    
    end;
  except
    on E: Exception do
    begin
      Writeln(E.Message);
      Halt(2);
    end;
  end;
end.

