library GUID_UDF;

{ 
russian:
  GUID_UDF -     GUID ( ).
  GUID        .
    GUID . www.microsoft.com.
  
     GUID        
  (  Windows 95,98, NT 4.  Windows 2000, XP, 2003 - GUID 
   ,   CreateRevGuid    
   ), 
      IB.     
  CreateReverseGUID,  ""  GUID.
         8
       CreateGUID!

   CreateGUID  CreateReverseGUID    thread-safe.
    ,     
  36 ,     32 . 
      GUID,    ,
     CHAR(32).

     GUID    
        ).

english:

  GUID_UDF - set of functions to get GUID (unique identifier). GUID can be used
  to get unique identifiers on different computers. For more information about
  GUIDs look at www.microsoft.com.

  Original GUID function return value that changes from left. This values can't be
  packed. There is a special function CreateReverseGuid that reverses GUID values
  to the right. This values can be packed in Interbase indices from 4 to 8 times
  (proved by tests). This only works if UDF is executed only at Windows 95, 98, NT.
  Windows 2000, XP, 2003 generates totally random GUID that does not "sequenced"
  in any of it's part. So, CreateRevGuid does not have sense.

  The following two functions are tested and thread-safe. While they are
  declared as returning 36 characters, really returned value is 32 characters.
  You can declare field as CHAR(32) to store GUID values.

  Unnecessary symbols are eliminated from standard GUID value.

(c) iBase.ru, Kuzmenko Dmitry, kdv@ibase.ru, http://www.ibase.ru (1251).

}

uses
  SysUtils,
  Classes,
  ActiveX;

 function CreateClassID: string;
 var
   ClassID: TCLSID;
   P: PWideChar;
 begin
  CoCreateGuid(ClassID);
  StringFromCLSID(ClassID, P);
  Result := P;
  CoTaskMemFree(P);
 end;

{ DECLARE EXTERNAL FUNCTION CreateGUID
  integer, cstring(36)
  RETURNS PARAMETER 2
  ENTRY_POINT 'CreateGUID' MODULE_NAME 'GUID_UDF';}

 procedure CreateGUID(var i: integer; p: pchar); cdecl; export;
  var s: string[36];
  begin
   i:=0;
   s:=Copy(CreateClassID, 2, 36);
   StrPCopy(P,
     Copy(s, 1,  8)+
     Copy(s, 10, 4)+
     Copy(s, 15, 4)+
     Copy(s, 20, 4)+
     Copy(s, 25,12));
  end;

{DECLARE EXTERNAL FUNCTION CreateRevGUID
  integer, cstring(36)
  RETURNS PARAMETER 2
  ENTRY_POINT 'CreateReverseGUID' MODULE_NAME 'GUID_UDF'}

 procedure CreateReverseGUID(var i: integer; p: pchar); cdecl; export;
  var s: string[36];
  begin
   i:=0;
   s:=Copy(CreateClassID, 2, 36);
   StrPCopy(P,
     Copy(s, 25, 12)+
     Copy(s, 20, 4)+
     Copy(s, 15, 4)+
     Copy(s, 10, 4)+
     Copy(s, 1, 8));
  end;



exports
 CreateGUID,
 CreateReverseGUID;

begin
 isMultiThread:=True;
end.
