program IB_AFFINITY;

{$APPTYPE CONSOLE}

{ Compiled with Delphi4 (UP3) }

uses Windows, Sysutils;

var
  MaskToSet: Integer = 0;
  SetMask: Boolean = false;
  QueryMask: Boolean = false;
  NoDebugPrivilege: Boolean = false;
  ib_hwnd: THandle = 0;
  ib_processid: DWORD = 0;
  ib_processh: THandle = 0;
  own_token: THandle = 0;
  process_affmask: DWORD = 0;
  sys_affmask: DWORD = 0;
  RetryCountdown: Integer = 0;
  RetryDelay: Integer = 0;
  RunProg: string = '';

function MyAdjustTokenPrivileges(TokenHandle: THandle; DisableAllPrivileges: BOOL;
  const NewState: TTokenPrivileges; BufferLength: DWORD;
  PreviousState: PTokenPrivileges; ReturnLength: PDWORD): BOOL; stdcall;
  external advapi32 name 'AdjustTokenPrivileges';

function EnablePrivilege(h: THandle; AName: string; AState: Boolean): Boolean;
var
  tp: TTokenPrivileges;
begin
  Result := false;
  if not LookupPrivilegeValue(nil, PChar(AName), tp.Privileges[0].Luid) then Exit;
  tp.PrivilegeCount := 1;
  if AState then tp.Privileges[0].Attributes := SE_PRIVILEGE_ENABLED
            else tp.Privileges[0].Attributes := 0;
  Result := MyAdjustTokenPrivileges(h, false, tp, SizeOf(tp), nil, nil);
end;

procedure EnableSeDebugPrivilege;
begin
  //enable SeDebugPrivilege
  //(needed to be able to set affinity mask if IBServer runs as service using the system account)
  if not NoDebugPrivilege then
  begin
    Win32Check(OpenProcessToken(GetCurrentProcess, TOKEN_ADJUST_PRIVILEGES, own_token));
    Win32Check(EnablePrivilege(own_token, 'SeDebugPrivilege', true));
  end;
end;

procedure PrintHelp;
begin
  writeln('With IB_AFFINITY you can control the affinity mask of the IBServer process.');
  writeln('IB_AFFINITY is freeware and comes AS-IS. Use it on your own risk.');
  writeln('IB_AFFINITY has been tested with Interbase V5.x on Windows NT4.');
  writeln('V1.2, Author: Karsten Strobel');
  writeln;
  writeln('Available switches:');
  writeln('   -Q     Query current affinity mask');
  writeln('   -An    New Affinity mask n (decimal) to set');
  writeln('   -N     Don''t try to enable SeDebugPrivilege');
  writeln('   -Rn,m  Retry up to n times with m millisec. delay to locate IBServer');
  writeln('   -Sprog Start the prog(ram), eg. taskmgr.exe. Don''t mix with -Q|A|R');
  writeln;
  Halt(1);
end;

var
  i, j, k: Integer;
  s: string;
begin
  try
    //eval cmdline switches
    for i := 1 to ParamCount do
    begin
      s := UpperCase(ParamStr(i));
      if s[1] <> '-' then PrintHelp;
      case s[2] of
        'A': begin
          Delete(s, 1, 2);
          MaskToSet := StrToIntDef(s, -1);
          if (MaskToSet <= 0) or SetMask then PrintHelp;
          SetMask := true;
        end;
        'Q': begin
          if (Length(s) > 2) or QueryMask then PrintHelp;
          QueryMask := true;
        end;
        'N': begin
          if (Length(s) > 2) or NoDebugPrivilege then PrintHelp;
          NoDebugPrivilege := true;
        end;
        'R': begin
          Delete(s, 1, 2);
          k := Pos(',', s);
          if k = 0 then PrintHelp;
          j := StrToIntDef(copy(s, 1, k-1), -1);
          k := StrToIntDef(copy(s, k+1, Length(s)), -1);
          if (j <= 0) or (k < 0) or (RetryCountdown > 0) then PrintHelp;
          RetryCountdown := j;
          RetryDelay := k;
        end;
        'S': begin
          Delete(s, 1, 2);
          s := Trim(s);
          if (s = '') or (RunProg <> '') then PrintHelp;
          RunProg := Trim(s);
        end;
      else
        PrintHelp;
      end;
    end;
    if (not ((RunProg <> '') or SetMask or QueryMask)) or
       ((RunProg <> '') and (SetMask or QueryMask or (RetryCountdown > 0))) then PrintHelp;

    //check NT is running
    if Win32Platform <> VER_PLATFORM_WIN32_NT then
      raise Exception.Create('IB_AFFINITY requires Windows NT.');

    if RunProg = '' then
    begin //-Q or -A was specified
      //find running IBServer.exe
      repeat
        ib_hwnd := FindWindow('IB_Server', 'InterBase Server');
        if (ib_hwnd <> 0) or (RetryCountdown <= 0) then system.break;
        Sleep(RetryDelay);
        Dec(RetryCountdown);
      until false;

      if ib_hwnd = 0 then
        raise Exception.Create('Unable to find IBServer process. Not running?');
      if GetWindowThreadProcessId(ib_hwnd, @ib_processid) = 0 then RaiseLastWin32Error;

      EnableSeDebugPrivilege;

      //get handle of IBServer process
      i := PROCESS_QUERY_INFORMATION;
      if SetMask then i := i or PROCESS_SET_INFORMATION;
      ib_processh := OpenProcess(i, false, ib_processid);
      if ib_processh = 0 then RaiseLastWin32Error;
      try
        //query current affinity mask
        Win32Check(GetProcessAffinityMask(ib_processh, process_affmask, sys_affmask));
        if QueryMask then
          writeln(Format('Current affinity mask: System=%d, IBServer=%d', [sys_affmask, process_affmask]));
        //set new affinity mask
        if SetMask then
        begin
          Win32Check(SetProcessAffinityMask(ib_processh, MaskToSet and sys_affmask));
          writeln(Format('Affinity mask set to %d', [MaskToSet and sys_affmask]));
        end;
      finally
        CloseHandle(ib_processh);
      end;
    end
    else
    begin //-Sprog was specified
      EnableSeDebugPrivilege;
      if WinExec(PChar(RunProg), SW_SHOWNORMAL) < 32 then RaiseLastWin32Error;
    end;

  except
    on E:Exception do
    begin
      s := E.Message + #13#10;
      WriteFile(GetStdHandle(STD_ERROR_HANDLE), s[1], Length(s), DWORD(i), nil);
      ExitCode := 1;
    end;
  end;
end.
