unit Test;

interface

uses
  SysUtils, WinTypes, WinProcs, Controls, StdCtrls, Classes, Forms;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;

    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation
uses DesX;
{$R *.DFM}

var
  Flag : Boolean;

function Crypt(Key: string; InStr: string): string;
const
{  Algorithm = 0; { uucp/uupc }
  Algorithm = 1; { Base64 }
var
  pKeyStr: array[0..31] of char;
  pInStr:  array[0..31] of char;
  pOutStr:  array[0..31] of char;

  Len: Byte;
begin
  StrPCopy(pKeyStr, Key);     
  StrPCopy(pInStr, InStr);

  {$Define InterBase}

  {$Ifdef InterBase}
    IBCrypt(pKeyStr, pInStr, pOutStr);
    result := StrPas(pOutStr);
  {$Else}
    { DES encrypt/decrypt }
    {
    if Flag then begin
      Len := Encrypt(@pKeyStr, @pInStr, @pOutStr,
        StrLen(pKeyStr), StrLen(pInStr), SizeOf(pOutStr));
    end
    else begin
      Len := Decrypt(@pKeyStr, @pInStr, @pOutStr,
        StrLen(pKeyStr), StrLen(pInStr), SizeOf(pInStr));
    end;
    pOutStr[Len] := #0;
    result := StrPas(pOutStr);
    {*}

    { Base64/UU encrypt/decrypt }
    {
    if Flag then begin
      Len := Encode3to4(Algorithm, @pInStr, @pOutStr, StrLen(pInStr), SizeOf(pInStr))
    end
    else begin
      Len := Decode4to3(Algorithm, @pInStr, @pOutStr, StrLen(pInStr), SizeOf(pOutStr));
    end;
    pOutStr[Len] := #0;
    result := StrPas(pOutStr);
    {*}

    { DES + Base64/UU encrypt/decrypt }
    if Flag then begin
      Len := Encrypt(@pKeyStr, @pInStr, @pOutStr,
        StrLen(pKeyStr), StrLen(pInStr), SizeOf(pOutStr));
      Len := Encode3to4(Algorithm, @pOutStr, @pInStr, Len, SizeOf(pInStr));
    end
    else begin
      Len := Decode4to3(Algorithm, @pInStr, @pOutStr, StrLen(pInStr), SizeOf(pOutStr));
      Len := Decrypt(@pKeyStr, @pOutStr, @pInStr,
        StrLen(pKeyStr), StrLen(pOutStr), SizeOf(pInStr));
    end;
    pInStr[Len] := #0;
    result := StrPas(pInStr);
    {*}
  {$Endif}
end;



procedure TForm1.Button1Click(Sender: TObject);
begin
  Flag := True;
  Edit2.text := Crypt('9z', Edit1.Text);
  Button2.SetFocus;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Flag := False;
  Edit3.text := Crypt('9z', Edit2.text);
  Button1.SetFocus;
end;

end.


