{ Employee.Gdb array fields used: }
{  PROJ_DEPT_BUDGET->QUART_HEAD_CNT = array[1..4] of Longint }
{  JOB->LANGUAGE_REQ = array[1..5] of array[0..17] of Char }
unit IBArrayTestU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, DBCtrls, DBTables, ExtCtrls, IBArray;

type
  TForm1 = class(TForm)
    DBNavigator1: TDBNavigator;
    IBTbl1: TTable;
    IBDS1: TDataSource;
    IBDB: TDatabase;
    HeadCountArray: TIBArray;
    LanguageReqArray: TIBArray;
    ListBox1: TListBox;
    ListBox2: TListBox;
    DBNavigator2: TDBNavigator;
    IBTbl2: TTable;
    IBDS2: TDataSource;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    Memo1: TMemo;
    IBTbl1QUART_HEAD_CNT: TBytesField;
    IBTbl2LANGUAGE_REQ: TBytesField;
    procedure HeadCountArrayDataChange(Sender: TObject);
    procedure LanguageReqArrayDataChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  BDE, IBProc, DBExcept;

{$R *.DFM}

{ Code to read the 4 head counts in any given array field }
procedure TForm1.HeadCountArrayDataChange(Sender: TObject);
var
  HeadCount: array[0..3] of Longint;
  Loop: Byte;
begin
  with Sender as TIBArray, Listbox1 do
  begin
    Items.BeginUpdate;
    Clear;
    if GetData(@HeadCount) then
      for Loop := 0 to 3 do
        Items.Add(IntToStr(HeadCount[Loop]));
    Items.EndUpdate;
  end;
end;

{ Code to read the 5 required languages in any given array field }
procedure TForm1.LanguageReqArrayDataChange(Sender: TObject);
var
  LangReq: array[0..4] of array[0..16] of Char;
  Loop: Byte;
begin
  with Sender as TIBArray, Listbox2 do
  begin
    Items.BeginUpdate;
    Clear;
    if GetData(@LangReq) then
      for Loop := 0 to 4 do
        Items.Add(SQLVaryingToString(LangReq[Loop]));
    Items.EndUpdate;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  IBTbl1.Open;
  IBTbl2.Open;
  { Position cursor on a non-null language array }
  if IBTbl2.Active then
  begin
    IBTbl2.Last;
    IBTbl2.Prior;
    IBTbl2.Prior;
  end;
end;

{ These two buttons are disabled as read/write operations don't work yet.
  Ignore this code }
procedure TForm1.Button1Click(Sender: TObject);
var
  HeadCount: array[0..3] of Longint;
  Loop: Byte;
begin
{  with HeadCountArray, Listbox1 do
  begin
    for Loop := 0 to Items.Count - 1 do
      HeadCount[Loop] := StrToInt(Items[Loop]);
    SetData(@HeadCount);
  end;}
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  LangReq: array[0..4] of array[0..16] of Char;
  Loop: Byte;
begin
{  IBTbl2.Edit;
  with LanguageReqArray, Listbox2 do
  begin
    for Loop := 0 to Items.Count - 1 do
      StringToSQLVarying(LangReq[Loop], Items[Loop], SizeOf(LangReq[Loop]));
    SetData(@LangReq);
  end;
  try
    IBTbl2.Post;
  except
    on E: EDBEngineError do
      with TDBEngineErrorDlg.Create(Application) do
        try
          ShowException(Application, E);
        finally
          Free;
        end;
  end;}
end;

end.
