unit IbDesign;

interface

uses
  Classes, DsgnIntf;

type
  TIBTableNameProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

implementation

uses
  IBArray, DB;

function TIBTableNameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TIBTableNameProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    with GetComponent(0) as TIBArray do
      if Assigned(DataSource) and Assigned(DataSource.DataSet) then
        with TDBDataSet(DataSource.DataSet) do
          DBSession.GetTableNames(DatabaseName, '', True, False, Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

end.
