unit IBProc;

interface

uses
  Windows;

const
  SqlDaVersion1 = 1;

  { Constants used to set data type in calls to IscArraySetDesc }
  { which populates an array desriptor with parameters as }
  { opposed to IscArrayLookupDesc which looks in the metadata }
  SqlText    = 452; // ftString
  SqlVarying = 448; // ftString
  SqlShort   = 500; // ftSmallint
  SqlLong    = 496; // ftInteger
  SqlFloat   = 482; // ftFloat
  SqlDouble  = 480; // ftFloat
  SqlD_Float = 530; // ftFloat
  SqlDate    = 510; // ftDateTime
  SqlBlob    = 520; // N/A
  SqlArray   = 540; // N/A
  SqlQuad    = 550; // N/A

  { Constants used to manually populate the }
  { data type field in an array descriptor }
  BlrText     = 14;
  BlrText2    = 15;
  BlrShort    = 7;
  BlrLong     = 8;
  BlrQuad     = 9;
  BlrFloat    = 10;
  BlrDouble   = 27;
  BlrD_Float  = 11;
  BlrDate     = 35;
  BlrVarying  = 37;
  BlrVarying2 = 38;
  BlrBlob     = 261;
  BlrCstring  = 40;
  BlrCstring2 = 41;
  BlrBlobId   = 45;

type
  PIscDbHandle = ^IscDbHandle;
  IscDbHandle = Pointer;
  PIscLong = ^IscLong;
  IscLong = Longint;
  PIscStatus = ^IscStatus;
  IscStatus = Longint;
  PIscTrHandle = ^IscTrHandle;
  IscTrHandle = Pointer;
  IscStmtHandle = Pointer;

  { Error structures }
  PStatusVector = ^TStatusVector;
  TStatusVector = array[0..19] of IscStatus;
  PPStatusVector = ^PStatusVector;

  { 64-bit number }
  TIscQuad = packed record
    High,
    Low: IscLong;
  end;

  { An array dimensions element number range }
  TIscArrayBound = packed record
    Lower,
    Upper: Word;
  end;

  { An array descriptor record }
  TIscArrayDesc = packed record
    DType: Byte;
    Scale: Shortint;
    Length: Word;
    FieldName,
    RelationName: array[0..31] of Char;
    Dimensions,
    Flags: Smallint;
    Bounds: array[0..15] of TIscArrayBound;
  end;

  PXSqlVar = ^TXSqlVar;
  TXSqlVar = packed record
    SqlType,                         // datatype of field
    SqlScale,                        // scale factor
    SqlSubType,                      // datatype subtype - BLOBs & Text types only
    SqlLen: Word;                    // length of data area
    SqlData: Pointer;                // address of data
    SqlInd: PWord;                   // address of indicator variable
    SqlNameLength: Word;             // length of sqlname field
    SqlName: array[0..31] of Char;   // name of field, name length + space for NULL
    RelNameLength: Word;             // length of relation name
    RelName: array[0..31] of Char;   // field's relation name + space for NULL
    OwnNameLength: Word;             // length of owner name
    OwnName: array[0..31] of Char;   // relation's owner name + space for NULL
    AliasNameLength: Word;           // length of alias name
    AliasName: array[0..31] of Char; // relation's alias name + space for NULL
  end;

  { Need range checking off for accessing SqlVar }
  { at the end - it's a variable length array }
  PXSqlDa = ^TXSqlDa;
  TXSqlDa = record
    Version: Word;                   // version of this XSQLDA
    SqlDAId: array[0..7] of Char;    // XSQLDA name field
    SqlDaBC: IscLong;                // length in bytes of SQLDA
    SqlN,                            // number of fields allocated
    SqlD: Word;                      // actual number of fields
    SqlVar: array[0..0] of TXSqlVar; // first field address
  end;

  { Transaction Existence Block }
  TIscTeb = record
    DBPtr: PLongint;
    TPBLen: Longint;
    TPBPtr: PChar;
  end;

function XSqlDaLength(N: Word): Word;

{ Read array slice }
function IscArrayGetSlice(
  var StatusVector: TStatusVector;
  var DbHandle: IscDbHandle;
  var TransHandle: IscTrHandle;
  var ArrayId: TIscQuad;
  var Desc: TIscArrayDesc;
  var DestArray;
  var SliceLength: IscLong
  ):IscStatus; stdcall;

{ Get array descriptor details (including dimension bounds) from metadata }
function IscArrayLookupBounds(
  var StatusVector: TStatusVector;
  var DbHandle: IscDbHandle;
  var TransHandle: IscTrHandle;
  TableName,
  ColumnName: PChar;
  var Desc: TIscArrayDesc
  ): IscStatus; stdcall;

{ Get array descriptor details (excluding dimension bounds) from metadata }
function IscArrayLookupDesc(
  var StatusVector: TStatusVector;
  var DbHandle: IscDbHandle;
  var TransHandle: IscTrHandle;
  TableName,
  ColumnName: PChar;
  var Desc: TIscArrayDesc
  ): IscStatus; stdcall;

{ Write array slice }
function IscArrayPutSlice(
  var StatusVector: TStatusVector;
  var DbHandle: IscDbHandle;
  var TransHandle: IscTrHandle;
  var ArrayId: TIscQuad;
  var Desc: TIscArrayDesc;
  var DestArray;
  var SliceLength: IscLong
  ):IscStatus; stdcall;

{ Populate array descriptor }
function IscArraySetDesc(
  var StatusVector: TStatusVector;
  TableName,
  ColumnName: PChar;
  var SqlDType,
      SqlLength,
      Dimensions: Word;
  var Desc: TIscArrayDesc
  ): IscStatus; stdcall;

{ Connect to database }
function IscAttachDatabase(
  var StatusVector: TStatusVector;
  DbNameLength: Word;
  DbName: PChar;
  var DbHandle: IscDbHandle;
  ParmBufferLength: Word;
  ParmBuffer: PChar
  ): IscStatus; stdcall;

{ Terminate transaction happily }
function IscCommitTransaction(
  var StatusVector: TStatusVector;
  var TransHandle: IscTrHandle
  ): IscStatus; stdcall;

{ Disconnect from database }
function IscDetachDatabase(
  var StatusVector: TStatusVector;
  var DbHandle: IscDbHandle
  ): IscStatus; stdcall;

{ Execute parameterised SQL }
function IscDSqlExecute(
  var StatusVector: TStatusVector;
  var TransHandle: IscTrHandle;
  var StmtHandle: IscStmtHandle;
  Dialect: Word;
  var InXSqlDa: TXSqlDa
  ): IscStatus; stdcall;

{ Get result set }
function IscDSqlFetch(
  var StatusVector: TStatusVector;
  var StmtHandle: IscStmtHandle;
  Dialect: Word;
  var OutXSqlDa: TXSqlDa
  ): IscStatus; stdcall;

{ Prepare SQL for execution }
function IscDSqlPrepare(
  var StatusVector: TStatusVector;
  var TransHandle: IscTrHandle;
  var StmtHandle: IscStmtHandle;
  Length: Word;
  Statement: PChar;
  Dialect: Word;
  var OutXSqlDa: TXSqlDa
  ): IscStatus; stdcall;

function IscFree(
  Buffer: PChar
  ): IscStatus; stdcall;

{ Decode error buffer }
function IscInterpretE(
  Buffer: PChar;
  var StatusVector: PStatusVector
  ): IscStatus; stdcall;

{ Terminate transaction unhappily }
function IscRollbackTransaction(
  var StatusVector: TStatusVector;
  var TransHandle: IscTrHandle
  ): IscStatus; stdcall;

{ Start transaction }
function IscStartMultiple(
  var StatusVector: TStatusVector;
  var TransHandle: IscTrHandle;
  DBHdlCount: Word;
  var TEB
  ): IscStatus; stdcall;

const
  Gds32 = 'GDS32.DLL';

implementation

function XSqlDaLength(N: Word): Word;
begin
  Result := SizeOf(TXSqlDa) + (N - 1) * SizeOf(TXSqlVar);
end;

function IscArrayGetSlice; external Gds32 name 'isc_array_get_slice';
function IscArrayLookupBounds; external Gds32 name 'isc_array_lookup_bounds';
function IscArrayLookupDesc; external Gds32 name 'isc_array_lookup_desc';
function IscArrayPutSlice; external Gds32 name 'isc_array_put_slice';
function IscArraySetDesc; external Gds32 name 'isc_array_set_desc';
function IscAttachDatabase; external Gds32 name 'isc_attach_database';
function IscCommitTransaction; external Gds32 name 'isc_commit_transaction';
function IscDetachDatabase; external Gds32 name 'isc_detach_database';
function IscDsqlExecute; external Gds32 name 'isc_dsql_execute';
function IscDSqlFetch; external Gds32 name 'isc_dsql_fetch';
function IscDSqlPrepare; external Gds32 name 'isc_dsql_prepare';
function IscFree; external Gds32 name 'isc_free';
function IscInterpretE; external Gds32 name 'isc_interprete';
function IscRollbackTransaction; external Gds32 name 'isc_rollback_transaction';
function IscStartMultiple; external Gds32 name 'isc_start_multiple';

end.

