unit CSConst;

interface

{ Client/Service constants }

const
  //Do not localize
  KEY_IBCONNSVC  = '\SOFTWARE\NetUtils\IBConnSvc';
  KEY_IBCONNCLT  = '\SOFTWARE\NetUtils\IBConnClt';
  SServiceName   = 'InterBaseConnections';
  SCfgFile       = 'IBConnections.cfg';
  SPort          = 'Port';
  SLogFile       = 'LogFile';
  STimeOut       = 'TimeOut';
  SSingleLine    = 'SingleLine';
  SPosition      = 'Position';
  SWindowState   = 'WindowState';
  SShowStatusBar = 'ShowStatusBar';
  SInterval      = 'Interval';
  SAutoRefresh   = 'AutoRefresh';
  cFldSep        = #132;

{ Default UDP port }

  UDP_PORT = $159F;

{ Action command }

  acBroadcast    = $C0000001;
  acConfirm      = $C0000002;
  acGetConInfo   = $C0000003;
  acConfirmSize  = $C0000004;
  acCloseConnect = $C0000005;

{ Action command size }

  AC_SIZE = SizeOf(acBroadcast);

resourcestring
  SIBConnSvcTitle = 'InterBase Connections';
  SIBConnSvcTip = 'InterBase Connections (%d)';
  SAlreadyRunning = 'The %s is already running.';
  SFmtStr = '%s (%s)'#9'%s'#13#10#9'%s: IP Address - %s, Host Name - %s'#13#10#13#10#13#10;
  SDTFmtStr = 'ddd mmm dd hh:nn:ss yyyy';
  SSingleFmtStr = '%-15s%-255s%-19s%-19s'#13#10;
  SDTSingleFmtStr = 'mm/dd/yyyy hh:nn:ss';
  SCurrentConnections = '%d current connections';
  SHostUnknown = '(Unknown)';
  SConnect = 'Connect';
  SDisconnect = 'Disconnect';
  SIBConnCltTitle = 'InterBase Connections Client';
  SAvailableServers = '%d available servers';

implementation

end.
