unit CltConn;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ToolWin, ImgList, ActnList, Menus, ExtCtrls, StdCtrls,
  UdpBase;

type
  TConnForm = class(TForm)
    ToolBar: TToolBar;
    StatusBar: TStatusBar;
    btnRefresh: TToolButton;
    btnactCloseConnect: TToolButton;
    ImageList: TImageList;
    ActionList: TActionList;
    actRefresh: TAction;
    actCloseConnection: TAction;
    lvConnections: TListView;
    Timer: TTimer;
    PopupMenu: TPopupMenu;
    piCloseConnection: TMenuItem;
    ToolButton1: TToolButton;
    lblInterval: TLabel;
    edtInterval: TEdit;
    udInterval: TUpDown;
    chkAutoRefresh: TCheckBox;
    actAutoRefresh: TAction;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure lvConnectionsColumnClick(Sender: TObject;
      Column: TListColumn);
    procedure lvConnectionsCompare(Sender: TObject; Item1,
      Item2: TListItem; Data: Integer; var Compare: Integer);
    procedure lvConnectionsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure udIntervalChangingEx(Sender: TObject;
      var AllowChange: Boolean; NewValue: Smallint;
      Direction: TUpDownDirection);
    procedure TimerTimer(Sender: TObject);
    procedure actRefreshExecute(Sender: TObject);
    procedure actCloseConnectionExecute(Sender: TObject);
    procedure actCloseConnectionUpdate(Sender: TObject);
    procedure actAutoRefreshExecute(Sender: TObject);
    procedure actAutoRefreshUpdate(Sender: TObject);
  private
    { Private declarations }
    FServer: string;
    FAscending: Boolean;
    FSortCol: Integer;
    procedure GetCurrentConnections;
    procedure UpdateStatus;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent; const AServer: string); reintroduce;
  end;

  TCltUdpThread = class(TCustomUdpThread)
  private
    FData: string;
  protected
    procedure Read; override;
  end;

var
  ConnForm: TConnForm;
  CltUdpThread: TCltUdpThread;

implementation

uses CSConst, Registry;

{$R *.dfm}

constructor TConnForm.Create(AOwner: TComponent; const AServer: string);
begin
  inherited Create(AOwner);
  ConnForm := Self;
  FServer := AServer;
end;

procedure TConnForm.GetCurrentConnections;
var
  Buffer: DWORD;
begin
  UpdateStatus;
  Buffer := acGetConInfo;
  CltUdpThread.SendBuf(Buffer, SizeOf(Buffer));
end;

procedure TConnForm.UpdateStatus;
begin
  StatusBar.SimpleText := Format(SCurrentConnections, [lvConnections.Items.Count]);
end;

procedure TConnForm.FormCreate(Sender: TObject);
var
  Position: TRect;
begin
  Caption := FServer;
  with TRegistry.Create do
  try
    if OpenKey(KEY_IBCONNCLT + PathDelim + Caption, False) then
    try
      if ValueExists(SPosition) then
      begin
        ReadBinaryData(SPosition, Position, SizeOf(Position));
        BoundsRect := Position;
      end;
      if ValueExists(SWindowState) then
        if ReadInteger(SWindowState) = Ord(wsMaximized) then
          WindowState := wsMaximized;
      if ValueExists(SInterval) then
      begin
        Timer.Interval := ReadInteger(SInterval);
        udInterval.Position := Timer.Interval div MSecsPerSec;
      end;
      if ValueExists(SAutoRefresh) then
        chkAutoRefresh.Checked := ReadBool(SAutoRefresh);
    finally
      CloseKey;
    end;
  finally
    Free;
  end;
  FAscending := False;
  FSortCol := -1;
  CltUdpThread := TCltUdpThread.Create(False, UDP_PORT, FServer);
end;

procedure TConnForm.FormShow(Sender: TObject);
begin
  GetCurrentConnections;
end;

procedure TConnForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TConnForm.FormDestroy(Sender: TObject);
var
  Position: TRect;
begin
  with TRegistry.Create do
  try
    if OpenKey(KEY_IBCONNCLT + PathDelim + Caption, True) then
    try
     if WindowState = wsNormal then
      begin
        Position := BoundsRect;
        WriteBinaryData(SPosition, Position, SizeOf(Position));
      end;
      WriteInteger(SWindowState, Ord(WindowState));
      WriteInteger(SInterval, Timer.Interval);
      WriteBool(SAutoRefresh, chkAutoRefresh.Checked);
    finally
      CloseKey;
    end;
  finally
    Free;
  end;
  with CltUdpThread do
  begin
    FreeOnTerminate := True;
    Terminate;
  end;
end;

procedure TConnForm.lvConnectionsColumnClick(Sender: TObject;
  Column: TListColumn);
begin
  FAscending := not FAscending;
  if (FSortCol <> -1) and (FSortCol <> Column.Index) then
  begin
    FAscending := True;
    lvConnections.Columns[FSortCol].ImageIndex := -1;
  end;
  if FAscending then
    Column.ImageIndex := 3
  else
    Column.ImageIndex := 4;
  FSortCol := Column.Index;
  lvConnections.CustomSort(nil, FSortCol - 1);
end;

procedure TConnForm.lvConnectionsCompare(Sender: TObject; Item1,
  Item2: TListItem; Data: Integer; var Compare: Integer);
var
  SortFlag: Integer;
begin
  if FAscending then SortFlag := 1 else SortFlag := -1;
  if Data = -1 then
    Compare := SortFlag * AnsiCompareText(AlignIpAddress(Item1.Caption),
                                          AlignIpAddress(Item2.Caption))
  else
    Compare := SortFlag * AnsiCompareText(Item1.SubItems[Data],
                                          Item2.SubItems[Data]);
end;

procedure TConnForm.lvConnectionsKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = 65) and (Shift = [ssCtrl]) then
    lvConnections.SelectAll;
end;

procedure TConnForm.udIntervalChangingEx(Sender: TObject;
  var AllowChange: Boolean; NewValue: Smallint;
  Direction: TUpDownDirection);
begin
  with Sender as TUpDown do
    if (NewValue >= Min) and (NewValue <= Max) then
      Timer.Interval := NewValue * MSecsPerSec;
end;

procedure TConnForm.TimerTimer(Sender: TObject);
begin
  actRefresh.Execute;
end;

procedure TConnForm.actRefreshExecute(Sender: TObject);
begin
  with lvConnections.Items do
  begin
    BeginUpdate;
    Clear;
    EndUpdate;
  end;
  GetCurrentConnections;
end;

procedure TConnForm.actCloseConnectionExecute(Sender: TObject);
var
  Buffer: Pointer;
  BufLen, i: Integer;
begin
  BufLen := AC_SIZE * 2;
  GetMem(Buffer, BufLen);
  try
    for i := lvConnections.Items.Count - 1 downto 0 do
      with lvConnections.Items[i] do
        if Selected then
        begin
          PDWORD(Buffer)^ := acCloseConnect;
          PDWORD(DWORD(Buffer) + AC_SIZE)^ := DWORD(Data);
          CltUdpThread.SendBuf(Buffer^, BufLen);
          Delete;
        end;
  finally
    FreeMem(Buffer);
  end;
end;

procedure TConnForm.actCloseConnectionUpdate(Sender: TObject);
begin
  (Sender as TAction).Enabled := Assigned(lvConnections.Selected);
end;

procedure TConnForm.actAutoRefreshExecute(Sender: TObject);
begin
  actAutoRefresh.Checked := not actAutoRefresh.Checked;
end;

procedure TConnForm.actAutoRefreshUpdate(Sender: TObject);
begin
  Timer.Enabled := actAutoRefresh.Checked;
end;

procedure TCltUdpThread.Read;

  procedure FillItemInfo(const S: string; var A: array of string);
  var
    i: Integer;
    P, Start: PChar;
  begin
    i := 0;
    P := PChar(S);
    while P^ <> #0 do
    begin
      Start := P;
      while not (P^ in [#0, cFldSep]) do Inc(P);
      SetString(A[i], Start, P - Start);
      Inc(i);
      if P^ <> #0 then Inc(P);
    end;
  end;

var
  RecvLen, i: Integer;
  Buffer: Pointer;
  ItemInfo: array[0..3] of string;
  Str: string;
begin
  RecvLen := GetRecvLength;
  GetMem(Buffer, RecvLen);
  try
    RecvLen := RecvBuf(Buffer^, RecvLen);
    if RecvLen > 0 then
      if PDWORD(Buffer)^ = acConfirmSize then
      begin
        if PDWORD(DWORD(Buffer) + AC_SIZE)^ = DWORD(Length(FData)) then
          with ConnForm, lvConnections do
          begin
            with TStringList.Create do
            try
              Text := FData;
              AllocBy := Count;
              Items.BeginUpdate;
              try
                for i := 0 to Count - 1 do
                begin
                  FillItemInfo(Strings[i], ItemInfo);
                  with Items.Add do
                  begin
                    ImageIndex := 2;
                    Caption := ItemInfo[0];
                    SubItems.Add(ItemInfo[1]);
                    SubItems.Add(ItemInfo[2]);
                    Data := Pointer(StrToInt(ItemInfo[3]));
                  end;
                end;
              finally
                Items.EndUpdate;
              end;
            finally
              Free;
            end;
            if FSortCol <> -1 then
              lvConnections.CustomSort(nil, FSortCol - 1);
            if not Assigned(ItemFocused) then
              Items[0].Focused := True;
            UpdateStatus;
          end;
        FData := '';
      end
      else
      begin
        SetString(Str, PChar(Buffer), RecvLen);
        FData := FData + Str;
      end;
  finally
    FreeMem(Buffer);
  end;
end;

end.
