
{*******************************************************}
{                                                       }
{       InterBase Connections Client Version 1.0        }
{                                                       }
{                                                       }
{          Copyright (c) 1999-2004 Vadim Crits          }
{                                                       }
{*******************************************************}

unit CltMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ActnList, ComCtrls, ImgList, Menus, UdpBase;

type
  TMainForm = class(TForm)
    ActionList: TActionList;
    actRefresh: TAction;
    lvServers: TListView;
    StatusBar: TStatusBar;
    ImageList: TImageList;
    MainMenu: TMainMenu;
    miFile: TMenuItem;
    miView: TMenuItem;
    miHelp: TMenuItem;
    actExit: TAction;
    miExit: TMenuItem;
    miWindow: TMenuItem;
    miNoWindows: TMenuItem;
    actAbout: TAction;
    miAbout: TMenuItem;
    actStatusBar: TAction;
    miStatusBar: TMenuItem;
    N1: TMenuItem;
    miRefresh: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lvServersDblClick(Sender: TObject);
    procedure lvServersKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure miWindowClick(Sender: TObject);
    procedure actExitExecute(Sender: TObject);
    procedure actRefreshExecute(Sender: TObject);
    procedure actStatusBarExecute(Sender: TObject);
    procedure actStatusBarUpdate(Sender: TObject);
    procedure actAboutExecute(Sender: TObject);
  private
    { Private declarations }
    procedure GetAvailableServers;
    procedure UpdateStatus;
    procedure WindowClick(Sender: TObject);
  public
    { Public declarations }
  end;

{ TBctUdpThread class }

  TBctUdpThread = class(TCustomUdpThread)
  protected
    procedure Read; override;
  end;

var
  MainForm: TMainForm;
  BctUdpThread: TBctUdpThread;

implementation

uses CltConn, CltAbout, CSConst, Registry, WinSock;

{$R *.dfm}

{ TMainForm }

procedure TMainForm.GetAvailableServers;
var
  Buffer: DWORD;
begin
  UpdateStatus;
  Buffer := acBroadcast;
  BctUdpThread.SendBuf(Buffer, SizeOf(Buffer));
end;

procedure TMainForm.UpdateStatus;
begin
  StatusBar.SimpleText := Format(SAvailableServers, [lvServers.Items.Count]);
end;

procedure TMainForm.WindowClick(Sender: TObject);
var
  hWindow: HWND;
begin
  hWindow := (Sender as TComponent).Tag;
  if IsIconic(hWindow) then
    ShowWindow(hWindow, SW_RESTORE)
  else
    Windows.SetFocus(hWindow);
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  Position: TRect;
begin
  Caption := SIBConnCltTitle;
  with TRegistry.Create do
  try
    if OpenKey(KEY_IBCONNCLT, False) then
    try
      if ValueExists(SPosition) then
      begin
        ReadBinaryData(SPosition, Position, SizeOf(Position));
        BoundsRect := Position;
      end;
      if ValueExists(SWindowState) then
        if ReadInteger(SWindowState) = Ord(wsMaximized) then
          WindowState := wsMaximized;
      if ValueExists(SShowStatusBar) then
        StatusBar.Visible := ReadBool(SShowStatusBar);
    finally
      CloseKey;
    end;
  finally
    Free;
  end;
  BctUdpThread := TBctUdpThread.Create(False, UDP_PORT, '255.255.255.255');
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  GetAvailableServers;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
var
  Position: TRect;
begin
  with TRegistry.Create do
  try
    if OpenKey(KEY_IBCONNCLT, True) then
    try
     if WindowState = wsNormal then
      begin
        Position := BoundsRect;
        WriteBinaryData(SPosition, Position, SizeOf(Position));
      end;
      WriteInteger(SWindowState, Ord(WindowState));
      WriteBool(SShowStatusBar, StatusBar.Visible);
    finally
      CloseKey;
    end;
  finally
    Free;
  end;
  with BctUdpThread do
  begin
    FreeOnTerminate := True;
    Terminate;
  end;
end;

procedure TMainForm.lvServersDblClick(Sender: TObject);
var
  i: Integer;
begin
  with lvServers do
  begin
    if not Assigned(Selected) then
      Exit;
    with Screen do
      for i := 0 to FormCount - 1 do
        if AnsiSameText(Forms[i].Caption, Selected.Caption) then
        begin
          if Forms[i].WindowState = wsMinimized then
            ShowWindow(Forms[i].Handle, SW_RESTORE)
          else
            Forms[i].SetFocus;
          Exit;
        end;
    with TConnForm.Create(Self, Selected.Caption) do Show;
  end;
end;

procedure TMainForm.lvServersKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RETURN then
    lvServersDblClick(Sender);
end;

procedure TMainForm.miWindowClick(Sender: TObject);
var
  i: Integer;
  MenuItem: TMenuItem;
begin
  with miWindow do
    for i := Count - 1 downto 0  do
      if Items[i] <> miNoWindows then
        Items[i].Free;
  with Screen do
    for i := 0 to FormCount - 1 do
      if Forms[i] <> Self then
      begin
        MenuItem := TMenuItem.Create(Self);
        MenuItem.Caption := Forms[i].Caption;
        MenuItem.Tag := Forms[i].Handle;
        MenuItem.OnClick := WindowClick;
        miWindow.Add(MenuItem);
      end;
  miNoWindows.Visible := miWindow.Count = 1;
end;

procedure TMainForm.actExitExecute(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.actRefreshExecute(Sender: TObject);
begin
  with lvServers.Items do
  begin
    BeginUpdate;
    Clear;
    EndUpdate;
  end;
  GetAvailableServers;
end;

procedure TMainForm.actStatusBarExecute(Sender: TObject);
begin
  StatusBar.Visible := not StatusBar.Visible;
end;

procedure TMainForm.actStatusBarUpdate(Sender: TObject);
begin
  actStatusBar.Checked := StatusBar.Visible;
end;

procedure TMainForm.actAboutExecute(Sender: TObject);
begin
  ShowAboutBox(Self);
end;

{ TBctUdpThread }

procedure TBctUdpThread.Read;
var
  RecvLen: Integer;
  Buffer: Pointer;
begin
  RecvLen := GetRecvLength;
  GetMem(Buffer, RecvLen);
  try
    if RecvBuf(Buffer^, RecvLen) > 0 then
      if PDWORD(Buffer)^ = acConfirm then
        with MainForm, lvServers do
        begin
          with Items.Add do
          begin
            ImageIndex := 0;
            Caption := inet_ntoa(AddrFrom.sin_addr);
          end;
          if not Assigned(ItemFocused) then
            Items[0].Focused := True;
          UpdateStatus;
        end;
  finally
    FreeMem(Buffer);
  end;
end;

var
  hApp: HWND;

initialization
  hApp := FindWindow('TApplication', PChar(SIBConnCltTitle));
  if hApp <> 0 then
  begin
    if IsIconic(hApp) then
      ShowWindow(hApp, SW_RESTORE)
    else
      SetForegroundWindow(hApp);
    Halt;
  end;
  Application.Title := SIBConnCltTitle;
end.
