
{*******************************************************}
{                                                       }
{       Borland Delphi Runtime Library                  }
{       IP Helper API Interface Unit                    }
{                                                       }
{       Copyright (c) 1997-1999 Microsoft Corporation   }
{                                                       }
{       Translator: Vadim Crits                         }
{                                                       }
{*******************************************************}

unit IpHlpApi;

{$ALIGN ON}
{$MINENUMSIZE 4}
{$WEAKPACKAGEUNIT}

interface

uses
  Windows;

const
  ANI_SIZE               = 1;

  MAX_ADAPTER_NAME       = 128;
  MAX_INTERFACE_NAME_LEN = 256;
  MAXLEN_IFDESCR         = 256;
  MAXLEN_PHYSADDR        = 8;

{ Definitions used by getnetworkparams and getadaptersinfo apis }

  MAX_ADAPTER_DESCRIPTION_LENGTH = 128;
  MAX_ADAPTER_NAME_LENGTH        = 256;
  MAX_ADAPTER_ADDRESS_LENGTH     = 8;
  DEFAULT_MINIMUM_ENTITIES       = 32;
  MAX_HOSTNAME_LEN               = 128;
  MAX_DOMAIN_NAME_LEN            = 128;
  MAX_SCOPE_ID_LEN               = 256;

{ Node Type }

  BROADCAST_NODETYPE    = 1;
  PEER_TO_PEER_NODETYPE = 2;
  MIXED_NODETYPE        = 4;
  HYBRID_NODETYPE       = 8;

{ Adapter Type }

  IF_OTHER_ADAPTERTYPE      = 0;
  IF_ETHERNET_ADAPTERTYPE   = 1;
  IF_TOKEN_RING_ADAPTERTYPE = 2;
  IF_FDDI_ADAPTERTYPE       = 3;
  IF_PPP_ADAPTERTYPE        = 4;
  IF_LOOPBACK_ADAPTERTYPE   = 5;
  IF_SLIP_ADAPTERTYPE       = 6;

{ Specifies the state of the TCP connection }

  MIB_TCP_STATE_CLOSED     = 1;
  MIB_TCP_STATE_LISTEN     = 2;
  MIB_TCP_STATE_SYN_SENT   = 3;
  MIB_TCP_STATE_SYN_RCVD   = 4;
  MIB_TCP_STATE_ESTAB      = 5;
  MIB_TCP_STATE_FIN_WAIT1  = 6;
  MIB_TCP_STATE_FIN_WAIT2  = 7;
  MIB_TCP_STATE_CLOSE_WAIT = 8;
  MIB_TCP_STATE_CLOSING    = 9;
  MIB_TCP_STATE_LAST_ACK   = 10;
  MIB_TCP_STATE_TIME_WAIT  = 11;
  MIB_TCP_STATE_DELETE_TCB = 12;

{ Specifies the type of ARP entry }

  MIB_IPNET_TYPE_OTHER	 = 1;
  MIB_IPNET_TYPE_INVALID = 2;
  MIB_IPNET_TYPE_DYNAMIC = 3;
  MIB_IPNET_TYPE_STATIC	 = 4;

{ Specifies the route type }

  MIB_IPROUTE_TYPE_OTHER    = 1;
  MIB_IPROUTE_TYPE_INVALID  = 2;
  MIB_IPROUTE_TYPE_DIRECT   = 3;
  MIB_IPROUTE_TYPE_INDIRECT = 4;

{ Specifies the retransmission timeout algorithm }

  MIB_TCP_RTO_OTHER    = 1;
  MIB_TCP_RTO_CONSTANT = 2;
  MIB_TCP_RTO_RSRE     = 3;
  MIB_TCP_RTO_VANJ     = 4;

{ Specifies whether IP forwarding is enabled or disabled }

  MIB_IP_FORWARDING     = 1;
  MIB_IP_NOT_FORWARDING = 2;

{ The interface is administratively enabled or disabled }

  MIB_IF_ADMIN_STATUS_UP   = 1;
  MIB_IF_ADMIN_STATUS_DOWN = 2;

{ The operational status of the interface }

  MIB_IF_OPER_STATUS_NON_OPERATIONAL = 0;
  MIB_IF_OPER_STATUS_UNREACHABLE     = 1;
  MIB_IF_OPER_STATUS_DISCONNECTED    = 2;
  MIB_IF_OPER_STATUS_CONNECTING      = 3;
  MIB_IF_OPER_STATUS_CONNECTED       = 4;
  MIB_IF_OPER_STATUS_OPERATIONAL     = 5;

{ IP Protocol Identifiers }

  IPRTRMGR_PID        = 10000;

  MIB_IPPROTO_OTHER   =	1;
  MIB_IPPROTO_LOCAL   =	2;
  MIB_IPPROTO_NETMGMT =	3;
  MIB_IPPROTO_ICMP    =	4;
  MIB_IPPROTO_EGP     =	5;
  MIB_IPPROTO_GGP     =	6;
  MIB_IPPROTO_HELLO   =	7;
  MIB_IPPROTO_RIP     =	8;
  MIB_IPPROTO_IS_IS   =	9;
  MIB_IPPROTO_ES_IS   =	10;
  MIB_IPPROTO_CISCO   =	11;
  MIB_IPPROTO_BBN     =	12;
  MIB_IPPROTO_OSPF    =	13;
  MIB_IPPROTO_BGP     =	14;

  MIB_IPPROTO_BOOTP             = 9999;
  MIB_IPPROTO_NT_AUTOSTATIC     = 10002;
  MIB_IPPROTO_NT_STATIC         = 10006;
  MIB_IPPROTO_NT_STATIC_NON_DOD = 10007;

{ IPX Protocol Identifiers }

  IPX_PROTOCOL_BASE = $0001FFFF;

  IPX_PROTOCOL_RIP  = IPX_PROTOCOL_BASE + 1;
  IPX_PROTOCOL_SAP  = IPX_PROTOCOL_BASE + 2;
  IPX_PROTOCOL_NLSP = IPX_PROTOCOL_BASE + 3;

{ IP Helper Type Definitions }

type
  TIPAddr = DWORD;
  TIPMask = DWORD;

  PIpAddressString = ^TIpAddressString;
  TIpAddressString = packed record
    str: array[0..15] of Char;
  end;

  PIpMaskString = ^TIpMaskString;
  TIpMaskString = TIpAddressString;

  PIpAddrString = ^TIpAddrString;
  TIpAddrString = packed record
    Next: PIpAddrString;
    IpAddress: TIpAddressString;
    IpMask: TIpMaskString;
    Context: DWORD;
  end;

  PIpAdapterInfo = ^TIpAdapterInfo;
  TIpAdapterInfo = packed record
    Next: PIpAdapterInfo;
    ComboIndex: DWORD;
    AdapterName: array[0..MAX_ADAPTER_NAME_LENGTH + 3] of Char;
    Description: array[0..MAX_ADAPTER_DESCRIPTION_LENGTH + 3] of Char;
    AddressLength: UINT;
    Address: array[0..MAX_ADAPTER_ADDRESS_LENGTH - 1] of BYTE;
    Index: DWORD;
    uType: UINT;
    DhcpEnabled: UINT;
    CurrentIpAddress: PIpAddrString;
    IpAddressList: TIpAddrString;
    GatewayList: TIpAddrString;
    DhcpServer: TIpAddrString;
    HaveWins: BOOL;
    PrimaryWinsServer: TIpAddrString;
    SecondaryWinsServer: TIpAddrString;
    LeaseObtained: Longint;
    LeaseExpires: Longint;
  end;

  PIpPerAdapterInfo = ^TIpPerAdapterInfo;
  TIpPerAdapterInfo = packed record
    AutoconfigEnabled: UINT;
    AutoconfigActive: UINT;
    CurrentDnsServer: PIpAddrString;
    DnsServerList: TIpAddrString;
  end;

  PIpUnidirectionalAdapterAddress = ^TIpUnidirectionalAdapterAddress;
  TIpUnidirectionalAdapterAddress = packed record
    NumAdapters: ULONG;
    Address: array[0..ANI_SIZE - 1] of TIPAddr;
  end;

  PIpAdapterIndexMap = ^TIpAdapterIndexMap;
  TIpAdapterIndexMap = packed record
    Index: ULONG;                                  { adapter index }
    Name: array[0..MAX_ADAPTER_NAME - 1] of WCHAR; { name of the adapter }
  end;

  PIpInterfaceInfo = ^TIpInterfaceInfo;
  TIpInterfaceInfo = packed record
    NumAdapters: Longint;                                  { number of adapters in array }
    Adapter: array[0..ANI_SIZE - 1] of TIpAdapterIndexMap; { adapter indices and names }
  end;

  PFixedInfo = ^TFixedInfo;
  TFixedInfo = packed record
    HostName: array[0..MAX_HOSTNAME_LEN + 3] of Char;
    DomainName: array[0..MAX_DOMAIN_NAME_LEN + 3] of Char;
    CurrentDnsServer: PIpAddrString;
    DnsServerList: TIpAddrString;
    NodeType: UINT;
    ScopeId: array[0..MAX_SCOPE_ID_LEN + 3] of Char;
    EnableRouting: UINT;
    EnableProxy: UINT;
    EnableDns: UINT;
  end;

  PMibIpForwardRow = ^TMibIpForwardRow;
  TMibIpForwardRow = packed record
    dwForwardDest: DWORD;      { IP addr of destination }
    dwForwardMask: DWORD;      { subnetwork mask of destination }
    dwForwardPolicy: DWORD;    { conditions for multi-path route }
    dwForwardNextHop: DWORD;   { IP address of next hop }
    dwForwardIfIndex: DWORD;   { index of interface }
    dwForwardType: DWORD;      { route type }
    dwForwardProto: DWORD;     { protocol that generated route }
    dwForwardAge: DWORD;       { age of route }
    dwForwardNextHopAS: DWORD; { autonomous system number of next hop }
    dwForwardMetric1: DWORD;   { protocol-specific metric }
    dwForwardMetric2: DWORD;   { protocol-specific metric }
    dwForwardMetric3: DWORD;   { protocol-specific metric }
    dwForwardMetric4: DWORD;   { protocol-specific metric }
    dwForwardMetric5: DWORD;   { protocol-specific metric }
  end;

  PMibIpNetRow = ^TMibIpNetRow;
  TMibIpNetRow = packed record
    dwIndex: DWORD;       { adapeter index }
    dwPhysAddrLen: DWORD; { physical address length }
    bPhysAddr: array[0..MAXLEN_PHYSADDR - 1] of BYTE; { physical address }
    dwAddr: DWORD;        { IP address }
    dwType: DWORD;        { ARP entry type }
  end;

  PMibIcmpStats = ^TMibIcmpStats;
  TMibIcmpStats = packed record
    dwMsgs: DWORD;          { number of messages }
    dwErrors: DWORD;        { number of errors }
    dwDestUnreachs: DWORD;  { destination unreachable messages }
    dwTimeExcds: DWORD;     { time-to-live exceeded messages }
    dwParmProbs: DWORD;     { parameter problem messages }
    dwSrcQuenchs: DWORD;    { source quench messages }
    dwRedirects: DWORD;     { redirection messages }
    dwEchos: DWORD;         { echo requests }
    dwEchoReps: DWORD;      { echo replies }
    dwTimestamps: DWORD;    { timestamp requests }
    dwTimestampReps: DWORD; { timestamp replies }
    dwAddrMasks: DWORD;     { address mask requests }
    dwAddrMaskReps: DWORD;  { address mask replies }
  end;

  PMibIcmpInfo = ^TMibIcmpInfo;
  TMibIcmpInfo = packed record
    icmpInStats: TMibIcmpStats;  { stats for incoming messages }
    icmpOutStats: TMibIcmpStats; { stats for outgoing messages }
  end;

  PMibIcmp = ^TMibIcmp;
  TMibIcmp = packed record
    stats: TMibIcmpInfo; { contains ICMP stats }
  end;

  PMibIfRow = ^TMibIfRow;
  TMibIfRow = packed record
    wszName: array[0..MAX_INTERFACE_NAME_LEN - 1] of WCHAR;
    dwIndex: DWORD;           { index of the interface }
    dwType: DWORD;            { type of interface }
    dwMtu: DWORD;             { max transmission unit }
    dwSpeed: DWORD;           { speed of the interface }
    dwPhysAddrLen: DWORD;     { length of physical address }
    bPhysAddr: array[0..MAXLEN_PHYSADDR - 1] of BYTE; { physical addr of adapter }
    dwAdminStatus: DWORD;     { administrative status }
    dwOperStatus: DWORD;      { operational status }
    dwLastChange: DWORD;      { last time oper status changed }
    dwInOctets: DWORD;        { octets received }
    dwInUcastPkts: DWORD;     { unicast packets received }
    dwInNUcastPkts: DWORD;    { non-unicast packets received }
    dwInDiscards: DWORD;      { received packets discarded }
    dwInErrors: DWORD;        { erroneous packets received }
    dwInUnknownProtos: DWORD; { unknow protocol packets received }
    dwOutOctets: DWORD;       { octets sent }
    dwOutUcastPkts: DWORD;    { unicast packets sent }
    dwOutNUcastPkts: DWORD;   { non-unicast packets sent }
    dwOutDiscards: DWORD;     { outgoing packets discarded }
    dwOutErrors: DWORD;       { erroneous packets sent }
    dwOutQLen: DWORD;         { output queue length }
    dwDescrLen: DWORD;        { length of bDescr member }
    bDescr: array[0..MAXLEN_IFDESCR - 1] of BYTE; { interface description }
  end;

  PMibIfTable = ^TMibIfTable;
  TMibIfTable = packed record
    dwNumEntries: DWORD;                        { number of entries in table }
    table: array[0..ANI_SIZE - 1] of TMibIfRow; { array of interface entries }
  end;

  PMibIpAddrRow = ^TMibIpAddrRow;
  TMibIpAddrRow = packed record
    dwAddr: DWORD;      { IP address }
    dwIndex: DWORD;     { interface index }
    dwMask: DWORD;      { subnet mask }
    dwBCastAddr: DWORD; { broadcast address }
    dwReasmSize: DWORD; { rassembly size }
    unused1: WORD;      { not currently used }
    unused2: WORD;      { not currently used }
  end;

  PMibIpAddrTable = ^TMibIpAddrTable;
  TMibIpAddrTable = packed record
    dwNumEntries: DWORD;                            { number of entries in the table }
    table: array[0..ANI_SIZE - 1] of TMibIpAddrRow; { array of IP address entries }
  end;

  PMibIpForwardTable = ^TMibIpForwardTable;
  TMibIpForwardTable = packed record
    dwNumEntries: DWORD;                               { number of entries in the table }
    table: array[0..ANI_SIZE - 1] of TMibIpForwardRow; { array of route entries }
  end;

  PMibIpNetTable = ^TMibIpNetTable;
  TMibIpNetTable = packed record
    dwNumEntries: DWORD;                           { number of entries in table }
    table: array[0..ANI_SIZE - 1] of TMibIpNetRow; { array of ARP entries }
  end;

  PMibIpStats = ^TMibIpStats;
  TMibIpStats = packed record
    dwForwarding: DWORD;      { IP forwarding enabled or disabled }
    dwDefaultTTL: DWORD;      { default time-to-live }
    dwInReceives: DWORD;      { datagrams received }
    dwInHdrErrors: DWORD;     { received header errors }
    dwInAddrErrors: DWORD;    { received address errors }
    dwForwDatagrams: DWORD;   { datagrams forwarded }
    dwInUnknownProtos: DWORD; { datagrams with unknown protocol }
    dwInDiscards: DWORD;      { received datagrams discarded }
    dwInDelivers: DWORD;      { received datagrams delivered }
    dwOutRequests: DWORD;
    dwRoutingDiscards: DWORD;
    dwOutDiscards: DWORD;     { sent datagrams discarded }
    dwOutNoRoutes: DWORD;     { datagrams for which no route }
    dwReasmTimeout: DWORD;    { datagrams for which all frags didn't arrive }
    dwReasmReqds: DWORD;      { datagrams requiring reassembly }
    dwReasmOks: DWORD;        { successful reassemblies }
    dwReasmFails: DWORD;      { failed reassemblies }
    dwFragOks: DWORD;         { successful fragmentations }
    dwFragFails: DWORD;       { failed fragmentations }
    dwFragCreates: DWORD;     { datagrams fragmented }
    dwNumIf: DWORD;           { number of interfaces on computer }
    dwNumAddr: DWORD;         { number of IP address on computer }
    dwNumRoutes: DWORD;       { number of routes in routing table }
  end;

  PMibTcpStats = ^TMibTcpStats;
  TMibTcpStats = packed record
    dwRtoAlgorithm: DWORD; { timeout algorithm }
    dwRtoMin: DWORD;       { minimum timeout }
    dwRtoMax: DWORD;       { maximum timeout }
    dwMaxConn: DWORD;      { maximum connections }
    dwActiveOpens: DWORD;  { active opens }
    dwPassiveOpens: DWORD; { passive opens }
    dwAttemptFails: DWORD; { failed attempts }
    dwEstabResets: DWORD;  { establised connections reset }
    dwCurrEstab: DWORD;    { established connections }
    dwInSegs: DWORD;       { segments received }
    dwOutSegs: DWORD;      { segment sent }
    dwRetransSegs: DWORD;  { segments retransmitted }
    dwInErrs: DWORD;       { incoming errors }
    dwOutRsts: DWORD;      { outgoing resets }
    dwNumConns: DWORD;     { cumulative connections }
  end;

  PMibTcpRow = ^TMibTcpRow;
  TMibTcpRow = packed record
    dwState: DWORD;      { state of the connection }
    dwLocalAddr: DWORD;  { address on local computer }
    dwLocalPort: DWORD;  { port number on local computer }
    dwRemoteAddr: DWORD; { address on remote computer }
    dwRemotePort: DWORD; { port number on remote computer }
  end;

  PMibTcpTable = ^TMibTcpTable;
  TMibTcpTable = packed record
    dwNumEntries: DWORD;                         { number of entries in the table }
    table: array[0..ANI_SIZE - 1] of TMibTcpRow; { array of TCP connections }
  end;

  PMibUdpStats = ^TMibUdpStats;
  TMibUdpStats = packed record
    dwInDatagrams: DWORD;  { received datagrams }
    dwNoPorts: DWORD;      { datagrams for which no port }
    dwInErrors: DWORD;     { errors on received datagrams }
    dwOutDatagrams: DWORD; { sent datagrams }
    dwNumAddrs: DWORD;     { number of entries in UDP listener table }
  end;

  PMibUdpRow = ^TMibUdpRow;
  TMibUdpRow = packed record
    dwLocalAddr: DWORD; { IP address on local computer }
    dwLocalPort: DWORD; { port number on local computer }
  end;

  PMibUdpTable = ^TMibUdpTable;
  TMibUdpTable = packed record
    dwNumEntries: DWORD;                         { number of entries in the table }
    table: array[0..ANI_SIZE - 1] of TMibUdpRow; { table of MIB_UDPROW structs }
  end;

{IP Helper API Prototypes }

function AddIPAddress(Address: TIPAddr; IpMask: TIPMask; IfIndex: DWORD;
  NTEContext, NTEInstance: PULONG): DWORD; stdcall;
function CreateIpForwardEntry(pRoute: PMibIpForwardRow): DWORD; stdcall;
function CreateIpNetEntry(pArpEntry: PMibIpNetRow): DWORD; stdcall;
function CreateProxyArpEntry(dwAddress, dwMask, dwIfIndex: DWORD): DWORD; stdcall;
function DeleteIPAddress(NTEContext: ULONG): DWORD; stdcall;
function DeleteIpForwardEntry(pRoute: PMibIpForwardRow): DWORD; stdcall;
function DeleteIpNetEntry(pArpEntry: PMibIpNetRow): DWORD; stdcall;
function DeleteProxyArpEntry(dwAddress, dwMask, dwIfIndex: DWORD): DWORD; stdcall;
function EnableRouter(pHandle: PHandle; pOverlapped: POverlapped): DWORD; stdcall;
function FlushIpNetTable(dwIfIndex: DWORD): DWORD; stdcall;
function GetAdapterIndex(AdapterName: LPWSTR; IfIndex: PULONG): DWORD; stdcall;
function GetAdaptersInfo(pAdapterInfo: PIpAdapterInfo; pOutBufLen: PULONG): DWORD; stdcall;
function GetBestInterface(dwDestAddr: TIPAddr; pdwBestIfIndex: PDWORD): DWORD; stdcall;
function GetBestRoute(dwDestAddr, dwSourceAddr: DWORD; pBestRoute: PMibIpForwardRow): DWORD; stdcall;
function GetFriendlyIfIndex(IfIndex: DWORD): DWORD; stdcall;
function GetIcmpStatistics(pStats: PMibIcmp): DWORD; stdcall;
function GetIfEntry(pIfRow: PMibIfRow): DWORD; stdcall;
function GetIfTable(pIfTable: PMibIfTable; pdwSize: PULONG; bOrder: BOOL): DWORD; stdcall;
function GetInterfaceInfo(pIfTable: PIpInterfaceInfo; dwOutBufLen: PULONG):DWORD; stdcall;
function GetIpAddrTable(pIpAddrTable: PMibIpAddrTable; pdwSize: PULONG; bOrder: BOOL): DWORD; stdcall;
function GetIpForwardTable(pIpForwardTable: PMibIpForwardTable; pdwSize: PULONG; bOrder: BOOL): DWORD; stdcall;
function GetIpNetTable(pIpNetTable: PMibIpNetTable; pdwSize: PULONG; bOrder: BOOL): DWORD; stdcall;
function GetIpStatistics(pStats: PMibIpStats): DWORD; stdcall;
function GetNetworkParams(pFixedInfo: PFixedInfo; pOutBufLen: PULONG): DWORD; stdcall;
function GetNumberOfInterfaces(pdwNumIf: PDWORD): DWORD; stdcall;
function GetPerAdapterInfo(IfIndex: ULONG; pPerAdapterInfo: PIpPerAdapterInfo;
  pOutBufLen: PULONG): DWORD; stdcall;
function GetRTTAndHopCount(DestIpAddress: TIPAddr; HopCount: PULONG;
  MaxHops: ULONG; RTT: PULONG): BOOL; stdcall;
function GetTcpStatistics(pStats: PMibTcpStats): DWORD; stdcall;
function GetTcpTable(pTcpTable: PMibTcpTable; pdwSize: PDWORD; bOrder: BOOL): DWORD; stdcall;
function GetUdpStatistics(pStats: PMibUdpStats): DWORD; stdcall;
function GetUdpTable(pUdpTable: PMibUdpTable; pdwSize: PDWORD; bOrder: BOOL): DWORD; stdcall;
function GetUniDirectionalAdapterInfo(pIPIfInfo: PIpUnidirectionalAdapterAddress;
  dwOutBufLen: PULONG): DWORD; stdcall;
function IpReleaseAddress(AdapterInfo: PIpAdapterIndexMap): DWORD; stdcall;
function IpRenewAddress(AdapterInfo: PIpAdapterIndexMap): DWORD; stdcall;
function NotifyAddrChange(Handle: PHandle; overlapped: POverlapped): DWORD; stdcall;
function NotifyRouteChange(Handle: PHandle; overlapped: POverlapped): DWORD; stdcall;
function SendARP(DestIP, SrcIP: TIPAddr; pMacAddr, PhyAddrLen: PULONG): DWORD; stdcall;
function SetIfEntry(pIfRow: PMibIfRow): DWORD; stdcall;
function SetIpForwardEntry(pRoute: PMibIpForwardRow): DWORD; stdcall;
function SetIpNetEntry(pArpEntry: PMibIpNetRow): DWORD; stdcall;
function SetIpStatistics(pIpStats: PMibIpStats): DWORD; stdcall;
function SetIpTTL(nTTL: UINT): DWORD; stdcall;
function SetTcpEntry(pTcpRow: PMibTcpRow): DWORD; stdcall;
function UnenableRouter(pOverlapped: POverlapped; lpdwEnableCount: LPDWORD): DWORD; stdcall;

implementation

const
  iphelper = 'iphlpapi.dll';

function AddIPAddress;                 external iphelper  name 'AddIPAddress';
function CreateIpForwardEntry;         external iphelper  name 'CreateIpForwardEntry';
function CreateIpNetEntry;             external iphelper  name 'CreateIpNetEntry';
function CreateProxyArpEntry;          external iphelper  name 'CreateProxyArpEntry';
function DeleteIPAddress;              external iphelper  name 'DeleteIPAddress';
function DeleteIpForwardEntry;         external iphelper  name 'DeleteIpForwardEntry';
function DeleteIpNetEntry;             external iphelper  name 'DeleteIpNetEntry';
function DeleteProxyArpEntry;          external iphelper  name 'DeleteProxyArpEntry';
function EnableRouter;                 external iphelper  name 'EnableRouter';
function FlushIpNetTable;              external iphelper  name 'FlushIpNetTable';
function GetAdapterIndex;              external iphelper  name 'GetAdapterIndex';
function GetAdaptersInfo;              external iphelper  name 'GetAdaptersInfo';
function GetBestInterface;             external iphelper  name 'GetBestInterface';
function GetBestRoute;                 external iphelper  name 'GetBestRoute';
function GetFriendlyIfIndex;           external iphelper  name 'GetFriendlyIfIndex';
function GetIcmpStatistics;            external iphelper  name 'GetIcmpStatistics';
function GetIfEntry;                   external iphelper  name 'GetIfEntry';
function GetIfTable;                   external iphelper  name 'GetIfTable';
function GetInterfaceInfo;             external iphelper  name 'GetInterfaceInfo';
function GetIpAddrTable;               external iphelper  name 'GetIpAddrTable';
function GetIpForwardTable;            external iphelper  name 'GetIpForwardTable';
function GetIpNetTable;                external iphelper  name 'GetIpNetTable';
function GetIpStatistics;              external iphelper  name 'GetIpStatistics';
function GetNetworkParams;             external iphelper  name 'GetNetworkParams';
function GetNumberOfInterfaces;        external iphelper  name 'GetNumberOfInterfaces';
function GetPerAdapterInfo;            external iphelper  name 'GetPerAdapterInfo';
function GetRTTAndHopCount;            external iphelper  name 'GetRTTAndHopCount';
function GetTcpStatistics;             external iphelper  name 'GetTcpStatistics';
function GetTcpTable;                  external iphelper  name 'GetTcpTable';
function GetUdpStatistics;             external iphelper  name 'GetUdpStatistics';
function GetUdpTable;                  external iphelper  name 'GetUdpTable';
function GetUniDirectionalAdapterInfo; external iphelper  name 'GetUniDirectionalAdapterInfo';
function IpReleaseAddress;             external iphelper  name 'IpReleaseAddress';
function IpRenewAddress;               external iphelper  name 'IpRenewAddress';
function NotifyAddrChange;             external iphelper  name 'NotifyAddrChange';
function NotifyRouteChange;            external iphelper  name 'NotifyRouteChange';
function SendARP;                      external iphelper  name 'SendARP';
function SetIfEntry;                   external iphelper  name 'SetIfEntry';
function SetIpForwardEntry;            external iphelper  name 'SetIpForwardEntry';
function SetIpNetEntry;                external iphelper  name 'SetIpNetEntry';
function SetIpStatistics;              external iphelper  name 'SetIpStatistics';
function SetIpTTL;                     external iphelper  name 'SetIpTTL';
function SetTcpEntry;                  external iphelper  name 'SetTcpEntry';
function UnenableRouter;               external iphelper  name 'UnenableRouter';

end.
