program ibconsvc;

uses
  SvcMgr,
  Forms,
  Windows,
  SysUtils,
  WinSvc,
  SvcMain in 'SvcMain.pas' {IBConnForm},
  CSConst in 'CSConst.pas';

{$R *.RES}
{$IFDEF VER150}
{$R WindowsXP.res}
{$ENDIF}

function Installing: Boolean;
begin
  Result := FindCmdLineSwitch('INSTALL', ['-', '\', '/'], True) or
    FindCmdLineSwitch('UNINSTALL', ['-', '\', '/'], True);
end;

function StartService: Boolean;
var
  Mgr, Svc: Integer;
  UserName, ServiceStartName: string;
  Config: Pointer;
  Size: DWORD;
begin
  Result := False;
  Mgr := OpenSCManager(nil, nil, SC_MANAGER_ALL_ACCESS);
  if Mgr <> 0 then
  begin
    Svc := OpenService(Mgr, PChar(SServiceName), SERVICE_ALL_ACCESS);
    Result := Svc <> 0;
    if Result then
    begin
      QueryServiceConfig(Svc, nil, 0, Size);
      Config := AllocMem(Size);
      try
        QueryServiceConfig(Svc, Config, Size, Size);
        ServiceStartName := PQueryServiceConfig(Config)^.lpServiceStartName;
        if CompareText(ServiceStartName, 'LocalSystem') = 0 then
          ServiceStartName := 'SYSTEM';
      finally
        Dispose(Config);
      end;
      CloseServiceHandle(Svc);
    end;
    CloseServiceHandle(Mgr);
  end;
  if Result then
  begin
    Size := 256;
    SetLength(UserName, Size);
    GetUserName(PChar(UserName), Size);
    SetLength(UserName, StrLen(PChar(UserName)));
    Result := CompareText(UserName, ServiceStartName) = 0;
  end;
end;

begin
  if not Installing then
  begin
    CreateMutex(nil, True, 'IBCONNSVC');
    if GetLastError in [ERROR_ALREADY_EXISTS, ERROR_ACCESS_DENIED] then
    begin
      MessageBox(0, PChar(Format(SAlreadyRunning, [SIBConnSvcTitle])),
        PChar(SIBConnSvcTitle), MB_OK or MB_ICONERROR);
      Halt;
    end;
  end;
  if Installing or StartService then
  begin
    SvcMgr.Application.Initialize;
    IBConnService := TIBConnService.CreateNew(SvcMgr.Application, 0);
    if not Installing then
    begin
      SvcMgr.Application.CreateForm(TIBConnForm, IBConnForm);
      IBConnForm.Initialize(False);
    end;
    SvcMgr.Application.Run;
  end
  else
  begin
    Forms.Application.Initialize;
    Forms.Application.ShowMainForm := False;
    Forms.Application.CreateForm(TIBConnForm, IBConnForm);
    IBConnForm.Initialize(True);
    Forms.Application.Run;
  end;
end.