unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, FIBDatabase, DBTables, ComCtrls,registry;

type
  TMainForm = class(TForm)
    tmUpdate: TTimer;
    dbIB: TFIBDatabase;
    lvInfo: TListView;
    tmConnect: TTimer;
    lvEvent: TListView;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    cbDBName: TComboBox;
    btConnect: TSpeedButton;
    edInterval: TEdit;
    udInterval: TUpDown;
    lbUsers: TListBox;
    Label4: TLabel;
    procedure tmUpdateTimer(Sender: TObject);
    procedure btConnectClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure tmConnectTimer(Sender: TObject);
    procedure lvInfoColumnClick(Sender: TObject; Column: TListColumn);
    procedure udIntervalClick(Sender: TObject; Button: TUDBtnType);
    procedure FormCreate(Sender: TObject);
  private
    cCurrentMemory,
    cMaxMemory,
    cNumBuffers,
    cAllocation,
    cFetches,
    cMarks,
    cReads,
    cWrites,
    cUserCount:integer;
    RegIni: TRegIniFile;
    function SetConnect(b:boolean):boolean;
    procedure SetActiv(b:boolean);
    procedure AddMessage(i:integer);
    procedure ReadAllInfo(bSetConst:boolean);
    procedure ClrInfo;
    procedure ReadReg;
    procedure WriteReg;
    procedure UpdDBNames(DBName: String);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation


{$R *.DFM}
procedure TMainForm.FormCreate(Sender: TObject);
begin
RegIni := TRegIniFile.Create('Software\IBMonitor');
ReadReg;
If cbDBName.Items.Count > 0 then cbDBName.ItemIndex:=0;
ClrInfo;
end;

procedure TMainForm.ReadReg;
begin
cbDBName.Items.Text:=RegIni.ReadString('','DBNames','');
udInterval.Position:=RegIni.ReadInteger('','TimeUpd',15);
If udInterval.Position=0 then tmUpdate.Interval:=1000
      else  tmUpdate.Interval:=udInterval.Position*1000;
end;

procedure TMainForm.WriteReg;
begin
RegIni.WriteString('','DBNames',cbDBName.Items.Text);
RegIni.WriteInteger('','TimeUpd',udInterval.Position);
end;

procedure TMainForm.ReadAllInfo(bSetConst:boolean);
var ListItem:TListItem;
    iCurrentMemory,
    iMaxMemory,
    iNumBuffers,
    iAllocation,
    iFetches,
    iMarks,
    iReads,
    iWrites,
    iUserCount,
    iPageSize:integer;
begin
try
With dbIB do begin
  iCurrentMemory:=CurrentMemory div 1024;
  iMaxMemory:=MaxMemory div 1024;
  iNumBuffers:=NumBuffers;
  iAllocation:=Allocation;
  iPageSize:=PageSize div 1024;
  iFetches:=Fetches;
  iMarks:=Marks;
  iReads:=Reads;
  iWrites:=Writes;
  iUserCount:=UserNames.Count;
  lbUsers.Items:=UserNames;
end;
except
 SetActiv(false);
 AddMessage(4);
 tmConnect.Enabled:=true;
end;
If bSetConst then begin
  cCurrentMemory:=iCurrentMemory;
  cMaxMemory:=iMaxMemory;
  cNumBuffers:=iNumBuffers;
  cAllocation:=iAllocation;
  cFetches:=iFetches;
  cMarks:=iMarks;
  cReads:=iReads;
  cWrites:=iWrites;
  cUserCount:=iUserCount;
  lvInfo.Columns[2].Caption:=FormatDateTime('hh:nn:ss',Time)+'   delta';
end;
lvInfo.Items[0].SubItems.Strings[0]:=IntToStr(iCurrentMemory);
 lvInfo.Items[0].SubItems.Strings[1]:=IntToStr(iCurrentMemory-cCurrentMemory);
lvInfo.Items[1].SubItems.Strings[0]:=IntToStr(iMaxMemory);
 lvInfo.Items[1].SubItems.Strings[1]:=IntToStr(iMaxMemory-cMaxMemory);
lvInfo.Items[2].SubItems.Strings[0]:=IntToStr(iNumBuffers)+'/'+IntToStr(iPageSize*iNumBuffers);
 lvInfo.Items[2].SubItems.Strings[1]:=IntToStr(iNumBuffers-cNumBuffers);
lvInfo.Items[3].SubItems.Strings[0]:=IntToStr(iAllocation)+'/'+IntToStr(iPageSize*iAllocation);
 lvInfo.Items[3].SubItems.Strings[1]:=IntToStr(iAllocation-cAllocation);
lvInfo.Items[4].SubItems.Strings[0]:=IntToStr(iFetches);
 lvInfo.Items[4].SubItems.Strings[1]:=IntToStr(iFetches-cFetches);
lvInfo.Items[5].SubItems.Strings[0]:=IntToStr(iMarks);
 lvInfo.Items[5].SubItems.Strings[1]:=IntToStr(iMarks-cMarks);
lvInfo.Items[6].SubItems.Strings[0]:=IntToStr(iReads);
 lvInfo.Items[6].SubItems.Strings[1]:=IntToStr(iReads-cReads);
lvInfo.Items[7].SubItems.Strings[0]:=IntToStr(iWrites);
 lvInfo.Items[7].SubItems.Strings[1]:=IntToStr(iWrites-cWrites);
lvInfo.Items[8].SubItems.Strings[0]:=IntToStr(iUserCount);
 lvInfo.Items[8].SubItems.Strings[1]:=IntToStr(iUserCount-cUserCount);
lvInfo.Columns[1].Caption:=FormatDateTime('hh:nn:ss',Time);
end;

procedure TMainForm.ClrInfo;
var ListItem:TListItem;
begin
lvInfo.Items.Clear;
ListItem:=lvInfo.Items.Add;
  ListItem.Caption:='current_memory (kb)';
  ListItem.SubItems.Add('');  ListItem.SubItems.Add('');
ListItem:=lvInfo.Items.Add;
  ListItem.Caption:='max_memory (kb)';
  ListItem.SubItems.Add('');  ListItem.SubItems.Add('');
ListItem:=lvInfo.Items.Add;
  ListItem.Caption:='num_buffers (page/kb)';
  ListItem.SubItems.Add('');  ListItem.SubItems.Add('');
ListItem:=lvInfo.Items.Add;
  ListItem.Caption:='info_allocation (page/kb)';
  ListItem.SubItems.Add('');  ListItem.SubItems.Add('');
ListItem:=lvInfo.Items.Add;
  ListItem.Caption:='fetches';
  ListItem.SubItems.Add('');   ListItem.SubItems.Add('');
ListItem:=lvInfo.Items.Add;
  ListItem.Caption:='marks';
  ListItem.SubItems.Add('');  ListItem.SubItems.Add('');
ListItem:=lvInfo.Items.Add;
  ListItem.Caption:='reads';
  ListItem.SubItems.Add('');  ListItem.SubItems.Add('');
ListItem:=lvInfo.Items.Add;
  ListItem.Caption:='writes';
  ListItem.SubItems.Add('');   ListItem.SubItems.Add('');
ListItem:=lvInfo.Items.Add;
  ListItem.Caption:='user_names (count)';
  ListItem.SubItems.Add('');  ListItem.SubItems.Add('');
lbUsers.Items.Clear;
end;

procedure TMainForm.tmUpdateTimer(Sender: TObject);
begin
 ReadAllInfo(false);
end;

procedure TMainForm.btConnectClick(Sender: TObject);
begin
If Trim(cbDBName.Text)='' then exit;
If SetConnect(btConnect.Down) then begin
 SetActiv(true);
 AddMessage(1);
 UpdDBNames(cbDBName.Text);
end else begin
 SetActiv(false);
 AddMessage(2);
end;
end;

function TMainForm.SetConnect(b:boolean):boolean;
begin
If b then
 try
    tmUpdate.Enabled:=False;
    If dbIB.Connected then dbIB.Close;
    dbIB.DBName:=cbDBName.Text;
    dbIB.Open;
    ReadAllInfo(true);
    Result:=true;
 except
    Result:=false;
 end
 else begin
    If dbIB.Connected then dbIB.Close;
    Result:=false;
    ClrInfo;
 end;
end;

procedure TMainForm.SetActiv(b:boolean);
begin
 tmUpdate.Enabled:=b;
// udInterval.Enabled:=not b;
 cbDBName.Enabled:=not b;
 btConnect.Down:=b;
 lvInfo.ColumnClick:=b;
end;

procedure TMainForm.tmConnectTimer(Sender: TObject);
begin
If SetConnect(true) then begin
 AddMessage(3);
 SetActiv(true);
 tmConnect.Enabled:=false;
end else SetActiv(false);
end;

procedure TMainForm.AddMessage(i:integer);
var ListItem:TListItem;
    st:string;
begin
Case i of
1: st:='Connect '+cbDBName.Text;
2: st:='Disconnect '+cbDBName.Text;
3: st:='  Restore';
4: st:='  Error';
end;
ListItem:=lvEvent.Items.Add;
  ListItem.Caption:=st;
  ListItem.SubItems.Add(FormatDateTime('hh:nn:ss',Time));
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 If dbIB.Connected then dbIB.Close;
 WriteReg;
end;

procedure TMainForm.lvInfoColumnClick(Sender: TObject;
  Column: TListColumn);
begin
If Column.Index=2 then  ReadAllInfo(true);
end;

procedure TMainForm.udIntervalClick(Sender: TObject; Button: TUDBtnType);
begin
 If udInterval.Position=0 then tmUpdate.Interval:=1000
  else  tmUpdate.Interval:=udInterval.Position*1000;
end;

procedure TMainForm.UpdDBNames(DBName: String);
var i: Integer;
begin
i:=0;
while i<cbDBName.Items.Count do begin
  if (cbDBName.Items[i]=DBName) then cbDBName.Items.Delete(i);
  Inc(i);
end;
cbDBName.Items.Insert(0,DBName);
cbDBName.ItemIndex:=0;
end;


end.

