unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBTables, ComCtrls, Menus, Db;

type
  TMainForm = class(TForm)
    GroupBox2: TGroupBox;
    lbUsers: TListBox;
    Label4: TLabel;
    btnAdd: TButton;
    btnMod: TButton;
    btnDel: TButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Connect1: TMenuItem;
    Disconnect1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Label1: TLabel;
    memUserInfo: TMemo;
    SB: TStatusBar;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Exit1Click(Sender: TObject);
    procedure Connect1Click(Sender: TObject);
    procedure lbUsersClick(Sender: TObject);
    procedure Disconnect1Click(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnModClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    procedure UpdateUserInfo;
  public
    { Public declarations }
    Protocol: integer;

  end;

var
  MainForm: TMainForm;

implementation

uses IBConnect, Ibase32, user, DM, welcome;

{$R *.DFM}

const
  USERS_SQL = 'SELECT DISTINCT USER_NAME, FIRST_NAME, MIDDLE_NAME, LAST_NAME, ' +
               'FULL_NAME, GROUP_NAME, SYS_USER_NAME, UID, GID, COMMENT ' +
               'FROM USERS ORDER BY USER_NAME';

procedure TMainForm.UpdateUserInfo;
begin
  if lbUsers.ItemIndex >= 0 then
  begin
    btnMod.Enabled := True;
    btnDel.Enabled := True;
    DMod.Query1.First;
    while not DMod.Query1.EOF do
    begin
      if DMod.Query1.FieldByName('USER_NAME').AsString = lbUsers.Items.Strings[lbUsers.ItemIndex] then
      begin
        memUserInfo.Clear;
        memUserInfo.Lines.Add('First Name = ' +  DMod.Query1.FieldByName('FIRST_NAME').AsString);
        memUserInfo.Lines.Add('Middle Name = ' +  DMod.Query1.FieldByName('MIDDLE_NAME').AsString);
        memUserInfo.Lines.Add('Last Name = ' +  DMod.Query1.FieldByName('LAST_NAME').AsString);
        memUserInfo.Lines.Add('Full Name = ' +  DMod.Query1.FieldByName('FULL_NAME').AsString);
        memUserInfo.Lines.Add('Group Name = ' +  DMod.Query1.FieldByName('GROUP_NAME').AsString);
        memUserInfo.Lines.Add('Sys User Name = ' +  DMod.Query1.FieldByName('SYS_USER_NAME').AsString);
        memUserInfo.Lines.Add('User ID = ' +  DMod.Query1.FieldByName('UID').AsString);
        memUserInfo.Lines.Add('Group ID = ' +  DMod.Query1.FieldByName('GID').AsString);
        memUserInfo.Lines.Add('Comments = ' +  DMod.Query1.FieldByName('Comment').AsString);
        Break;
      end;
      DMod.Query1.Next;
    end;
  end
  else
  begin
    btnMod.Enabled := False;
    btnDel.Enabled := False;
  end;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  DMod.Database1.Close;

end;

procedure TMainForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.Connect1Click(Sender: TObject);
begin
  Disconnect1Click(self);
  frmIBConnect := TfrmIBConnect.Create(nil);
  try
    if frmIBConnect.ShowModal = mrOK then
    begin
      DMod.Database1.Params.values['SERVER NAME'] := frmIBConnect.lblSecPath.Caption;
      DMod.Database1.Params.values['USER NAME'] := frmIBConnect.UNEdt.Text;
      DMod.Database1.Params.values['PASSWORD'] := frmIBConnect.PEdt.Text;
      screen.Cursor := crSQLWait;
      Application.ProcessMessages;
      DMod.Database1.Open;
      SB.SimpleText := 'Connnected to: ' + DMod.Database1.Params.values['SERVER NAME'];
      btnAdd.Enabled := True;
      DMod.Query1.SQL.Text := USERS_SQL;
      DMod.Query1.Open;
      while not DMod.Query1.EOF do
      begin
        lbUsers.Items.Add(DMod.Query1.FieldByName('USER_NAME').AsString);
        DMod.Query1.Next;
      end;
    end;
  finally
    frmIBConnect.Free;
    screen.Cursor := crDefault;
    Application.ProcessMessages;
  end;
end;

procedure TMainForm.lbUsersClick(Sender: TObject);
begin
  UpdateUserInfo;
end;

procedure TMainForm.Disconnect1Click(Sender: TObject);
begin
  DMod.Query1.Close;
  DMod.Database1.Close;
  SB.SimpleText := 'Disconnnected';
  lbUsers.Clear;
  memUserInfo.Clear;
  btnMod.Enabled := False;
  btnDel.Enabled := False;
  btnAdd.Enabled := False;
end;

procedure TMainForm.btnAddClick(Sender: TObject);
begin
  frmUser := TfrmUser.Create(nil);
  try
    frmUser.Operation := uoAdd;
    if frmUser.ShowModal = mrOK then
    begin
      screen.cursor := crSQLWait;
      Application.ProcessMessages;
      lbUsers.Items.clear;
      DMod.Query1.Close;
      DMod.Query1.Open;
      while not DMod.Query1.EOF do
      begin
        lbUsers.Items.Add(DMod.Query1.FieldByName('USER_NAME').AsString);
        DMod.Query1.Next;
      end;
    end;
  finally
    screen.cursor := crDefault;
    frmUser.Free;
  end;
end;

procedure TMainForm.btnModClick(Sender: TObject);
begin
  frmUser := TfrmUser.Create(nil);
  try
    frmUser.Operation := uoModify;
    frmUser.UserName := lbUsers.Items.Strings[lbUsers.ItemIndex];
    if frmUser.ShowModal = mrOK then
    begin
      screen.cursor := crSQLWait;
      Application.ProcessMessages;
      DMod.Query1.Close;
      DMod.Query1.Open;
      UpdateUserInfo;
    end;
  finally
    screen.cursor := crDefault;
    frmUser.Free;
  end;
end;

procedure TMainForm.btnDelClick(Sender: TObject);
var
  DBAInfo: TDBAInfo;
  ServerInfo: TServerInfo;

begin
  // make sure3 you want to delete the selected user...
  if MessageDlg('Are you sure you want to delete user: ' +
      lbUsers.items.Strings[lbUsers.ItemIndex], mtConfirmation, [mbOK], 0) = mrOK then
  begin
    screen.cursor := crSQLWait;
    application.processmessages;
    // extract the server name from the connection string...
    ServerInfo.Name :=
       ExtractServerName(DMod.Database1.Params.values['SERVER NAME'], MainForm.Protocol);
      ServerInfo.Protocol := MainForm.Protocol;

    // set the name property in the TDBAInfo structure the the name of the SYSDBA...
    DBAInfo.Name := DMod.Database1.Params.values['USER NAME'];
    // set the password property in the TDBAInfo structure the the password of the SYSDBA...
    DBAInfo.Password := DMod.Database1.Params.values['PASSWORD'];
    // Delete the user
    {
       DeleteUser(Server info entered above: i.e.server and protocol,
                  DBA info entered above: usually SYSDBA and SYSDBA's password,
                  User name to delete from the password database);
    }
    DeleteUser(@ServerInfo, DBAInfo, lbUsers.items.Strings[lbUsers.ItemIndex]);
    try
      // refresh the users list...
      lbUsers.Clear;
      DMod.Query1.Close;
      DMod.Query1.Open;
      while not DMod.Query1.EOF do
      begin
        lbUsers.Items.Add(DMod.Query1.FieldByName('USER_NAME').AsString);
        DMod.Query1.Next;
      end;
    finally
      memuserInfo.Clear;
      btnDel.Enabled := False;
      btnMod.Enabled := False;      
      screen.cursor := crDefault;
    end;
  end;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  frmWelcome.ShowModal;
end;

end.


