unit IBConnect;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Registry, Menus;

type
  TfrmIBConnect = class(TForm)
    GroupBox1: TGroupBox;
    LocalBtn: TRadioButton;
    Label1: TLabel;
    RemoteBtn: TRadioButton;
    Label2: TLabel;
    ServerEdt: TEdit;
    ProtocolCB: TComboBox;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    UNEdt: TEdit;
    PEdt: TEdit;
    ConnectBtn: TButton;
    CancelBtn: TButton;
    OpenDialog1: TOpenDialog;
    GroupBox3: TGroupBox;
    Label6: TLabel;
    SecEdt: TEdit;
    lblSecPath: TLabel;
    BrowseSecBtn: TButton;
    MainMenu1: TMainMenu;
    PriorConnections1: TMenuItem;
    Item1: TMenuItem;
    Item2: TMenuItem;
    Item3: TMenuItem;
    Item4: TMenuItem;
    Item5: TMenuItem;
    procedure LocalBtnClick(Sender: TObject);
    procedure RemoteBtnClick(Sender: TObject);
    procedure ServerEdtChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SecEdtChange(Sender: TObject);
    procedure ConnectBtnClick(Sender: TObject);
    procedure BrowseSecBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Item1Click(Sender: TObject);
  private
    { Private declarations }
    Reg: TRegistry;
    Values: TStringList;
    procedure RemoteDB(IsRemote: boolean);
    function CreateDBString(Protocol, Server, DB: string): string;
    function FindLocalIBPath: string;
    procedure SetPriorLists;
    procedure AddToPriorList(S: String);
    procedure SetIBConnectString(S: string);
  public
    { Public declarations }
  end;

var
  frmIBConnect: TfrmIBConnect;

implementation

uses Unit1, Ibase32;

const
  BORLAND_EXAMPLE = '\SOFTWARE\Borland\InterBase Connection Example';


{$R *.DFM}

procedure TfrmIBConnect.SetIBConnectString(S: string);
var
  Temp: string;

begin
  if S[2] = ':' then // Local Connnection...
  begin
    LocalBtn.Checked := True;
    ServerEdt.Text := '';
    ProtocolCB.ItemIndex := -1;
    SecEdt.Text := S;
//    lblSecpath.Caption := S;
  end
  else
  begin
    // netBEUI Connection...
    if Pos('\\', S) <> 0 then
    begin
      RemoteBtn.Checked := True;
      Temp := Copy(S, 3, Length(S) - 2);
      ServerEdt.Text := Copy(Temp, 1, Pos('\', Temp) - 1);
      ProtocolCB.ItemIndex := 0;
      SecEdt.Text := Copy(Temp, Pos('\', Temp) + 1, Length(Temp) - Pos('\', Temp));
    end;
    // TCP/IP Connection...
    if (Pos('@', S) = 0) and (Pos('\\', S) = 0) and (Pos(':', S) <> 0) then
    begin
      RemoteBtn.Checked := True;
      ServerEdt.Text := Copy(S, 1, Pos(':', S) - 1);
      ProtocolCB.ItemIndex := 1;
      SecEdt.Text := Copy(S, Pos(':', S) + 1, Length(S) - Pos(':', S));
    end;
    // IPX Connection...
    if Pos('@', S) <> 0  then
    begin
      RemoteBtn.Checked := True;
      ServerEdt.Text := Copy(S, 1, Pos('@', S) - 1);
      ProtocolCB.ItemIndex := 2;
      SecEdt.Text := Copy(S, Pos('@', S) + 1, Length(S) - Pos('@', S));
    end;
  end;
end;

procedure TfrmIBConnect.AddToPriorList(S: String);
var
  Found: boolean;
  B: byte;

begin
  Found := False;
  Reg.OpenKey(BORLAND_EXAMPLE, False);
  if Values.Count > 0 then
  begin
    for B := 0 to Values.Count - 1 do
    begin
      if Uppercase(Reg.ReadString(Values.Strings[B])) = Uppercase(S) then
        Found := True;

    end;
    if Found = False then
    begin
      for B := Values.Count downto 1 do
      begin
        if B <= 4 then
          Reg.WriteString('Item' + IntToStr(B + 1),
                  Reg.ReadString('Item' + InttoStr(B)));
      end;
      Reg.WriteString('Item1', S);
    end
  end
  else
    Reg.WriteString('Item1', S);
  Reg.CloseKey;
end;

procedure TfrmIBConnect.SetPriorLists;
var
  B: byte;

begin

  Reg.RootKey := HKEY_LOCAL_MACHINE;
  Reg.OpenKey(BORLAND_EXAMPLE, True);
  Reg.GetValueNames(Values);
  if Values.Count > 0 then
    for B := 0 to Values.Count - 1 do
    begin
      if B = 0 then
      begin
        Item1.Caption := Reg.ReadString(Values.Strings[B]);
        Item1.Enabled := True;
      end;
      if B = 1 then
      begin
        Item2.Caption := Reg.ReadString(Values.Strings[B]);
        Item2.Visible := True;
      end;
      if B = 2 then
      begin
        Item3.Caption := Reg.ReadString(Values.Strings[B]);
        Item3.Visible := True;
      end;
      if B = 3 then
      begin
        Item4.Caption := Reg.ReadString(Values.Strings[B]);
        Item4.Visible := True;
      end;
      if B = 4 then
      begin
        Item5.Caption := Reg.ReadString(Values.Strings[B]);
        Item5.Visible := True;
      end;
    end;
  Reg.Closekey;
end;

function TfrmIBConnect.FindLocalIBPath: string;
const
  BORLAND_INTERBASE = '\SOFTWARE\Borland\InterBase\CurrentVersion';
  INTERBASE = '\SOFTWARE\InterBase Corp\InterBase\CurrentVersion';

var
  Reg: TRegistry;

begin
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    if Reg.OpenKey(BORLAND_INTERBASE, False) = True then
    begin
      Result := Reg.ReadString('RootDirectory');
      if Result[Length(Result)] <> '\' then
        Result := Result + '\';
    end
    else
      if Reg.OpenKey(INTERBASE, False) = True then
      begin
        Result := Reg.ReadString('RootDirectory');
        if Result[Length(Result)] <> '\' then
          Result := Result + '\';
      end
      else
        Result := '';

  finally
    Reg.CloseKey;
    Reg.Free;
  end;
end;

procedure TfrmIBConnect.RemoteDB(IsRemote: boolean);
begin
  ServerEdt.Enabled := IsRemote;
  ProtocolCB.Enabled := IsRemote;
  BrowseSecBtn.Enabled := not IsRemote;
  if IsRemote = False then
  begin
    ServerEdt.Text := '';
    ProtocolCB.ItemIndex := -1;
  end;
end;

procedure TfrmIBConnect.LocalBtnClick(Sender: TObject);
begin
  RemoteDB(False);
  ServerEdtChange(self);
end;

procedure TfrmIBConnect.RemoteBtnClick(Sender: TObject);
begin
  RemoteDB(True);
  ServerEdtChange(self);  
end;

function TfrmIBConnect.CreateDBString(Protocol, Server, DB: string): string;
begin
  if RemoteBtn.Checked = True then
  begin
    if CompareText(Protocol, 'TCP/IP') = 0 then
    begin
      Result := Format('%s:%s', [Server, DB]);
    end;
    if CompareText(Protocol, 'NetBEUI') = 0 then
    begin
      Result := Format('\\%s\%s', [Server, DB]);
    end;
    if CompareText(Protocol, 'Novell SPX') = 0 then
    begin
      Result := Format('%s@%s', [Server, DB]);
    end;
  end;
  if LocalBtn.Checked = True then
   Result := DB;
end;

procedure TfrmIBConnect.FormShow(Sender: TObject);
begin
  Reg := TRegistry.Create;
  Values := TStringList.Create;
  RemoteDB(False);
  PEdt.Text := '';
  SECEdt.Text := FindLocalIBPath + 'isc4.gdb';
  ServerEdt.Text := '';
  SetPriorLists;
end;

procedure TfrmIBConnect.SecEdtChange(Sender: TObject);
begin
  lblSecPath.Caption := CreateDBString(ProtocolCB.Text, ServerEdt.Text, SecEdt.Text);
end;

procedure TfrmIBConnect.ServerEdtChange(Sender: TObject);
begin
  lblSecPath.Caption := CreateDBString(ProtocolCB.Text, ServerEdt.Text, SecEdt.Text);
end;


procedure TfrmIBConnect.ConnectBtnClick(Sender: TObject);
begin
  ModalResult := mrOK;
  if UNEdt.Text <> 'SYSDBA' then
    if MessageDlg('Are you sure you want to log in as a non-SYSDBA user? ' +
       'User editing functionality will be lost', mtConfirmation, [mbYes, mbNO], 0) = mrNO then
  begin
    UNEdt.Text := 'SYSDBA';
    ModalResult := mrNONE;    
    Exit;
  end;
  if RemoteBtn.Checked = True then
  begin
    if ProtocolCB.Text = 'TCP/IP' then
      MainForm.Protocol := sec_protocol_tcpip;
    if ProtocolCB.Text = 'NetBEUI' then
      MainForm.Protocol := sec_protocol_netbeui;
    if ProtocolCB.Text = 'Novell SPX' then
      MainForm.Protocol := sec_protocol_netbeui;
  end;
  if LocalBtn.Checked = True then
      MainForm.Protocol := sec_protocol_local;
  AddToPriorList(lblSecPath.Caption);
end;

procedure TfrmIBConnect.BrowseSecBtnClick(Sender: TObject);
begin
  OpenDialog1.Title := 'Find Security Database';
  OpenDialog1.FileName := 'isc4.gdb';
  if SecEdt.Text = '' then
    OpenDialog1.DefaultExt := ExtractFilePath(Application.ExeName)
  else
    OpenDialog1.DefaultExt := ExtractFilePath(SecEdt.Text);
  if OpenDialog1.Execute = True then
  begin
    SecEdt.Text := OpenDialog1.FileName;
  end;
end;

procedure TfrmIBConnect.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Reg.CloseKey;
  Reg.Free;
  Values.Free;
end;

procedure TfrmIBConnect.Item1Click(Sender: TObject);
var
  B: word;
begin
  for B := 0 to ComponentCount - 1 do
  begin
    if (Components[B] = Sender) and (Sender is TMenuItem) then
    begin
      TMenuItem(Components[B]).Checked := True;
      SetIBConnectString(TMenuItem(Components[B]).Caption);
    end
    else
      if Components[B] is TMenuItem then
        TMenuItem(Components[B]).Checked := False;
  end;
end;

end.
