unit user;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB;

type
  TUserOptions = (uoAdd, uoModify);

  TfrmUser = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    lbluser: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    edtUser: TEdit;
    edtPswd: TEdit;
    edtConfPswd: TEdit;
    edtFirst: TEdit;
    edtMiddle: TEdit;
    edtLast: TEdit;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure edtFirstEnter(Sender: TObject);
  private
    { Private declarations }
    NameChanged: Boolean;
  public
    { Public declarations }
    Operation: TUserOptions;
    UserName: string;
  end;

var
  frmUser: TfrmUser;

implementation

uses DM, Ibase32, Unit1;

{$R *.DFM}

const
  DONT_CHANGE_PSWD = 'DontCHNG';


procedure TfrmUser.FormShow(Sender: TObject);
begin
  NameChanged := False;
  if Operation = uoAdd then
    Caption := Caption + ' (Add User)';
  if Operation = uoModify then
  begin
    Caption := Caption + ' (Modify User)';
    edtUser.Enabled := False;
    lblUser.Enabled := False;
    edtPswd.Text := DONT_CHANGE_PSWD;
    edtConfPswd.Text := DONT_CHANGE_PSWD;
    try
      DMod.Query1.Filter := 'USER_NAME = ''' + UserName + '''';
      edtUser.Text := DMod.Query1.FieldByName('USER_NAME').AsString;
      edtFirst.Text := DMod.Query1.FieldByName('FIRST_NAME').AsString;
      edtMiddle.Text := DMod.Query1.FieldByName('MIDDLE_NAME').AsString;
      edtLast.Text := DMod.Query1.FieldByName('LAST_NAME').AsString;
    finally
      DMod.Query1.Filtered := False;
    end;
  end;
end;

procedure TfrmUser.Button1Click(Sender: TObject);
var
  UserInfo: PUserInfo;
  DBAInfo: TDBAInfo;
  ServerInfo: PServerInfo;
  Pswd: string;


begin
  if edtUser.Text = '' then
  begin
    ShowMessage('User Name cannot be blank. Please try again');
    edtUser.SetFocus;
    Exit;
  end;

  if edtConfPswd.Text <> edtPswd.Text then
  begin
    ShowMessage('Password and Confirm passwords do not match. Please try again');
    edtConfPswd.Text := '';
    edtPswd.Text := '';
    edtPswd.SetFocus;
    Exit;
  end;

  if (edtConfPswd.Text = '') or (edtPswd.Text = '') then
  begin
    ShowMessage('Password cannot be blank. Please try again');
    edtPswd.SetFocus;    
    Exit;
  end;

  // if the user has changed any of the first, middle or last settings
  //    add them to the UserInfo structure...
  if NameChanged = True then
  begin
    UserInfo := AllocMem(sizeof(TUserInfo));
    UserInfo^.FirstName := edtFirst.Text;
    UserInfo^.MiddleName := edtMiddle.Text;
    UserInfo^.LastName := edtLast.Text;
  end
  else
    UserInfo := nil;

  // if the user has specified anything besides a local connection, we need
  //   to know the server naem and the protocol to connect to the server...
  if MainForm.Protocol <> sec_protocol_local then
  begin
    ServerInfo := AllocMem(sizeof(TServerInfo));
    ServerInfo^.Name :=
       ExtractServerName(DMod.Database1.Params.values['SERVER NAME'], MainForm.Protocol);
    ServerInfo^.Protocol := MainForm.Protocol;
  end
  else
    ServerInfo := nil;  // this means use a local connection...

  // Always need to have a DBA user name and password (usually SYSDBA)...
  DBAInfo.Name := DMod.Database1.Params.values['USER NAME'];
  DBAInfo.Password := DMod.Database1.Params.values['PASSWORD'];

  screen.cursor := crSQLWait;
  Application.ProcessMessages;

  try
    if Operation = uoModify then
    begin

      // if the user did not change the password box, don't change the password...
      if edtPswd.Text = DONT_CHANGE_PSWD then
        Pswd := ''
      else
        Pswd := edtPswd.Text;
      {
         ModifyUser(Server info entered above: i.e.server and protocol,
                    DBA info entered above: usually SYSDBA and SYSDBA's password,
                    User name to modify in the password database,
                    Password to modify in the password database,
                    Extra user info: i.e. first, middle and last names);
      }
      ModifyUser(ServerInfo, DBAInfo, edtUser.Text, Pswd, UserInfo);
    end;
    if Operation = uoAdd then
    begin
      Pswd := edtPswd.Text;
      {
         AddUser(Server info entered above: i.e.server and protocol,
                    DBA info entered above: usually SYSDBA and SYSDBA's password,
                    User name to add in the password database,
                    Password to add in the password database,
                    Extra user info: i.e. first, middle and last names);
      }
      AddUser(ServerInfo, DBAInfo, edtUser.Text, Pswd, UserInfo);
    end;
  finally
    screen.cursor := crDefault;
    if UserInfo <> nil then
      FreeMem(UserInfo);
    if ServerInfo <> nil then
      FreeMem(ServerInfo);
  end;
  ModalResult := mrOK;
end;

procedure TfrmUser.edtFirstEnter(Sender: TObject);
begin
  NameChanged := True;
end;

end.
