unit Defs;

interface
uses
 SysUtils,
 Windows;

const
 defVersion = $0003;

type
 PLongint = ^longint;
 PDouble  = ^double;
 TISCQuad = comp;
 PISCQuad = ^TISCQuad;
 TDateTimeRec = record
                 RSec    : integer;
                 RMin    : integer;
                 RHour   : integer;
                 RDay    : integer;
                 RMonth  : integer;
                 RYear   : integer;
                 RDOW    : integer;
                 RDOY    : integer;
                 RDST    : integer;
                end;{TDateTimeRec}
 PDateTimeRec = ^TDateTimeRec;
 TITDResult   = ( irOK, irAlreadyAllocated, irUnableToAllocate, irNotAllocated, irInternalError );

const
 defSTDOUT : THandle = INVALID_HANDLE_VALUE;
 defFile   : THandle = INVALID_HANDLE_VALUE; 

 defMaxPCharLen = $FF;
 defCRLF        = #$0D#$0A;
 defEmptyPChar  = '';
 
 defVersionFmt  = 'ITD -- InterBase Trivial Debugger. Ver. %d.%d' + defCRLF + defCRLF;
 defWMFmt       = '%s';
 defWIFmt       = '%s (integer): %d';
 defWSFmt       = '%s (string): %s';
 defWFFmt       = '%s (double): %*.*f';
 defWDFmt       = '%s (date): %2.2d/%2.2d/%2.2d %2.2d:%2.2d:%2.2d';

function ITDStart( AFileName : PChar ) : longint; cdecl; export;
function ITDStop : longint; cdecl; export;
function ITDMessage( AMessage : PChar ) : longint; cdecl; export;
function ITDWatchInteger( AVarName : PChar; AVarValue : PLongint ) : longint; cdecl; export;
function ITDWatchString( AVarName : PChar; AVarValue : PChar ) : longint; cdecl; export;
function ITDWatchFloat( AVarName : PChar; ALength, APrecision : PLongint; AVarValue : PDouble ) : longint; cdecl; export;
function ITDWatchDate( AVarName : PChar; AVarValue : PISCQuad ) : longint; cdecl; export;

implementation

procedure isc_decode_date( AIBDate : PISCQuad; ADecodedDate : PDateTimeRec );
 stdcall; external 'gds32.dll';

function WriteConsoleFmt( AFormat : PChar; const AArgs : array of const ) : longint;
var
 PBuf : PChar;
 LRes : dword;
begin
 if defSTDOUT = INVALID_HANDLE_VALUE
  then Result := Ord( irNotAllocated )
  else
  begin
   Result := Ord( irOK );
   PBuf   := StrAlloc( Succ( defMaxPCharLen ));
   StrFmt( PBuf, AFormat, AArgs );
   StrCat( PBuf, defCRLF );
   WriteConsole( defSTDOUT, PBuf, StrLen( PBuf ), LRes, nil );
   if defFile <> INVALID_HANDLE_VALUE then
    WriteFile( defFile, PBuf^, StrLen( PBuf ), LRes, nil );
   StrDispose( PBuf );
  end;{then} 
end;{WriteConsoleFmt}

function ITDStart( AFileName : PChar ) : longint;
begin
 Result := Ord( irOK );
 if defSTDOUT <> INVALID_HANDLE_VALUE then
  begin
   Result := Ord( irAlreadyAllocated );
   Exit;
  end;{then}
 AllocConsole;
 defSTDOUT := GetStdHandle( STD_OUTPUT_HANDLE );
 if StrComp( AFileName, defEmptyPChar ) > 0 then
  defFile := CreateFile( AFileName, GENERIC_WRITE, FILE_SHARE_READ, nil, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, INVALID_HANDLE_VALUE );
 if defSTDOUT = INVALID_HANDLE_VALUE
  then Result := Ord( irUnableToAllocate )
  else
  begin
   try
    WriteConsoleFmt( defVersionFmt, [ Hi( defVersion ), Lo( defVersion )]);
   except
    Result := Ord( irInternalError );
   end;{try}
 end;{else}
end;{ITDStart}

function ITDStop : longint;
begin
 Result := Ord( irOK );
 if defFile <> INVALID_HANDLE_VALUE then CloseHandle( defFile );
 if defSTDOUT = INVALID_HANDLE_VALUE  
  then Result := Ord( irNotAllocated )
  else
  begin
   FreeConsole;
   defSTDOUT := INVALID_HANDLE_VALUE;
  end;{else}
end;{ITDStop}

function ITDMessage( AMessage : PChar ) : longint;
begin
 try
  Result := WriteConsoleFmt( defWMFmt, [ AMessage ]);
 except
  Result := Ord( irInternalError );
 end;{try} 
end;{ITDMessage}

function ITDWatchInteger( AVarName : PChar; AVarValue : PLongint ) : longint;
begin
 try
  Result := WriteConsoleFmt( defWIFmt, [ AVarName, AVarValue^ ]);
 except
  Result := Ord( irInternalError );
 end;{try}
end;{ITDWatchInteger}

function ITDWatchString( AVarName : PChar; AVarValue : PChar ) : longint;
begin
 try
  Result := WriteConsoleFmt( defWSFmt, [ AVarName, AVarValue ]);
 except
  Result := Ord( irInternalError );
 end;{try}
end;{ITDWatchString}

function ITDWatchFloat( AVarName : PChar; ALength, APrecision : PLongint; AVarValue : PDouble ) : longint;
begin
 try
  Result := WriteConsoleFmt( defWFFmt, [ AVarName, ALength^, APrecision^, AVarValue^ ]);
 except
  Result := Ord( irInternalError );
 end;{try}
end;{ITDWatchFloat}

function ITDWatchDate( AVarName : PChar; AVarValue : PISCQuad ) : longint;
var
 PDat : PDateTimeRec;
begin
 New( PDat );
 try
  isc_decode_date( AVarValue, PDat );
  with PDat^ do
   Result := WriteConsoleFmt( defWDFmt, [ AVarName, Succ( RMonth ), RDay, RYear, RHour, RMin, RSec ]);
 except
  Result := Ord( irInternalError );
 end;{try}
 Dispose( PDat );
end;{ITDWatchDate}

end.
