/* ITD -- InterBase Trivial Debugger. Ver. 0.3 */
/* CREATE.SQL */
/* Last modified 6:59 PM 12/22/98 */
/* Creates a sample ITD database */

/* Dropping schema */
connect "localhost:/program files/itd/demo/itd.gdb" user "SYSDBA" password "masterkey";
drop schema;

/* Creating schema */
create schema "localhost:/program files/itd/demo/itd.gdb" user "SYSDBA" password "masterkey";

/* Declaring external functions */
declare external function DStart cstring( 255 )
 returns integer by value
 entry_point "ITDSTART" module_name "ITD";
declare external function DStop
 returns integer by value
 entry_point "ITDSTOP" module_name "ITD";
declare external function DMessage cstring( 255 )
 returns integer by value
 entry_point "ITDMESSAGE" module_name "ITD";
declare external function DWInteger cstring( 255 ), integer
 returns integer by value
 entry_point "ITDWATCHINTEGER" module_name "ITD";
declare external function DWString cstring( 255 ), cstring( 255 )
 returns integer by value
 entry_point "ITDWATCHSTRING" module_name "ITD";
declare external function DWFloat cstring( 255 ), integer, integer, double precision
 returns integer by value
 entry_point "ITDWATCHFLOAT" module_name "ITD";
declare external function DWDate cstring( 255 ), date
 returns integer by value
 entry_point "ITDWATCHDATE" module_name "ITD";
commit;


/* Creating tables */
create table Sales(
                   ID       integer not null,
                   SaleDate date not null,
                   Customer char( 64 ) not null,
                   Amount   double precision not null,
                   primary key( ID )
                  );
commit;

/* Creating indices */
create ascending index SalesSaleDate on Sales( SaleDate );
create ascending index SalesCustomer on Sales( Customer );
create ascending index SalesAmount on Sales( Amount );
commit;

/* Creating generators */
create generator SalesIDGenerator;
commit;

/* Creating triggers */
set term !! ;

create trigger SalesBeforeInsert
for Sales before insert position 0
as
begin
 new.ID = Gen_ID( SalesIDGenerator, 1 );
end !!

create trigger SalesAfterInsert
for Sales after insert position 0
as
 declare variable I integer;
begin
 I = DWInteger( "ID", new.ID );
 I = DWDate( "SaleDate", new.SaleDate );
 I = DWString( "Customer", new.Customer );
 I = DWFloat( "Amount", 14, 4, new.Amount );
end !!

set term ; !!
commit;

/* Creating procedures */
set term !! ;

create procedure StartD( F varchar( 255 ))
 returns( I integer )
as
begin
 I = DStart( F );
 if ( I = 0 ) then
 begin
  I = DMessage( 'Started' );
 end
end !!

create procedure StopD
 returns( I integer )
as
begin
 I = DStop();
end !!

set term ; !!
commit;

/* End of CREATE.SQL */