{
  TBUDF - Open Source UDF for InterBase and FireBird

  Authors...: Daniel Pereira Guimares and Anthony J. Caduto
  E-mail...: tecnobyte@ulbrajp.com.br; acaduto@amsoftwaredesign.com
  Tecno Byte Home-Page: www.ulbrajp.com.br/~tecnobyte
  AM Software design Home Page: http://www.amsoftwaredesign.com

  Null functions added on 3 July 2002 by Anthony J. Caduto
  Original Null functions by Claudio Valderama
  Special thanks to:
  Ann Harrison:  Provided varchar,cstring and text formats that are passed by descriptor
  Rudy Velthuis: Helped with buffer to string routines
  Henner Kollman: Ported the setnull and isnull functions
  And everyone else who helped from the Firebird-devel newsgroup 


  This library is Open-Source!
}

unit tb_consts;

interface

const
  DSC_null = 1;
  DSC_no_subtype = 2; //dsc has no sub type specified
  DSC_nullable = 4;

  dtype_null = 0;
  dtype_text = 1;
  dtype_cstring = 2;
  dtype_varying = 3;
  dtype_packed = 6;
  dtype_byte = 7;
  dtype_short = 8;
  dtype_long = 9;
  dtype_quad = 10;
  dtype_real = 11;
  dtype_double = 12;
  dtype_d_float = 13;
  dtype_sql_date = 14;
  dtype_sql_time = 15;
  dtype_timestamp = 16;
  dtype_blob = 17;
  dtype_array = 18;
  dtype_int64 = 19;


  MONTH_DAYS: array[1..12] of byte = (31,28,31,30,31,30,31,31,30,31,30,31);

  SECONDS_PER_MINUTE = 60;
  SECONDS_PER_HOUR = 3600;
  SECONDS_PER_DAY = 86400;

  DAYS_PER_WEEK = 7;
  MONTHS_PER_YEAR = 12;

  APPROX_DAYS_PER_MONTH = 30.4375;
  APPROX_DAYS_PER_YEAR = 365.25;

  ISC_TIME_SECONDS_PRECISION = 10000;

implementation

end.
