unit Routins;

interface

//     
function IntPower(var X:Double;var I:Integer):Double; cdecl; export;

//     
function IntPower10(var I:Integer):Double; cdecl; export;

//  ANumber  AToDigit   
function RoundTo(var ANumber:Double;var AToDigit:Integer): Double; cdecl; export;

implementation

function IntPower(var X:Double;var I:Integer):Double;
{ Invariant: Y >= 0 & Result*X**Y = X**I.  Init Y = I and Result = 1. }
var
  Y: Integer;
begin
  Y := Abs(I);
  Result := 1.0;
  while Y > 0 do begin
    while not Odd(Y) do begin
      Y := Y shr 1;
      X := X * X;
    end;
    Dec(Y);
    Result := Result * X;
  end;
  if I < 0 then Result := 1.0 / Result;
end;

function IntPower10(var I:Integer):Double;
  var
    Z: Double;
begin
  Z := 10;
  Result := IntPower(Z,I);
end;

function RoundTo(var ANumber:Double;var AToDigit:Integer): Double;
  function RoundUp(X: Double): longint;
  begin
    if X < 0
    then Result := Trunc(X-0.5)
    else Result := Trunc(X+0.5);
  end;
  var
    MP: Double;
begin
  MP := IntPower10(AToDigit);
  Result := RoundUp(ANumber*MP)/MP;
end;

end.
