library randomudf;

uses
  Windows;

{ Copyright Dmitry Kuzmenko, Epsylon Technologies }
{ e-mail: dima@demo.ru,  web: http://ib.demo.ru   }
{       
  ,              
  no copyright.
  this module is wrapper to standard Delphi Random functions }


{  dll   intrbase\bin  4.2,  intrbase\lib  5.x.  UDF  6.x
   DDL-
          Database Explorer  WISQL.

  Place dll into intrbase\bin for IB 4.2, intrbase\lib for 5.x, or UDF for IB6.x
  Execute DDL-commands from randomudf.sql to declare needed functions in 
  Database Explorer or WISQL.

   :
  Function Descriptions:

  GetRandom -   .  Range <> 0,  Range  
      .  Range = 0,  GetRandom  
    0  1,  .

  GetRandom - returns random integer number. If Range <> 0, Range is used to set up
  highest random number (-1). If Range = 0, getRandom returns random number between
  0 and 1 (as usual).


  SetRandSeed -    ,  GetRandom.
     ,    .

  SetRandSeed - Enables to repeat random sequences, generated by GetRandom.
  Result value is equal to input value, and have no sense.

  InitRandom -  Randomize     GetRandom.
    0.
  InitRandom - calls Randomise to generate random sequence.
 
  RandomStr -         MinLen  MaxLen. 
  MaxLen       .
       ,      .
       Blob,       
  StrToBlob  FreeUDFLib.

  RandomStr - returns string with random russian (!) characters with MinLen and MaxLen.
  MaxLen must not exceed UDF's declared result length.
  By default RandomStr returns latin and national symbols.


  RandomStrE - returns only latin an special characters.

       ,     .
    RAND()  ib_udf       , 
    ""       . 
    ,   select rand() from testtable  rand   
     ~500 .
   GetRandom    ,       .
  
  WHY these functions were implemented.
  seems that IB RAND() function from ib_udf takes it's value from current time.
  But milliseconds is not used. That's why "random" values does not change if generated
  in 1 second interval. If you want to see this behavior, execure query:
    select RAND() from rdb$relations
  In my tests such query, but on real table, returned packets of ~500 equal
  "random" numbers.
  Function GetRandom have no such limitation, and returns different values on each call.

  }



{ DECLARE EXTERNAL FUNCTION GETRANDOM
   INTEGER RETURNS DOUBLE PRECISION BY VALUE
  ENTRY_POINT 'GetRandom'  MODULE_NAME 'RANDOMUDF.DLL' }

function GetRandom(var Range: integer): double; cdecl; export;
 begin
  if Range = 0 then
   Result:=Random
  else
   Result:=Random(Range);
 end;

{ DECLARE EXTERNAL FUNCTION SETRANDSEED
   INTEGER RETURNS INTEGER BY VALUE
  ENTRY_POINT 'SetRandSeed'  MODULE_NAME 'RANDOMUDF.DLL' }

function SetRandSeed(var Value: integer): integer; cdecl; export;
 begin
  RandSeed:=Value;
  Result:=Value;
 end;

{ DECLARE EXTERNAL FUNCTION INITRANDOM
   RETURNS INTEGER BY VALUE
  ENTRY_POINT 'InitRandom'  MODULE_NAME 'RANDOMUDF.DLL' }

function InitRandom: integer; cdecl; export;
 begin
  Randomize;
  Result:=0;
 end;

{ DECLARE EXTERNAL FUNCTION RANDOMSTR
   INTEGER, INTEGER, CSTRING(16000)   
  RETURNS PARAMETER 3
   ENTRY_POINT 'RandomStr'  MODULE_NAME 'RANDOMUDF.DLL' }

procedure RandomStr(var MinLen, MaxLen: Integer; CString: PChar); cdecl; export;
var
 i, r: integer;
{ s: ShortString;}
begin
  r:=Random(MaxLen - MinLen) + MinLen;
  for i:=0 to r-1 do
   CString[i]:=char(Random(63)+192); {     }
  CString[r] := #0;
end;


{ DECLARE EXTERNAL FUNCTION RANDOMSTRE
   INTEGER, INTEGER, CSTRING(16000)   
  RETURNS PARAMETER 3
   ENTRY_POINT 'RandomStrE'  MODULE_NAME 'RANDOMUDF.DLL' }

procedure RandomStrE(var MinLen, MaxLen: Integer; CString: PChar); cdecl; export;
var
 i, r: integer;
 c: char;
begin
  r:=Random(MaxLen - MinLen) + MinLen;
  for i:=0 to r-1 do
   begin
    repeat
     c:=char(Random(58)+65);
    until not (c in [#91..#96]);
    CString[i]:=c; { only latin characters + spec. symbols }
   end;
  CString[r] := #0;
end;



exports
 GetRandom,
 SetRandSeed,
 InitRandom,
 RandomStr,
 RandomStrE;

begin
 isMultiThread:=True;
end.
