
/* russian (1251) -    randomudf     */
/* english        - usage examples and declaring functions from RandomUDF */

DECLARE EXTERNAL FUNCTION GETRANDOM
  INTEGER 
RETURNS 
  DOUBLE PRECISION BY VALUE
ENTRY_POINT 'GetRandom'  MODULE_NAME 'randomudf' 

DECLARE EXTERNAL FUNCTION SETRANDSEED
  INTEGER 
RETURNS 
  INTEGER BY VALUE
ENTRY_POINT 'SetRandSeed'  MODULE_NAME 'randomudf'

DECLARE EXTERNAL FUNCTION INITRANDOM
RETURNS 
  INTEGER BY VALUE
ENTRY_POINT 'InitRandom'  MODULE_NAME 'randomudf'

DECLARE EXTERNAL FUNCTION RANDOMSTR
  INTEGER, INTEGER, CSTRING(16000)   
RETURNS PARAMETER 3
ENTRY_POINT 'RandomStr'  MODULE_NAME 'randomudf' 

DECLARE EXTERNAL FUNCTION RANDOMSTRE
  INTEGER, INTEGER, CSTRING(16000)   
RETURNS PARAMETER 3
ENTRY_POINT 'RandomStrE'  MODULE_NAME 'randomudf'

/*   */
/* examples */

/*      0  9 */
/* get random numbers from 0 to 9 */
SELECT GetRandom(10) FROM MYTABLE

/*      1  10 */
/* get random numbers from 1 to 10 */
SELECT GetRandom(10)+1 FROM MYTABLE


/*     0  99   */
/* insert record with random values from 0 to 99 */

INSERT INTO MYTABLE (CLIENT_ID) VALUES (GetRandom(100));


/*  RandSeed  100.  
 GetRandom       
,     
SetRandSeed */

/* setting randseed to 100. After that
GetRandom calls will return the same
random sequence (re-initiated by SetRandSeed call
with the same value)  */

SELECT SetRandSeed(100) FROM RDB$DATABASE


/*  RandSeed  .
  -  SetRandSeed(getRandom(100000)) */
/* set RandSeed to random initial number.
the same can be emulated by calling SetRandSeed(getRandom(100000)) */

SELECT InitRandom() from RDB$DATABASE


/*      10  30 . 
..  RandomStr 
 ,   DatabaseExplorer   
 MEMO.   ,  RandomStr  
 CHAR  VARCHAR  */

/* get random strings with length from 10 to 30 characters.
RandomStr returns long string, so it will be shown
in Database Explorer as MEMO field. This can be ignored,
because RandomStr can be set to CHAR or VARCHAR fields of any
length */

SELECT RandomStr(10, 30) FROM MYTABLE


/*    -    Blob.
     StrBlob  FreeUDFLib.
(       http://ib.demo.ru)

  blob         
DECLARE VARIABLE TEMP BLOB;

,        1  8:
TEMP=F_StrBlob(RandomStr(1024, 8192));

      TEMP  :
INSERT INTO MYTABLE (MYBLOB) VALUES (:TEMP) */


/* last sample - generating random BLOB data.
This can be done only with StrBlob UDF from FreeUDFLib (www.webinterbase.com).

at first BLOB variable must be declared in procedure or trigger:
DECLARE VARIABLE TEMP BLOB;

Next, set this variable with random data, for example, from 1 to 8 K length:
TEMP=F_StrBlob(RandomStr(1024, 8192));

Than TEMP variable can be used for inserting data:
INSERT INTO MYTABLE (MYBLOB) VALUES (:TEMP) */



