#
# Trigger definition template file.  The replication
# manager will perform the following substitutions:
# 
#  @@table@@    - table name
#  @@action@@   - INSERT/UPDATE/DELETE
#  @@context@@  - new/old
#  @@op@@       - I/U/D
#  @@tablekey@@ - Column name of table's unique integer key
#  @@username@@ - Database User Name used to log into Source DB
# 
# The remaining non-comment text will be passed unchanged.
#
#  Comments to this file must have # in the 1st character of the line
#  Double Quotes (") must be used to indicate character strings 
#  (i.e. DO NOT USE SINGLE QUOTES (') in this file
#
create trigger @@table@@_@@action@@_REPL FOR @@table@@
after @@action@@ as
begin
  if( USER <> "@@username@@" ) then
  begin
    insert into changes(TableKey,TableName,Op,Loc_ID)
      select @@context@@.@@tablekey@@,"@@table@@","@@op@@",loc_id
      from repl_tables where TableName="@@table@@";
  end
end

