unit rmgr1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Buttons, ExtCtrls, OpenDB, RmgrSQL, DB, DBTables,
  DualDlg, DBEdit, Bde, IniFiles, Menus;

const
  VERSION = 'IBRM-T0.2';

  CHANGES_INSERT
    = 'insert into changes(TableKey,TableName,Op,Loc_ID)';
  LOCATION_ID_FIELD
    = 'loc_id';
  LOCATION_SELECT
    = 'from repl_tables where TableName=';

  IB_SMALLINT = 7;
  IB_INTEGER  = 8;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Edit1: TEdit;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    ColSrcList: TListBox;
    ColDstList: TListBox;
    Label2: TLabel;
    Label3: TLabel;
    ColModBtn: TButton;
    ColSaveBtn: TButton;
    ColCancelBtn: TButton;
    TriggerMemo: TMemo;
    TrigSaveBtn: TButton;
    TrigCancelBtn: TButton;
    SourceDB: TDatabase;
    QuerySource: TQuery;
    ReplDB: TDatabase;
    QueryRepl: TQuery;
    SaveDialog1: TSaveDialog;
    Label6: TLabel;
    DBSrcList: TListBox;
    Label4: TLabel;
    Label5: TLabel;
    DBDstList: TListBox;
    Button1: TButton;
    DbModBtn: TButton;
    DbSaveBtn: TButton;
    DbCancelBtn: TButton;
    TabSheet4: TTabSheet;
    EventMemo: TMemo;
    CheckBox1: TCheckBox;
    EvntCancelBtn: TButton;
    EvntSaveBtn: TButton;
    Panel3: TPanel;
    Label1: TLabel;
    TableListBox: TComboBox;
    Button2: TButton;
    Label7: TLabel;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    BtnDBOpen: TButton;
    BtnDBClose: TButton;
    PopupMenu2: TPopupMenu;
    Authors1: TMenuItem;
    MainMenu1: TMainMenu;
    Help1: TMenuItem;
    About1: TMenuItem;
    procedure BtnDBOpenClick(Sender: TObject);
    procedure BtnDBCloseClick(Sender: TObject);
    procedure ColCancelBtnClick(Sender: TObject);
    procedure ColSaveBtnClick(Sender: TObject);
    procedure TrigSaveBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TableListBoxChange(Sender: TObject);
    procedure ColModBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DbModBtnClick(Sender: TObject);
    procedure DbCancelBtnClick(Sender: TObject);
    procedure DbSaveBtnClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure EvntSaveBtnClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Authors1Click(Sender: TObject);
  private
    { Private declarations }
    procedure DispErrorMsg( E : EDBEngineError );
    function CountReplTables: Integer;
    procedure SetupReplTables;
    function GetWorkingPath: string;
    procedure InitDstFields(TableName: string);
    procedure InitSrcFields(TableName: String );
    procedure InitTableList;
    procedure InitDbList(TableName: string);
    procedure StoreStmt( Stmt : TStringList; TableName : String; Op : Char);
    procedure BuildTriggers( Fields: TStrings; Table: string; Path: string);
    procedure AddTrigger( Fields : TStrings; Table : string; Op : string;
      TrigTemp: TStringList );
    procedure DropTrigger( Table : string; Op : string; TrigTemp: TStringList );
    procedure AddEventTrigger;
    procedure DropEventTrigger;
    function VerifyIntegerCol(ColName: String; TableName: String): boolean;
    function getFirstSelected( List: TCustomListBox ): Integer;
    procedure GetTrigTemplate( var TrigTemp: TStringList );
    function GetTrigName(TrigLine: string): string;
    function CheckTrigExists( TrigName: string ): boolean;
    function ChangeTrigToAlter( TrigLine: string): string;
    procedure ApplyTrigToDB( TrigLines: TStrings );
    procedure SaveSourceDB(DBPath: string; UserName: string; Password: string);
  public
    { Public declarations }
    ReplTable : string[32];
    ReplFields : TStrings;
  end;

var
  Form1: TForm1;
  TableList : TStringList;
  FieldList : TStringList;
  DBList: TStringList;
  UserName: string[50];
  WorkingPath: string[255];

implementation

uses DelDb, AppTrig, DBSetup;

{$R *.DFM}

procedure TForm1.DispErrorMsg( E: EDBEngineError );
var
  i: Integer;
  S : string[100];
begin
  for i := 0 to E.ErrorCount-1 do
  begin
    if( E.Errors[i].NativeError <> 0 ) then
      MessageDlg(E.Errors[i].Message, mtInformation, [mbOK], 0 );
  end;
end;
procedure TForm1.BtnDBOpenClick(Sender: TObject);
var
  AliasParams: TStringList;
begin
  { Prompt for db to open }
  if( OpenDBDlg.ShowModal = mrOK ) then
  begin
    Edit1.Text := OpenDBDlg.DBPath;

    if( OpenDBDlg.DBPath <> '') then
    begin
      { open the db }
      with SourceDB do
      begin
        Close;
        Params.Clear;
        Params.Add('SERVER NAME='+OpenDBDlg.DBPath);
        Params.Add('USER NAME='+OpenDBDlg.UserName);
        Params.Add('OPEN MODE=READ/WRITE');
        Params.Add('SCHEMA CACHE SIZE=8');
        Params.Add('SQLPASSTHRU MODE=SHARED NOAUTOCOMMIT');
        Params.Add('SCHEMA CACHE TIME=-1');
        Params.Add('MAX ROWS=-1');
        Params.Add('BATCH COUNT=200');
        Params.Add('ENABLE SCHEMA CACHE=FALSE');
        Params.Add('ENABLE BCD=FALSE');
        Params.Add('PASSWORD='+OpenDBDlg.Password);

        try
          Open;
        except
          on E1: EDBEngineError do
          begin
            ShowMessage('Cannot open DB: ' + OpenDBDlg.DBPath);
            DispErrorMsg(E1);
          end;
        end;
      end;

      { Verify the selected db has the necessary replication tables }
      if( CountReplTables > 0 ) then
      begin
        SaveSourceDB(OpenDBDlg.DBPath, OpenDBDlg.UserName, OpenDBDlg.Password );
        UserName := OpenDBDlg.UserName;
        InitTableList;
        TableListBox.ItemIndex := 0;
      end else begin
        SetupDB.Label1.Caption := OpenDBDlg.DBPath; 
        if( SetupDB.ShowModal = mrOK ) then
        begin
          SetupReplTables;
          SaveSourceDB(OpenDBDlg.DBPath, OpenDBDlg.UserName, OpenDBDlg.Password );
          UserName := OpenDBDlg.UserName;
          InitTableList;
          TableListBox.ItemIndex := 0;
        end else
          SourceDB.Close;
      end;
    end;
  end;
end;

procedure TForm1.SetupReplTables;
begin
  with QuerySource do
  begin
    try
      SourceDB.StartTransaction;
      SQL.Clear;
      SQL.Add('create table changes(');
      SQL.Add('CHANGECODE INTEGER Not Null,');
      SQL.Add('TABLENAME VARCHAR(32) Not Null,');
      SQL.Add('TABLEKEY INTEGER Not Null,');
      SQL.Add('OP CHAR(1) Not Null,');
      SQL.Add('LOC_ID INTEGER Not Null)');
      ExecSQL;
    
      SQL.Clear;
      SQL.Add('grant select, insert on changes to public');
      ExecSQL;

      SQL.Clear;
      SQL.Add('create table repl_tables(');
      SQL.Add('TABLENAME VARCHAR(32) Not Null,');
      SQL.Add('LOC_ID INTEGER Not Null)');
      ExecSQL;

      SQL.Clear;
      SQL.Add('grant select on repl_tables to public');
      ExecSQL;

      SQL.Clear;
      SQL.Add('create generator gen_changecode');
      ExecSQL;

      SQL.Clear;
      SQL.Add('create trigger insert_changes for changes');
      SQL.Add('before insert as');
      SQL.Add('begin');
      SQL.Add('  new.ChangeCode = gen_id( gen_changecode, 1 );');
      SQL.Add('end');
      ExecSQL;

      SourceDB.Commit;
    except
      on E1: EDBEngineError do
      begin
        ShowMessage('Cannot Setup DB for Replication');
        DispErrorMsg(E1);
        if( SourceDB.inTransaction ) then
          SourceDB.Rollback;
      end;
    end;
  end;
end;

procedure TForm1.SaveSourceDB(DBPath: string; UserName: string; Password: string);
begin
  with QueryRepl do
  begin
    SQL.Clear;
    SQL.Add('delete from source_location');

    ReplDB.StartTransaction;
    ExecSQL;

    SQL.Clear;
    SQL.Add('insert into source_location( source_path, username, passwd )');
    SQL.Add('values( :sp, :u, :p )');
    Params[0].AsString := DBPath;
    Params[1].AsString := UserName;
    Params[2].AsString := Password;

    ExecSQL;
    ReplDB.Commit;
  end;
end;

function TForm1.CountReplTables: Integer;
var
  Count: Integer;
begin
  Count := 0;
  { Select the special replication table names from the metadata }
  with QuerySource do
  begin
    SQL.Clear;
    SQL.Add('Select RDB$RELATION_NAME FROM');
    SQL.Add('RDB$RELATIONS WHERE');
    SQL.Add('RDB$RELATION_NAME = "CHANGES"');
    SQL.Add('OR RDB$RELATION_NAME = "REPL_TABLES"');

    SourceDB.StartTransaction;
    Open;
    While Not EOF do
    begin
      Next;
      inc(Count);
    end;
    Close;
    SourceDB.Commit;
  end;

  CountReplTables := Count;
end;

procedure TForm1.InitTableList;
begin
  { Set Up Table List Box }
  TableList.Clear;
  with QuerySource do
  begin
    SQL.Clear;
    SQL.Add('Select RDB$RELATION_NAME FROM');
    SQL.Add('RDB$RELATIONS WHERE');
    SQL.Add('RDB$SYSTEM_FLAG <> 1');
    SQL.Add('AND RDB$VIEW_BLR IS NULL');
    SQL.Add('AND RDB$RELATION_NAME <> "CHANGES"');
    SQL.Add('AND RDB$RELATION_NAME <> "REPL_TABLES"');
    SQL.Add('ORDER BY RDB$RELATION_NAME');
    SourceDB.StartTransaction;
    Open;
    While Not   EOF do
    begin
      TableList.Add(Fields[0].AsString);
      Next;
    end;
    Close;
  end;
  SourceDB.Commit;

  TableListBox.Items := TableList;
  TableListBox.Sorted := True;
end;

procedure TForm1.InitSrcFields( TableName: string );
var
  i: Integer;
begin
  { Set Up Field List Box }
  FieldList.Clear;
  with QuerySource do
  begin
    SQL.Clear;
    { Get the fields that are not computed and not arrays}
    SQL.Add('Select RF.RDB$FIELD_NAME FROM');
    SQL.Add('RDB$RELATION_FIELDS RF LEFT JOIN RDB$FIELDS F');
    SQL.Add('ON RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME WHERE');
    SQL.Add('RDB$RELATION_NAME = :TABLENAME');
    SQL.Add('AND F.RDB$COMPUTED_BLR IS NULL');
    SQL.Add('AND F.RDB$DIMENSIONS IS NULL');

    {Don't select those fields currently selected }
    for i := 0 to ColDstList.Items.Count - 1 do
    begin
      SQL.Add('AND RF.RDB$FIELD_NAME <> "'+ColDstList.Items[i]+'"');
    end;

    SQL.Add('ORDER BY RF.RDB$FIELD_NAME');
    Params[0].AsString := TableName;
    SourceDB.StartTransaction;
    Open;
    While Not EOF do
    begin
      FieldList.Add(Fields[0].AsString);
      Next;
    end;
    Close;
  end;
  SourceDB.Commit;

  ColSrcList.Clear;
  ColSrcList.Items := FieldList;
  ColSrcList.Sorted := True;
end;

procedure TForm1.InitDstFields(TableName: string);
var
  stmt: string[255];
  field: string[32];
  StartPos, CommaPos, EndPos: Integer;
  SelectFound, FromFound: boolean;
begin
  ColDstList.Clear;
  with QueryRepl do
  begin
    SQL.Clear;
    { Get the fields including in any existing REPLDEFS entry}
    SQL.Add('Select SQLSTMT FROM REPLDEFS WHERE');
    SQL.Add('TABLENAME = :TABLENAME');
    SQL.Add('AND OPTYPE = "S"');
    SQL.Add('ORDER BY MORE');
    Params[0].AsString := TableName;
    ReplDB.StartTransaction;
    Open;

    SelectFound := False;
    FromFound := False;

    While ((not EOF) and (not FromFound)) do
    begin
      { Parse out the column names from the SQLSTMT }
      stmt := Fields[0].AsString;
      if( not SelectFound ) then
      begin
        { remove select keyword + blank }
        System.Delete(stmt, 1, 7);
        SelectFound := True;
      end;

      { stop either at the FROM or end of line }
      EndPos := Pos('FROM',stmt);
      if( EndPos = 0 ) then
        EndPos := length(stmt)
      else begin
        FromFound := True;
        dec(EndPos);
      end;

      while EndPos > 0 do
      begin
        CommaPos := Pos(',',stmt);
        if(CommaPos = 0) then
          CommaPos := EndPos;

        field := Copy(stmt, 1, CommaPos - 1 );
        ColDstList.Items.Add(field);

        System.Delete(stmt, 1, CommaPos );
        EndPos := EndPos - CommaPos;
      end;

      if( not FromFound ) then
        Next;
    end;
    ReplDB.Commit;
    Close;
  end;
end;

procedure TForm1.InitDbList(TableName: string);
var
  i: Integer;
  DstDbIds: TStringList;
  DstFound: boolean;
begin
  DstDbIds := TStringList.Create;
  DbDstList.Clear;

  with QuerySource do
  begin
    SQL.Clear;
    SQL.Add('Select LOC_ID FROM REPL_TABLES');
    SQL.Add('WHERE TABLENAME = :TABLENAME');
    SQL.Add('ORDER BY LOC_ID');
    Params[0].AsString := TableName;
    SourceDB.StartTransaction;
    Open;
    While Not   EOF do
    begin
      DstDbIds.Add(Fields[0].AsString);
      Next;
    end;
    Close;
  end;
  SourceDB.Commit;

  DbList.Clear;
  with QueryRepl do
  begin
    SQL.Clear;
    SQL.Add('Select LOC_ID,LOC_PATH FROM LOCATIONS');
    SQL.Add('ORDER BY LOC_ID');
    ReplDB.StartTransaction;
    Open;
    While Not EOF do
    begin
      DstFound := False;
      for i := 0 to DstDbIds.Count-1 do
      begin
        if( CompareStr(DstDbIds[i],Fields[0].AsString) = 0 ) then
        begin
          DstFound := True;
          Break;
        end;
      end;

      if( DstFound ) then
        DbDstList.Items.Add(Fields[0].AsString + ',' + Fields[1].AsString)
      else
        DbList.Add(Fields[0].AsString + ',' + Fields[1].AsString);

      Next;
    end;
    Close;
  end;
  ReplDB.Commit;


  DbSrcList.Clear;
  DbSrcList.Items := DbList;
  DbSrcList.Sorted := True;

  DstDbIds.Free;
end;

procedure TForm1.TableListBoxChange(Sender: TObject);
var
  Index: Integer;
begin
  Index := TableListBox.ItemIndex;
  ReplTable := TableListBox.Items.Strings[ Index ];
  InitDstFields( ReplTable );
  InitSrcFields( ReplTable );
  if( ColDstList.Items.Count > 0 ) then
    BuildTriggers( ColDstList.Items, ReplTable, Edit1.Text )
  else
    TriggerMemo.Clear;

  InitDbList( ReplTable );
end;

procedure TForm1.BtnDBCloseClick(Sender: TObject);
begin
  SourceDB.Close;
end;

procedure TForm1.ColCancelBtnClick(Sender: TObject);
begin
  ColDstList.Clear;
  ColSrcList.Clear;
  TableListBox.ItemIndex := 0;
  TriggerMemo.Clear;
end;

procedure TForm1.ColSaveBtnClick(Sender: TObject);
var
  Stmt :  TStringList;
  Index : Integer;
begin
  Stmt := TStringList.Create;
  Index := TableListBox.ItemIndex;
  ReplFields := ColDstList.Items;

  RmgrSQL.BuildSelect( ReplFields,
    ReplTable, Stmt );
  StoreStmt( Stmt, TableListBox.Items.Strings[Index], 'S');
  Stmt.Clear;

  RmgrSQL.BuildInsert( ColDstList.Items, TableListBox.Items.Strings[ Index ], Stmt );
  StoreStmt( Stmt, TableListBox.Items.Strings[Index], 'I');
  Stmt.Clear;
  RmgrSQL.BuildUpdate( ColDstList.Items,
    TableListBox.Items.Strings[ Index ], Stmt );
  StoreStmt( Stmt, TableListBox.Items.Strings[Index], 'U');
  Stmt.Clear;
  RmgrSQL.BuildDelete( ColDstList.Items,
    TableListBox.Items.Strings[ Index ], Stmt );
  StoreStmt( Stmt, TableListBox.Items.Strings[Index], 'D');
  Stmt.Free;

  BuildTriggers( ColDstList.Items, ReplTable, Edit1.Text );
end;

procedure TForm1.StoreStmt ( Stmt : TStringList; TableName : string; Op : Char);
var
  More, I : SmallInt;
begin
  with QueryRepl do
  begin
    SQL.Clear;
    SQL.Add('Delete FROM REPLDEFS ');
    SQL.Add('WHERE TABLENAME = :TABLENAME AND');
    SQL.Add('OpType = :OP');

    Params[0].AsString := TableName;
    Params[1].AsString := Op;

    ReplDB.StartTransaction;
    ExecSQL;

    if( Stmt.Count > 1 ) then
      More := 1
    else
      More := 0;

    for I := 0 to (Stmt.Count - 1) do
    begin
      SQL.Clear;
      SQL.Add('INSERT INTO REPLDEFS(');
      SQL.Add('TABLENAME,OpType,SQLStmt,More) VALUES (');
      SQL.Add(':TABLENAME,:OPERATION,:STMT, :MORE)');

      Params[0].AsString := TableName;
      Params[1].AsString := Op;
      Params[2].AsString := Stmt[I];
      Params[3].AsInteger := More + I;

      ExecSQL;
    end;
  end;

  ReplDB.Commit;
end;

procedure TForm1.BuildTriggers( Fields : TStrings; Table : string;
  Path : string);
var
  Op : string[6];
  TrigTemplate : TStringList;
begin
  TrigTemplate := TStringList.Create;
  GetTrigTemplate( TrigTemplate );

  With TriggerMemo do
  begin
    Clear;

    Lines.Add('connect "' + Path + '";');
    Lines.Add('');

    Lines.Add('set term ^^;');
    Lines.Add('');

    if( Fields.Count > 0 ) then
    begin
      Op := 'DELETE';
      AddTrigger( Fields, Table, Op, TrigTemplate );
      Lines.Add('^^');

      Op := 'INSERT';
      AddTrigger( Fields, Table, Op, TrigTemplate );
      Lines.Add('^^');

      Op := 'UPDATE';
      AddTrigger( Fields, Table, Op, TrigTemplate );
      Lines.Add('^^');
    end else
    begin
      Op := 'INSERT';
      DropTrigger( Table, Op, TrigTemplate );
      Lines.Add('^^');

      Op := 'UPDATE';
      DropTrigger( Table, Op, TrigTemplate );
      Lines.Add('^^');

      Op := 'DELETE';
      DropTrigger( Table, Op, TrigTemplate );
      Lines.Add('^^');
    end;

    Lines.Add('set term ;^^');
  end;
  TrigTemplate.Free;
end;

procedure TForm1.GetTrigTemplate( var TrigTemp: TStringList );
var
  F: TextFile;
  S: string;
begin
  TrigTemp.Clear;

  AssignFile(F, WorkingPath+'\repltrig.sql');
  Reset(F);
  Readln(F, S);

  while( not Eof(F) ) do
  begin
    if(length(S) > 0) then
    begin
      if(S[1] <> '#') then
      begin
        TrigTemp.Add(S);
      end;
    end;

    Readln(F,S);
  end;
  CloseFile(F);

{    Add('create trigger @@table@@_@@action@@_REPL FOR @@table@@');
    Add('after @@action@@ as');
    Add('begin');
    Add('  if USER <> SYSDBA then');
    Add('  begin');
    Add('    insert into changes(TableKey,TableName,Op,Loc_ID)');
    Add('      select @@context@@.@@tablekey@@,"@@table@@","@@op@@",loc_id');
    Add('      from repl_tables where TableName="@@table@@";');
    Add('  end');
    Add('end^^');
  end;      }
end;

procedure TForm1.AddTrigger( Fields: TStrings; Table: string; Op: string; TrigTemp: TStringList );
var
  OutTrig : string[80];
  TempLine: string[80];
  context : string[4];
  i, StartPos, EndPos: Integer;
  Token: string[32];
  TrigName: string[32];
begin
  if( Op = 'DELETE' ) then
    context := 'old'
  else
    context := 'new';

  for i := 0 to TrigTemp.Count-1 do
  begin
    TempLine := TrigTemp[i];
    StartPos := Pos('@@',TempLine);
    OutTrig := '';
    while( StartPos > 0 ) do
    begin
      OutTrig := OutTrig + Copy(TempLine, 1, StartPos - 1);
      Delete(TempLine,1,StartPos+1);
      EndPos := Pos('@@',TempLine);
      Token := Copy( TempLine, 1, EndPos-1);
      Delete(TempLine,1,EndPos+1);
      StartPos := Pos('@@',TempLine);

      if( CompareText(Token,'table') = 0 ) then
        OutTrig := OutTrig + Table
      else if( CompareText(Token,'action') = 0 ) then
        OutTrig := OutTrig + Op
      else if( CompareText(Token,'context') = 0 ) then
        OutTrig := OutTrig + context
      else if( CompareText(Token,'tablekey') = 0 ) then
        OutTrig := OutTrig + Fields.Strings[0]
      else if( CompareText(Token,'op') = 0 ) then
        OutTrig := OutTrig + Op[1]
      else if( CompareText(Token,'username') = 0 ) then
        OutTrig := OutTrig + UserName;
    end;

    OutTrig := OutTrig + TempLine;

    if( Pos('CREATE', AnsiUpperCase(OutTrig)) > 0 ) then
    begin
      TrigName := GetTrigName( OutTrig );
      if( CheckTrigExists( TrigName ) ) then
        OutTrig := ChangeTrigToAlter( OutTrig );
    end;

    TriggerMemo.Lines.Add(OutTrig);
  end;

{    With TriggerMemo do
    begin
    OutTrig := 'create trigger ' + Table + '_' + Op + '_REPL FOR ' + Table;
    Lines.Add( OutTrig);
    OutTrig := 'after ' + Op + ' as';
    Lines.Add( OutTrig );
    Lines.Add( 'begin' );
    OutTrig := CHANGES_INSERT;
    Lines.Add( '  ' + OutTrig );
    OutTrig := 'select ' + context + '.' + Fields.Strings[0] + ',"' + Table + '"'
       + ',"' + Op[1] + '",' + LOCATION_ID_FIELD;
    Lines.Add( '    ' + OutTrig );
    OutTrig := LOCATION_SELECT + '"' + Table + '"' + ';';
    Lines.Add( '    ' + OutTrig );
    Lines.Add( 'end^^' );
  end;   }
end;

procedure TForm1.DropTrigger( Table : string; Op : string; TrigTemp: TStringList );
var
  OutTrig : string[80];
  TempLine: string[80];
  i, StartPos, EndPos: Integer;
  Token: string[32];
  TrigName: string[32];
begin
  for i := 0 to TrigTemp.Count-1 do
  begin
    TempLine := TrigTemp[i];
    StartPos := Pos('@@',TempLine);
    OutTrig := '';
    while( StartPos > 0 ) do
    begin
      OutTrig := OutTrig + Copy(TempLine, 1, StartPos - 1);
      Delete(TempLine,1,StartPos+1);
      EndPos := Pos('@@',TempLine);
      Token := Copy( TempLine, 1, EndPos-1);
      Delete(TempLine,1,EndPos+1);
      StartPos := Pos('@@',TempLine);

      if( CompareText(Token,'table') = 0 ) then
        OutTrig := OutTrig + Table
      else if( CompareText(Token,'action') = 0 ) then
        OutTrig := OutTrig + Op
      else if( CompareText(Token,'op') = 0 ) then
        OutTrig := OutTrig + Op[1]
      else if( CompareText(Token,'username') = 0 ) then
        OutTrig := OutTrig + UserName;
    end;

    OutTrig := OutTrig + TempLine;

    if(Pos('CREATE',AnsiUpperCase(OutTrig)) > 0 ) then
    begin
      TriggerMemo.Lines.Add('DROP TRIGGER '+ GetTrigName(OutTrig));
      break;
    end;
  end;
end;

procedure TForm1.TrigSaveBtnClick(Sender: TObject);
begin
  SaveDialog1.Execute;
  if(SaveDialog1.FileName <> '' ) then
    TriggerMemo.Lines.SaveToFile(SaveDialog1.FileName);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  TableList := TStringList.Create;
  FieldList := TStringList.Create;
  DBList := TStringList.Create;

  WorkingPath := GetWorkingPath;

  if( Length(WorkingPath) > 0 ) then
  begin
    with ReplDB do
    begin
      Close;
      Params.Clear;
      Params.Add('SERVER NAME='+WorkingPath+'\REPLICATE.GDB');
      Params.Add('OPEN MODE=READ/WRITE');
      Params.Add('SCHEMA CACHE SIZE=8');
      Params.Add('SQLPASSTHRU MODE=SHARED NOAUTOCOMMIT');
      Params.Add('SCHEMA CACHE TIME=-1');
      Params.Add('MAX ROWS=-1');
      Params.Add('BATCH COUNT=200');
      Params.Add('ENABLE SCHEMA CACHE=FALSE');
      Params.Add('ENABLE BCD=FALSE');

      try
        Open;
      except
        on E1: EDBEngineError do
        begin
          ShowMessage('Cannot open DB: ' + WorkingPath + '\REPLICATE.GDB');
          DispErrorMsg(E1);
          Application.Terminate;
        end;
      end;
    end;
  end else
    Application.Terminate;
end;

function TForm1.GetWorkingPath: string;
var
  IniFile: TIniFile;
  WPaths: TStringList;
  Path: string[255];
begin
  WPaths := TStringList.Create;
  IniFile := TIniFile.Create('REPL.INI');

  Path := IniFile.ReadString('ReplMgmt', 'Path', 'BOGER');
  if( CompareStr(Path,'&^BOGER**') = 0 ) then
  begin
    ShowMessage('REPL.INI invalid or not found');
    Path := '';
  end else begin
    Path := Trim(Path);
    if( Path[Length(Path)] = '\' ) then
      Delete(Path, Length(Path), 1 );
  end;

  GetWorkingPath := Path;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  TableList.Free;
  FieldList.Free;
  DBList.Free;
  SourceDB.Close;
  ReplDB.Close;
end;

procedure TForm1.ColModBtnClick(Sender: TObject);
begin
  DualListDlg.SrcList.Items := ColSrcList.Items;
  DualListDlg.SrcLabel.Caption := 'Columns';
  DualListDlg.DstList.Items := ColDstList.Items;
  DualListDlg.DstLabel.Caption := 'Replicated Columns';
  if(DualListDlg.ShowModal = mrOK) then
  begin
    if(DualListDlg.DstList.Items.Count > 0 ) then
    begin
      if(VerifyIntegerCol(DualListDlg.DstList.Items.Strings[0], ReplTable)) then
      begin
        ColSrcList.Items := DualListDlg.SrcList.Items;
        ColDstList.Items := DualListDlg.DstList.Items;
      end else
        ShowMessage(DualListDlg.DstList.Items.Strings[0] + ' is not an Integer!');
    end else
    begin
      ColSrcList.Items := DualListDlg.SrcList.Items;
      ColDstList.Items := DualListDlg.DstList.Items;
    end;
  end;
end;

function TForm1.VerifyIntegerCol(ColName: String; TableName: String): boolean;
var
  IsInteger: boolean;
begin
  IsInteger := False;

  with QuerySource do
  begin
    SQL.Clear;
    { Get the fields that are not computed }
    SQL.Add('Select F.RDB$FIELD_TYPE FROM');
    SQL.Add('RDB$RELATION_FIELDS RF, RDB$FIELDS F');
    SQL.Add('WHERE RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME AND');
    SQL.Add('RF.RDB$RELATION_NAME = :TABLENAME');
    SQL.Add('AND RF.RDB$FIELD_NAME = :COLNAME');
    Params[0].AsString := TableName;
    Params[1].AsString := ColName;
    SourceDB.StartTransaction;
    Open;
    If not EOF then
    begin
      if( (Fields[0].AsInteger = IB_SMALLINT) or
          (Fields[0].AsInteger = IB_INTEGER)) then
        IsInteger := True;
    end;
    Close;
  end;
  SourceDB.Commit;

  VerifyIntegerCol := IsInteger;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  NewPath: string[255];
begin
  Form2.LocPath := 'server:[drive]\path';
  Form2.User := '';
  Form2.Password := '';
  Form2.RasServiceName := '';
  Form2.RasUser := '';
  Form2.RasPassword := '';

  if(Form2.ShowModal = mrOK) then
  begin
    with QueryRepl do
    begin
      SQL.Clear;
      { Get the fields including in any existing REPLDEFS entry}
      SQL.Add('INSERT INTO LOCATIONS (LOC_PATH, RAS_SERVICENAME, ');
      SQL.Add('RAS_USER,RAS_PASSWORD, USERNAME, PASSWD)');
      SQL.Add('VALUES(:LP, :RS, :RU, :RP, :U, :P)');
      Params[0].AsString := Form2.LocPath;
      Params[1].AsString := Form2.RasServiceName;
      Params[2].AsString := Form2.RasUser;
      Params[3].AsString := Form2.RasPassword;
      Params[4].AsString := Form2.User;
      Params[5].AsString := Form2.Password;
      
      ReplDB.StartTransaction;
      ExecSQL;
      ReplDB.Commit;

      InitDbList(ReplTable);
    end;
  end;
end;

procedure TForm1.DbModBtnClick(Sender: TObject);
begin
  DualListDlg.SrcList.Items := DbSrcList.Items;
  DualListDlg.SrcLabel.Caption := 'Databases';
  DualListDlg.DstList.Items := DbDstList.Items;
  DualListDlg.DstLabel.Caption := 'Target Databases';
  if(DualListDlg.ShowModal = mrOK) then
  begin
    DbSrcList.Items := DualListDlg.SrcList.Items;
    DbDstList.Items := DualListDlg.DstList.Items;
  end;
end;

procedure TForm1.DbCancelBtnClick(Sender: TObject);
begin
  DbSrcList.Clear;
  DbDstList.Clear;
  DbSrcList.Items := DbList;
end;

procedure TForm1.DbSaveBtnClick(Sender: TObject);
var
  i, len: Integer;
  loc_str: string[10];
begin
  with QuerySource do
  begin
    SQL.Clear;
    SQL.Add('Delete FROM REPL_TABLES ');
    SQL.Add('WHERE TABLENAME = :TABLENAME');

    Params[0].AsString := TableListBox.Items.Strings[TableListBox.ItemIndex];

    SourceDB.StartTransaction;
    ExecSQL;

    for i:= 0 to DbDstList.Items.Count - 1 do
    begin
      SQL.Clear;
      SQL.Add('INSERT INTO REPL_TABLES(');
      SQL.Add('TABLENAME, LOC_ID) VALUES (');
      SQL.Add(':TABLENAME,:LOC_ID)');

      Params[0].AsString := TableListBox.Items.Strings[TableListBox.ItemIndex];

      { parse the location id out of the path string }
      Len := Pos(',',DbDstList.Items.Strings[i]) -1;
      loc_str := Copy(DbDstList.Items.Strings[i], 0, Len);
      Params[1].AsString := loc_str;

      ExecSQL;
    end;
  end;

  SourceDB.Commit;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  if(CheckBox1.Checked = True) then
    AddEventTrigger
  else
    DropEventTrigger;
end;

procedure TForm1.AddEventTrigger;
begin
  With EventMemo do
  begin
    Clear;

    Lines.Add('connect "' + Edit1.Text + '";');
    Lines.Add('');

    Lines.Add('set term ^^;');
    Lines.Add('');

    Lines.Add('create trigger CHANGES_INSERT_REPL for CHANGES');
    Lines.Add('after insert as');
    Lines.Add('begin');
    Lines.Add('  POST_EVENT "new_change";');
    Lines.Add('end');
    Lines.Add('^^');

    Lines.Add('');
    Lines.Add('set term ;^^');
  end;
end;

procedure TForm1.DropEventTrigger;
begin
  With EventMemo do
  begin
    Clear;

    Lines.Add('connect "' + Edit1.Text + '";');
    Lines.Add('');

    Lines.Add('set term ^^;');
    Lines.Add('');

    Lines.Add('drop trigger CHANGES_INSERT_REPL');
    Lines.Add('^^');

    Lines.Add('');
    Lines.Add('set term ;^^');
  end;
end;

procedure TForm1.EvntSaveBtnClick(Sender: TObject);
begin
  SaveDialog1.Execute;
  if(SaveDialog1.FileName <> '' ) then
    EventMemo.Lines.SaveToFile(SaveDialog1.FileName);
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  x, LocId, CommaPos: Integer;
  EditDB: string[100];
begin
  EditDB := '';

  x := getFirstSelected( DBDstList );
  if( x > -1 ) then
    EditDB := DBDstList.Items[x]
  else begin
    x := getFirstSelected( DBSrcList );
    if( x > -1 ) then
      EditDB := DBSrcList.Items[x];
  end;

  if( length(EditDB) <> 0 ) then
  begin
    CommaPos := Pos(',', EditDB);
    LocId := StrToInt(Copy(EditDB, 1, CommaPos - 1));

    with QueryRepl do
    begin
      SQL.Clear;
      { Get the fields including in any existing REPLDEFS entry}
      SQL.Add('Select LOC_PATH,USERNAME,PASSWD,RAS_SERVICENAME,RAS_USER,RAS_PASSWORD ');
      SQL.Add('FROM LOCATIONS WHERE');
      SQL.Add('LOC_ID = :LOC_ID');
      Params[0].AsInteger := LocId;
      ReplDB.StartTransaction;
      Open;

      if (not EOF) then
      begin
        Form2.LocPath := Fields[0].AsString;
        Form2.User := Fields[1].AsString;
        Form2.Password := Fields[2].AsString;
        Form2.RasServiceName := Fields[3].AsString;
        Form2.RasUser := Fields[4].AsString;
        Form2.RasPassword := Fields[5].AsString;
      end;
      Close;
      ReplDB.Commit;

      if(Form2.ShowModal = mrOK) then
      begin
        SQL.Clear;
        { Get the fields including in any existing REPLDEFS entry}
        SQL.Add('UPDATE LOCATIONS SET LOC_PATH = :L,RAS_SERVICENAME =:RS,');
        SQL.Add('RAS_USER = :RU,RAS_PASSWORD = :RP, USERNAME = :U, PASSWD = :P');
        SQL.Add('WHERE LOC_ID = :LOC_ID');
        Params[0].AsString := Form2.LocPath;
        Params[1].AsString := Form2.RasServiceName;
        Params[2].AsString := Form2.RasUser;
        Params[3].AsString := Form2.RasPassword;
        Params[4].AsString := Form2.User;
        Params[5].AsString := Form2.Password;
        Params[6].AsInteger := LocId;
        ReplDB.StartTransaction;
        ExecSQL;
        ReplDB.Commit;

        InitDbList(ReplTable);
      end;
    end;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  x, Len: Integer;
  loc_str: string[10];
  DelDB: string[100];
begin
  DelDB := '';

  { get the selected db path }
  x := getFirstSelected( DBDstList );
  if( x > -1 ) then
    DelDB := DBDstList.Items[x]
  else begin
    x := getFirstSelected( DBSrcList );
    if( x > -1 ) then
      DelDB := DBSrcList.Items[x];
  end;

  { if one's selected, confirm choice }
  if( length(DelDB) > 0) then
  begin
    DelDbDlg.DBPath := DelDB;
    if( DelDbDlg.ShowModal = mrOK ) then
    begin
      { parse out the location id }
      Len := Pos(',',DelDB) -1;
      loc_str := Copy(DelDB, 0, Len);

      { delete any pending changes }
      with QuerySource do
      begin
        SQL.Clear;
        SQL.Add('DELETE FROM CHANGES WHERE LOC_ID = :L');
        Params[0].AsString := loc_str;

        SourceDB.StartTransaction;
        ExecSQL;
        SourceDB.Commit;
      end;

      { delete from global locations table }
      with QueryRepl do
      begin
        SQL.Clear;
        SQL.Add('DELETE FROM LOCATIONS WHERE LOC_ID = :L');
        Params[0].AsString := loc_str;

        ReplDB.StartTransaction;
        ExecSQL;
        ReplDB.Commit;
      end;

      InitDbList(ReplTable);
    end;
  end;
end;

function TForm1.getFirstSelected( List: TCustomListBox ): Integer;
var
  x: Integer;
begin
  getFirstSelected := -1;
  for x:= 0 to List.Items.Count -1 do
    if List.Selected[x] then
    begin
      getFirstSelected := x;
      Break;
    end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  if( OKTrigDlg.ShowModal = mrOK ) then
  begin
    ApplyTrigtoDB( TriggerMemo.Lines );
  end;
end;

procedure TForm1.ApplyTrigToDB( TrigLines: TStrings );
var
  inTrigger: boolean;
  i: Integer;
  UpLine: string[255];
begin
  try
    SourceDB.StartTransaction;

    QuerySource.SQL.Clear;
    inTrigger := False;

    for i := 0 to TrigLines.Count - 1 do
    begin
      if( not inTrigger ) then
      begin
        UpLine := AnsiUpperCase(TrigLines[i]);
        if( (Pos('CREATE', UpLine) > 0) or
            (Pos('ALTER', UpLine) > 0) or
            (Pos('DROP', UpLine) > 0) ) then
          inTrigger := True;
      end else if( Pos('^^', TrigLines[i] ) > 0) then
      begin
        inTrigger := False;
        QuerySource.ExecSQL;
        QuerySource.SQL.Clear;
      end;

      if( inTrigger = True ) then
        QuerySource.SQL.Add(TrigLines[i]);
    end;
    SourceDB.Commit;
  except
    on E1: EDBEngineError do
    begin
      ShowMessage('Cannot Apply Triggers to DB');
      DispErrorMsg(E1);
      if( SourceDB.inTransaction ) then
        SourceDB.Rollback;
    end;
  end;
end;

function TForm1.ChangeTrigToAlter( TrigLine: string): string;
var
  UpLine: string[255];
  StartPos: integer;
begin
  UpLine := AnsiUpperCase(TrigLine);
  StartPos := Pos('CREATE', UpLine );
  if( StartPos > 0 ) then
  begin
    Delete( UpLine, StartPos, length('CREATE') );
    StartPos := Pos('FOR', UpLine );
    Delete( UpLine, StartPos, Length(UpLine) - StartPos + 1);
    TrigLine := 'ALTER' + UpLine;
  end;

  ChangeTrigToAlter := TrigLine;
end;

function TForm1.CheckTrigExists( TrigName: string ): boolean;
begin
  with QuerySource do
  begin
    SQL.Clear;
    SQL.Add('select rdb$trigger_name from rdb$triggers where');
    SQL.Add('rdb$trigger_name = :trig');
    Params[0].AsString := TrigName;

    SourceDB.StartTransaction;
    Open;
    if( not EOF ) then
      CheckTrigExists := True
    else
      CheckTrigExists := False;

    Close;
    SourceDB.Commit;
  end;
end;

function TForm1.GetTrigName( TrigLine: string ): string;
var
  i, NameStart, NameEnd: Integer;
  TrigName: string[32];
  UpLine: string[255];
  Done: boolean;
begin
  Done := False;
  TrigName := '';

  UpLine := AnsiUpperCase(TrigLine);
  if( Pos('CREATE', UpLine ) > 0 ) then
  begin
    NameStart := Pos('TRIGGER', UpLine ) + length('TRIGGER') + 1;
    NameEnd := Pos('FOR', UpLine);
    TrigName := Copy(UpLine, NameStart, NameEnd - NameStart);
    TrigName := Trim(TrigName);
  end else if( (Pos('DROP', UpLine ) > 0) or
               (Pos('ALTER', UpLine) > 0) ) then
  begin
    NameStart := Pos('TRIGGER', UpLine) + length('TRIGGER') + 1;
    NameEnd := length(UpLine);
    TrigName := Copy(UpLine, NameStart, NameEnd - NameStart);
    TrigName := Trim(TrigName);
  end;

  GetTrigName := TrigName;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  if( OKTrigDlg.ShowModal = mrOK ) then
  begin
    ApplyTrigtoDB( EventMemo.Lines );
  end;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
  ShowMessage('Version='+VERSION);
end;

procedure TForm1.Authors1Click(Sender: TObject);
begin
  ShowMessage('Stan Dorcey and Kevin Gardeck');
end;

end.
