unit Repl;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DB, DBTables, Grids, DBGrids,DbiErrs,DbiTypes,DbiProcs,IBAPI,IBDBAPI,
  IBCtrls, Rascomp32, ExtCtrls, Menus,IniFiles;

const
  REPLEFILE  = 'c:\temp\repl.err';
  MaxBlobSize = 128000;    { This can be modified
                              modifying the INI file(BlobMaxBytes)}
  MaxColumns  = 1024;
  ChangeSelect = 'SELECT CHANGECODE,TABLENAME,TABLEKEY,OP FROM CHANGES WHERE LOC_ID = ? ORDER BY CHANGECODE';
  ChangeDelete = 'DELETE FROM CHANGES WHERE CHANGECODE = ?';
  Version = 'IBRS-T0.2';

type

  ParamRec = record
       ParamPtr    : pointer;
       NullPtr     : pointer;
       BlobSizePtr : PSDWORD;
       DataType    : SWORD;
  end;

  StmtPtr = ^StmtPtrNode;
  LocsPtr = ^LocsPtrNode;

  StmtPtrNode = record
    TableName  : array[0..32] of Char;
    Operation  : array[0..1] of Char;
    SqlStmt    : Pointer;
    Link  : StmtPtr;
  end;
  LocsPtrNode = record
    LocPath  : Pointer;
    RService : array[0..49] of Char;
    RUser    : array[0..49] of Char;
    RPass    : array[0..49] of Char;
    UserName : array[0..49] of Char;
    Password : array[0..49] of Char;
    IdLoc : Integer; { The actual Location Id }
    Link  : LocsPtr;
  end;
  HeadPtr = ^StmtPtr;
  LocsHeadPtr = ^LocsPtr;

  TForm1 = class(TForm)
    DBSource: TDatabase;
    Button1: TButton;
    QueryStmt: TQuery;
    ReplDB: TDatabase;
    QueryStmtSQLSTMT: TStringField;
    QueryLocs: TQuery;
    QueryStmtTABLENAME: TStringField;
    QueryStmtOPTYPE: TStringField;
    QueryStmtMORE: TSmallintField;
    QueryLocsLOC_PATH: TStringField;
    IBEvent: TIBEventAlerter;
    QueryLocsRAS_SERVICENAME: TStringField;
    QueryLocsRAS_USER: TStringField;
    QueryLocsRAS_PASSWORD: TStringField;
    EvSourceDB: TDatabase;
    QLocChanges: TQuery;
    QueryLocsLOC_ID: TIntegerField;
    TDoReplication: TTimer;
    TReplInterval: TTimer;
    QChanges: TQuery;
    QChangesCOUNT: TIntegerField;
    Image1: TImage;
    MainMenu1: TMainMenu;
    Options1: TMenuItem;
    Exit1: TMenuItem;
    Exit2: TMenuItem;
    Properties1: TMenuItem;
    QSrcLocs: TQuery;
    QSrcLocsSOURCE_PATH: TStringField;
    QSrcLocsUSERNAME: TStringField;
    QSrcLocsPASSWD: TStringField;
    QueryLocsUSERNAME: TStringField;
    QueryLocsPASSWD: TStringField;
    Image2: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    QLocChangesLOC_ID: TIntegerField;
    Help1: TMenuItem;
    About1: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure IBEventEventAlert(Sender: TObject; EventName: string;
      EventCount: Longint; var CancelAlerts: Boolean);
    procedure FormDestroy(Sender: TObject);
    procedure TDoReplicationTimer(Sender: TObject);
    procedure TReplIntervalTimer(Sender: TObject);
    procedure Exit2Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Properties1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    function  CacheSqlStmts:Integer;
    procedure FreeSqlStmts;
    procedure ReplicateData;
    procedure AddStmtLL(Head:HeadPtr;TableName,Operation,SqlStr:PChar);
    procedure AddLocsLL(Head:LocsHeadPtr;LocPath,RasServ,RasUser,RasPass:PChar;IdLoc :Integer;User,Passwd:PChar);
    function  SearchStmtLL(Head:StmtPtr;TableName,Operation:PChar): PChar;
    function  SearchLocsLL(Head:LocsPtr;IdLoc:Integer): LocsPtr;
    function  ConnectDb(LocId:Integer;LocPtr:LocsPtr):Integer;
    procedure DisconnectDb(IdLoc:Integer);
    procedure SyncSrcAndTarget;
    function  OpenChanges:RETCODE;
    function  DeleteChangeRec:RETCODE;
    function  GetChanges:RETCODE;
    function  SyncInsUpd:RETCODE;
    function  SyncDelete:RETCODE;
    procedure CloseChanges;
    procedure DestroyStmtLL(Head:HeadPtr);
    procedure DestroyLocsLL(Head:LocsHeadPtr);
    procedure SetParams;
    procedure HandleError(ErrorMsg:string);

  public
   ErrorFile : array[0..254] of Char;
    { Public declarations }
  end;

var
  Form1: TForm1;
  SrcPath,TargetPath,AliasName : string;
  StmtHead : StmtPtr;
  LocsHead : LocsPtr;
  CachedEm : Boolean;
  TotalLocs : Integer;
  SrcHandle,TargetHandle : HDBC;
  ChgStmt,ChgStmt2,SrcStmt,TargetStmt : HSTMT;
  ChgCode,ChgLocId,ChgTableKey  : Integer;
  ChgTableName : array[0..33] of Char;
  ChgOperation : array[0..1] of Char ;
  SomeNull1,SomeNull2,SomeNull3,SomeNull4,SomeNull5 : Boolean;
  SqlStmtPtr : PChar;
  AnyErrors,BlobMaxSize : Integer;
  Running,Reg4Event,FatalError : Boolean;
  SrcUsername,SrcPassword, SrcPathDB,TargetUser,TargetPwd :string;

implementation

uses rasform, Unit3, Unit4;

{$R *.DFM}
function TForm1.CacheSqlStmts: Integer;
var
  SqlStmts:Integer;
  TableName : array[0..32] of Char;
  Operation : array[0..1] of Char;
  SqlStr : array[0..2047] of Char;
  TmpStr, LocPath : string;
  IdLoc : Integer;

begin
  if ( not CachedEm) then
  begin
    SqlStmts := 0;
    SqlStr := '';

    if (ReplDB.InTransaction) then
      ReplDB.Commit;
    ReplDB.StartTransaction;

    QueryStmt.Open;
    QueryStmt.First;
    StrCopy(TableName,PChar(QueryStmtTABLENAME.value));
    StrCopy(Operation,PChar(QueryStmtOPTYPE.value));
    while( QueryStmt.EOF <> True ) do
    begin
      if (QueryStmtOPTYPE.value <> Operation)
          or (QueryStmtTABLENAME.value <> TableName) then
      begin
        Inc(SqlStmts);
        AddStmtLL(@(StmtHead),TableName,Operation,SqlStr);

        StrCopy(TableName,PChar(QueryStmtTABLENAME.value));
        StrCopy(Operation,PChar(QueryStmtOPTYPE.value));
        SqlStr := '';
      end;
      TmpStr := QueryStmtSQLSTMT.value;
      StrLCat(SqlStr,PChar(TmpStr),Sizeof(SqlStr)-1);
      QueryStmt.Next;
    end;
    if (TableName <> '') then
         AddStmtLL(@(StmtHead),TableName,Operation,SqlStr);
    QueryStmt.Close;

    { See how many locations we have to deal with
      and cache all the dbpaths/locid while were at it
    }

    QueryLocs.Open;
    QueryLocs.First;

    TotalLocs :=0;
    while( QueryLocs.EOF <> True ) do
    begin
      Inc(TotalLocs);
      AddLocsLL(@(LocsHead),PChar(QueryLocsLOC_PATH.value),PChar(QueryLocsRAS_SERVICENAME.value),PChar(QueryLocsRAS_USER.value),PChar(QueryLocsRAS_PASSWORD.value),QueryLocsLOC_ID.value,PChar(QueryLocsUSERNAME.value),PChar(QueryLocsPASSWD.value));
      QueryLocs.Next;
    end;
    ReplDB.Commit;
    CachedEm := True;
  end;
  CacheSqlStmts := TotalLocs;
end;

procedure TForm1.FreeSqlStmts;
begin
  DestroyStmtLL(@(StmtHead));
  DestroyLocsLL(@(LocsHead));
end;

procedure TForm1.SetParams;
var
  Len : Integer;
  TmpError : array[0..254] of Char;
  ReplIni: TIniFile;
  EvtStr : string;
  SomeNum,n1,PathLen: Integer;
  ReplPath : string;


begin
  ReplIni := TIniFile.Create('REPL.INI');
  with ReplIni do
  begin
     TReplInterval.Interval:=StrToInt(ReadString('ReplServer', 'Interval', '0'))*1000;
     EvtStr:=ReadString('ReplServer', 'EventResp', 'False');
     ReplPath:=ReadString('ReplMgmt', 'Path', 'Not Found');
     BlobMaxSize:=StrToInt(ReadString('ReplServer', 'BlobMaxBytes', IntToStr(MaxBlobSize)))
  end;
  if (StrComp('Not Found',PChar(ReplPath)) = 0) then
  begin
    ShowMessage('Cannot find REPL.INI or the ReplMgmt section is missing.  See readme.txt included with Replication Server zip file.');
    FatalError := True;
    Application.Terminate;
  end
  else
  begin
    PathLen := Length(ReplPath);
    if (ReplPath[PathLen] = '\') then
    begin
       ReplPath[PathLen] := Char(0);
    end;

    StrCopy(ErrorFile,PChar(ReplPath));
    StrLCat(ErrorFile, PChar('\repl.err'),SizeOf(ErrorFile)-1);
    ReplPath:= PChar(ReplPath)+'\replicate.gdb';
    if (not FileExists(ReplPath)) then
    begin
       MessageDlg(ReplPath+' does not exist!  Check repl.ini and make sure the Path variable under the ReplMgmt section is correct.', mtError,[mbOk], 0);
       FatalError := True;
       ReplIni.Free;
    end
    else
    begin
      if TReplInterval.Interval < 1 then
         TReplInterval.Enabled := False
      else
        TReplInterval.Enabled := True;

      if (EvtStr = 'True') then
        Reg4Event := True
      else
        Reg4Event := False;

      ReplIni.Free;

      ReplDB.Params.Clear;
      ReplDB.Params.Add('SERVER NAME='+ReplPath);
      ReplDB.Params.Add('OPEN MODE=READ/WRITE');
      ReplDB.Params.Add('USER NAME=SYSDBA');
      ReplDB.Params.Add('SCHEMA CACHE SIZE=8');
      ReplDB.Params.Add('SQLPASSTHRU MODE=SHARED NOAUTOCOMMIT');
      ReplDB.Params.Add('SCHEMA CACHE TIME=-1');
      ReplDB.Params.Add('MAX ROWS=-1');
      ReplDB.Params.Add('BATCH COUNT=200');
      ReplDB.Params.Add('ENABLE SCHEMA CACHE=FALSE');
      ReplDB.Params.Add('ENABLE BCD=FALSE');

      ReplDB.Open;
      if ( not ReplDB.Connected) then
        FatalError := True;
      ReplDB.StartTransaction;
      QSrcLocs.Open;
      QSrcLocs.First;

      SrcPathDB := QSrcLocsSOURCE_PATH.value;
      if (not FileExists(SrcPathDB)) then
      begin
        ShowMessage('The Replication Source Database could not be found.  You must first configure your db for replication using rmgr.exe');
        FatalError := True;
      end
      else
      begin
        SrcUsername := QSrcLocsUSERNAME.value;
        SrcPassword := QSrcLocsPASSWD.value;
        QSrcLocs.Close;
        ReplDB.Commit;

        DBSource.Params.Clear;
        DBSource.Params.Add('SERVER NAME='+SrcPathDB);
        DBSource.Params.Add('USER NAME='+SrcUsername);
        DBSource.Params.Add('OPEN MODE=READ/WRITE');
        DBSource.Params.Add('SCHEMA CACHE SIZE=8');
        DBSource.Params.Add('SQLPASSTHRU MODE=SHARED NOAUTOCOMMIT');
        DBSource.Params.Add('SCHEMA CACHE TIME=-1');
        DBSource.Params.Add('MAX ROWS=-1');
        DBSource.Params.Add('BATCH COUNT=200');
        DBSource.Params.Add('ENABLE SCHEMA CACHE=FALSE');
        DBSource.Params.Add('ENABLE BCD=FALSE');
        DBSource.Params.Add('PASSWORD='+SrcPassword);

        EvSourceDB.Params.Clear;
        EvSourceDB.Params.Add('SERVER NAME='+SrcPathDB);
        EvSourceDB.Params.Add('USER NAME='+SrcUsername);
        EvSourceDB.Params.Add('OPEN MODE=READ/WRITE');
        EvSourceDB.Params.Add('SCHEMA CACHE SIZE=8');
        EvSourceDB.Params.Add('SQLPASSTHRU MODE=SHARED NOAUTOCOMMIT');
        EvSourceDB.Params.Add('SCHEMA CACHE TIME=-1');
        EvSourceDB.Params.Add('MAX ROWS=-1');
        EvSourceDB.Params.Add('BATCH COUNT=200');
        EvSourceDB.Params.Add('ENABLE SCHEMA CACHE=FALSE');
        EvSourceDB.Params.Add('ENABLE BCD=FALSE');
        EvSourceDB.Params.Add('PASSWORD='+SrcPassword);
      end;
    end;
  end;
end;

procedure TForm1.HandleError(ErrorMsg:string);
var
  Len : Integer;
  F:Textfile;
  FileId : Integer;
begin
  if (not FileExists(ErrorFile)) then
  begin
    FileId := FileCreate(ErrorFile);
    if FileId > 0 then
    begin
      FileClose(FileId);
    end;
  end;
  AssignFile(F,ErrorFile);
  Append(F);
  Writeln(F,DateTimeToStr(Now) + ' '+ErrorMsg);
  CloseFile(F);
  Inc(AnyErrors);
end;

procedure TForm1.DestroyStmtLL(Head:HeadPtr);
var
  CurPtr,NextPtr : StmtPtr;
begin
  CurPtr := Head^;
  if ( CurPtr <> nil) then
  begin
     while (CurPtr^.link <> nil) do
     begin
        NextPtr := CurPtr^.link;
        if CurPtr^.SqlStmt <> nil then
          FreeMem(PChar(CurPtr^.SqlStmt));
         FreeMem(CurPtr);
        CurPtr := NextPtr;
     end;
     FreeMem(CurPtr^.SqlStmt);
     FreeMem(CurPtr);
     Head^ := nil;
  end
end;
procedure TForm1.AddStmtLL(Head:HeadPtr;TableName,Operation,SqlStr:PChar);
var
  LenStr : Integer;
  TmpPtr,NewPtr : StmtPtr;
begin
  New(NewPtr);
  StrCopy(NewPtr^.Tablename,TableName);
  StrCopy(NewPtr^.Operation,Operation);
  LenStr := StrLen(SqlStr);
  NewPtr^.SqlStmt := AllocMem(LenStr+1);
  StrCopy(NewPtr^.SqlStmt,SqlStr);
  NewPtr^.link := nil;
  TmpPtr := Head^;
  if (TmpPtr = nil) then
    Head^ := NewPtr   {First one on the list}
  else
  begin
    while (TmpPtr^.link <> nil) do   { stick it on the end }
      TmpPtr := TmpPtr^.link;
    TmpPtr^.link := NewPtr;
  end;
end;

function  TForm1.SearchStmtLL(Head:StmtPtr;TableName,Operation:PChar): PChar;
var
  CurPtr : StmtPtr;
  Foundit : Integer;

begin
  CurPtr := Head;
  Foundit := 0;
  if ( CurPtr <> nil) then
  begin
     while (CurPtr <> nil) and (Foundit = 0) do
     begin
        if ( StrIComp(CurPtr^.TableName,TableName)=0) and (StrIComp(CurPtr^.Operation,Operation)=0) then
          Foundit := 1
        else
          CurPtr := CurPtr^.link;
     end;
  end;
  if CurPtr = nil then
     SearchStmtLL := nil
  else
     SearchStmtLL := CurPtr^.SqlStmt;
end;

procedure TForm1.DestroyLocsLL(Head:LocsHeadPtr);
var
  CurPtr,NextPtr : LocsPtr;
begin
  CurPtr := Head^;
  if ( CurPtr <> nil) then
  begin
     while (CurPtr^.link <> nil) do
     begin
        NextPtr := CurPtr^.link;
        if CurPtr^.LocPath <> nil then
          FreeMem(PChar(CurPtr^.LocPath));
         FreeMem(CurPtr);
        CurPtr := NextPtr;
     end;
     FreeMem(CurPtr^.LocPath);
     FreeMem(CurPtr);
     Head^ := nil;
  end
end;

procedure TForm1.AddLocsLL(Head:LocsHeadPtr;LocPath,RasServ,RasUser,RasPass:PChar;IdLoc :Integer;User,Passwd:PChar);
var
  LenStr : Integer;
  TmpPtr,NewPtr : LocsPtr;
begin
  New(NewPtr);
  NewPtr^.IdLoc := IdLoc;
  LenStr := StrLen(LocPath);
  NewPtr^.LocPath := AllocMem(LenStr+1);
  StrCopy(NewPtr^.LocPath,LocPath);
  StrCopy(NewPtr^.RService, RasServ);
  StrCopy(NewPtr^.RUser, RasUser);
  StrCopy(NewPtr^.RPass, RasPass);
  StrCopy(NewPtr^.UserName, User);
  StrCopy(NewPtr^.Password, Passwd);
  NewPtr^.link := nil;
  TmpPtr := Head^;
  if (TmpPtr = nil) then
    Head^ := NewPtr   {First one on the list}
  else
  begin
    while (TmpPtr^.link <> nil) do   { stick it on the end }
      TmpPtr := TmpPtr^.link;
    TmpPtr^.link := NewPtr;
  end;
end;
function  TForm1.SearchLocsLL(Head:LocsPtr;IdLoc:Integer): LocsPtr;
var
  CurPtr : LocsPtr;
  Foundit : Integer;

begin
  CurPtr := Head;
  Foundit := 0;
  if ( CurPtr <> nil) then
  begin
     while (CurPtr <> nil) and (Foundit = 0) do
     begin
        if ( IdLoc =  CurPtr^.IdLoc ) then
          Foundit := 1
        else
          CurPtr := CurPtr^.link;
     end;
  end;
  if CurPtr = nil then
     SearchLocsLL := nil
  else
     SearchLocsLL := CurPtr;
end;

function TForm1.ConnectDb(LocId:Integer;LocPtr:LocsPtr):Integer;
var
  retval : RETCODE;
  ErrorBuf : array[0..511] of Char;
  DbName : string;
  DbStatus : Integer;

begin
   retval := SQL_SUCCESS;
   FillChar(ErrorBuf, SizeOf(ErrorBuf), Char(0));
   if (LocId = -1) then
   begin
      SrcHandle := nil;
      SQLAllocConnect(@SrcHandle);
      SQLSetConnectOption( SrcHandle,SQL_AUTOCOMMIT,SQL_AUTOCOMMIT_OFF);
      retval := SQLConnect(SrcHandle,PChar(SrcPathDB),PChar(SrcUsername),PChar(SrcPassword));
      if ( retval <> SQL_SUCCESS) then
      begin
         SQLError(SrcHandle,nil,ErrorBuf);
         HandleError('Src Connect Failed: '+ ErrorBuf);
      end
   end
   else
   begin
     if (LocPtr <> nil) then
     begin
       TargetUser := LocPtr^.UserName;
       TargetPwd := LocPtr^.Password;
       TargetPath := StrPas(PChar(LocPtr^.LocPath));

       if (Length(LocPtr^.RService) > 0) then
       { Is there a RAS service
         affilliated with this location?
       }
       begin
         Form2.REntryName := LocPtr^.RService;
         Form2.RUserName := LocPtr^.RUser;
         Form2.RPassword := LocPtr^.RPass;
         {Wait for the RAS connection to take place.}
         Form2.ShowModal;

         if (not Form2.IsConnected) then
         begin
           retval := SQL_ERROR;
           HandleError('Target'+IntToStr(LocId)+' Connect Failed: Could not connect to associated RAS Service('+Form2.REntryName+')');
         end
       end;
     end
     else
     begin
       retval := SQL_ERROR;
       HandleError('Could not find Target location linked-list info');
     end;
     if (retval = SQL_SUCCESS) then
     begin
        TargetHandle := nil;
        SQLAllocConnect(@TargetHandle);
        SQLSetConnectOption( TargetHandle,SQL_AUTOCOMMIT,SQL_AUTOCOMMIT_OFF);
        retval := SQLConnect(TargetHandle,PChar(TargetPath),PChar(TargetUser),PChar(TargetPwd));
        if ( retval <> SQL_SUCCESS) then
        begin
           SQLError(TargetHandle,nil,ErrorBuf);
           HandleError('Target'+IntToStr(LocId)+' Connect Failed: '+ ErrorBuf);
        end
     end
     else
     begin
        retval := SQL_ERROR;
        HandleError('Target'+IntToStr(LocId)+' Connect Failed: Could not connect to associated RAS Service('+Form2.REntryName+')');
     end;
   end;
   ConnectDb := retval;
end;

procedure TForm1.DisconnectDb(IdLoc:Integer);
var
  retval : RETCODE;
begin
   if (IdLoc = -1) then
      retval := SQLDisconnect(@SrcHandle)
   else
   begin
      retval := SQLDisconnect(@TargetHandle);
      if (Form2.IsConnected) then
      begin
         Form2.RAS1.Disconnect;
         Form2.IsConnected := False;
      end;
   end;
end;

function TForm1.OpenChanges:RETCODE;
var
  retval : RETCODE;
  ErrorBuf : array[0..511] of Char;

begin
   FillChar(ErrorBuf, SizeOf(ErrorBuf), Char(0));
   retval := SQLAllocStmt( SrcHandle,@ChgStmt);
   if ( retval = SQL_SUCCESS) then
   begin
     retval := SQLPrepare( ChgStmt, PChar(ChangeSelect) , 0 );
     if ( retval = SQL_SUCCESS) then
     begin
       SQLBindCol( ChgStmt,1, SQL_LONG+1,@ChgCode,@SomeNull1,nil);
       SQLBindCol( ChgStmt,2, SQL_VARYING+1,@ChgTableName,@SomeNull2,nil);
       SQLBindCol( ChgStmt,3, SQL_LONG+1,@ChgTableKey,@SomeNull3,nil);
       SQLBindCol( ChgStmt,4, SQL_TEXT+1,@ChgOperation,@SomeNull4,nil);
       SQLBindParameter( ChgStmt,1, SQL_LONG+1,@ChgLocId,@SomeNull5,nil,0);

       retval := SQLExecute( ChgStmt );
       if ( retval <> SQL_SUCCESS) then
       begin
         SQLError(SrcHandle,ChgStmt,ErrorBuf);
         HandleError('ChgExecute Failed: for LocId='+IntToStr(ChgLocId)+' SqlStmt='+ChangeSelect+' Error='+ ErrorBuf);
         SQLFreeStmt( ChgStmt,SQL_DROP);
       end
     end
     else
     begin
       SQLError(SrcHandle,ChgStmt,ErrorBuf);
       HandleError('ChgPrepare Failed: for LocId='+IntToStr(ChgLocId)+' SqlStmt='+ChangeSelect+' Error='+ErrorBuf);
       SQLFreeStmt( ChgStmt,SQL_DROP);
     end
   end
   else
   begin
     SQLError(SrcHandle,nil,ErrorBuf);
     HandleError('Chg AllocFailed for LocId='+IntToStr(ChgLocId)+' Error= '+ ErrorBuf);
   end;
   OpenChanges := retval;
end;

function TForm1.DeleteChangeRec:RETCODE;
var
  retval : RETCODE;
  ErrorBuf : array[0..511] of Char;

begin
   FillChar(ErrorBuf, SizeOf(ErrorBuf), Char(0));
   retval := SQLAllocStmt( SrcHandle,@ChgStmt2);
   if ( retval = SQL_SUCCESS) then
   begin
     retval := SQLPrepare( ChgStmt2, PChar(ChangeDelete) , 0 );
     if ( retval = SQL_SUCCESS) then
     begin
       SQLBindParameter( ChgStmt2,1, SQL_LONG+1,@ChgCode,@SomeNull1,nil,0);
       retval := SQLExecute( ChgStmt2 );
       if ( retval <> SQL_SUCCESS) then
       begin
         SQLError(SrcHandle,ChgStmt2,ErrorBuf);
         HandleError('ChgDelete Failed LocId='+IntToStr(ChgCode)+' SqlStmt='+ChangeDelete+ 'Error='+ErrorBuf);
       end
     end
     else
     begin
       SQLError(SrcHandle,ChgStmt2,ErrorBuf);
       HandleError('ChgDelPrepare Failed LocId='+IntToStr(ChgCode)+' SqlStmt='+ ChangeDelete+' Error='+ErrorBuf);
     end;
     SQLFreeStmt( ChgStmt2,SQL_DROP);
   end
   else
   begin
     SQLError(SrcHandle,nil,ErrorBuf);
     HandleError('ChgDel AllocFailed LocId='+IntToStr(ChgLocId)+' Error='+ ErrorBuf);
   end;
   DeleteChangeRec := retval;
end;

function TForm1.GetChanges:RETCODE;
var
  retval : RETCODE;
  ErrorBuf : array[0..511] of Char;

begin
  FillChar(ErrorBuf, SizeOf(ErrorBuf), Char(0));
  retval := SQLFetch( ChgStmt );
  if (retval <> SQL_SUCCESS) then
  begin
     if (retval <> 100) then
     begin
       SQLError(SrcHandle,ChgStmt,ErrorBuf);
       HandleError('ChgFetch Failed LocId='+IntToStr(ChgLocId)+' SqlStmt='+ ChangeSelect+ ' Error='+ErrorBuf);
     end;
  end;
  GetChanges := retval;
end;

procedure TForm1.CloseChanges;
begin
  SQLFreeStmt( ChgStmt,SQL_DROP);
end;

function TForm1.SyncDelete:RETCODE;
var
  retval : RETCODE;
  ErrorBuf : array[0..511] of Char;

begin
   FillChar(ErrorBuf, SizeOf(ErrorBuf), Char(0));
   retval := SQLAllocStmt( TargetHandle,@TargetStmt);
   if ( retval = SQL_SUCCESS) then
   begin
     retval := SQLPrepare( TargetStmt, PChar(SqlStmtPtr) , 0 );
     if ( retval = SQL_SUCCESS) then
     begin
       SomeNull1 := False;
       SQLBindParameter( TargetStmt,1, SQL_LONG+1,@ChgTableKey,@SomeNull1,nil,0);
       retval := SQLExecute( TargetStmt );
       if ( retval <> SQL_SUCCESS) then
       begin
         SQLError(TargetHandle,TargetStmt,ErrorBuf);
         HandleError('TgtDelete Failed: LocId='+IntToStr(ChgLocId)+'Key='+IntToStr(ChgTableKey)+ ' SqlStmt='+SqlStmtPtr+' Error='+ErrorBuf);
       end
     end
     else
     begin
       SQLError(TargetHandle,TargetStmt,ErrorBuf);
       HandleError('TgtDelPrepare Failed: LocId='+IntToStr(ChgLocId)+'Key='+IntToStr(ChgTableKey)+ ' SqlStmt='+SqlStmtPtr+' Error='+ErrorBuf);
     end;
     SQLFreeStmt( TargetStmt,SQL_DROP);
   end
   else
   begin
     SQLError(TargetHandle,nil,ErrorBuf);
     HandleError('TgtDel AllocFailed: LocId='+IntToStr(ChgLocId)+' Error='+ ErrorBuf);
   end;
   SyncDelete := retval;
end;

function TForm1.SyncInsUpd:RETCODE;
var
  retval1,retval2 : RETCODE;
  ErrorBuf : array[0..511] of Char;
  SrcSqlPtr : PChar;
  DataType,DataLen:SWORD;
  ParamNum,NumIn,NumOut,i : UWORD;
  InList,OutList : array[1..MaxColumns] of ParamRec;
  BoolPtr : ^Boolean;
  TmpChar : array[0..1] of Char;

begin
   retval1 := 0;
   retval2 := 0;
   FillChar(ErrorBuf, SizeOf(ErrorBuf), Char(0));
     retval1 := SQLAllocStmt( SrcHandle,@SrcStmt);
     retval2 := SQLAllocStmt( TargetHandle,@TargetStmt);
     if ( retval1 = SQL_SUCCESS) and (retval2 = SQL_SUCCESS) then
     begin
       TmpChar := 'S';
       SrcSqlPtr := SearchStmtLL(StmtHead,ChgTableName,TmpChar);
       retval1 := SQLPrepare( SrcStmt, SrcSqlPtr , 0 );
       if ( retval1 = SQL_SUCCESS) then
       begin
         NumOut := 1;
                { For each column in a Select clause, we'll
                  allocate space. SQLGetCol() will tell us
                  the Datatype and Length.  Once we have the
                  proper space allocated, we can "bind" the
                  output data to the variable pointed to by the
                  allocated space using SQLBindCol().
                }
         retval1 := SQLGetCol( SrcStmt,NumOut,DataType,DataLen);
         while (retval1 <> 100) do
         begin
           OutList[NumOut].NullPtr := AllocMem(sizeof(Boolean));
           OutList[NumOut].BlobSizePtr := nil;
           BoolPtr := OutList[NumOut].NullPtr;
           BoolPtr^ := False;
           case DataType of
              SQL_DATE+1,SQL_DATE:
                { Dates are passed in/out as strings of
                  the format mm/dd/yyyy hh:mm:ss
                }
              begin
                OutList[NumOut].ParamPtr := AllocMem(sizeof(Char)*20);
                SQLBindCol( SrcStmt,NumOut, SQL_DATE+1,OutList[NumOut].ParamPtr,OutList[NumOut].NullPtr,nil);
                OutList[NumOut].DataType := SQL_DATE+1;
              end;
              SQL_TEXT+1,SQL_TEXT:
              begin
                OutList[NumOut].ParamPtr := AllocMem(sizeof(Char)*DataLen+1);
                SQLBindCol( SrcStmt,NumOut, SQL_TEXT+1,OutList[NumOut].ParamPtr,OutList[NumOut].NullPtr,nil);
                OutList[NumOut].DataType := SQL_TEXT+1;
              end;
              SQL_VARYING+1,SQL_VARYING:
              begin
                OutList[NumOut].ParamPtr := AllocMem(sizeof(Char)*DataLen+1);
                 SQLBindCol( SrcStmt,NumOut, SQL_VARYING+1,OutList[NumOut].ParamPtr,OutList[NumOut].NullPtr,nil);
                OutList[NumOut].DataType := SQL_VARYING+1;
              end;
              SQL_LONG,SQL_LONG+1:
              begin
                OutList[NumOut].ParamPtr := AllocMem(sizeof(LongInt));
                SQLBindCol( SrcStmt,NumOut, SQL_LONG+1,OutList[NumOut].ParamPtr,OutList[NumOut].NullPtr,nil);
                OutList[NumOut].DataType := SQL_LONG+1;
              end;
              SQL_SHORT,SQL_SHORT+1:
              begin
                OutList[NumOut].ParamPtr := AllocMem(sizeof(Short));
                SQLBindCol( SrcStmt,NumOut, SQL_SHORT+1,OutList[NumOut].ParamPtr,OutList[NumOut].NullPtr,nil);
                OutList[NumOut].DataType := SQL_SHORT+1;
              end;
              SQL_FLOAT,SQL_FLOAT+1:
              begin
                OutList[NumOut].ParamPtr := AllocMem(sizeof(Double));
                SQLBindCol( SrcStmt,NumOut, SQL_FLOAT+1,OutList[NumOut].ParamPtr,OutList[NumOut].NullPtr,nil);
                OutList[NumOut].DataType := SQL_FLOAT+1;
              end;
              SQL_DOUBLE,SQL_DOUBLE+1:
              begin
                OutList[NumOut].ParamPtr := AllocMem(sizeof(Double));
                SQLBindCol( SrcStmt,NumOut, SQL_DOUBLE+1,OutList[NumOut].ParamPtr,OutList[NumOut].NullPtr,nil);
                OutList[NumOut].DataType := SQL_DOUBLE+1;
              end;
              SQL_BLOB,SQL_BLOB+1:
              begin
                OutList[NumOut].ParamPtr := AllocMem(sizeof(Char)*BlobMaxSize);
                OutList[NumOut].BlobSizePtr := AllocMem(sizeof(SDWORD));

               { OutList[NumOut].BlobSizePtr^ := DataLen;}
                OutList[NumOut].BlobSizePtr^ := sizeof(Char)*BlobMaxSize;
                { DataLen is filled in when we called SQLGetCol.
                  DataLen contains the segment size for this blob
                  field. After calling
                  SQLFetch() this variable will contain the actual
                  size of the Blob returned.
                }
                SQLBindCol( SrcStmt,NumOut, SQL_BLOB+1,OutList[NumOut].ParamPtr,OutList[NumOut].NullPtr,OutList[NumOut].BlobSizePtr);
                OutList[NumOut].DataType := SQL_BLOB+1;
              end;
           end;
           Inc(NumOut);
           retval1 := SQLGetCol( SrcStmt,NumOut,DataType,DataLen);
         end;
         SomeNull1 := False;
         SQLBindParameter( SrcStmt,1, SQL_LONG+1,@ChgTableKey,@SomeNull1,nil,0);

         retval2 := SQLPrepare( TargetStmt, PChar(SqlStmtPtr) , 0 );
         if (retval2 = SQL_SUCCESS) then
         begin
           {SQLBindCol is for output params
              BindParameter is for input params}

           {The input params to the other dbs stmt(hstmt2)
            are the output params from the first dbs
            stmt(hstmt1). If this were not the case then,
            we'd obviously have to allocate space for the
            variables we were going to pass in.}
           i := 1;
           while i < NumOut do
           begin
             if (OutList[i].BlobSizePtr = nil) then
               SQLBindParameter( TargetStmt,i, OutList[i].DataType,OutList[i].ParamPtr,OutList[i].NullPtr,OutList[i].BlobSizePtr,0)
             else
               SQLBindParameter( TargetStmt,i, OutList[i].DataType,OutList[i].ParamPtr,OutList[i].NullPtr,OutList[i].BlobSizePtr,OutList[i].BlobSizePtr^);
             Inc(i);
           end;
           if (ChgOperation = 'U') then
           begin
               {If we're issuing and Update statement, we'll
                have one more parameter to Bind into the
                Input data section, i.e. The TableKey
                }
               SomeNull1 := False;
               SQLBindParameter( TargetStmt,NumOut, SQL_LONG+1,@ChgTableKey,@SomeNull1,nil,0);
           end;
           retval1 := SQLExecute( SrcStmt );
           retval2 := SQLFetch( SrcStmt );
           while ( (retval1  = SQL_SUCCESS) and (retval2 = SQL_SUCCESS)) do
           begin
             retval2 := SQLExecute( TargetStmt );
             if (retval2 = SQL_SUCCESS) then
               retval1 := SQLFetch( SrcStmt );
           end;
           if ( (retval1  = 100) and (retval2 = SQL_SUCCESS)) then
           begin
                retval1 := SQL_SUCCESS;
           end
           else
           begin
             if (retval2 <> SQL_SUCCESS) then
             begin
                if (retval2 <> 100) then
                begin
                  if (retval2 = -23) then
                  begin
                    HandleError('Not enough memory allocated for a Blob field.  Make sure BlobMaxBytes is set to a large enough value in repl.ini');
                    retval1 := SQL_ERROR;
                  end
                  else
                  begin
                    SQLError(TargetHandle,TargetStmt,ErrorBuf);
                    HandleError('InsUpd TgtEx Failed: LocId='+IntToStr(ChgLocId)+'Key='+IntToStr(ChgTableKey)+ ' SqlStmt='+SqlStmtPtr+' Error='+ErrorBuf);
                    retval1 := SQL_ERROR;
                  end;
                end;
             end
             else
             begin
                SQLError(SrcHandle,SrcStmt,ErrorBuf);
                HandleError('InsUpd SrcFetch Failed: LocId='+IntToStr(ChgLocId)+'Key='+IntToStr(ChgTableKey)+ ' SqlStmt='+SrcSqlPtr+' Error='+ErrorBuf);
                retval1 := SQL_ERROR;
             end;
           end
         end
         else { Target Prepare Failed }
         begin
           SQLError(TargetHandle,TargetStmt,ErrorBuf);
           HandleError('InsUpd TgtPrep Failed: LocId='+IntToStr(ChgLocId)+'Key='+IntToStr(ChgTableKey)+ ' SqlStmt='+SqlStmtPtr+' Error='+ErrorBuf);
           retval1 := SQL_ERROR;
         end
       end
       else
       begin  { Source Prepare Failed }
         SQLError(SrcHandle,SrcStmt,ErrorBuf);
         HandleError('InsUpd SrcPrep Failed: LocId='+IntToStr(ChgLocId)+'Key='+IntToStr(ChgTableKey)+ ' SqlStmt='+SrcSqlPtr+' Error='+ErrorBuf);
       end;
       SQLFreeStmt( SrcStmt,SQL_DROP);
       SQLFreeStmt( TargetStmt,SQL_DROP);
       i := 1;
       while i < NumOut do
       begin
         if OutList[i].DataType = SQL_BLOB+1 then
           FreeMem( OutList[i].BlobSizePtr);
         FreeMem( OutList[i].ParamPtr);
         FreeMem( OutList[i].NullPtr);
         Inc(i);
       end;
     end
     else
     begin
       if retval1 <> SQL_SUCCESS then
       begin
           SQLError(SrcHandle,nil,ErrorBuf);
           HandleError('InsUpd SrcAlloc Failed: LocId'+IntToStr(ChgLocId)+' Error='+ ErrorBuf);
       end
       else
       begin
           SQLError(TargetHandle,nil,ErrorBuf);
           HandleError('InsUpd Target Alloc Failed: LocId'+IntToStr(ChgLocId)+' Error='+ ErrorBuf);
           retval1 := SQL_ERROR;
       end
     end;
   SyncInsUpd := retval1;
end;

procedure TForm1.SyncSrcAndTarget;
var
  retval1,retval2 : RETCODE;
  ErrorBuf : array[0..511] of Char;
  DbArray : HDBCARR;
  DbCount : Integer;
begin
  { For each record in the Change Table
    matching the passed in Loc_id.
    We'll Pull the information out of the
    Source DB and propagate it to the
    Target DB
  }
  FillChar(ErrorBuf, SizeOf(ErrorBuf), Char(0));
  DbArray[0] := @SrcHandle;
  DbArray[1] := @TargetHandle;
  DbCount := 2;
  retval1 := SQLTransactMdb( dbArray,SQL_BEGIN_TRANS,DbCount);
  if ( retval1 = SQL_SUCCESS) then
  begin
    retval1 := OpenChanges;
    if (retval1 = SQL_SUCCESS) then
    begin
       retval2 := GetChanges;
       retval1 := SQL_SUCCESS;
       While ( retval2 = SQL_SUCCESS) and (retval1 = SQL_SUCCESS) do
       begin
       {Get the proper SQL statement
        for the given TABLENAME, and Operation
       }
          SqlStmtPtr := SearchStmtLL(StmtHead,ChgTableName,ChgOperation);
          if SqlStmtPtr <> nil then
          begin
            if (ChgOperation = 'U') or (ChgOperation = 'I') then
               retval1 := SyncInsUpd
            else
               retval1 := SyncDelete;
              { Handle the sync of Insert,
                Update, or Delete
              }
            if (retval1 = SQL_SUCCESS) then
            begin
             {We've done what we should have, so we
              can delete the record from the Changes table.
             }
               retval1 := DeleteChangeRec;
            end;
            retval2 := GetChanges;
          end
          else
          begin
            HandleError('No Corresponding SQL Stmt for TableName='+ChgTableName+' Operation='+ChgOperation);
            SQLTransactMdb( dbArray,SQL_ROLLBACK,DbCount);
            retval2 := 100;
          end;
       end;
       if (retval2 <> 100) or (retval1 <> SQL_SUCCESS) then
       begin
          if (retval2 <> 100) then
          begin
            HandleError('Sql Failed: '+ ErrorBuf);
            retval1 := SQLTransactMdb( dbArray,SQL_ROLLBACK,DbCount);
          end
       end
       else
          retval1 := SQLTransactMdb( dbArray,SQL_COMMIT,DbCount);
       CloseChanges;
    end
    else
    begin
       retval1 := SQLTransactMdb( dbArray,SQL_ROLLBACK,DbCount);
    end
  end
  else
  begin
    SQLError(SrcHandle,nil,ErrorBuf);
    HandleError('Source Begin TX Failed: '+ ErrorBuf);
  end;
end;

procedure TForm1.ReplicateData;
var
  PosCode,NumLocations : Integer;
  ret1,ret2 : RETCODE;
  Connected2Src : Boolean;
  LocPtr : LocsPtr;

begin
ret1 := SQL_SUCCESS;
Connected2Src := False;
try
  NumLocations := CacheSqlStmts; {Cache all the SQL stmts
                                for all tables that may
                                be replicated. At the
                                same time, figure out
                                how many target locations
                                there are and cache all of
                                their DB names}
  
  if (DBSource.InTransaction) then
      DBSource.Commit;
  DBSource.StartTransaction;
  QLocChanges.Open; { Query for distinct LocIds in Change table}
  QLocChanges.First;
  while( (QLocChanges.EOF <> True) and (ret1=SQL_SUCCESS)) do
  begin
    if (not Connected2Src) then
    begin
      ret1 := ConnectDb(-1,nil);  {-1 signifies the Source DB}    ChgLocId := QLocChangesLOC_ID.value;
      if (ret1 = SQL_SUCCESS) then
         Connected2Src := True;
    end;
    ChgLocId := QLocChangesLOC_ID.value;
    LocPtr := SearchLocsLL(LocsHead,ChgLocId);
    ret2 := ConnectDb(ChgLocId,LocPtr);
    if (ret2 = SQL_SUCCESS)and (ret1 = SQL_SUCCESS) then
    begin
      SyncSrcAndTarget;
      DisconnectDb(ChgLocId);
    end;
    QLocChanges.Next;
  end;
  QLocChanges.Close;
  DBSource.Commit;
  if (Connected2Src) then
    DisconnectDb(-1);  { -1 signifies the Source DB }
except
  on E:EDBEngineError do
  begin
    ShowMessage(E.Message);
  end;
end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  TDoReplication.Enabled := True;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  try
    SetParams;
    if not (FatalError) then
    begin
      if not (DBSource.Connected) then
        DBSource.Connected := True;
      if not (EvSourceDB.Connected) then
        EvSourceDB.Connected := True;
      if (Reg4Event) then
        IBEvent.Registered := True;
    end
    else
      Application.Terminate;
  except
    on E:EDBEngineError do
    begin
      ShowMessage(E.Message);
      Application.Terminate;
    end;
  end;
end;

procedure TForm1.IBEventEventAlert(Sender: TObject; EventName: string;
  EventCount: Longint; var CancelAlerts: Boolean);
begin
  TDoReplication.Enabled := True;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   FreeSqlStmts; { Free all Cached SQL stmts }
   if ( DBSource.Connected) then
     DBSource.Connected := False;
   if ( EvSourceDB.Connected) then
   begin
     IBEvent.Registered := False;
     EvSourceDB.Connected := True;
   end;
end;

procedure TForm1.TDoReplicationTimer(Sender: TObject);
begin
  TDoReplication.Enabled := False;
  if ( Not Running) then
  begin
    Running := True;
    Image2.Picture.LoadFromFile('YLIGHT.BMP');
    Application.ProcessMessages;
    ReplicateData;
    if (AnyErrors > 0) then
      Image2.Picture.LoadFromFile('RLIGHT.BMP')
    else
      Image2.Picture.LoadFromFile('GLIGHT.BMP');

    Application.ProcessMessages;
    AnyErrors := 0;
    Screen.Cursor := CrDefault;
    Running := False;
  end;
end;

procedure TForm1.TReplIntervalTimer(Sender: TObject);
begin
  TDoReplication.Enabled := True;
end;

procedure TForm1.Exit2Click(Sender: TObject);
begin
   Form1.Close;
end;


procedure TForm1.Exit1Click(Sender: TObject);
begin
   Form4.Show;
end;


procedure TForm1.Properties1Click(Sender: TObject);
begin
  Form3.ShowModal;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
   ShowMessage('Version='+Version);
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  if ( not ReplDB.connected) then
    Application.Terminate;
end;

initialization
  SomeNull1 := False;
  SomeNull2 := False;
  SomeNull3 := False;
  SomeNull4 := False;
  SomeNull5 := False;
  AnyErrors := 0;
  FatalError := False;
  Running := False;
  CachedEm := False;
end.
