unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,IniFiles, Menus;

type
  TForm3 = class(TForm)
    EInterval: TEdit;
    Label1: TLabel;
    Button1: TButton;
    Label2: TLabel;
    CBEvent: TCheckBox;
    MainMenu1: TMainMenu;
    Exit1: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

uses Repl;

{$R *.DFM}

procedure TForm3.Button1Click(Sender: TObject);
var
  ReplIni: TIniFile;

begin
   Form1.TReplInterval.Enabled := False;
   Form1.IBEvent.Registered := False;

   ReplIni := TIniFile.Create('REPL.INI');
   with ReplIni do
   begin
     WriteString('ReplServer', 'Interval', EInterval.Text);
     if CBEvent.Checked then
        WriteString('ReplServer', 'EventResp', 'True')
     else
        WriteString('ReplServer', 'EventResp', 'False');
   end;
   Form1.TReplInterval.Interval := StrToInt( EInterval.Text)*1000;
   Form1.TReplInterval.Enabled := True;
   if (CBEvent.Checked) then
     Form1.IBEvent.Registered := True;
end;

procedure TForm3.FormActivate(Sender: TObject);
var
  ReplIni: TIniFile;
  EvtStr : string;

begin
  ReplIni := TIniFile.Create('REPL.INI');
  with ReplIni do
  begin
     EInterval.Text:=ReadString('ReplServer', 'Interval', '0');
     EvtStr:=ReadString('ReplServer', 'EventResp', 'False');
  end;
  if (EvtStr = 'True') then
     CBEvent.Checked := True
  else
     CBEvent.Checked := False;
end;

procedure TForm3.Exit1Click(Sender: TObject);
begin
   Form3.Close;
end;

end.
